/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import gnu.trove.map.hash.TIntLongHashMap;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.label.AbstractLabelMultisetLoader;
import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.ComparableLabelMultisetEntryList;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelMultisetToUnsignedLongConverter;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static LabelMultisetType collapse(Iterable<LabelMultisetType> lmts, int numElements) {
        LabelMultisetType result = new LabelMultisetType();
        LabelUtils.collapse(lmts, numElements, result);
        return result;
    }

    public static void collapse(Iterable<LabelMultisetType> lmts, int numElements, LabelMultisetType result) {
        result.entrySet().clear();
        LabelMultisetEntry ref = new LabelMultisetEntry(0L, 1);
        for (LabelMultisetType lmt : lmts) {
            result.entrySet().addAll(lmt.entrySetWithRef(ref));
        }
    }

    public static byte[] serializeLabelMultisetTypes(Iterable<LabelMultisetType> lmts, int numElements) {
        LabelMultisetEntry entryReference = new LabelMultisetEntry(0L, 1);
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
        LabelUtils.writeInt(dataBuffer, 0, ByteOrder.BIG_ENDIAN);
        TreeMap<ComparableLabelMultisetEntryList, Integer> listOffsets = new TreeMap<ComparableLabelMultisetEntryList, Integer>();
        int nextListOffset = 0;
        boolean allListsEmpty = true;
        ByteArrayOutputStream entryList = new ByteArrayOutputStream();
        ComparableLabelMultisetEntryList listRef = new ComparableLabelMultisetEntryList();
        for (LabelMultisetType lmt : lmts) {
            lmt.getAccess().getValue(lmt.index().get(), listRef);
            Integer listOffset = listOffsets.putIfAbsent(listRef, nextListOffset);
            if (listOffset != null) {
                LabelUtils.writeInt(dataBuffer, listOffset, ByteOrder.BIG_ENDIAN);
                continue;
            }
            ComparableLabelMultisetEntryList swap = new ComparableLabelMultisetEntryList();
            swap.addAll(listRef);
            listRef.referToDataAt(swap.data, swap.getBaseOffset());
            listRef = swap;
            Set<LabelMultisetType.Entry<Label>> entries = lmt.entrySetWithRef(entryReference);
            LabelUtils.writeInt(entryList, entries.size(), ByteOrder.LITTLE_ENDIAN);
            for (LabelMultisetType.Entry<Label> entry : entries) {
                LabelUtils.writeLong(entryList, entry.getElement().id(), ByteOrder.LITTLE_ENDIAN);
                int count = entry.getCount();
                LabelUtils.writeInt(entryList, count, ByteOrder.LITTLE_ENDIAN);
                allListsEmpty = allListsEmpty && count == 0;
            }
            LabelUtils.writeInt(dataBuffer, nextListOffset, ByteOrder.BIG_ENDIAN);
            nextListOffset = entryList.size();
        }
        if (allListsEmpty) {
            return null;
        }
        byte[] entryListBytes = entryList.toByteArray();
        dataBuffer.write(entryListBytes, 0, entryListBytes.length);
        return dataBuffer.toByteArray();
    }

    public static void writeInt(ByteArrayOutputStream dataBuffer, int value, ByteOrder byteOrder) {
        dataBuffer.write(ByteBuffer.allocate(4).order(byteOrder).putInt(value).array(), 0, 4);
    }

    public static void writeLong(ByteArrayOutputStream dataBuffer, long value, ByteOrder byteOrder) {
        dataBuffer.write(ByteBuffer.allocate(8).order(byteOrder).putLong(value).array(), 0, 8);
    }

    public static LabelMultisetType getOutOfBounds() {
        return LabelUtils.getOutOfBounds(1);
    }

    public static LabelMultisetType getOutOfBounds(int count) {
        return new LabelMultisetType(new LabelMultisetEntry(-3L, count));
    }

    public static VolatileLabelMultisetArray fromBytes(byte[] bytes, int numElements) {
        int i;
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        LOG.debug("Creating VolatileLabelMultisetArray from {} bytes for {} elements", (Object)bytes.length, (Object)numElements);
        int argMaxSize = bb.getInt();
        LOG.debug("Data contains {} arg maxes", (Object)argMaxSize);
        long[] argMax = new long[argMaxSize];
        for (int i2 = 0; i2 < argMaxSize; ++i2) {
            argMax[i2] = bb.getLong();
        }
        int[] listEntryOffsets = new int[numElements];
        int listOffsetsSize = AbstractLabelMultisetLoader.listOffsetsSizeInBytes(listEntryOffsets.length);
        int argMaxListSize = AbstractLabelMultisetLoader.argMaxListSizeInBytes(argMax.length);
        int listDataSize = bytes.length - (listOffsetsSize + argMaxListSize);
        LongMappedAccessData listData = LongMappedAccessData.factory.createStorage(listDataSize);
        for (i = 0; i < listEntryOffsets.length; ++i) {
            listEntryOffsets[i] = bb.getInt();
        }
        for (i = 0; i < listDataSize; ++i) {
            ByteUtils.putByte(bb.get(), listData.data, i);
        }
        if (argMaxSize == 0) {
            argMax = new long[listEntryOffsets.length];
            TIntLongHashMap entryOffsetToArgMax = new TIntLongHashMap(10, 0.5f, -1, -1L);
            LabelMultisetEntryList lmel = null;
            for (int i3 = 0; i3 < listEntryOffsets.length; ++i3) {
                int listDataIdx = listEntryOffsets[i3];
                long cachedArgMax = entryOffsetToArgMax.get(listDataIdx);
                if (cachedArgMax != entryOffsetToArgMax.getNoEntryValue()) {
                    argMax[i3] = cachedArgMax;
                    continue;
                }
                if (lmel == null) {
                    lmel = new LabelMultisetEntryList();
                }
                lmel.referToDataAt(listData, listDataIdx);
                argMax[i3] = LabelUtils.getArgMax(lmel);
                entryOffsetToArgMax.put(listDataIdx, argMax[i3]);
            }
        }
        return new VolatileLabelMultisetArray(listEntryOffsets, listData, listDataSize, true, argMax);
    }

    public static long getArgMax(Collection<? extends LabelMultisetType.Entry<Label>> labelMultisetEntries) {
        int maxCount = 0;
        long maxCountId = -2L;
        for (LabelMultisetType.Entry<Label> entry : labelMultisetEntries) {
            int count = entry.getCount();
            if (maxCount >= count && (maxCount != count || entry.getElement().id() >= maxCountId)) continue;
            maxCount = count;
            maxCountId = entry.getElement().id();
        }
        return maxCountId;
    }

    public static RandomAccessibleInterval<UnsignedLongType> convertToUnsignedLong(RandomAccessibleInterval<LabelMultisetType> labelMultisets) {
        return Converters.convert(labelMultisets, (Converter)new LabelMultisetToUnsignedLongConverter(), (Type)new UnsignedLongType());
    }
}

