/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.yaml;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ui.behaviour.io.InputTriggerDescription;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfigIO {
    private static final Tag tag = new Tag("!mapping");

    private static final Yaml getYaml() {
        DumperOptions options = new DumperOptions();
        options.setExplicitStart(true);
        Representer representer = new Representer(options);
        representer.addClassTag(InputTriggerDescription.class, tag);
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(loaderOptions);
        constructor.addTypeDescription(new TypeDescription(InputTriggerDescription.class, tag));
        Yaml yaml = new Yaml((BaseConstructor)constructor, representer, options);
        return yaml;
    }

    public static void write(Iterable<InputTriggerDescription> descriptions, Writer writer) {
        Yaml yaml = YamlConfigIO.getYaml();
        yaml.dump(descriptions, writer);
    }

    public static void write(Iterable<InputTriggerDescription> descriptions, String fileName) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        YamlConfigIO.write(descriptions, writer);
        writer.close();
    }

    public static List<InputTriggerDescription> read(Reader reader) {
        Yaml yaml = YamlConfigIO.getYaml();
        ArrayList<InputTriggerDescription> descriptions = new ArrayList<InputTriggerDescription>();
        try {
            Object obj = yaml.load(reader);
            if (obj instanceof Iterable) {
                Iterable raw = (Iterable)obj;
                for (Object item : raw) {
                    if (!(item instanceof InputTriggerDescription)) continue;
                    InputTriggerDescription mapping = (InputTriggerDescription)item;
                    if (null == mapping.getAction()) {
                        System.err.println("[YamlConfigIO] Missing action definition for mapping:\n" + mapping + "- ignored.");
                        continue;
                    }
                    if (null == mapping.getContexts()) {
                        System.err.println("[YamlConfigIO] Missing contexts definition for mapping:\n" + mapping + "- ignored.");
                        continue;
                    }
                    if (null == mapping.getTriggers()) {
                        System.err.println("[YamlConfigIO] Missing trigger definition for mapping:\n" + mapping + "- ignored.");
                        continue;
                    }
                    descriptions.add(mapping);
                }
            }
        }
        catch (ParserException pse) {
            System.err.println("Problem reading data:");
            System.err.println(pse.getProblemMark());
        }
        return descriptions;
    }

    public static List<InputTriggerDescription> read(String fileName) throws IOException {
        FileReader reader = new FileReader(fileName);
        List<InputTriggerDescription> descriptions = YamlConfigIO.read(reader);
        reader.close();
        return descriptions;
    }

    private YamlConfigIO() {
    }
}

