/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.sparse.Ntree;
import net.imglib2.img.sparse.NtreeAccess;

public final class FloatNtree
implements FloatAccess,
NtreeAccess<Float, FloatNtree> {
    private final long[] position;
    private final Ntree<Float> data;

    public FloatNtree(long[] dimensions, long[] position, float value) {
        this.data = new Ntree<Float>(dimensions, Float.valueOf(value));
        this.position = position;
    }

    private FloatNtree(Ntree<Float> data, long[] position) {
        this.data = data;
        this.position = position;
    }

    @Override
    public float getValue(int index) {
        return this.data.getNode(this.position).getValue().floatValue();
    }

    @Override
    public void setValue(int index, float value) {
        this.data.createNodeWithValue(this.position, Float.valueOf(value));
    }

    @Override
    public Ntree<Float> getCurrentStorageNtree() {
        return this.data;
    }

    @Override
    public FloatNtree createInstance(long[] pos) {
        return new FloatNtree(this.data, pos);
    }
}

