/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import java.io.Serializable;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.sparse.NtreeAccess;
import net.imglib2.img.sparse.NtreeCursor;
import net.imglib2.img.sparse.NtreeImgFactory;
import net.imglib2.img.sparse.NtreeRandomAccess;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.Fraction;

public final class NtreeImg<T extends NativeType<T>, A extends NtreeAccess<?, A>>
extends AbstractNativeImg<T, A>
implements Serializable {
    private static final long serialVersionUID = 1L;
    final A data;

    public NtreeImg(A data, long[] dim, Fraction entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        this.data = data;
    }

    private NtreeImg(NtreeImg<T, A> img) {
        super(img.dimension, new Fraction());
        this.data = img.data;
    }

    @Override
    public A update(Object updater) {
        return (A)this.data.createView(updater);
    }

    @Override
    public NtreeRandomAccess<T> randomAccess() {
        return new NtreeRandomAccess(this);
    }

    @Override
    public NtreeCursor<T> cursor() {
        return new NtreeCursor(this);
    }

    @Override
    public NtreeCursor<T> localizingCursor() {
        return this.cursor();
    }

    @Override
    public ImgFactory<T> factory() {
        return new NtreeImgFactory<NativeType>(this.linkedType);
    }

    public NtreeImg<T, A> copy() {
        NtreeImg copy = (NtreeImg)this.factory().create(this.dimension);
        Cursor source = this.cursor();
        Cursor target = copy.cursor();
        while (((IntervalIterator)((Object)source)).hasNext()) {
            ((NativeType)target.next()).set((Type)source.next());
        }
        return copy;
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }

    public static interface PositionProvider {
        public long[] getPosition();
    }
}

