/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import net.imglib2.RealLocalizable;
import net.imglib2.kdtree.KDTreeImpl;

public class NearestNeighborSearchImpl {
    private final KDTreeImpl tree;
    private final int numDimensions;
    private final int numPoints;
    private final double[] pos;
    private int bestIndex;
    private double bestSquDistance;
    private final double[] axisDiffs;
    private final int[] awayChilds;

    public NearestNeighborSearchImpl(KDTreeImpl tree) {
        this.tree = tree;
        this.numDimensions = tree.numDimensions();
        this.numPoints = tree.size();
        this.pos = new double[this.numDimensions];
        this.bestIndex = -1;
        this.bestSquDistance = Double.POSITIVE_INFINITY;
        int depth = tree.depth();
        this.axisDiffs = new double[depth + 1];
        this.awayChilds = new int[depth + 1];
    }

    public void search(RealLocalizable p) {
        p.localize(this.pos);
        int current = this.tree.root();
        int depth = 0;
        double d = this.bestSquDistance = this.bestIndex >= 0 ? this.tree.squDistance(this.bestIndex, this.pos) : Double.POSITIVE_INFINITY;
        while (true) {
            int d2;
            double axisDiff;
            double squDistance;
            if ((squDistance = this.tree.squDistance(current, this.pos)) < this.bestSquDistance) {
                this.bestSquDistance = squDistance;
                this.bestIndex = current;
            }
            boolean leftIsNearBranch = (axisDiff = this.pos[d2 = depth % this.numDimensions] - this.tree.getDoublePosition(current, d2)) < 0.0;
            int nearChild = 2 * current + (leftIsNearBranch ? 1 : 2);
            int awayChild = 2 * current + (leftIsNearBranch ? 2 : 1);
            this.awayChilds[++depth] = awayChild;
            this.axisDiffs[depth] = axisDiff * axisDiff;
            if (nearChild >= this.numPoints) {
                while (this.awayChilds[depth] >= this.numPoints || this.axisDiffs[depth] > this.bestSquDistance) {
                    if (--depth != 0) continue;
                    return;
                }
                current = this.awayChilds[depth];
                this.awayChilds[depth] = this.numPoints;
                continue;
            }
            current = nearChild;
        }
    }

    public int bestIndex() {
        return this.bestIndex;
    }

    public double bestSquDistance() {
        return this.bestSquDistance;
    }

    public NearestNeighborSearchImpl copy() {
        NearestNeighborSearchImpl copy = new NearestNeighborSearchImpl(this.tree);
        System.arraycopy(this.pos, 0, copy.pos, 0, this.pos.length);
        copy.bestIndex = this.bestIndex;
        copy.bestSquDistance = this.bestSquDistance;
        return copy;
    }
}

