/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Gradient;
import fiji.plugin.volumeviewer.ImageRegion;
import fiji.plugin.volumeviewer.Pic;
import fiji.plugin.volumeviewer.TFalpha1;
import fiji.plugin.volumeviewer.TFalpha2;
import fiji.plugin.volumeviewer.TFalpha3;
import fiji.plugin.volumeviewer.TFalpha4;
import fiji.plugin.volumeviewer.TFrgb;
import fiji.plugin.volumeviewer.Volume_Viewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Gui
extends JPanel
implements MouseListener,
MouseMotionListener,
ChangeListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    JPanel upperButtonPanel;
    JPanel lowerButtonPanel;
    JPanel transferFunctionPanel;
    private JPanel centerPanel;
    private JPanel slicePanel;
    private JCheckBox checkSlices;
    private JCheckBox checkAxes;
    private JCheckBox checkClipLines;
    private JComboBox renderChoice;
    private JComboBox interpolationChoice;
    private JComboBox lutChoice;
    private JCheckBox checkPickColor2;
    private JCheckBox checkPickColor3;
    private JSlider scaleSlider;
    private JSlider distSlider;
    private JSlider positionXSlider;
    private JSlider positionYSlider;
    private JSlider positionZSlider;
    private float scaleSliderValue;
    private JLabel zAspectLabel;
    private String zAspectString = "z-Aspect:";
    private JTextField tfZaspect;
    private JLabel samplingLabel;
    private String samplingString = "Sampling:";
    private JTextField tfSampling;
    private int xStart;
    private int yStart;
    private int xAct;
    private int yAct;
    private JLabel scaleLabel1;
    private JLabel scaleLabel2;
    private JLabel distLabel1;
    private JLabel distLabel2;
    private JLabel positionLabel;
    private JLabel valueLabel;
    ImageRegion imageRegion;
    private ImageRegion sliceImageRegion;
    private JSpinner spinnerX;
    private JSpinner spinnerY;
    private JSpinner spinnerZ;
    private boolean enableSpinnerChangeListener = true;
    private JSlider alphaSlider1;
    private JSlider alphaSlider2;
    private JSlider alphaSlider3;
    private JSlider alphaSlider4;
    private JSlider sliderLumTolerance;
    private JSlider sliderGradTolerance;
    private JButton autobutton1;
    private JButton autobutton2;
    private JButton autobutton3;
    private JButton clearbutton1;
    private JButton clearbutton2;
    private JButton clearbutton3;
    private JButton clearbutton4;
    private JTabbedPane transferFunctionTabbedPane;
    private JPanel lightBox;
    private String positionString;
    private String valueString;
    private int positionX;
    private int positionY;
    private int positionZ;
    private int maxPositionX;
    private int maxPositionY;
    private int maxPositionZ;
    Pic pic = null;
    Pic picSlice = null;
    private Control control;
    private Volume_Viewer vv;
    private JCheckBox checkLight;
    private JSlider ambientSlider;
    private JSlider diffuseSlider;
    private JSlider specularSlider;
    private JSlider shineSlider;
    private ImageRegion imageLightRegion;
    private Pic picLight;
    private ImageRegion imageLEDRegion;
    private Pic picLED;
    private JLabel jLabelLight;
    private JSlider objectLightSlider;
    long startR = 0L;

    public Gui(Control control, Volume_Viewer vv) {
        this.control = control;
        this.vv = vv;
    }

    void makeGui() {
        if (this.vv.tf_rgb == null) {
            this.vv.tf_rgb = new TFrgb(this.control, this.vv);
        }
        if (this.vv.tf_a1 == null) {
            this.vv.tf_a1 = new TFalpha1(this.control, this.vv.vol);
        }
        if (this.vv.tf_a2 == null) {
            this.vv.tf_a2 = new TFalpha2(this.control, this.vv.vol, this.vv.lookupTable.lut, this.vv.lookupTable.lut2D_2);
        }
        if (this.vv.tf_a3 == null) {
            this.vv.tf_a3 = new TFalpha3(this.control, this.vv.vol, this.vv.lookupTable.lut, this.vv.lookupTable.lut2D_3);
        }
        if (this.vv.tf_a4 == null) {
            this.vv.tf_a4 = new TFalpha4(this.control, this.vv.vol, this.vv.vol.aPaint_3D, this.vv.vol.aPaint_3D2);
        }
        this.control.pickColor = false;
        if (this.checkPickColor2 != null) {
            this.checkPickColor2.setSelected(this.control.pickColor);
        }
        this.pic = new Pic(this.control, this.vv, this.control.windowWidthImageRegion, this.control.windowHeight);
        this.imageRegion = new ImageRegion(this.control);
        this.imageRegion.setPlaneColor(this.control.backgroundColor);
        this.imageRegion.addMouseMotionListener(this);
        this.imageRegion.addMouseListener(this);
        this.imageRegion.setPic(this.pic);
        this.picSlice = new Pic(this.control, this.vv, this.control.windowWidthSlices, this.control.windowHeight - 130);
        this.sliceImageRegion = new ImageRegion(this.control);
        this.sliceImageRegion.addMouseMotionListener(this);
        this.sliceImageRegion.addMouseListener(this);
        this.sliceImageRegion.setPic(this.picSlice);
        this.sliceImageRegion.newLines(3);
        this.sliceImageRegion.newText(3);
        this.positionX = (int)((float)(this.vv.vol.widthV - 1) * this.control.positionFactorX);
        this.positionY = (int)((float)(this.vv.vol.heightV - 1) * this.control.positionFactorY);
        this.positionZ = (int)((float)(this.vv.vol.depthV - 1) * this.control.positionFactorZ) + 1;
        this.picSlice.drawSlices();
        this.slicePanel = new JPanel();
        this.slicePanel.setLayout(new BorderLayout());
        this.slicePanel.add((Component)this.sliceImageRegion, "North");
        JPanel sliderBox = new JPanel();
        sliderBox.setLayout(new GridLayout(3, 1));
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        this.maxPositionZ = this.vv.vol.depthV - 1;
        this.positionZSlider = new JSlider(0, 0, this.maxPositionZ, (int)((float)this.maxPositionZ * this.control.positionFactorZ));
        this.positionZSlider.setBorder(new TitledBorder(empty, "xy", 4, 2, new Font("Sans", 0, 12), new Color(0, 187, 187)));
        this.positionZSlider.setPreferredSize(new Dimension((int)((double)this.control.windowWidthSlices * 0.25), 30));
        this.positionZSlider.setSnapToTicks(true);
        this.positionZSlider.addChangeListener(this);
        this.positionZSlider.addMouseListener(this);
        sliderBox.add(this.positionZSlider);
        this.maxPositionX = this.vv.vol.widthV - 1;
        this.positionXSlider = new JSlider(0, 0, this.maxPositionX, (int)((float)this.maxPositionX * this.control.positionFactorX));
        this.positionXSlider.setBorder(new TitledBorder(empty, "yz", 4, 2, new Font("Sans", 0, 12), new Color(0, 150, 0)));
        this.positionXSlider.setPreferredSize(new Dimension((int)((double)this.control.windowWidthSlices * 0.25), 30));
        this.positionXSlider.setSnapToTicks(true);
        this.positionXSlider.addChangeListener(this);
        this.positionXSlider.addMouseListener(this);
        sliderBox.add(this.positionXSlider);
        this.maxPositionY = this.vv.vol.heightV - 1;
        this.positionYSlider = new JSlider(0, 0, this.maxPositionY, (int)((float)this.maxPositionY * this.control.positionFactorY));
        this.positionYSlider.setBorder(new TitledBorder(empty, "xz", 4, 2, new Font("Sans", 0, 12), Color.red));
        this.positionYSlider.setPreferredSize(new Dimension((int)((double)this.control.windowWidthSlices * 0.25), 30));
        this.positionYSlider.setSnapToTicks(true);
        this.positionYSlider.addChangeListener(this);
        this.positionYSlider.addMouseListener(this);
        sliderBox.add(this.positionYSlider);
        this.slicePanel.add((Component)sliderBox, "Center");
        JPanel labelBox = new JPanel();
        labelBox.setLayout(new GridLayout(2, 1));
        this.positionLabel = new JLabel(this.positionString);
        this.positionLabel.setPreferredSize(new Dimension((int)((double)this.control.windowWidthSlices * 0.9), 20));
        labelBox.add(this.positionLabel);
        this.valueLabel = new JLabel(this.valueString);
        this.valueLabel.setPreferredSize(new Dimension((int)((double)this.control.windowWidthSlices * 0.9), 20));
        labelBox.add(this.valueLabel);
        this.slicePanel.add((Component)labelBox, "South");
        this.vv.cube.initTextsAndDrawColors(this.imageRegion);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.imageRegion, "Center");
        this.centerPanel.add((Component)this.slicePanel, "West");
        this.upperButtonPanel = new JPanel();
        String renderString = "Mode:";
        JLabel renderLabel = new JLabel(renderString);
        this.upperButtonPanel.add(renderLabel);
        this.renderChoice = new JComboBox<String>(Control.renderName);
        this.renderChoice.setSelectedIndex(this.control.renderMode);
        this.renderChoice.setAlignmentX(0.0f);
        this.renderChoice.addActionListener(this);
        this.renderChoice.setPreferredSize(new Dimension(160, 24));
        this.upperButtonPanel.add(this.renderChoice);
        String interpolationString = "Interpolation:";
        JLabel interpolationLabel = new JLabel(interpolationString);
        this.upperButtonPanel.add(interpolationLabel);
        this.interpolationChoice = new JComboBox<String>(Control.interpolationName);
        this.interpolationChoice.setSelectedIndex(this.control.interpolationMode);
        this.interpolationChoice.setAlignmentX(0.0f);
        this.interpolationChoice.addActionListener(this);
        this.interpolationChoice.setPreferredSize(new Dimension(160, 24));
        this.upperButtonPanel.add(this.interpolationChoice);
        JPanel miniPanelZ = new JPanel();
        this.zAspectLabel = new JLabel(this.zAspectString);
        this.zAspectLabel.setHorizontalAlignment(4);
        miniPanelZ.add(this.zAspectLabel);
        this.tfZaspect = new JTextField();
        this.tfZaspect.setText("" + this.control.zAspect);
        this.tfZaspect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Gui)Gui.this).control.zAspect = Float.parseFloat(Gui.this.tfZaspect.getText());
                Gui.this.vv.setZAspect();
                Gui.this.vv.initializeTransformation();
                Gui.this.vv.buildFrame();
            }
        });
        miniPanelZ.add(this.tfZaspect);
        this.upperButtonPanel.add(miniPanelZ);
        JPanel miniPanelSampling = new JPanel();
        this.samplingLabel = new JLabel(this.samplingString);
        this.samplingLabel.setHorizontalAlignment(4);
        miniPanelSampling.add(this.samplingLabel);
        this.tfSampling = new JTextField();
        this.tfSampling.setText("" + this.control.sampling);
        this.tfSampling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Gui)Gui.this).control.sampling = Float.parseFloat(Gui.this.tfSampling.getText());
                if (((Gui)Gui.this).control.sampling <= 0.0f) {
                    ((Gui)Gui.this).control.sampling = 1.0f;
                }
                if (((Gui)Gui.this).control.sampling > 20.0f) {
                    ((Gui)Gui.this).control.sampling = 20.0f;
                }
                Gui.this.tfSampling.setText("" + ((Gui)Gui.this).control.sampling);
                Gui.this.newDisplayMode();
            }
        });
        miniPanelSampling.add(this.tfSampling);
        this.upperButtonPanel.add(miniPanelSampling);
        JButton buttonBackgroundColor = new JButton("Background");
        buttonBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color bgColor = JColorChooser.showDialog(null, "Choose background color", null);
                if (bgColor != null) {
                    ((Gui)Gui.this).control.backgroundColor = bgColor;
                    Gui.this.imageRegion.setPlaneColor(bgColor);
                    Gui.this.newDisplayMode();
                }
            }
        });
        this.upperButtonPanel.add(buttonBackgroundColor);
        JButton buttonSaveView = new JButton("Snapshot");
        buttonSaveView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.imageRegion.saveToImage();
            }
        });
        this.upperButtonPanel.add(buttonSaveView);
        JButton buttonReset = new JButton("Reset");
        buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.vv.reset();
            }
        });
        this.upperButtonPanel.add(buttonReset);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, this.control.windowHeight));
        sliderPanel.setMaximumSize(new Dimension(this.control.windowWidthSliderRegion, this.control.windowHeight));
        sliderPanel.setLayout(new GridLayout(0, 1));
        this.control.maxDist = (int)Math.sqrt(this.vv.vol.zOffa * this.vv.vol.zOffa * this.control.zAspect * this.control.zAspect + this.vv.vol.yOffa * this.vv.vol.yOffa + this.vv.vol.xOffa * this.vv.vol.xOffa);
        if (!this.control.distWasSet && this.control.renderMode >= 2) {
            this.control.dist = -this.control.maxDist;
        }
        this.control.dist = Math.min(Math.max(this.control.dist, (float)(-this.control.maxDist)), (float)this.control.maxDist);
        JPanel panelDist = new JPanel();
        this.picLED = new Pic(this.control, this.vv, 15, 15);
        this.imageLEDRegion = new ImageRegion(this.control);
        this.imageLEDRegion.setPlaneColor(UIManager.getColor("Panel.background"));
        this.imageLEDRegion.setPic(this.picLED);
        panelDist.add(this.imageLEDRegion);
        this.picLED.render_LED(true);
        this.imageLEDRegion.setImage(this.picLED.image);
        this.imageLEDRegion.repaint();
        String textOnButton = this.control.showTF ? "<html><body><center>Hide<br>TF</center></body></html>" : "<html><body><center>Show<br>TF</center></body></html>";
        JButton tfButton = new JButton(textOnButton);
        tfButton.setMargin(new Insets(0, -30, 0, -30));
        tfButton.setPreferredSize(new Dimension(50, 40));
        panelDist.add(tfButton);
        tfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Gui)Gui.this).control.showTF = !((Gui)Gui.this).control.showTF;
                Gui.this.vv.buildFrame();
            }
        });
        panelDist.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, (this.control.windowHeight - 20) / 2));
        this.distSlider = new JSlider(1, -this.control.maxDist * 2, this.control.maxDist * 2, (int)(2.0f * this.control.dist));
        this.distSlider.setPreferredSize(new Dimension(20, (this.control.windowHeight - 220) / 2));
        this.distSlider.addChangeListener(this);
        this.distSlider.addMouseListener(this);
        this.distLabel1 = new JLabel("" + this.control.dist);
        this.distLabel1.setHorizontalAlignment(0);
        this.distLabel1.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, 15));
        this.distLabel2 = new JLabel("Distance");
        this.distLabel2.setFont(new Font("Sans", 0, 11));
        this.distLabel2.setHorizontalAlignment(0);
        this.distLabel2.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, 15));
        panelDist.add(this.distSlider);
        panelDist.add(this.distLabel1);
        panelDist.add(this.distLabel2);
        sliderPanel.add(panelDist);
        String scaleString = "" + (float)((int)(this.control.scale * 100.0f + 0.5f)) / 100.0f;
        int scaleVal = (int)(Math.log(this.control.scale) / Math.log(1.0717734) + 20.0);
        JPanel panelScale = new JPanel();
        panelScale.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, (this.control.windowHeight - 20) / 2));
        this.scaleSlider = new JSlider(1, 0, 90, scaleVal);
        this.scaleSlider.setPreferredSize(new Dimension(20, (this.control.windowHeight - 90) / 2));
        this.scaleSlider.addChangeListener(this);
        this.scaleSlider.addMouseListener(this);
        this.scaleLabel1 = new JLabel(scaleString);
        this.scaleLabel1.setHorizontalAlignment(0);
        this.scaleLabel1.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, 15));
        this.scaleLabel2 = new JLabel("Scale");
        this.scaleLabel2.setHorizontalAlignment(0);
        this.scaleLabel2.setPreferredSize(new Dimension(this.control.windowWidthSliderRegion, 15));
        panelScale.add(this.scaleSlider);
        panelScale.add(this.scaleLabel1);
        panelScale.add(this.scaleLabel2);
        sliderPanel.add(panelScale);
        this.lowerButtonPanel = new JPanel();
        this.lowerButtonPanel.setPreferredSize(new Dimension(900, 40));
        JPanel panelCheck = new JPanel();
        this.checkAxes = new JCheckBox("Show:  Axes");
        this.checkAxes.setSelected(this.control.showAxes);
        this.checkAxes.setHorizontalAlignment(0);
        this.checkAxes.setHorizontalTextPosition(10);
        this.checkAxes.addItemListener(this);
        panelCheck.add(this.checkAxes);
        this.checkClipLines = new JCheckBox("Clipping");
        this.checkClipLines.setSelected(this.control.showClipLines);
        this.checkClipLines.setHorizontalAlignment(0);
        this.checkClipLines.setHorizontalTextPosition(10);
        this.checkClipLines.addItemListener(this);
        panelCheck.add(this.checkClipLines);
        this.checkSlices = new JCheckBox("Slice positions");
        this.checkSlices.setSelected(this.control.showSlices);
        this.checkSlices.setHorizontalAlignment(0);
        this.checkSlices.setHorizontalTextPosition(10);
        this.checkSlices.addItemListener(this);
        panelCheck.add(this.checkSlices);
        JPanel panelSpinners = new JPanel();
        JLabel labelX = new JLabel("Rotation: x:");
        panelSpinners.add(labelX);
        this.spinnerX = this.makeSpinner(Math.round(this.control.degreeX));
        panelSpinners.add(this.spinnerX);
        JLabel labelY = new JLabel(" y:");
        panelSpinners.add(labelY);
        this.spinnerY = this.makeSpinner(Math.round(this.control.degreeY));
        panelSpinners.add(this.spinnerY);
        JLabel labelZ = new JLabel(" z:");
        panelSpinners.add(labelZ);
        this.spinnerZ = this.makeSpinner(Math.round(this.control.degreeZ));
        panelSpinners.add(this.spinnerZ);
        JPanel panelOrientationButtons = new JPanel();
        panelOrientationButtons.setLayout(new GridLayout(1, 3));
        JButton buttonXY = new JButton("xy");
        buttonXY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enableSpinnerChangeListener = false;
                ((Gui)Gui.this).control.degreeX = 0.0f;
                ((Gui)Gui.this).control.degreeY = 0.0f;
                ((Gui)Gui.this).control.degreeZ = 0.0f;
                Gui.this.vv.setRotation(((Gui)Gui.this).control.degreeX, ((Gui)Gui.this).control.degreeY, ((Gui)Gui.this).control.degreeZ);
                Gui.this.newDisplayMode();
                Gui.this.enableSpinnerChangeListener = true;
            }
        });
        panelOrientationButtons.add(buttonXY);
        JButton buttonYZ = new JButton("yz");
        buttonYZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enableSpinnerChangeListener = false;
                ((Gui)Gui.this).control.degreeX = 0.0f;
                ((Gui)Gui.this).control.degreeY = 90.0f;
                ((Gui)Gui.this).control.degreeZ = -90.0f;
                Gui.this.vv.setRotation(((Gui)Gui.this).control.degreeX, ((Gui)Gui.this).control.degreeY, ((Gui)Gui.this).control.degreeZ);
                Gui.this.newDisplayMode();
                Gui.this.enableSpinnerChangeListener = true;
            }
        });
        panelOrientationButtons.add(buttonYZ);
        JButton buttonXZ = new JButton("xz");
        buttonXZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.enableSpinnerChangeListener = false;
                ((Gui)Gui.this).control.degreeX = 90.0f;
                ((Gui)Gui.this).control.degreeY = 0.0f;
                ((Gui)Gui.this).control.degreeZ = 0.0f;
                Gui.this.vv.setRotation(((Gui)Gui.this).control.degreeX, ((Gui)Gui.this).control.degreeY, ((Gui)Gui.this).control.degreeZ);
                Gui.this.newDisplayMode();
                Gui.this.enableSpinnerChangeListener = true;
            }
        });
        panelOrientationButtons.add(buttonXZ);
        this.lowerButtonPanel.add(panelSpinners);
        JLabel spaceLabel2 = new JLabel("   ");
        this.lowerButtonPanel.add(spaceLabel2);
        this.lowerButtonPanel.add(panelOrientationButtons);
        JLabel spaceLabel1 = new JLabel("   ");
        this.lowerButtonPanel.add(spaceLabel1);
        this.lowerButtonPanel.add(panelCheck);
        this.transferFunctionPanel = new JPanel();
        this.transferFunctionPanel.setPreferredSize(new Dimension(280, 650));
        JLabel tfLabel = new JLabel(" Transfer Function (TF): Color & Alpha");
        this.transferFunctionPanel.add(tfLabel);
        this.lutChoice = new JComboBox<String>(Control.lutName);
        this.lutChoice.setSelectedIndex(this.control.lutNr);
        this.lutChoice.setPreferredSize(new Dimension(240, 30));
        this.lutChoice.setAlignmentX(0.0f);
        this.lutChoice.addActionListener(this);
        this.transferFunctionPanel.add(this.lutChoice);
        JLabel rgbLabel = new JLabel("Draw LUT");
        this.transferFunctionPanel.add(rgbLabel);
        JRadioButton rgbButton = new JRadioButton("RGB");
        rgbButton.setHorizontalTextPosition(2);
        rgbButton.setActionCommand("RGB");
        rgbButton.setSelected(true);
        JRadioButton rButton = new JRadioButton("R");
        rButton.setHorizontalTextPosition(2);
        rButton.setActionCommand("R");
        JRadioButton gButton = new JRadioButton("G");
        gButton.setActionCommand("G");
        gButton.setHorizontalTextPosition(2);
        JRadioButton bButton = new JRadioButton("B");
        bButton.setActionCommand("B");
        bButton.setHorizontalTextPosition(2);
        ButtonGroup group = new ButtonGroup();
        group.add(rgbButton);
        group.add(rButton);
        group.add(gButton);
        group.add(bButton);
        rButton.addActionListener(this);
        gButton.addActionListener(this);
        bButton.addActionListener(this);
        rgbButton.addActionListener(this);
        this.transferFunctionPanel.add(rgbButton);
        this.transferFunctionPanel.add(rButton);
        this.transferFunctionPanel.add(gButton);
        this.transferFunctionPanel.add(bButton);
        this.transferFunctionPanel.add(this.vv.tf_rgb);
        this.vv.tf_rgb.channel = 3;
        this.transferFunctionPanel.add(this.vv.gradientLUT);
        JPanel tfPanel1D = new JPanel();
        tfPanel1D.setPreferredSize(new Dimension(256, 240));
        JLabel alphaLabel = new JLabel("Draw the alpha graph of the 1D-TF(lum)");
        alphaLabel.setFont(new Font("Sans", 0, 12));
        tfPanel1D.add(alphaLabel);
        JLabel alphaLabel1 = new JLabel("                                      ");
        tfPanel1D.add(alphaLabel1);
        tfPanel1D.add(this.vv.tf_a1);
        this.alphaSlider1 = new JSlider(0, 300, 150);
        this.alphaSlider1.setBorder(new TitledBorder(empty, "global alpha offset", 2, 6, new Font("Sans", 0, 10)));
        this.alphaSlider1.addChangeListener(this);
        this.alphaSlider1.addMouseListener(this);
        this.alphaSlider1.setPreferredSize(new Dimension(140, 30));
        tfPanel1D.add(this.alphaSlider1);
        this.autobutton1 = new JButton("auto");
        this.autobutton1.setMargin(new Insets(1, 1, 1, 1));
        this.autobutton1.setFont(new Font("Sans", 0, 12));
        this.autobutton1.setPreferredSize(new Dimension(50, 20));
        this.autobutton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider1.setValue(150);
                ((Gui)Gui.this).vv.tf_a1.setAlphaOffset(0);
                ((Gui)Gui.this).vv.tf_a1.setAlphaAuto();
                ((Gui)Gui.this).vv.tf_a1.repaint();
                Gui.this.newDisplayMode();
            }
        });
        tfPanel1D.add(this.autobutton1);
        this.clearbutton1 = new JButton("clear");
        this.clearbutton1.setMargin(new Insets(1, 1, 1, 1));
        this.clearbutton1.setFont(new Font("Sans", 0, 12));
        this.clearbutton1.setPreferredSize(new Dimension(50, 20));
        this.clearbutton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider1.setValue(150);
                ((Gui)Gui.this).vv.tf_a1.setAlphaOffset(0);
                ((Gui)Gui.this).vv.tf_a1.clearAlpha();
                ((Gui)Gui.this).vv.tf_a1.repaint();
                Gui.this.newDisplayMode();
            }
        });
        tfPanel1D.add(this.clearbutton1);
        JPanel tfPanel2D = new JPanel();
        tfPanel2D.setPreferredSize(new Dimension(256, 240));
        alphaLabel = new JLabel("Pick alpha (& color) and draw the 2D-");
        alphaLabel.setFont(new Font("Sans", 0, 12));
        tfPanel2D.add(alphaLabel);
        alphaLabel1 = new JLabel("TF(lum,grad). Draw with Alt key to erase.");
        alphaLabel1.setFont(new Font("Sans", 0, 12));
        tfPanel2D.add(alphaLabel1);
        this.vv.gradient2 = new Gradient(this.control, this.vv, 150, 18);
        tfPanel2D.add(this.vv.gradient2);
        this.checkPickColor2 = new JCheckBox("pick color");
        this.checkPickColor2.setSelected(this.control.pickColor);
        this.checkPickColor2.setHorizontalAlignment(0);
        this.checkPickColor2.addItemListener(this);
        boolean enableCheckColor = this.control.lutNr != 0 && this.control.lutNr != 1;
        this.checkPickColor2.setEnabled(enableCheckColor);
        tfPanel2D.add(this.checkPickColor2);
        tfPanel2D.add(this.vv.tf_a2);
        this.alphaSlider2 = new JSlider(0, 300, 150);
        this.alphaSlider2.setBorder(new TitledBorder(empty, "global alpha offset", 2, 6, new Font("Sans", 0, 10)));
        this.alphaSlider2.addChangeListener(this);
        this.alphaSlider2.addMouseListener(this);
        this.alphaSlider2.setPreferredSize(new Dimension(140, 30));
        tfPanel2D.add(this.alphaSlider2);
        this.autobutton2 = new JButton("auto");
        this.autobutton2.setMargin(new Insets(1, 1, 1, 1));
        this.autobutton2.setFont(new Font("Sans", 0, 12));
        this.autobutton2.setPreferredSize(new Dimension(50, 20));
        this.autobutton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider2.setValue(150);
                ((Gui)Gui.this).control.alphaPaint2 = 64;
                ((Gui)Gui.this).vv.gradient2.repaint();
                ((Gui)Gui.this).vv.tf_a2.setAlphaOffset(0);
                ((Gui)Gui.this).control.pickColor = false;
                if (Gui.this.checkPickColor2 != null) {
                    Gui.this.checkPickColor2.setSelected(((Gui)Gui.this).control.pickColor);
                }
                ((Gui)Gui.this).vv.lookupTable.setLut();
                ((Gui)Gui.this).vv.tf_a2.setAlphaAuto();
                ((Gui)Gui.this).vv.tf_a2.repaint();
                Gui.this.newDisplayMode();
            }
        });
        tfPanel2D.add(this.autobutton2);
        this.clearbutton2 = new JButton("clear");
        this.clearbutton2.setMargin(new Insets(1, 1, 1, 1));
        this.clearbutton2.setFont(new Font("Sans", 0, 12));
        this.clearbutton2.setPreferredSize(new Dimension(50, 20));
        this.clearbutton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider2.setValue(150);
                ((Gui)Gui.this).vv.tf_a2.setAlphaOffset(0);
                ((Gui)Gui.this).vv.tf_a2.clearAlpha();
                ((Gui)Gui.this).vv.tf_a2.repaint();
                Gui.this.newDisplayMode();
            }
        });
        tfPanel2D.add(this.clearbutton2);
        JPanel tfPanel2DLH = new JPanel();
        tfPanel2DLH.setPreferredSize(new Dimension(256, 240));
        alphaLabel = new JLabel("Pick alpha (& color) and draw the 2D-");
        alphaLabel.setFont(new Font("Sans", 0, 12));
        tfPanel2DLH.add(alphaLabel);
        alphaLabel1 = new JLabel("TF(mean,diff). Draw with Alt key to erase.");
        alphaLabel1.setFont(new Font("Sans", 0, 12));
        tfPanel2DLH.add(alphaLabel1);
        this.vv.gradient3 = new Gradient(this.control, this.vv, 150, 18);
        tfPanel2DLH.add(this.vv.gradient3);
        this.checkPickColor3 = new JCheckBox("pick color");
        this.checkPickColor3.setSelected(this.control.pickColor);
        this.checkPickColor3.setHorizontalAlignment(0);
        this.checkPickColor3.addItemListener(this);
        this.checkPickColor3.setEnabled(enableCheckColor);
        tfPanel2DLH.add(this.checkPickColor3);
        tfPanel2DLH.add(this.vv.tf_a3);
        this.alphaSlider3 = new JSlider(0, 300, 150);
        this.alphaSlider3.setBorder(new TitledBorder(empty, "global alpha offset", 2, 6, new Font("Sans", 0, 10)));
        this.alphaSlider3.addChangeListener(this);
        this.alphaSlider3.addMouseListener(this);
        this.alphaSlider3.setPreferredSize(new Dimension(140, 30));
        tfPanel2DLH.add(this.alphaSlider3);
        this.autobutton3 = new JButton("auto");
        this.autobutton3.setMargin(new Insets(1, 1, 1, 1));
        this.autobutton3.setFont(new Font("Sans", 0, 12));
        this.autobutton3.setPreferredSize(new Dimension(50, 20));
        this.autobutton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider3.setValue(150);
                ((Gui)Gui.this).control.alphaPaint3 = 64;
                ((Gui)Gui.this).vv.gradient3.repaint();
                ((Gui)Gui.this).vv.tf_a3.setAlphaOffset(0);
                ((Gui)Gui.this).control.pickColor = false;
                if (Gui.this.checkPickColor2 != null) {
                    Gui.this.checkPickColor2.setSelected(((Gui)Gui.this).control.pickColor);
                }
                ((Gui)Gui.this).vv.lookupTable.setLut();
                ((Gui)Gui.this).vv.tf_a3.setAlphaAuto();
                ((Gui)Gui.this).vv.tf_a3.repaint();
                Gui.this.newDisplayMode();
            }
        });
        tfPanel2DLH.add(this.autobutton3);
        this.clearbutton3 = new JButton("clear");
        this.clearbutton3.setMargin(new Insets(1, 1, 1, 1));
        this.clearbutton3.setFont(new Font("Sans", 0, 12));
        this.clearbutton3.setPreferredSize(new Dimension(50, 20));
        this.clearbutton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider3.setValue(150);
                ((Gui)Gui.this).vv.tf_a3.setAlphaOffset(0);
                ((Gui)Gui.this).vv.tf_a3.clearAlpha();
                ((Gui)Gui.this).vv.tf_a3.repaint();
                Gui.this.newDisplayMode();
            }
        });
        tfPanel2DLH.add(this.clearbutton3);
        JPanel tfPanelPaint = new JPanel();
        tfPanelPaint.setPreferredSize(new Dimension(256, 240));
        JPanel textLabels = new JPanel();
        textLabels.setLayout(new GridLayout(6, 1));
        JLabel alphaLabel4a = new JLabel("Pick alpha (& color) values and click", 2);
        alphaLabel4a.setFont(new Font("Sans", 0, 12));
        textLabels.add(alphaLabel4a);
        JLabel alphaLabel4b = new JLabel("the slice images on the left to assign", 2);
        alphaLabel4b.setFont(new Font("Sans", 0, 12));
        textLabels.add(alphaLabel4b);
        JLabel alphaLabel4c = new JLabel("these values to connected similar", 2);
        alphaLabel4c.setFont(new Font("Sans", 0, 12));
        textLabels.add(alphaLabel4c);
        JLabel alphaLabel4d = new JLabel("regions of the volume = 3D-TF(x,y,z)", 2);
        alphaLabel4d.setFont(new Font("Sans", 0, 12));
        textLabels.add(alphaLabel4d);
        JLabel alphaLabel4e = new JLabel("Alt-click to erase.", 2);
        alphaLabel4e.setFont(new Font("Sans", 0, 12));
        textLabels.add(alphaLabel4e);
        JLabel alphaLabel4f = new JLabel("                                       ");
        textLabels.add(alphaLabel4f);
        tfPanelPaint.add(textLabels);
        this.vv.gradient4 = new Gradient(this.control, this.vv, 150, 18);
        tfPanelPaint.add(this.vv.gradient4);
        JLabel alphaLabel4g = new JLabel("                                       ");
        tfPanelPaint.add(alphaLabel4g);
        JPanel sliderBox2 = new JPanel();
        sliderBox2.setLayout(new GridLayout(1, 2));
        this.sliderLumTolerance = new JSlider(0, 128, this.control.lumTolerance);
        this.sliderLumTolerance.setBorder(new TitledBorder(empty, "luminance tolerance", 2, 6, new Font("Sans", 0, 10)));
        this.sliderLumTolerance.addChangeListener(this);
        this.sliderLumTolerance.setPreferredSize(new Dimension(135, 30));
        sliderBox2.add(this.sliderLumTolerance);
        this.sliderGradTolerance = new JSlider(0, 128, this.control.gradTolerance);
        this.sliderGradTolerance.setBorder(new TitledBorder(empty, "gradient tolerance", 2, 6, new Font("Sans", 0, 10)));
        this.sliderGradTolerance.addChangeListener(this);
        this.sliderGradTolerance.setPreferredSize(new Dimension(135, 30));
        sliderBox2.add(this.sliderGradTolerance);
        tfPanelPaint.add(sliderBox2);
        this.alphaSlider4 = new JSlider(0, 300, 150);
        this.alphaSlider4.setBorder(new TitledBorder(empty, "global alpha offset", 2, 6, new Font("Sans", 0, 10)));
        this.alphaSlider4.addChangeListener(this);
        this.alphaSlider4.addMouseListener(this);
        this.alphaSlider4.setPreferredSize(new Dimension(140, 30));
        tfPanelPaint.add(this.alphaSlider4);
        this.clearbutton4 = new JButton("clear");
        this.clearbutton4.setMargin(new Insets(1, 1, 1, 1));
        this.clearbutton4.setFont(new Font("Sans", 0, 12));
        this.clearbutton4.setPreferredSize(new Dimension(50, 20));
        this.clearbutton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.alphaSlider4.setValue(150);
                ((Gui)Gui.this).vv.tf_a4.setAlphaOffset(0);
                ((Gui)Gui.this).vv.tf_a4.clearAlpha();
                Gui.this.newDisplayMode();
            }
        });
        tfPanelPaint.add(this.clearbutton4);
        this.transferFunctionTabbedPane = new JTabbedPane(1);
        JPanel jp1 = new JPanel();
        JPanel jp2 = new JPanel();
        JPanel jp3 = new JPanel();
        JPanel jp4 = new JPanel();
        this.transferFunctionTabbedPane.addTab("1D", jp1);
        this.transferFunctionTabbedPane.addTab("2D Grad", jp2);
        this.transferFunctionTabbedPane.addTab("2D MD", jp3);
        this.transferFunctionTabbedPane.addTab("3D Fill", jp4);
        this.transferFunctionTabbedPane.setSelectedIndex(this.control.alphaMode);
        this.transferFunctionTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                ((Gui)Gui.this).control.alphaMode = pane.getSelectedIndex();
                if (Gui.this.checkPickColor2 != null) {
                    Gui.this.checkPickColor2.setSelected(((Gui)Gui.this).control.pickColor);
                }
                if (Gui.this.checkPickColor3 != null) {
                    Gui.this.checkPickColor3.setSelected(((Gui)Gui.this).control.pickColor);
                }
                if (((Gui)Gui.this).control.LOG) {
                    System.out.println("alphaMode " + ((Gui)Gui.this).control.alphaMode);
                }
                ((Gui)Gui.this).control.drag = false;
                ((Gui)Gui.this).control.alphaWasChanged = true;
                Gui.this.newDisplayMode();
            }
        });
        jp1.add(tfPanel1D);
        jp2.add(tfPanel2D);
        jp3.add(tfPanel2DLH);
        jp4.add(tfPanelPaint);
        this.transferFunctionPanel.add(this.transferFunctionTabbedPane);
        this.lightBox = new JPanel();
        this.lightBox.setLayout(new BorderLayout());
        JPanel lightSliderBoxR = new JPanel();
        JPanel lightSliderBoxL = new JPanel();
        lightSliderBoxR.setPreferredSize(new Dimension(102, 110));
        lightSliderBoxL.setPreferredSize(new Dimension(58, 110));
        lightSliderBoxR.setLayout(new GridLayout(5, 1));
        lightSliderBoxL.setLayout(new GridLayout(5, 1));
        JLabel jl1 = new JLabel("object color", 4);
        jl1.setFont(new Font("Sans", 0, 10));
        lightSliderBoxL.add(jl1);
        this.objectLightSlider = new JSlider(0, 0, 100, (int)(50.0f * this.control.objectLightValue));
        this.objectLightSlider.addChangeListener(this);
        this.objectLightSlider.addMouseListener(this);
        this.objectLightSlider.setEnabled(this.control.useLight);
        lightSliderBoxR.add(this.objectLightSlider);
        JLabel jl2 = new JLabel("ambient", 4);
        jl2.setFont(new Font("Sans", 0, 10));
        lightSliderBoxL.add(jl2);
        this.ambientSlider = new JSlider(0, 0, 100, (int)(this.control.ambientValue * 100.0f));
        this.ambientSlider.addChangeListener(this);
        this.ambientSlider.addMouseListener(this);
        this.ambientSlider.setEnabled(this.control.useLight);
        lightSliderBoxR.add(this.ambientSlider);
        JLabel jl3 = new JLabel("diffuse", 4);
        jl3.setFont(new Font("Sans", 0, 10));
        lightSliderBoxL.add(jl3);
        this.diffuseSlider = new JSlider(0, 0, 100, (int)(this.control.diffuseValue * 100.0f));
        this.diffuseSlider.addChangeListener(this);
        this.diffuseSlider.addMouseListener(this);
        this.diffuseSlider.setEnabled(this.control.useLight);
        lightSliderBoxR.add(this.diffuseSlider);
        JLabel jl4 = new JLabel("specular", 4);
        jl4.setFont(new Font("Sans", 0, 10));
        lightSliderBoxL.add(jl4);
        this.specularSlider = new JSlider(0, 0, 100, (int)(this.control.specularValue * 100.0f));
        this.specularSlider.addChangeListener(this);
        this.specularSlider.addMouseListener(this);
        this.specularSlider.setEnabled(this.control.useLight);
        lightSliderBoxR.add(this.specularSlider);
        JLabel jl5 = new JLabel("shine", 4);
        jl5.setFont(new Font("Sans", 0, 10));
        lightSliderBoxL.add(jl5);
        int val = (int)(200.0 * Math.pow(this.control.shineValue / 400.0f, 0.3333333432674408) - 20.0);
        val = Math.min(100, Math.max(0, val));
        this.shineSlider = new JSlider(0, 0, 100, val);
        this.shineSlider.addChangeListener(this);
        this.shineSlider.addMouseListener(this);
        this.shineSlider.setEnabled(this.control.useLight);
        lightSliderBoxR.add(this.shineSlider);
        this.checkLight = new JCheckBox("Light");
        this.checkLight.setSelected(this.control.useLight);
        this.checkLight.addItemListener(this);
        this.picLight = new Pic(this.control, this.vv, 55, 55);
        this.imageLightRegion = new ImageRegion(this.control);
        this.imageLightRegion.setPlaneColor(UIManager.getColor("Panel.background"));
        this.imageLightRegion.addMouseMotionListener(this);
        this.imageLightRegion.addMouseListener(this);
        this.imageLightRegion.setPic(this.picLight);
        JPanel lightRegion = new JPanel();
        lightRegion.add(this.imageLightRegion);
        this.picLight.render_sphere();
        this.imageLightRegion.setImage(this.picLight.image);
        this.imageLightRegion.repaint();
        JPanel lightBoxLeft = new JPanel();
        lightBoxLeft.setPreferredSize(new Dimension(120, 115));
        lightBoxLeft.setLayout(new BorderLayout());
        lightBoxLeft.add((Component)this.checkLight, "North");
        lightBoxLeft.add((Component)lightRegion, "Center");
        this.jLabelLight = new JLabel("<html>Drag sphere <P>to change<P> direction, <P> double click<P> to change <P>color of light.</html>");
        lightBoxLeft.add((Component)this.jLabelLight, "West");
        this.jLabelLight.setFont(new Font("SANS", 0, 10));
        if (this.control.useLight) {
            this.jLabelLight.setForeground(Color.BLACK);
        } else {
            this.jLabelLight.setForeground(UIManager.getColor("Panel.background"));
        }
        JPanel lightBoxBottom = new JPanel();
        lightBoxBottom.setLayout(new GridLayout(1, 2));
        this.lightBox.add((Component)lightBoxLeft, "West");
        this.lightBox.add((Component)lightSliderBoxL, "Center");
        this.lightBox.add((Component)lightSliderBoxR, "East");
        this.transferFunctionPanel.add(this.lightBox);
        if (this.control.renderMode >= 2) {
            this.transferFunctionTabbedPane.setVisible(true);
            this.samplingLabel.setVisible(true);
            this.tfSampling.setVisible(true);
        } else {
            this.transferFunctionTabbedPane.setVisible(false);
            this.samplingLabel.setVisible(false);
            this.tfSampling.setVisible(false);
        }
        if (this.control.renderMode == 4) {
            this.lightBox.setVisible(true);
        } else {
            this.lightBox.setVisible(false);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.centerPanel, "West");
        this.add((Component)sliderPanel, "Center");
        if (this.control.showTF) {
            this.add((Component)this.transferFunctionPanel, "East");
        }
        this.add((Component)this.upperButtonPanel, "North");
        this.add((Component)this.lowerButtonPanel, "South");
        this.validate();
        this.control.scaledDist = this.control.scale * this.control.dist;
    }

    public void setPositionText(int wx, int wy, int wz) {
        int xs = 10;
        int ys = 14;
        this.sliceImageRegion.setText("xy slice  z=" + this.positionZ, 0, xs, wy + ys - 3, 0, Color.black, 1);
        this.sliceImageRegion.setText("yz slice  x=" + this.positionX, 1, xs, wy + wz + 2 * ys - 3, 0, Color.black, 1);
        this.sliceImageRegion.setText("xz slice  y=" + this.positionY, 2, xs, wy + 2 * wz + 3 * ys - 3, 0, Color.black, 1);
    }

    private JSpinner makeSpinner(float value) {
        Float current = new Float(value);
        Float min = new Float(-360.0f);
        Float max = new Float(360.0f);
        Float step = new Float(1.0f);
        SpinnerNumberModel m_numberSpinnerModel = new SpinnerNumberModel(current, min, max, step);
        JSpinner jSpinner = new JSpinner(m_numberSpinnerModel);
        jSpinner.addChangeListener(new SpinnerListener());
        return jSpinner;
    }

    void updateDistSlider() {
        this.control.maxDist = (int)Math.sqrt(this.vv.vol.zOffa * this.vv.vol.zOffa * this.control.zAspect * this.control.zAspect + this.vv.vol.yOffa * this.vv.vol.yOffa + this.vv.vol.xOffa * this.vv.vol.xOffa);
        this.distSlider.setMaximum(this.control.maxDist * 2);
        this.distSlider.setMinimum(-this.control.maxDist * 2);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        if (slider == this.scaleSlider) {
            this.scaleSliderValue = this.scaleSlider.getValue();
            this.scaleSliderValue -= 20.0f;
            float s = (float)Math.pow(1.0717734, this.scaleSliderValue);
            if (s == this.control.scale) {
                return;
            }
            this.control.scale = s;
            String scaleString = "" + (float)((int)(this.control.scale * 100.0f + 0.5f)) / 100.0f;
            this.scaleLabel1.setText(scaleString);
            this.control.scaledDist = this.control.dist * this.control.scale;
            this.vv.setScale();
            this.vv.setZAspect();
            this.vv.initializeTransformation();
        } else if (slider == this.distSlider) {
            float d = (float)this.distSlider.getValue() / 2.0f;
            if (d == this.control.dist) {
                return;
            }
            this.control.dist = d;
            this.control.scaledDist = this.control.dist * this.control.scale;
            this.distLabel1.setText("" + this.control.dist);
        } else if (slider == this.positionXSlider) {
            this.control.positionFactorX = (float)this.positionXSlider.getValue() / (float)this.maxPositionX;
            float xV = (float)(this.vv.vol.widthV - 1) * this.control.positionFactorX;
            this.positionX = (int)xV;
            if (slider.getValueIsAdjusting()) {
                this.showPositionAndValues();
            }
            this.vv.cube.setCornersYZ(xV);
            this.picSlice.drawSlices();
            this.sliceImageRegion.findLines(this.vv.cube, this.control.scaledDist, this.vv.vol.depthV);
            this.sliceImageRegion.setImage(this.picSlice.image);
            this.sliceImageRegion.repaint();
        } else if (slider == this.positionYSlider) {
            this.control.positionFactorY = (float)this.positionYSlider.getValue() / (float)this.maxPositionY;
            float yV = (float)(this.vv.vol.heightV - 1) * this.control.positionFactorY;
            this.positionY = (int)yV;
            if (slider.getValueIsAdjusting()) {
                this.showPositionAndValues();
            }
            this.vv.cube.setCornersXZ(yV);
            this.picSlice.drawSlices();
            this.sliceImageRegion.findLines(this.vv.cube, this.control.scaledDist, this.vv.vol.depthV);
            this.sliceImageRegion.setImage(this.picSlice.image);
            this.sliceImageRegion.repaint();
        } else if (slider == this.positionZSlider) {
            this.control.positionFactorZ = (float)this.positionZSlider.getValue() / (float)this.maxPositionZ;
            float zV = (float)(this.vv.vol.depthV - 1) * this.control.positionFactorZ;
            this.positionZ = (int)zV;
            if (slider.getValueIsAdjusting()) {
                this.showPositionAndValues();
            }
            this.vv.cube.setCornersXY(zV);
            this.picSlice.drawSlices();
            this.sliceImageRegion.findLines(this.vv.cube, this.control.scaledDist, this.vv.vol.depthV);
            this.sliceImageRegion.setImage(this.picSlice.image);
            this.sliceImageRegion.repaint();
        } else if (slider == this.alphaSlider1) {
            this.vv.tf_a1.setAlphaOffset(this.alphaSlider1.getValue() - 150);
            this.vv.tf_a1.scaleAlpha();
            this.vv.tf_a1.repaint();
        } else if (slider == this.alphaSlider2) {
            this.vv.tf_a2.setAlphaOffset(this.alphaSlider2.getValue() - 150);
            this.vv.tf_a2.scaleAlpha();
            this.vv.tf_a2.repaint();
        } else if (slider == this.alphaSlider3) {
            this.vv.tf_a3.setAlphaOffset(this.alphaSlider3.getValue() - 150);
            this.vv.tf_a3.scaleAlpha();
            this.vv.tf_a3.repaint();
        } else if (slider == this.alphaSlider4) {
            this.vv.tf_a4.setAlphaOffset(this.alphaSlider4.getValue() - 150);
            this.vv.tf_a4.scaleAlpha();
        } else if (slider == this.sliderLumTolerance) {
            this.control.lumTolerance = this.sliderLumTolerance.getValue();
        } else if (slider == this.sliderGradTolerance) {
            this.control.gradTolerance = this.sliderGradTolerance.getValue();
        } else if (slider == this.objectLightSlider) {
            this.control.objectLightValue = (float)this.objectLightSlider.getValue() / 50.0f;
        } else if (slider == this.ambientSlider) {
            this.control.ambientValue = (float)this.ambientSlider.getValue() / 100.0f;
        } else if (slider == this.diffuseSlider) {
            this.control.diffuseValue = (float)this.diffuseSlider.getValue() / 100.0f;
        } else if (slider == this.specularSlider) {
            this.control.specularValue = (float)this.specularSlider.getValue() / 100.0f;
        } else if (slider == this.shineSlider) {
            float k = 200.0f;
            this.control.shineValue = (float)(Math.pow((float)(this.shineSlider.getValue() + 20) / k, 3.0) * 2.0 * (double)k);
        }
        if (slider == this.objectLightSlider || slider == this.ambientSlider || slider == this.diffuseSlider || slider == this.specularSlider || slider == this.shineSlider) {
            this.picLight.render_sphere();
            this.imageLightRegion.setImage(this.picLight.image);
            this.imageLightRegion.repaint();
        }
        if ((slider == this.positionXSlider || slider == this.positionYSlider || slider == this.positionZSlider) && this.control.showSlices || slider == this.scaleSlider || slider == this.alphaSlider1 || slider == this.alphaSlider2 || slider == this.alphaSlider3 || slider == this.alphaSlider4 || slider == this.objectLightSlider || slider == this.ambientSlider || slider == this.diffuseSlider || slider == this.specularSlider || slider == this.shineSlider || slider == this.distSlider) {
            this.newDisplayMode();
        }
    }

    private void showPositionAndValues() {
        this.positionString = String.format("  x=%3d, y=%3d, z=%3d", this.positionX, this.positionY, this.positionZ);
        if (this.control.isRGB) {
            int r = this.vv.vol.data3D[1][this.positionZ + 2][this.positionY + 2][this.positionX + 2] & 0xFF;
            int g = this.vv.vol.data3D[2][this.positionZ + 2][this.positionY + 2][this.positionX + 2] & 0xFF;
            int b = this.vv.vol.data3D[3][this.positionZ + 2][this.positionY + 2][this.positionX + 2] & 0xFF;
            this.valueString = String.format("  R=%3d, G=%3d, B=%3d", r, g, b);
        } else {
            int val = this.vv.vol.data3D[0][this.positionZ + 2][this.positionY + 2][this.positionX + 2] & 0xFF;
            this.valueString = String.format("  Value=%3d", val);
        }
        this.valueLabel.setText(this.valueString);
        this.positionLabel.setText(this.positionString);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("R")) {
            this.vv.tf_rgb.channel = 0;
        } else if (actionCommand.equals("G")) {
            this.vv.tf_rgb.channel = 1;
        } else if (actionCommand.equals("B")) {
            this.vv.tf_rgb.channel = 2;
        } else if (actionCommand.equals("RGB")) {
            this.vv.tf_rgb.channel = 3;
        } else {
            JComboBox cb = (JComboBox)e.getSource();
            if (cb == this.lutChoice) {
                this.control.lutNr = cb.getSelectedIndex();
                switch (this.control.lutNr) {
                    case 0: {
                        this.vv.lookupTable.orig();
                        break;
                    }
                    case 1: {
                        this.vv.lookupTable.gray();
                        break;
                    }
                    case 2: {
                        this.vv.lookupTable.spectrum();
                        break;
                    }
                    case 3: {
                        this.vv.lookupTable.fire();
                        break;
                    }
                    case 4: {
                        this.vv.lookupTable.thermal();
                    }
                }
                this.vv.lookupTable.setLut();
                if (this.checkPickColor2 != null) {
                    this.checkPickColor2.setSelected(this.control.pickColor);
                }
                if (this.checkPickColor3 != null) {
                    this.checkPickColor3.setSelected(this.control.pickColor);
                }
                if (this.control.lutNr == 0 || this.control.lutNr == 1) {
                    if (this.checkPickColor2 != null) {
                        this.checkPickColor2.setEnabled(false);
                    }
                    if (this.checkPickColor3 != null) {
                        this.checkPickColor3.setEnabled(false);
                    }
                } else {
                    if (this.checkPickColor2 != null) {
                        this.checkPickColor2.setEnabled(true);
                    }
                    if (this.checkPickColor3 != null) {
                        this.checkPickColor3.setEnabled(true);
                    }
                }
                this.control.rPaint = this.vv.lookupTable.lut[this.control.indexPaint][0];
                this.control.gPaint = this.vv.lookupTable.lut[this.control.indexPaint][1];
                this.control.bPaint = this.vv.lookupTable.lut[this.control.indexPaint][2];
                if (this.control.renderMode >= 2 && this.control.alphaMode == 3) {
                    this.vv.gradient4.repaint();
                }
            } else if (cb == this.renderChoice) {
                this.control.renderMode = cb.getSelectedIndex();
                this.valueString = "";
                this.positionString = "";
                this.valueLabel.setText(this.valueString);
                this.positionLabel.setText(this.positionString);
                if (this.control.renderMode >= 2) {
                    this.transferFunctionTabbedPane.setVisible(true);
                    this.samplingLabel.setVisible(true);
                    this.tfSampling.setVisible(true);
                    this.control.dist = -2 * this.control.maxDist;
                } else {
                    this.transferFunctionTabbedPane.setVisible(false);
                    this.samplingLabel.setVisible(false);
                    this.tfSampling.setVisible(false);
                    this.control.dist = 0.0f;
                }
                if (this.control.renderMode == 4) {
                    this.lightBox.setVisible(true);
                } else {
                    this.lightBox.setVisible(false);
                }
                this.distSlider.setValue((int)this.control.dist);
                this.distLabel1.setText("" + this.control.dist);
                this.control.scaledDist = this.control.dist * this.control.scale;
            } else if (cb == this.interpolationChoice) {
                this.control.interpolationMode = cb.getSelectedIndex();
            }
        }
        this.vv.cube.initTextsAndDrawColors(this.imageRegion);
        this.newDisplayMode();
        super.requestFocus();
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkAxes) {
            this.control.showAxes = this.checkAxes.isSelected();
        } else if (e.getSource() == this.checkSlices) {
            this.control.showSlices = this.checkSlices.isSelected();
        } else if (e.getSource() == this.checkClipLines) {
            this.control.showClipLines = this.checkClipLines.isSelected();
        } else if (e.getSource() == this.checkPickColor2) {
            if (this.checkPickColor2.isSelected()) {
                this.control.pickColor = true;
                this.control.rPaint = this.vv.lookupTable.lut[128][0];
                this.control.gPaint = this.vv.lookupTable.lut[128][1];
                this.control.bPaint = this.vv.lookupTable.lut[128][2];
            } else {
                this.control.pickColor = false;
            }
            this.vv.gradient2.repaint();
        } else if (e.getSource() == this.checkPickColor3) {
            if (this.checkPickColor3.isSelected()) {
                this.control.pickColor = true;
                this.control.rPaint = this.vv.lookupTable.lut[128][0];
                this.control.gPaint = this.vv.lookupTable.lut[128][1];
                this.control.bPaint = this.vv.lookupTable.lut[128][2];
            } else {
                this.control.pickColor = false;
            }
            this.vv.gradient3.repaint();
        } else if (e.getSource() == this.checkLight) {
            this.control.useLight = this.checkLight.isSelected();
            this.picLight.render_sphere();
            this.imageLightRegion.setImage(this.picLight.image);
            this.imageLightRegion.repaint();
            if (this.control.useLight) {
                this.jLabelLight.setForeground(Color.BLACK);
            } else {
                this.jLabelLight.setForeground(UIManager.getColor("Panel.background"));
            }
            this.objectLightSlider.setEnabled(this.control.useLight);
            this.shineSlider.setEnabled(this.control.useLight);
            this.ambientSlider.setEnabled(this.control.useLight);
            this.diffuseSlider.setEnabled(this.control.useLight);
            this.specularSlider.setEnabled(this.control.useLight);
        }
        this.newDisplayMode();
        super.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Color lightColor;
        Object source = e.getSource();
        if (source == this.sliceImageRegion) {
            int xm = e.getX();
            int ym = e.getY();
            if (this.control.alphaMode == 3 && this.control.renderMode >= 2) {
                int[] vals = this.sliceImageRegion.getValues(xm, ym);
                int alpha = this.control.alphaPaint4;
                if (e.isAltDown()) {
                    alpha = 0;
                }
                int lum = vals[0];
                int z = vals[4];
                int y = vals[5];
                int x = vals[6];
                this.vv.vol.findAndSetSimilarInVolume(lum, alpha, z, y, x);
                this.control.drag = false;
                this.newDisplayMode();
            }
        }
        if (source == this.imageLightRegion && e.getClickCount() >= 2 && (lightColor = JColorChooser.showDialog(null, "Choose light color", null)) != null) {
            this.control.lightRed = lightColor.getRed();
            this.control.lightGreen = lightColor.getGreen();
            this.control.lightBlue = lightColor.getBlue();
            this.newDisplayMode();
            this.picLight.render_sphere();
            this.imageLightRegion.setImage(this.picLight.image);
            this.imageLightRegion.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        if (this.control.renderMode >= 2) {
            int[] vals = new int[]{-1, -1, -1, -1};
            if (this.control.alphaMode == 0) {
                this.vv.tf_a1.setValues(vals);
                this.vv.tf_a1.repaint();
            } else if (this.control.alphaMode == 1) {
                this.vv.tf_a2.setValues(vals);
                this.vv.tf_a2.repaint();
            } else if (this.control.alphaMode == 2) {
                this.vv.tf_a3.setValues(vals);
                this.vv.tf_a3.repaint();
            }
        }
        this.valueString = "";
        this.positionString = "";
        this.valueLabel.setText(this.valueString);
        this.positionLabel.setText(this.positionString);
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion || source == this.imageLightRegion) {
            this.xStart = arg0.getX();
            this.yStart = arg0.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion) {
            this.xAct = arg0.getX();
            this.yAct = arg0.getY();
            if (arg0.isShiftDown()) {
                this.vv.changeTranslation(this.xAct - this.xStart, this.yAct - this.yStart);
            } else {
                this.vv.changeRotation(this.xStart, this.yStart, this.xAct, this.yAct, this.control.windowWidthImageRegion);
            }
            this.xStart = this.xAct;
            this.yStart = this.yAct;
            this.newDisplayMode();
        }
        if (source == this.imageLightRegion) {
            this.xAct = arg0.getX();
            this.yAct = arg0.getY();
            this.vv.changeRotationLight(this.xStart, this.yStart, this.xAct, this.yAct, 50);
            this.xStart = this.xAct;
            this.yStart = this.yAct;
            this.picLight.render_sphere();
            this.imageLightRegion.setImage(this.picLight.image);
            this.imageLightRegion.repaint();
            this.newDisplayMode();
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        Object source = arg0.getSource();
        int xS = arg0.getX();
        int yS = arg0.getY();
        if (source == this.sliceImageRegion) {
            int[] vals = this.sliceImageRegion.getValues(xS, yS);
            int xV = vals[6];
            int yV = vals[5];
            int zV = vals[4];
            if (xV != -1 && yV != -1 && zV != -1) {
                this.positionString = String.format("  x=%3d, y=%3d, z=%3d", xV, yV, zV + 1);
                if (this.control.isRGB) {
                    int r = this.vv.vol.data3D[1][zV + 2][yV + 2][xV + 2] & 0xFF;
                    int g = this.vv.vol.data3D[2][zV + 2][yV + 2][xV + 2] & 0xFF;
                    int b = this.vv.vol.data3D[3][zV + 2][yV + 2][xV + 2] & 0xFF;
                    this.valueString = String.format("  R=%3d, G=%3d, B=%3d", r, g, b);
                } else {
                    int val = this.vv.vol.data3D[0][zV + 2][yV + 2][xV + 2] & 0xFF;
                    this.valueString = String.format("  Value=%3d", val);
                }
            } else {
                this.valueString = "";
                this.positionString = "";
            }
            this.valueLabel.setText(this.valueString);
            this.positionLabel.setText(this.positionString);
            if (this.control.renderMode >= 2) {
                if (this.control.alphaMode == 0) {
                    this.vv.tf_a1.setValues(vals);
                    this.vv.tf_a1.repaint();
                } else if (this.control.alphaMode == 1) {
                    this.vv.tf_a2.setValues(vals);
                    this.vv.tf_a2.repaint();
                } else if (this.control.alphaMode == 2) {
                    this.vv.tf_a3.setValues(vals);
                    this.vv.tf_a3.repaint();
                }
            }
        } else if (source == this.imageRegion) {
            if (this.control.renderMode <= 1) {
                float[] xyzV = this.vv.trScreen2Vol(xS, yS, this.control.scaledDist);
                float xV = xyzV[0];
                float yV = xyzV[1];
                float zV = xyzV[2];
                if (xV >= 0.0f && xV < (float)this.vv.vol.widthV && yV >= 0.0f && yV < (float)this.vv.vol.heightV && zV >= 0.0f && zV < (float)this.vv.vol.depthV) {
                    this.positionString = String.format("  x=%3d, y=%3d, z=%3d", (int)xV, (int)yV, (int)zV + 1);
                    if (this.control.isRGB) {
                        int r = this.vv.vol.data3D[1][(int)zV + 2][(int)yV + 2][(int)xV + 2] & 0xFF;
                        int g = this.vv.vol.data3D[2][(int)zV + 2][(int)yV + 2][(int)xV + 2] & 0xFF;
                        int b = this.vv.vol.data3D[3][(int)zV + 2][(int)yV + 2][(int)xV + 2] & 0xFF;
                        this.valueString = String.format("  R=%3d, G=%3d, B=%3d", r, g, b);
                    } else {
                        int val = this.vv.vol.data3D[0][(int)zV + 2][(int)yV + 2][(int)xV + 2] & 0xFF;
                        this.valueString = String.format("  Value=%3d", val);
                    }
                } else {
                    this.valueString = "";
                    this.positionString = "";
                }
                this.valueLabel.setText(this.valueString);
                this.positionLabel.setText(this.positionString);
            } else {
                this.valueString = "";
                this.positionString = "";
            }
            this.valueLabel.setText(this.valueString);
            this.positionLabel.setText(this.positionString);
        }
    }

    public void newDisplayMode() {
        if (this.control.LOG) {
            System.out.println("newDisplayMode");
        }
        this.signalBusy();
        this.vv.cube.setTextAndLines(this.imageRegion);
        if (this.control.renderMode >= 2) {
            this.pic.startVolumeRendering();
        } else {
            this.vv.lookupTable.setLut();
            if (this.control.renderMode == 1) {
                this.pic.render_SliceAndBorders();
            } else if (this.control.renderMode == 0) {
                this.pic.render_Slice();
            }
            this.imageRegion.setImage(this.pic.image);
            this.imageRegion.repaint();
            this.signalReady();
        }
        this.picSlice.updateImage();
        this.sliceImageRegion.findLines(this.vv.cube, this.control.scaledDist, this.vv.vol.depthV);
        this.sliceImageRegion.setImage(this.picSlice.image);
        this.sliceImageRegion.repaint();
    }

    void signalReady() {
        if (this.control.LOG) {
            long end = System.currentTimeMillis();
            System.out.println("Render time " + (end - this.startR) + " ms.");
        }
        this.control.isReady = true;
        this.picLED.render_LED(true);
        this.imageLEDRegion.setImage(this.picLED.image);
        this.imageLEDRegion.paintImmediately(0, 0, this.imageLEDRegion.getWidth(), this.imageLEDRegion.getHeight());
    }

    void signalBusy() {
        if (this.control.LOG && this.control.LOG) {
            this.startR = System.currentTimeMillis();
        }
        this.control.isReady = false;
        this.picLED.render_LED(false);
        this.imageLEDRegion.setImage(this.picLED.image);
        this.imageLEDRegion.paintImmediately(0, 0, this.imageLEDRegion.getWidth(), this.imageLEDRegion.getHeight());
    }

    public void setSpinners() {
        this.enableSpinnerChangeListener = false;
        if (this.imageRegion != null && this.spinnerX != null && this.spinnerY != null && this.spinnerZ != null) {
            this.spinnerX.setValue(Float.valueOf(Math.round(this.control.degreeX)));
            this.spinnerY.setValue(Float.valueOf(Math.round(this.control.degreeY)));
            this.spinnerZ.setValue(Float.valueOf(Math.round(this.control.degreeZ)));
        }
        this.enableSpinnerChangeListener = true;
    }

    class SpinnerListener
    implements ChangeListener {
        static final int MIN_TIME = 200;

        SpinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (Gui.this.enableSpinnerChangeListener) {
                ((Gui)Gui.this).control.spinnersAreChanging = true;
                ((Gui)Gui.this).control.degreeX = ((Float)Gui.this.spinnerX.getValue()).floatValue();
                ((Gui)Gui.this).control.degreeY = ((Float)Gui.this.spinnerY.getValue()).floatValue();
                ((Gui)Gui.this).control.degreeZ = ((Float)Gui.this.spinnerZ.getValue()).floatValue();
                Gui.this.vv.setRotation(((Gui)Gui.this).control.degreeX, ((Gui)Gui.this).control.degreeY, ((Gui)Gui.this).control.degreeZ);
                ((Gui)Gui.this).control.spinnersAreChanging = false;
                Gui.this.newDisplayMode();
            }
        }
    }
}

