/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Interpolation;
import fiji.plugin.volumeviewer.Volume_Viewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.SwingWorker;
import javax.swing.UIManager;

public class Pic {
    BufferedImage image;
    private int[] pixels = null;
    private int width;
    private int height;
    private Control control;
    private Volume_Viewer vv;
    byte[][][] volData3D = null;
    private Interpolation interpolation;
    float xd;
    float yd;
    float zd;
    int xs = 10;
    int ys = 14;
    int xo = this.xs;
    int yo_xy = 0;
    int yo_yz;
    int yo_xz;
    private int lightRed;
    private int lightGreen;
    private int lightBlue;
    private int maxThreads = 8;
    private int numThreads = 1;
    private int subMax;
    private int counter = 0;
    private boolean doStopRendering;
    private boolean isRendering = false;
    private int sub;
    private boolean isWaitingForRendering;
    private float[] light;
    private boolean lastReady;
    private boolean isRGB;

    public Pic(Control control, Volume_Viewer vv, int width, int height) {
        this.control = control;
        this.vv = vv;
        this.width = width;
        this.height = height;
        this.subMax = Math.max(width, height) / 100;
        if (this.subMax % 2 != 1) {
            ++this.subMax;
        }
        if (control.sampling > 1.0f || control.interpolationMode > 1) {
            this.subMax += 2;
        }
        if (control.LOG) {
            System.out.println("subMax = " + this.subMax);
        }
        this.pixels = new int[width * height];
        this.image = new BufferedImage(width, height, 2);
        this.image.setRGB(0, 0, width, height, this.pixels, 0, width);
        this.interpolation = new Interpolation(control);
    }

    public void setPixelsToZero() {
        Arrays.fill(this.pixels, 0);
    }

    Dimension getSliceViewSize(int width, int height) {
        int my = (int)((float)this.vv.vol.heightV + (float)this.vv.vol.depthV * Math.abs(this.control.zAspect) * 2.0f) + 1;
        int mx = Math.max(this.vv.vol.widthV, this.vv.vol.heightV);
        int nWidth = width - 2 * this.xs;
        int nHeight = height - 3 * this.ys;
        float sy = (float)nHeight / (float)my;
        float sx = (float)nWidth / (float)mx;
        float s = Math.max(sy, sx);
        while (s * (float)my > (float)nHeight || s * (float)mx > (float)nWidth) {
            s = (float)((double)s * 0.99);
        }
        return new Dimension((int)(s * (float)mx + (float)(2 * this.xs)), (int)((float)(3 * this.ys) + s * (float)my));
    }

    void drawSlices() {
        int z_;
        int my = (int)((float)this.vv.vol.heightV + (float)this.vv.vol.depthV * Math.abs(this.control.zAspect) * 2.0f) + 1;
        int mx = Math.max(this.vv.vol.widthV, this.vv.vol.heightV);
        int nWidth = this.width - 2 * this.xs;
        int nHeight = this.height - 3 * this.ys;
        float sy = (float)nHeight / (float)my;
        float sx = (float)nWidth / (float)mx;
        float s = Math.max(sy, sx);
        while (s * (float)my > (float)nHeight || s * (float)mx > (float)nWidth) {
            s = (float)((double)s * 0.99);
        }
        int Wx = (int)((float)this.vv.vol.widthV * s);
        int Wy = (int)((float)this.vv.vol.heightV * s);
        int Wz = (int)((float)this.vv.vol.depthV * Math.abs(this.control.zAspect) * s);
        this.xd = (float)this.vv.vol.widthV / (float)Wx;
        this.yd = (float)this.vv.vol.heightV / (float)Wy;
        this.zd = (float)this.vv.vol.depthV / (float)Wz;
        Color color = UIManager.getColor("Panel.background");
        int c = color.getRGB();
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = c;
        }
        if (this.control.isRGB) {
            int valB;
            int valG;
            int valR;
            int pos;
            int x;
            int y_;
            z_ = (int)(this.control.positionFactorZ * (float)(this.vv.vol.depthV - 1));
            for (int y = 0; y < Wy; ++y) {
                y_ = (int)((float)y * this.yd);
                for (x = 0; x < Wx; ++x) {
                    pos = (this.yo_xy + y) * this.width + x + this.xo;
                    int x_ = (int)((float)x * this.xd);
                    valR = 0xFF & this.vv.vol.data3D[1][z_ + 2][y_ + 2][x_ + 2];
                    valG = 0xFF & this.vv.vol.data3D[2][z_ + 2][y_ + 2][x_ + 2];
                    valB = 0xFF & this.vv.vol.data3D[3][z_ + 2][y_ + 2][x_ + 2];
                    this.pixels[pos] = 0xFF000000 | valR << 16 | valG << 8 | valB;
                }
            }
            this.yo_yz = this.ys + Wy;
            int x_ = (int)(this.control.positionFactorX * (float)(this.vv.vol.widthV - 1));
            for (int y = 0; y < Wz; ++y) {
                z_ = (int)((float)y * this.zd);
                for (x = 0; x < Wy; ++x) {
                    pos = (this.yo_yz + y) * this.width + x + this.xo;
                    int y_2 = (int)((float)x * this.yd);
                    valR = 0xFF & this.vv.vol.data3D[1][this.vv.vol.depthV + 1 - z_][y_2 + 2][x_ + 2];
                    valG = 0xFF & this.vv.vol.data3D[2][this.vv.vol.depthV + 1 - z_][y_2 + 2][x_ + 2];
                    valB = 0xFF & this.vv.vol.data3D[3][this.vv.vol.depthV + 1 - z_][y_2 + 2][x_ + 2];
                    this.pixels[pos] = 0xFF000000 | valR << 16 | valG << 8 | valB;
                }
            }
            this.yo_xz = 2 * this.ys + Wy + Wz;
            y_ = (int)(this.control.positionFactorY * (float)(this.vv.vol.heightV - 1));
            for (int y = 0; y < Wz; ++y) {
                z_ = (int)((float)y * this.zd);
                for (int x2 = 0; x2 < Wx; ++x2) {
                    int pos2 = (this.yo_xz + y) * this.width + x2 + this.xo;
                    x_ = (int)((float)x2 * this.xd);
                    valR = 0xFF & this.vv.vol.data3D[1][this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
                    valG = 0xFF & this.vv.vol.data3D[2][this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
                    valB = 0xFF & this.vv.vol.data3D[3][this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
                    this.pixels[pos2] = 0xFF000000 | valR << 16 | valG << 8 | valB;
                }
            }
        } else {
            int val;
            int pos;
            int x;
            int y_;
            z_ = (int)(this.control.positionFactorZ * (float)(this.vv.vol.depthV - 1));
            for (int y = 0; y < Wy; ++y) {
                y_ = (int)((float)y * this.yd);
                for (x = 0; x < Wx; ++x) {
                    pos = (this.yo_xy + y) * this.width + x + this.xo;
                    int x_ = (int)((float)x * this.xd);
                    val = 0xFF & this.vv.vol.data3D[0][z_ + 2][y_ + 2][x_ + 2];
                    this.pixels[pos] = 0xFF000000 | val << 16 | val << 8 | val;
                }
            }
            this.yo_yz = this.ys + Wy;
            int x_ = (int)(this.control.positionFactorX * (float)(this.vv.vol.widthV - 1));
            for (int y = 0; y < Wz; ++y) {
                z_ = (int)((float)y * this.zd);
                for (x = 0; x < Wy; ++x) {
                    pos = (this.yo_yz + y) * this.width + x + this.xo;
                    int y_3 = (int)((float)x * this.yd);
                    val = 0xFF & this.vv.vol.data3D[0][this.vv.vol.depthV + 1 - z_][y_3 + 2][x_ + 2];
                    this.pixels[pos] = 0xFF000000 | val << 16 | val << 8 | val;
                }
            }
            this.yo_xz = 2 * this.ys + Wy + Wz;
            y_ = (int)(this.control.positionFactorY * (float)(this.vv.vol.heightV - 1));
            for (int y = 0; y < Wz; ++y) {
                z_ = (int)((float)y * this.zd);
                for (int x3 = 0; x3 < Wx; ++x3) {
                    int pos3 = (this.yo_xz + y) * this.width + x3 + this.xo;
                    x_ = (int)((float)x3 * this.xd);
                    val = 0xFF & this.vv.vol.data3D[0][this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
                    this.pixels[pos3] = 0xFF000000 | val << 16 | val << 8 | val;
                }
            }
        }
        this.vv.gui.setPositionText(Wx, Wy, Wz);
        this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    public int[] getValuesfromSlices(int xm, int ym) {
        int[] vals = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int my = (int)((float)this.vv.vol.heightV + (float)this.vv.vol.depthV * Math.abs(this.control.zAspect) * 2.0f) + 1;
        int mx = Math.max(this.vv.vol.widthV, this.vv.vol.heightV);
        int nWidth = this.width - 2 * this.xs;
        int nHeight = this.height - 3 * this.ys;
        float sy = (float)nHeight / (float)my;
        float sx = (float)nWidth / (float)mx;
        float s = Math.max(sy, sx);
        while (s * (float)my > (float)nHeight || s * (float)mx > (float)nWidth) {
            s = (float)((double)s * 0.99);
        }
        int Wx = (int)((float)this.vv.vol.widthV * s);
        int Wy = (int)((float)this.vv.vol.heightV * s);
        int Wz = (int)((float)this.vv.vol.depthV * Math.abs(this.control.zAspect) * s);
        this.xd = (float)this.vv.vol.widthV / (float)Wx;
        this.yd = (float)this.vv.vol.heightV / (float)Wy;
        this.zd = (float)this.vv.vol.depthV / (float)Wz;
        this.yo_yz = this.ys + Wy;
        this.yo_xz = 2 * this.ys + Wy + Wz;
        if (xm >= this.xo && xm < this.xo + Wx && ym >= this.yo_xy && ym < this.yo_xy + Wy) {
            int x = xm - this.xo;
            int y = ym - this.yo_xy;
            int x_ = (int)((float)x * this.xd);
            int y_ = (int)((float)y * this.yd);
            int z_ = (int)(this.control.positionFactorZ * (float)(this.vv.vol.depthV - 1));
            vals[0] = 0xFF & this.vv.vol.data3D[0][z_ + 2][y_ + 2][x_ + 2];
            vals[1] = 0xFF & this.vv.vol.grad3D[z_ + 2][y_ + 2][x_ + 2];
            vals[2] = 0xFF & this.vv.vol.mean3D[z_ + 2][y_ + 2][x_ + 2];
            vals[3] = 0xFF & this.vv.vol.diff3D[z_ + 2][y_ + 2][x_ + 2];
            vals[4] = z_;
            vals[5] = y_;
            vals[6] = x_;
            return vals;
        }
        if (xm >= this.xo && xm < this.xo + Wy && ym >= this.yo_yz && ym < this.yo_yz + Wz) {
            int x = xm - this.xo;
            int y = ym - this.yo_yz;
            int z_ = (int)((float)y * this.zd);
            int x_ = (int)(this.control.positionFactorX * (float)(this.vv.vol.widthV - 1));
            int y_ = (int)((float)x * this.yd);
            vals[0] = 0xFF & this.vv.vol.data3D[0][this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[1] = 0xFF & this.vv.vol.grad3D[this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[2] = 0xFF & this.vv.vol.mean3D[this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[3] = 0xFF & this.vv.vol.diff3D[this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[4] = this.vv.vol.depthV - 1 - z_;
            vals[5] = y_;
            vals[6] = x_;
            return vals;
        }
        if (xm >= this.xo && xm < this.xo + Wx && ym >= this.yo_xz && ym < this.yo_xz + Wz) {
            int x = xm - this.xo;
            int y = ym - this.yo_xz;
            int z_ = (int)((float)y * this.zd);
            int y_ = (int)(this.control.positionFactorY * (float)(this.vv.vol.heightV - 1));
            int x_ = (int)((float)x * this.xd);
            vals[0] = 0xFF & this.vv.vol.data3D[0][this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[1] = 0xFF & this.vv.vol.grad3D[this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[2] = 0xFF & this.vv.vol.mean3D[this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[3] = 0xFF & this.vv.vol.diff3D[this.vv.vol.depthV + 1 - z_][y_ + 2][x_ + 2];
            vals[4] = this.vv.vol.depthV - 1 - z_;
            vals[5] = y_;
            vals[6] = x_;
            return vals;
        }
        return vals;
    }

    void updateImage() {
        this.image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    void render_Slice() {
        this.setPixelsToZero();
        int[] boundsXY = this.getXYRenderingBoundsSlice();
        int xSmin = boundsXY[0];
        int xSmax = boundsXY[1];
        int ySmin = boundsXY[2];
        int ySmax = boundsXY[3];
        float[] vecScreen = new float[3];
        if (!this.control.isRGB || this.control.lutNr != 0) {
            this.volData3D = this.vv.vol.data3D[0];
            vecScreen[2] = this.control.scaledDist;
            vecScreen[1] = ySmin;
            vecScreen[0] = xSmin;
            float[] vecVolume = this.vv.trScreen2Volume(vecScreen);
            float xV00 = vecVolume[0];
            float yV00 = vecVolume[1];
            float zV00 = vecVolume[2];
            vecScreen[0] = xSmin + 1;
            vecVolume = this.vv.trScreen2Volume(vecScreen);
            float xV01 = vecVolume[0];
            float yV01 = vecVolume[1];
            float zV01 = vecVolume[2];
            vecScreen[0] = xSmin;
            vecScreen[1] = ySmin + 1;
            vecVolume = this.vv.trScreen2Volume(vecScreen);
            float xV10 = vecVolume[0];
            float yV10 = vecVolume[1];
            float zV10 = vecVolume[2];
            float dxVx = xV01 - xV00;
            float dyVx = yV01 - yV00;
            float dzVx = zV01 - zV00;
            float dxVy = xV10 - xV00;
            float dyVy = yV10 - yV00;
            float dzVy = zV10 - zV00;
            float xV_ = xV00;
            float yV_ = yV00;
            float zV_ = zV00;
            int[] colors = this.vv.lookupTable.colors;
            for (int yS = ySmin; yS <= ySmax; ++yS) {
                float xV = xV_;
                float yV = yV_;
                float zV = zV_;
                for (int xS = xSmin; xS <= xSmax; ++xS) {
                    if (xV >= 0.0f && xV < (float)this.vv.vol.widthV && yV >= 0.0f && yV < (float)this.vv.vol.heightV && zV >= 0.0f && zV < (float)this.vv.vol.depthV) {
                        int val = this.interpolation.get(this.volData3D, zV, yV, xV);
                        this.pixels[yS * this.width + xS] = colors[val];
                    }
                    xV += dxVx;
                    yV += dyVx;
                    zV += dzVx;
                }
                xV_ += dxVy;
                yV_ += dyVy;
                zV_ += dzVy;
            }
        } else {
            vecScreen[2] = this.control.scaledDist;
            for (int yS = ySmin; yS <= ySmax; ++yS) {
                vecScreen[1] = yS;
                for (int xS = xSmin; xS <= xSmax; ++xS) {
                    vecScreen[0] = xS;
                    float[] xyzV = this.vv.trScreen2Volume(vecScreen);
                    float xV = xyzV[0];
                    float yV = xyzV[1];
                    float zV = xyzV[2];
                    if (!(xV >= 0.0f) || !(xV < (float)this.vv.vol.widthV) || !(yV >= 0.0f) || !(yV < (float)this.vv.vol.heightV) || !(zV >= 0.0f) || !(zV < (float)this.vv.vol.depthV)) continue;
                    int r = this.vv.lookupTable.lut[this.interpolation.get(this.vv.vol.data3D[1], zV, yV, xV)][0];
                    int g = this.vv.lookupTable.lut[this.interpolation.get(this.vv.vol.data3D[2], zV, yV, xV)][1];
                    int b = this.vv.lookupTable.lut[this.interpolation.get(this.vv.vol.data3D[3], zV, yV, xV)][2];
                    int n = yS * this.width + xS;
                    this.pixels[n] = this.pixels[n] | (0xFF000000 | r << 16 | g << 8 | b);
                }
            }
        }
        this.updateImage();
    }

    public void render_SliceAndBorders() {
        this.setPixelsToZero();
        int[] boundsXY = this.getXYRenderingBoundsSlice();
        int xSmin = boundsXY[0];
        int xSmax = boundsXY[1];
        int ySmin = boundsXY[2];
        int ySmax = boundsXY[3];
        float[] vS = new float[3];
        int widthS = this.control.windowWidthImageRegion;
        if (this.control.isRGB && this.control.lutNr == 0) {
            for (int ch = 0; ch < 3; ++ch) {
                int shift = (2 - ch) * 8;
                this.volData3D = this.vv.vol.data3D[ch + 1];
                vS[2] = this.control.scaledDist;
                for (int y = ySmin; y <= ySmax; ++y) {
                    vS[1] = y;
                    for (int x = xSmin; x <= xSmax; ++x) {
                        int pos = y * widthS + x;
                        vS[0] = x;
                        float[] xyzV = this.vv.trScreen2Volume(vS);
                        float xV = xyzV[0];
                        float yV = xyzV[1];
                        float zV = xyzV[2];
                        if (!(xV >= 0.0f) || !(xV <= (float)this.vv.vol.widthV) || !(yV >= 0.0f) || !(yV <= (float)this.vv.vol.heightV) || !(zV >= 0.0f) || !(zV <= (float)this.vv.vol.depthV)) continue;
                        int n = pos;
                        this.pixels[n] = this.pixels[n] | (0xFF000000 | this.interpolation.get(this.volData3D, zV, yV, xV) << shift);
                    }
                }
                float[] boundsXYZ = this.getXYZRenderingBoundsVolume();
                xSmin = (int)boundsXYZ[0];
                xSmax = (int)boundsXYZ[1];
                ySmin = (int)boundsXYZ[2];
                ySmax = (int)boundsXYZ[3];
                float zSmax = boundsXYZ[5];
                for (int y = ySmin; y < ySmax; ++y) {
                    block4: for (int x = xSmin; x < xSmax; ++x) {
                        float nd;
                        int pos = y * widthS + x;
                        if ((this.pixels[pos] >> shift & 0xFF) != 0 || !this.vv.cube.isInside(x, y)) continue;
                        vS[0] = x;
                        vS[1] = y;
                        vS[2] = this.control.scaledDist + 1.0f;
                        float[] xyzV = this.vv.trScreen2Volume(vS);
                        float xV = xyzV[0];
                        float yV = xyzV[1];
                        float zV = xyzV[2];
                        vS[2] = zSmax;
                        xyzV = this.vv.trScreen2Volume(vS);
                        float xV2 = xyzV[0];
                        float yV2 = xyzV[1];
                        float zV2 = xyzV[2];
                        float nd1 = 1.0f / nd;
                        float dx = (xV2 - xV) * nd1;
                        float dy = (yV2 - yV) * nd1;
                        float dz = (zV2 - zV) * nd1;
                        if (xV < 0.0f && dx < 0.0f || xV > (float)this.vv.vol.widthV && dx > 0.0f || yV < 0.0f && dy < 0.0f || yV > (float)this.vv.vol.heightV && dy > 0.0f || zV < 0.0f && dz < 0.0f || zV > (float)this.vv.vol.depthV && dz > 0.0f) continue;
                        for (nd = zSmax - (this.control.scaledDist + 1.0f); nd >= 0.0f; nd -= 1.0f) {
                            if (xV >= 0.0f && xV <= (float)this.vv.vol.widthV && yV >= 0.0f && yV <= (float)this.vv.vol.heightV && zV >= 0.0f && zV <= (float)this.vv.vol.depthV) {
                                int val = this.interpolation.get(this.volData3D, zV, yV, xV);
                                int n = pos;
                                this.pixels[n] = this.pixels[n] | (0xFF000000 | val << shift);
                                continue block4;
                            }
                            xV += dx;
                            yV += dy;
                            zV += dz;
                        }
                    }
                }
            }
        } else {
            vS[2] = this.control.scaledDist;
            this.volData3D = this.vv.vol.data3D[0];
            for (int y = ySmin; y < ySmax; ++y) {
                vS[1] = y;
                for (int x = xSmin; x < xSmax; ++x) {
                    int pos = y * widthS + x;
                    vS[0] = x;
                    float[] xyzV = this.vv.trScreen2Volume(vS);
                    float xV = xyzV[0];
                    float yV = xyzV[1];
                    float zV = xyzV[2];
                    if (!(xV >= 0.0f) || !(xV <= (float)this.vv.vol.widthV) || !(yV >= 0.0f) || !(yV <= (float)this.vv.vol.heightV) || !(zV >= 0.0f) || !(zV <= (float)this.vv.vol.depthV)) continue;
                    this.pixels[pos] = this.vv.lookupTable.colors[this.interpolation.get(this.volData3D, zV, yV, xV)];
                }
            }
            float[] boundsXYZ = this.getXYZRenderingBoundsVolume();
            xSmin = (int)boundsXYZ[0];
            xSmax = (int)boundsXYZ[1];
            ySmin = (int)boundsXYZ[2];
            ySmax = (int)boundsXYZ[3];
            float zSmax = boundsXYZ[5];
            for (int y = ySmin; y <= ySmax; ++y) {
                vS[1] = y;
                block9: for (int x = xSmin; x <= xSmax; ++x) {
                    float nd;
                    int pos = y * widthS + x;
                    if (this.pixels[pos] != 0 || !this.vv.cube.isInside(x, y)) continue;
                    vS[0] = x;
                    vS[2] = this.control.scaledDist + 1.0f;
                    float[] xyzV = this.vv.trScreen2Volume(vS);
                    float xV = xyzV[0];
                    float yV = xyzV[1];
                    float zV = xyzV[2];
                    vS[2] = zSmax;
                    xyzV = this.vv.trScreen2Volume(vS);
                    float nd1 = 1.0f / nd;
                    float dx = (xyzV[0] - xV) * nd1;
                    float dy = (xyzV[1] - yV) * nd1;
                    float dz = (xyzV[2] - zV) * nd1;
                    if (xV < 0.0f && dx < 0.0f || xV > (float)this.vv.vol.widthV && dx > 0.0f || yV < 0.0f && dy < 0.0f || yV > (float)this.vv.vol.heightV && dy > 0.0f || zV < 0.0f && dz < 0.0f || zV > (float)this.vv.vol.depthV && dz > 0.0f) continue;
                    for (nd = zSmax - (this.control.scaledDist + 1.0f); nd >= 0.0f; nd -= 1.0f) {
                        if (xV >= 0.0f && xV <= (float)this.vv.vol.widthV && yV >= 0.0f && yV <= (float)this.vv.vol.heightV && zV >= 0.0f && zV <= (float)this.vv.vol.depthV) {
                            this.pixels[pos] = this.vv.lookupTable.colors[this.interpolation.get(this.volData3D, zV, yV, xV)];
                            continue block9;
                        }
                        xV += dx;
                        yV += dy;
                        zV += dz;
                    }
                }
            }
        }
        this.updateImage();
    }

    public void render_volume(int sub) {
        float a;
        int x;
        if (this.control.LOG) {
            System.out.println("render volume, sub: " + sub);
        }
        this.isRendering = true;
        this.numThreads = sub == this.subMax ? 1 : this.maxThreads;
        this.counter = this.numThreads;
        this.setPixelsToZero();
        int actualInterpolationMode = this.control.interpolationMode;
        if (sub > 1) {
            this.control.interpolationMode = 0;
        }
        this.getXYRenderingBoundsSlice();
        this.light = this.vv.trLightVolume2Screen(1.0f, 0.0f, 0.0f);
        this.lightRed = this.control.lightRed;
        this.lightGreen = this.control.lightGreen;
        this.lightBlue = this.control.lightBlue;
        float[] boundsXYZ = this.getXYZRenderingBoundsVolume();
        int xSmin = (int)boundsXYZ[0];
        int xSmax = (int)boundsXYZ[1];
        int ySmin = (int)boundsXYZ[2];
        int ySmax = (int)boundsXYZ[3];
        float zSmin = boundsXYZ[4];
        float zSmax = boundsXYZ[5];
        float[] xyzV1 = this.vv.trScreen2Vol(0.0f, 0.0f, 0.0f);
        float[] xyzV2 = this.vv.trScreen2Vol(0.0f, 0.0f, this.control.scale);
        float dxV = xyzV2[0] - xyzV1[0];
        float dyV = xyzV2[1] - xyzV1[1];
        float dzV = xyzV2[2] - xyzV1[2];
        float sample = this.control.sampling;
        if (sub == 3) {
            sample = 1.0f;
        }
        if (sub > 3) {
            sample = 0.5f;
        }
        if (this.control.LOG) {
            System.out.println("sample " + sample);
        }
        int nd = (int)(sample * (zSmax - zSmin) / this.control.scale);
        dxV /= sample;
        dyV /= sample;
        dzV /= sample;
        if (this.control.alphaMode == 0) {
            for (int i = 0; i < this.vv.a1_R.length; ++i) {
                float a2 = (float)this.vv.tf_a1.a1[i] / 255.0f;
                if (a2 < 0.0f) {
                    a2 = 0.0f;
                }
                a2 *= a2;
                this.vv.a1_R[i] = Math.min(1.0f, a2 / sample);
            }
        } else if (this.control.alphaMode == 1) {
            for (x = 0; x < 256; ++x) {
                for (int y = 0; y < 128; ++y) {
                    a = (float)this.vv.tf_a2.a2[x][y] / 255.0f;
                    if (a < 0.0f) {
                        a = 0.0f;
                    }
                    a *= a;
                    this.vv.a2_R[x][y] = Math.min(1.0f, a / sample);
                }
            }
        } else if (this.control.alphaMode == 2) {
            for (x = 0; x < 256; ++x) {
                for (int y = 0; y < 128; ++y) {
                    a = (float)this.vv.tf_a3.a3[x][y] / 255.0f;
                    if (a < 0.0f) {
                        a = 0.0f;
                    }
                    a *= a;
                    this.vv.a3_R[x][y] = Math.min(1.0f, a / sample);
                }
            }
        }
        if (!this.control.drag && this.control.alphaWasChanged) {
            this.vv.vol.calculateGradients();
        }
        this.volData3D = this.vv.vol.data3D[0];
        ySmin = ySmin / sub * sub;
        int stripHeight = (ySmax - ySmin) / this.numThreads;
        stripHeight = stripHeight / sub * sub;
        int stripStart = ySmin;
        this.isRGB = this.control.isRGB && this.control.lutNr == 0;
        int i = 0;
        while (i < this.numThreads - 1) {
            new RenderCalculations(sub, nd, dxV, dyV, dzV, xSmin, xSmax, stripStart, stripStart + stripHeight, zSmin).execute();
            ++i;
            stripStart += stripHeight;
        }
        new RenderCalculations(sub, nd, dxV, dyV, dzV, xSmin, xSmax, stripStart, stripStart + stripHeight, zSmin).execute();
        this.control.interpolationMode = actualInterpolationMode;
    }

    public void render_sphere() {
        if (this.control.LOG) {
            System.out.println("render sphere");
        }
        this.light = this.vv.trLightVolume2Screen(-1.0f, 0.0f, 0.0f);
        this.lightRed = this.control.lightRed;
        this.lightGreen = this.control.lightGreen;
        this.lightBlue = this.control.lightBlue;
        int rad = 27;
        for (int y_ = 0; y_ < this.height; ++y_) {
            int y = y_ - this.height / 2;
            for (int x_ = 0; x_ < this.width; ++x_) {
                int x = x_ - this.width / 2;
                float d = (float)Math.sqrt(x * x + y * y);
                if (!(d <= (float)(rad + 1))) continue;
                float z = d - (float)rad;
                int alpha = 255;
                if (d > (float)rad) {
                    alpha = (int)((1.0f - z) * 255.0f);
                }
                int valR = 64;
                int valG = 64;
                int valB = 64;
                if (this.control.useLight) {
                    float[] n = new float[]{x, y, z};
                    float lenN = (float)(1.0 / Math.sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]));
                    n[0] = n[0] * lenN;
                    n[1] = n[1] * lenN;
                    n[2] = n[2] * lenN;
                    float sp = n[0] * this.light[0] + n[1] * this.light[1] + n[2] * this.light[2];
                    float[] r = new float[]{2.0f * sp * n[0] - this.light[0], 2.0f * sp * n[1] - this.light[1], 2.0f * sp * n[2] - this.light[2]};
                    float diffuse = n[0] * this.light[0] + n[1] * this.light[1] + n[2] * this.light[2];
                    float[] v = new float[3];
                    v[2] = -1.0f;
                    float spec = Math.max(0.0f, r[2] * v[2]);
                    spec = (float)(Math.pow(spec, this.control.shineValue) * ((double)(this.control.shineValue + 2.0f) / (Math.PI * 2)));
                    float lightFactor = this.control.ambientValue + diffuse * this.control.diffuseValue + spec * this.control.specularValue;
                    valR = (int)Math.min(255.0f, Math.max(0.0f, 64.0f + (float)this.lightRed * lightFactor));
                    valG = (int)Math.min(255.0f, Math.max(0.0f, 64.0f + (float)this.lightGreen * lightFactor));
                    valB = (int)Math.min(255.0f, Math.max(0.0f, 64.0f + (float)this.lightBlue * lightFactor));
                }
                this.pixels[y_ * this.width + x_] = alpha << 24 | valR << 16 | valG << 8 | valB;
            }
        }
        this.updateImage();
    }

    public void render_LED(boolean ready) {
        if (ready == this.lastReady) {
            return;
        }
        this.lastReady = ready;
        if (this.control.LOG) {
            System.out.println("render LED");
        }
        float[] lightLED = new float[]{-0.7f, -0.7f, 0.1f};
        int ledRed = 220;
        int ledGreen = 80;
        int ledBlue = 40;
        if (ready) {
            ledRed = 80;
            ledGreen = 180;
            ledBlue = 40;
        }
        int rad = 7;
        for (int y_ = 0; y_ < this.height; ++y_) {
            int y = y_ - this.height / 2;
            for (int x_ = 0; x_ < this.width; ++x_) {
                int x = x_ - this.width / 2;
                float d = (float)Math.sqrt(x * x + y * y);
                if (!(d <= (float)(rad + 1))) continue;
                float z = d - (float)rad;
                int alpha = 255;
                if (d > (float)rad) {
                    alpha = (int)((1.0f - z) * 255.0f);
                }
                float[] n = new float[]{x, y, z};
                float lenN = (float)(1.0 / Math.sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]));
                n[0] = n[0] * lenN;
                n[1] = n[1] * lenN;
                n[2] = n[2] * lenN;
                float sp = n[0] * lightLED[0] + n[1] * lightLED[1] + n[2] * lightLED[2];
                float[] r = new float[]{2.0f * sp * n[0] - lightLED[0], 2.0f * sp * n[1] - lightLED[1], 2.0f * sp * n[2] - lightLED[2]};
                float diffuse = n[0] * lightLED[0] + n[1] * lightLED[1] + n[2] * lightLED[2];
                float[] v = new float[3];
                v[2] = -1.0f;
                float spec = Math.max(0.0f, r[2] * v[2]);
                spec = (float)(Math.pow(spec, 6.0) * 1.2732395447351628);
                float lightFactor = 1.0f + diffuse * 0.5f + 2.0f * spec;
                int valR = (int)Math.min(255.0f, Math.max(0.0f, (float)ledRed * lightFactor));
                int valG = (int)Math.min(255.0f, Math.max(0.0f, (float)ledGreen * lightFactor));
                int valB = (int)Math.min(255.0f, Math.max(0.0f, (float)ledBlue * lightFactor));
                this.pixels[y_ * this.width + x_] = alpha << 24 | valR << 16 | valG << 8 | valB;
            }
        }
        this.updateImage();
    }

    float[] getXYZRenderingBoundsVolume() {
        this.vv.cube.findIntersections(this.control.scaledDist);
        float[][] iS = this.vv.cube.getCorners();
        float[] xyzS = this.vv.trVolume2Screen(iS[0]);
        float xi = xyzS[0];
        float yi = xyzS[1];
        float zi = xyzS[2];
        float xMin = xi;
        float xMax = xi;
        float yMin = yi;
        float yMax = yi;
        float zMin = zi;
        float zMax = zi;
        for (int i = 1; i < 8; ++i) {
            xyzS = this.vv.trVolume2Screen(iS[i]);
            xi = xyzS[0];
            if (xi < xMin) {
                xMin = xi;
            } else if (xi > xMax) {
                xMax = xi;
            }
            yi = xyzS[1];
            if (yi < yMin) {
                yMin = yi;
            } else if (yi > yMax) {
                yMax = yi;
            }
            zi = xyzS[2];
            if (zi > zMax) {
                zMax = zi;
                continue;
            }
            if (!(zi < zMin)) continue;
            zMin = zi;
        }
        int widthS = this.control.windowWidthImageRegion;
        int heightS = this.control.windowHeight;
        if (xMin < 0.0f) {
            xMin = 0.0f;
        }
        if (xMax >= (float)widthS) {
            xMax = widthS - 1;
        }
        if (yMin < 0.0f) {
            yMin = 0.0f;
        }
        if (yMax >= (float)heightS) {
            yMax = heightS - 1;
        }
        if (this.control.scaledDist > zMin) {
            zMin = this.control.scaledDist;
        }
        float[] xyBounds = new float[]{xMin, xMax, yMin, yMax, zMin, zMax};
        return xyBounds;
    }

    int[] getXYRenderingBoundsSlice() {
        this.vv.cube.findIntersections(this.control.scaledDist);
        float[][] iS = this.vv.cube.getInterSections();
        float[] xyzS = this.vv.trVolume2Screen(iS[0]);
        int[] x = new int[6];
        int[] y = new int[6];
        int xi = x[0] = (int)xyzS[0];
        int yi = y[0] = (int)xyzS[1];
        int xSMin = xi;
        int xSMax = xi;
        int ySMin = yi;
        int ySMax = yi;
        for (int i = 1; i < 6; ++i) {
            xyzS = this.vv.trVolume2Screen(iS[i]);
            x[i] = (int)xyzS[0];
            xi = x[i];
            if (xi < xSMin) {
                xSMin = xi;
            } else if (xi > xSMax) {
                xSMax = xi;
            }
            yi = y[i] = (int)xyzS[1];
            if (yi < ySMin) {
                ySMin = yi;
                continue;
            }
            if (yi <= ySMax) continue;
            ySMax = yi;
        }
        int xm = 0;
        int ym = 0;
        for (int i = 0; i < y.length; ++i) {
            xm += x[i];
            ym += y[i];
        }
        xm /= 6;
        ym /= 6;
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        final double[] angle = new double[6];
        for (int i = 0; i < y.length; ++i) {
            angle[i] = Math.atan2(y[i] - ym, x[i] - xm);
            map.put(i, angle[i]);
        }
        Integer[] id = new Integer[]{0, 1, 2, 3, 4, 5};
        Arrays.sort(id, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(angle[o1], angle[o2]);
            }
        });
        Color color = this.control.showClipLines ? Color.ORANGE : new Color(0, 0, 0, 0);
        for (int i = 0; i < 6; ++i) {
            this.vv.gui.imageRegion.setClipLine(i, x[id[i]], y[id[i]], x[id[(i + 1) % 6]], y[id[(i + 1) % 6]], -1, color);
        }
        --xSMin;
        ++xSMax;
        --ySMin;
        ++ySMax;
        int widthS = this.control.windowWidthImageRegion;
        int heightS = this.control.windowHeight;
        if (xSMin < 0) {
            xSMin = 0;
        }
        if (xSMax >= widthS) {
            xSMax = widthS - 1;
        }
        if (ySMin < 0) {
            ySMin = 0;
        }
        if (ySMax >= heightS) {
            ySMax = heightS - 1;
        }
        int[] xyBounds = new int[]{xSMin, xSMax, ySMin, ySMax};
        return xyBounds;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Image getImage() {
        return this.image;
    }

    public void startVolumeRendering(int sub) {
        this.sub = sub;
        this.render_volume(sub);
    }

    public void startVolumeRendering() {
        if (this.isRendering && this.sub < this.subMax) {
            this.doStopRendering = true;
            this.isWaitingForRendering = true;
            return;
        }
        this.sub = this.subMax;
        if (!this.isRendering) {
            this.render_volume(this.sub);
        } else {
            this.isWaitingForRendering = true;
        }
    }

    private class RenderCalculations
    extends SwingWorker<Void, Void> {
        private int sub;
        private int nd;
        private int xSMin;
        private int xSMax;
        private int ySMin;
        private int ySMax;
        private float dxV;
        private float dyV;
        private float dzV;
        private float zSMin;

        public RenderCalculations(int sub, int nd, float dxV, float dyV, float dzV, int xSMin, int xSMax, int ySMin, int ySMax, float zSMin) {
            this.sub = sub;
            this.nd = nd;
            this.dxV = dxV;
            this.dyV = dyV;
            this.dzV = dzV;
            this.xSMin = xSMin;
            this.xSMax = xSMax;
            this.ySMin = ySMin;
            this.ySMax = ySMax;
            this.zSMin = zSMin;
        }

        @Override
        protected Void doInBackground() {
            return this.doRendering();
        }

        @Override
        protected void done() {
            Pic.this.counter--;
            if (Pic.this.doStopRendering && Pic.this.counter == 0) {
                Pic.this.isRendering = false;
                Pic.this.doStopRendering = false;
                this.sub = Pic.this.subMax;
                Pic.this.startVolumeRendering(this.sub);
            } else if (!Pic.this.doStopRendering && Pic.this.counter == 0) {
                Pic.this.updateImage();
                Pic.this.isRendering = false;
                if (this.sub == 1) {
                    ((Pic)Pic.this).vv.gui.signalReady();
                }
                ((Pic)Pic.this).vv.gui.imageRegion.paintImmediately(0, 0, ((Pic)Pic.this).vv.gui.imageRegion.getWidth(), ((Pic)Pic.this).vv.gui.imageRegion.getHeight());
                if (Pic.this.isWaitingForRendering) {
                    Pic.this.isWaitingForRendering = false;
                    this.sub = Pic.this.subMax;
                    Pic.this.startVolumeRendering(this.sub);
                } else if (this.sub >= 3) {
                    if (this.sub <= 5) {
                        this.sub -= 2;
                    } else {
                        this.sub /= 2;
                        if (this.sub % 2 == 0) {
                            ++this.sub;
                        }
                    }
                    Pic.this.startVolumeRendering(this.sub);
                }
            }
        }

        private Void doRendering() {
            int s_2 = this.sub / 2;
            float[] xyzV = Pic.this.vv.trScreen2Vol(this.xSMin + s_2, this.ySMin + s_2, this.zSMin);
            float x0V = xyzV[0];
            float y0V = xyzV[1];
            float z0V = xyzV[2];
            xyzV = Pic.this.vv.trScreen2Vol(this.xSMin + s_2 + 1, this.ySMin + s_2, this.zSMin);
            float dxVx = xyzV[0] - x0V;
            float dyVx = xyzV[1] - y0V;
            float dzVx = xyzV[2] - z0V;
            xyzV = Pic.this.vv.trScreen2Vol(this.xSMin + s_2, this.ySMin + s_2 + 1, this.zSMin);
            float dxVy = xyzV[0] - x0V;
            float dyVy = xyzV[1] - y0V;
            float dzVy = xyzV[2] - z0V;
            for (int yS = this.ySMin; yS < this.ySMax; ++yS) {
                int j = 0;
                int xS = this.xSMin;
                while (xS < this.xSMax) {
                    block27: {
                        block28: {
                            int ns;
                            float zV;
                            float yV;
                            float xV;
                            boolean hasBeenInTheVolume;
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    if (Pic.this.doStopRendering) {
                                                        return null;
                                                    }
                                                    if (!((Pic)Pic.this).vv.cube.isInside(xS, yS)) break block27;
                                                    if (yS % this.sub != 0 || xS % this.sub != 0) break block28;
                                                    hasBeenInTheVolume = false;
                                                    float rand = (float)(-Math.random());
                                                    xV = x0V + (float)j * dxVx + rand * this.dxV;
                                                    yV = y0V + (float)j * dyVx + rand * this.dyV;
                                                    zV = z0V + (float)j * dzVx + rand * this.dzV;
                                                    ns = 0;
                                                    if (!(xV < 0.0f)) break block29;
                                                    if (!(this.dxV > 0.0f)) break block27;
                                                    ns = (int)(-xV / this.dxV);
                                                    break block30;
                                                }
                                                if (!(xV > (float)((Pic)Pic.this).vv.vol.widthV)) break block30;
                                                if (!(this.dxV < 0.0f)) break block27;
                                                ns = (int)Math.max(((float)((Pic)Pic.this).vv.vol.widthV - xV) / this.dxV, (float)ns);
                                            }
                                            if (!(yV < 0.0f)) break block31;
                                            if (!(this.dyV > 0.0f)) break block27;
                                            ns = (int)Math.max(-yV / this.dyV, (float)ns);
                                            break block32;
                                        }
                                        if (!(yV > (float)((Pic)Pic.this).vv.vol.heightV)) break block32;
                                        if (!(this.dyV < 0.0f)) break block27;
                                        ns = (int)Math.max(((float)((Pic)Pic.this).vv.vol.heightV - yV) / this.dyV, (float)ns);
                                    }
                                    if (!(zV < 0.0f)) break block33;
                                    if (!(this.dzV > 0.0f)) break block27;
                                    ns = (int)Math.max(-zV / this.dzV, (float)ns);
                                    break block34;
                                }
                                if (!(zV > (float)((Pic)Pic.this).vv.vol.depthV)) break block34;
                                if (!(this.dzV < 0.0f)) break block27;
                                ns = (int)Math.max(((float)((Pic)Pic.this).vv.vol.depthV - zV) / this.dzV, (float)ns);
                            }
                            xV += (float)ns * this.dxV;
                            yV += (float)ns * this.dyV;
                            zV += (float)ns * this.dzV;
                            float valR = 0.0f;
                            float valG = 0.0f;
                            float valB = 0.0f;
                            float nx = 0.0f;
                            float ny = 0.0f;
                            float nz = 0.0f;
                            float aNext = 1.0f;
                            float sumA = 1.0f;
                            int valProj = 0;
                            int mean = 0;
                            int diff = 0;
                            int rMax = 0;
                            int gMax = 0;
                            int bMax = 0;
                            int[] actLut = null;
                            boolean didStartInVolume = false;
                            int n = ns;
                            while (n < this.nd) {
                                block37: {
                                    block35: {
                                        int b;
                                        int g;
                                        int r;
                                        float a;
                                        int val;
                                        block38: {
                                            block40: {
                                                block39: {
                                                    int grad;
                                                    block36: {
                                                        if (!(xV >= 0.0f) || !(xV <= (float)((Pic)Pic.this).vv.vol.widthV) || !(yV >= 0.0f) || !(yV <= (float)((Pic)Pic.this).vv.vol.heightV) || !(zV >= 0.0f) || !(zV <= (float)((Pic)Pic.this).vv.vol.depthV)) break block35;
                                                        hasBeenInTheVolume = true;
                                                        if (((Pic)Pic.this).control.alphaMode != 0) break block36;
                                                        val = Pic.this.interpolation.get(Pic.this.volData3D, zV, yV, xV);
                                                        a = ((Pic)Pic.this).vv.a1_R[val];
                                                        if (a == 0.0f) break block37;
                                                        actLut = ((Pic)Pic.this).vv.lookupTable.lut[val];
                                                        break block38;
                                                    }
                                                    if (((Pic)Pic.this).control.alphaMode != 1) break block39;
                                                    val = Pic.this.interpolation.get(Pic.this.volData3D, zV, yV, xV);
                                                    a = ((Pic)Pic.this).vv.a2_R[val][grad = Math.min(127, Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.grad3D, zV, yV, xV))];
                                                    if (a == 0.0f) break block37;
                                                    actLut = ((Pic)Pic.this).vv.lookupTable.lut2D_2[val][grad];
                                                    break block38;
                                                }
                                                if (((Pic)Pic.this).control.alphaMode != 2) break block40;
                                                mean = Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.mean3D, zV, yV, xV);
                                                a = ((Pic)Pic.this).vv.a3_R[mean][diff = Math.min(127, Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.diff3D, zV, yV, xV))];
                                                if (a == 0.0f) break block37;
                                                actLut = ((Pic)Pic.this).vv.lookupTable.lut2D_3[mean][diff];
                                                val = mean;
                                                break block38;
                                            }
                                            a = Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.aPaint_3D, zV, yV, xV);
                                            if (a == 0.0f) break block37;
                                            a *= 0.00392f;
                                            a *= a;
                                            val = Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.col_3D, zV, yV, xV);
                                            actLut = ((Pic)Pic.this).vv.lookupTable.lut[val];
                                        }
                                        if (n - ns < 3 && xV >= 3.0f && xV <= (float)(((Pic)Pic.this).vv.vol.widthV - 3) && yV >= 3.0f && yV <= (float)(((Pic)Pic.this).vv.vol.heightV - 3) && zV >= 3.0f && zV <= (float)(((Pic)Pic.this).vv.vol.depthV - 3)) {
                                            didStartInVolume = true;
                                        }
                                        if (Pic.this.isRGB) {
                                            r = ((Pic)Pic.this).vv.lookupTable.lut[Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.data3D[1], zV, yV, xV)][0];
                                            g = ((Pic)Pic.this).vv.lookupTable.lut[Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.data3D[2], zV, yV, xV)][1];
                                            b = ((Pic)Pic.this).vv.lookupTable.lut[Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.data3D[3], zV, yV, xV)][2];
                                        } else {
                                            r = actLut[0];
                                            g = actLut[1];
                                            b = actLut[2];
                                        }
                                        if (((Pic)Pic.this).control.renderMode == 4) {
                                            float an = a * aNext;
                                            valR += an * (float)r;
                                            valG += an * (float)g;
                                            valB += an * (float)b;
                                            if (((Pic)Pic.this).control.useLight) {
                                                int dx = Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.nx_3D, zV, yV, xV) - 128;
                                                int dy = Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.ny_3D, zV, yV, xV) - 128;
                                                int dz = Pic.this.interpolation.get(((Pic)Pic.this).vv.vol.nz_3D, zV, yV, xV) - 128;
                                                nx += an * (float)dx;
                                                ny += an * (float)dy;
                                                nz += an * (float)dz;
                                            }
                                            if ((double)(aNext *= 1.0f - a) < 0.02) {
                                                aNext = 0.0f;
                                                break;
                                            }
                                        } else if (((Pic)Pic.this).control.renderMode == 3) {
                                            valR += a * (float)r;
                                            valG += a * (float)g;
                                            valB += a * (float)b;
                                            sumA += a;
                                        } else if (Pic.this.isRGB) {
                                            if (r + g + b > valProj) {
                                                valProj = r + g + b;
                                                rMax = r;
                                                gMax = g;
                                                bMax = b;
                                            }
                                        } else if (val > valProj) {
                                            valProj = val;
                                        }
                                        break block37;
                                    }
                                    if (hasBeenInTheVolume) break;
                                }
                                ++n;
                                xV += this.dxV;
                                yV += this.dyV;
                                zV += this.dzV;
                            }
                            if (((Pic)Pic.this).control.renderMode == 4) {
                                int alpha;
                                if (didStartInVolume) {
                                    nx += 20.0f * this.dxV;
                                    ny += 20.0f * this.dyV;
                                    nz += 20.0f * this.dzV;
                                }
                                if ((alpha = (int)((1.0f - aNext) * 255.0f)) > 0) {
                                    if (((Pic)Pic.this).control.useLight) {
                                        float[] xyz0 = Pic.this.vv.trVolume2Screen(0.0f, 0.0f, 0.0f);
                                        float[] xyz = Pic.this.vv.trVolume2Screen(nx / ((Pic)Pic.this).control.scale, ny / ((Pic)Pic.this).control.scale, nz / (((Pic)Pic.this).control.zAspect * ((Pic)Pic.this).control.scale));
                                        float[] n2 = new float[]{xyz[0] - xyz0[0], xyz[1] - xyz0[1], xyz[2] - xyz0[2]};
                                        float lenN = n2[0] * n2[0] + n2[1] * n2[1] + n2[2] * n2[2];
                                        if (lenN > 0.0f) {
                                            lenN = (float)(1.0 / Math.sqrt(lenN));
                                            n2[0] = n2[0] * lenN;
                                            n2[1] = n2[1] * lenN;
                                            n2[2] = n2[2] * lenN;
                                        }
                                        float diffuse = n2[0] * Pic.this.light[0] + n2[1] * Pic.this.light[1] + n2[2] * Pic.this.light[2];
                                        float sp = 2.0f * (n2[0] * Pic.this.light[0] + n2[1] * Pic.this.light[1] + n2[2] * Pic.this.light[2]);
                                        float spec = Math.max(0.0f, sp * n2[2] - Pic.this.light[2]);
                                        spec = (float)(Math.pow(spec, ((Pic)Pic.this).control.shineValue) * ((double)(((Pic)Pic.this).control.shineValue + 2.0f) / (Math.PI * 2)));
                                        float lightFactor = ((Pic)Pic.this).control.ambientValue + diffuse * ((Pic)Pic.this).control.diffuseValue + spec * ((Pic)Pic.this).control.specularValue;
                                        valR = (int)Math.min(255.0f, Math.max(0.0f, ((Pic)Pic.this).control.objectLightValue * valR + (float)Pic.this.lightRed * lightFactor));
                                        valG = (int)Math.min(255.0f, Math.max(0.0f, ((Pic)Pic.this).control.objectLightValue * valG + (float)Pic.this.lightGreen * lightFactor));
                                        valB = (int)Math.min(255.0f, Math.max(0.0f, ((Pic)Pic.this).control.objectLightValue * valB + (float)Pic.this.lightBlue * lightFactor));
                                    }
                                    ((Pic)Pic.this).pixels[yS * ((Pic)Pic.this).width + xS] = alpha << 24 | (int)valR << 16 | (int)valG << 8 | (int)valB;
                                }
                            } else if (((Pic)Pic.this).control.renderMode == 3) {
                                int al = 255;
                                ((Pic)Pic.this).pixels[yS * ((Pic)Pic.this).width + xS] = al << 24 | (int)(valR /= sumA) << 16 | (int)(valG /= sumA) << 8 | (int)(valB /= sumA);
                            } else {
                                ((Pic)Pic.this).pixels[yS * ((Pic)Pic.this).width + xS] = Pic.this.isRGB ? 0xFF000000 | rMax << 16 | gMax << 8 | bMax : ((Pic)Pic.this).vv.lookupTable.colors[valProj];
                            }
                            break block27;
                        }
                        ((Pic)Pic.this).pixels[yS * ((Pic)Pic.this).width + xS] = Pic.this.pixels[yS / this.sub * this.sub * Pic.this.width + xS / this.sub * this.sub];
                    }
                    ++xS;
                    ++j;
                }
                x0V += dxVy;
                y0V += dyVy;
                z0V += dzVy;
            }
            return null;
        }
    }
}

