/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.archipelago.segmentation;

import edu.utexas.archipelago.image.ImageBlockDeblock;
import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.data.Duplex;
import ij.IJ;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.io.FileSaver;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import trainableSegmentation.WekaSegmentation;
import weka.classifiers.AbstractClassifier;
import weka.core.Instances;

public class BatchWekaSegmentation {
    private final File classifier;
    private final int[] blockSize;
    private final int[] ovlpPx;
    private final int nClasses;
    private final ExecutorService ibdService;
    private final ExecutorService segService;

    public BatchWekaSegmentation(File classifier, int[] blockSize, int[] ovlpPx) throws InvalidAlgorithmParameterException {
        this(classifier, blockSize, ovlpPx, Executors.newFixedThreadPool(1), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public BatchWekaSegmentation(File classifier, int[] blockSize, int[] ovlpPx, Cluster cluster) throws InvalidAlgorithmParameterException {
        this(classifier, blockSize, ovlpPx, cluster.getService(1.0f), cluster.getService(1));
    }

    private BatchWekaSegmentation(File classifier, int[] blockSize, int[] ovlpPx, ExecutorService ibdService, ExecutorService segService) throws InvalidAlgorithmParameterException {
        this.classifier = classifier;
        this.blockSize = blockSize;
        this.ovlpPx = ovlpPx;
        this.ibdService = ibdService;
        this.segService = segService;
        try {
            this.nClasses = BatchWekaSegmentation.countClasses(classifier);
        }
        catch (Exception e) {
            throw new InvalidAlgorithmParameterException("Could not count classes in the classifier model file " + classifier.getPath() + ".", e);
        }
        if (blockSize.length != 2) {
            throw new InvalidAlgorithmParameterException("blockSize must have exactly 2 elements, had " + blockSize.length);
        }
        if (ovlpPx.length != 2) {
            throw new InvalidAlgorithmParameterException("ovlpPx must have exactly 2 elements, had " + ovlpPx.length);
        }
    }

    public ArrayList<VirtualStack> segmentImages(Collection<File> imageFiles) {
        ImageBlockDeblock ibd;
        ArrayList<Future<ImageBlockDeblock>> ibdFutures = new ArrayList<Future<ImageBlockDeblock>>(imageFiles.size());
        ArrayList<Future<Duplex<Integer, Duplex<File, ArrayList<File>>>>> segFutures = new ArrayList<Future<Duplex<Integer, Duplex<File, ArrayList<File>>>>>();
        ArrayList<Future<ImageBlockDeblock>> outputFutures = new ArrayList<Future<ImageBlockDeblock>>();
        ArrayList<ImageBlockDeblock> ibdList = new ArrayList<ImageBlockDeblock>();
        ArrayList<VirtualStack> stacks = new ArrayList<VirtualStack>();
        int j = 0;
        FijiArchipelago.log("Submitting images for splitting into blocks");
        for (File file : imageFiles) {
            String path = file.getAbsolutePath();
            int lastDot = path.lastIndexOf(46);
            String outPath = path.substring(0, lastDot) + "_seg_%d" + path.substring(lastDot);
            ImageBlockDeblock ibd2 = new ImageBlockDeblock(file, new File(outPath), this.blockSize, this.ovlpPx, this.nClasses);
            ibd2.setSubfolder("blocks/" + j + "/");
            ibdFutures.add(this.ibdService.submit(ibd2.imageBlockCallable()));
            ++j;
        }
        FijiArchipelago.log("Submitting image blocks for segmentation");
        try {
            for (int i = 0; i < ibdFutures.size(); ++i) {
                Future future = (Future)ibdFutures.get(i);
                ibd = (ImageBlockDeblock)future.get();
                ibdList.add(ibd);
                for (File fc : ibd.imageBlockFiles()) {
                    WekaSegmentationCallable callable = new WekaSegmentationCallable(fc, this.classifier, i);
                    segFutures.add(this.segService.submit(callable));
                }
            }
        }
        catch (ExecutionException ee) {
            FijiArchipelago.err("A problem occured while splitting images: " + ee);
            FijiArchipelago.debug("A problem occured while splitting images: ", ee);
            return stacks;
        }
        catch (InterruptedException ie) {
            FijiArchipelago.err("Interrupted while splitting images: " + ie);
            FijiArchipelago.debug("Interrupted while splitting images: ", ie);
            return stacks;
        }
        FijiArchipelago.log("Submitting segmented blocks for recombination");
        try {
            for (Future future : segFutures) {
                Duplex segDup = (Duplex)future.get();
                int index = (Integer)segDup.a;
                ImageBlockDeblock ibd3 = (ImageBlockDeblock)ibdList.get(index);
                for (int i = 0; i < this.nClasses; ++i) {
                    ibd3.mapChunks((File)((Duplex)segDup.b).a, (File)((ArrayList)((Duplex)segDup.b).b).get(i), i);
                }
                if (ibd3.numUnmappedBlocks(this.nClasses - 1) > 0) continue;
                outputFutures.add(this.ibdService.submit(ibd3.imageDeblockCallable()));
            }
        }
        catch (ExecutionException ee) {
            FijiArchipelago.err("A problem occured while segmenting images: " + ee);
            FijiArchipelago.debug("A problem occured while segmenting images: ", ee);
            return stacks;
        }
        catch (InterruptedException ie) {
            FijiArchipelago.err("Interrupted while segmenting images: " + ie);
            FijiArchipelago.debug("Interrupted while segmenting images: ", ie);
            return stacks;
        }
        FijiArchipelago.log("Creating virtual stack");
        try {
            for (Future future : outputFutures) {
                int i;
                ibd = (ImageBlockDeblock)future.get();
                if (stacks.isEmpty()) {
                    for (i = 0; i < this.nClasses; ++i) {
                        stacks.add(new VirtualStack(ibd.getWidth(), ibd.getHeight(), ColorModel.getRGBdefault(), ""));
                    }
                }
                for (i = 0; i < this.nClasses; ++i) {
                    File segFile = ibd.getOutputFile(i);
                    FijiArchipelago.log("Adding file " + segFile.getName() + " to VS");
                    stacks.get(i).addSlice(segFile.getAbsolutePath());
                }
            }
            FijiArchipelago.log("Done Creating VirtualStack");
        }
        catch (ExecutionException ee) {
            FijiArchipelago.err("A problem occured while recombining segmented image blocks: " + ee);
            FijiArchipelago.debug("A problem occured while recombining segmented image blocks: ", ee);
            return stacks;
        }
        catch (InterruptedException ie) {
            FijiArchipelago.err("Interrupted while recombining segmented image blocks: " + ie);
            FijiArchipelago.debug("Interrupted while recombining segmented image blocks: ", ie);
            return stacks;
        }
        return stacks;
    }

    private static int countClasses(File classifier) throws IOException, ClassNotFoundException {
        FileInputStream is = new FileInputStream(classifier);
        ObjectInputStream objectInputStream = new ObjectInputStream(is);
        AbstractClassifier abstractClassifier = (AbstractClassifier)objectInputStream.readObject();
        Instances header = (Instances)objectInputStream.readObject();
        objectInputStream.close();
        return header.numClasses();
    }

    public static class WekaSegmentationCallable
    implements Callable<Duplex<Integer, Duplex<File, ArrayList<File>>>>,
    Serializable {
        private final File file;
        private final File classifier;
        private final int index;

        public WekaSegmentationCallable(File inFile, File inClassifier, int index) {
            this.index = index;
            this.file = inFile;
            this.classifier = inClassifier;
        }

        @Override
        public Duplex<Integer, Duplex<File, ArrayList<File>>> call() throws Exception {
            try {
                String inPath = this.file.getAbsolutePath();
                int idot = inPath.lastIndexOf(46);
                String formatString = inPath.substring(0, idot) + "_seg_%02d.png";
                ArrayList<File> outputFiles = this.segment(this.file.getAbsolutePath(), this.classifier.getAbsolutePath(), formatString);
                return new Duplex<Integer, Duplex<File, ArrayList<File>>>(this.index, new Duplex<File, ArrayList<File>>(this.file, outputFiles));
            }
            catch (Exception e) {
                FijiArchipelago.debug("Caught an exception:", e);
                throw e;
            }
        }

        private ImagePlus openImageOrException(String file) throws IOException {
            FijiArchipelago.log("Loading image from " + file);
            ImagePlus imp = IJ.openImage((String)file);
            if (imp == null) {
                throw new IOException("Could not read file: " + file);
            }
            return imp;
        }

        public ArrayList<File> segment(String file, String classifier, String outputFormat) throws Exception {
            File outFile;
            int i;
            File imageFile = new File(file);
            File f = new File(classifier);
            ArrayList<File> outputFiles = new ArrayList<File>();
            ImagePlus imp = this.openImageOrException(file);
            FijiArchipelago.log("Creating weka segmentation object");
            WekaSegmentation seg = new WekaSegmentation(imp);
            FileInputStream is = new FileInputStream(f);
            ObjectInputStream objectInputStream = new ObjectInputStream(is);
            boolean cacheOK = true;
            FijiArchipelago.log("Loading classifier from " + classifier);
            AbstractClassifier abstractClassifier = (AbstractClassifier)objectInputStream.readObject();
            Instances header = (Instances)objectInputStream.readObject();
            objectInputStream.close();
            FijiArchipelago.log("Calling seg.setClassifier");
            seg.setClassifier(abstractClassifier);
            seg.setTrainHeader(header);
            for (i = 1; i <= seg.getNumOfClasses(); ++i) {
                outFile = new File(String.format(outputFormat, i));
                outputFiles.add(outFile);
                cacheOK &= outFile.exists() && outFile.lastModified() > f.lastModified() && outFile.lastModified() > imageFile.lastModified();
            }
            if (!cacheOK) {
                FijiArchipelago.log("Applying classifier to image");
                ImagePlus impSeg = seg.applyClassifier(imp, 1, true);
                for (i = 1; i <= impSeg.getImageStackSize(); ++i) {
                    outFile = outputFiles.get(i - 1);
                    ImagePlus impSave = new ImagePlus(impSeg.getTitle(), impSeg.getImageStack().getProcessor(i));
                    FijiArchipelago.log("Saving classified image to " + outFile.getAbsolutePath());
                    new FileSaver(impSave).saveAsTiff(outFile.getAbsolutePath());
                }
                FijiArchipelago.log("Done.");
            } else {
                FijiArchipelago.log("Found a good cache for " + imageFile + ". Being lazy and refusing to work.");
            }
            return outputFiles;
        }
    }
}

