/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.curve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Curves2D {
    public static double toUnitSegment(double t, double t0, double t1) {
        if (t <= t0) {
            return 0.0;
        }
        if (t >= t1) {
            return 1.0;
        }
        if (t0 == Double.NEGATIVE_INFINITY && t1 == Double.POSITIVE_INFINITY) {
            return Math.atan(t) / Math.PI + 0.5;
        }
        if (t0 == Double.NEGATIVE_INFINITY) {
            return Math.atan(t - t1) * 2.0 / Math.PI + 1.0;
        }
        if (t1 == Double.POSITIVE_INFINITY) {
            return Math.atan(t - t0) * 2.0 / Math.PI;
        }
        return (t - t0) / (t1 - t0);
    }

    public static double fromUnitSegment(double t, double t0, double t1) {
        if (t <= 0.0) {
            return t0;
        }
        if (t >= 1.0) {
            return t1;
        }
        if (t0 == Double.NEGATIVE_INFINITY && t1 == Double.POSITIVE_INFINITY) {
            return Math.tan((t - 0.5) * Math.PI);
        }
        if (t0 == Double.NEGATIVE_INFINITY) {
            return Math.tan((t - 1.0) * Math.PI / 2.0) + t1;
        }
        if (t1 == Double.POSITIVE_INFINITY) {
            return Math.tan(t * Math.PI / 2.0) + t0;
        }
        return t * (t1 - t0) + t0;
    }

    public static CurveSet2D<? extends Curve2D> clipCurve(Curve2D curve, Box2D box) {
        if (curve instanceof ContinuousCurve2D) {
            return Curves2D.clipContinuousCurve((ContinuousCurve2D)curve, box);
        }
        if (curve instanceof CurveSet2D) {
            return Curves2D.clipCurveSet((CurveSet2D)curve, box);
        }
        System.err.println("Unknown curve class in Box2D.clipCurve()");
        return new CurveArray2D();
    }

    public static CurveSet2D<? extends Curve2D> clipCurveSet(CurveSet2D<?> curveSet, Box2D box) {
        CurveArray2D<Curve2D> result = new CurveArray2D<Curve2D>();
        for (Curve2D curve : curveSet) {
            CurveSet2D<? extends Curve2D> clipped = Curves2D.clipCurve(curve, box);
            for (Curve2D curve2D : clipped) {
                result.add(curve2D);
            }
        }
        return result;
    }

    public static CurveSet2D<ContinuousCurve2D> clipContinuousCurve(ContinuousCurve2D curve, Box2D box) {
        CurveArray2D<ContinuousCurve2D> res = new CurveArray2D<ContinuousCurve2D>();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (LinearShape2D edge : box.edges()) {
            points.addAll(curve.intersections(edge));
        }
        TreeSet<Double> set = new TreeSet<Double>();
        for (Point2D p : points) {
            set.add(new Double(curve.position(p)));
        }
        Iterator iter = set.iterator();
        int nInter = set.size();
        double[] positions = new double[nInter + 2];
        double[] between = new double[nInter + 1];
        positions[0] = curve.t0();
        int i = 0;
        while (i < nInter) {
            positions[i + 1] = (Double)iter.next();
            ++i;
        }
        positions[nInter + 1] = curve.t1();
        i = 0;
        while (i < nInter + 1) {
            between[i] = Curves2D.choosePosition(positions[i], positions[i + 1]);
            ++i;
        }
        ArrayList<Double> toRemove = new ArrayList<Double>();
        int i2 = 0;
        while (i2 < nInter) {
            boolean b2;
            Point2D p1 = curve.point(between[i2]);
            Point2D p2 = curve.point(between[i2 + 1]);
            boolean b1 = box.contains(p1);
            if (b1 == (b2 = box.contains(p2))) {
                toRemove.add(positions[i2 + 1]);
            }
            ++i2;
        }
        set.removeAll(toRemove);
        iter = set.iterator();
        if (set.size() == 0) {
            Point2D point;
            if (curve.isBounded()) {
                point = curve.firstPoint();
            } else {
                double pos = Curves2D.choosePosition(curve.t0(), curve.t1());
                point = curve.point(pos);
            }
            if (box.contains(point)) {
                res.add(curve);
            }
            return res;
        }
        boolean inside = false;
        boolean touch = false;
        double t0 = curve.t0();
        if (Curves2D.isLeftInfinite(curve)) {
            double pos = Curves2D.choosePosition(t0, (Double)set.iterator().next());
            inside = box.contains(curve.point(pos));
        } else {
            Point2D point = curve.firstPoint();
            inside = box.contains(point);
            if (box.boundary().contains(point)) {
                touch = true;
                double pos = Curves2D.choosePosition(t0, (Double)iter.next());
                while (Math.abs(pos - t0) < 1.0E-12 && iter.hasNext()) {
                    pos = Curves2D.choosePosition(t0, (Double)iter.next());
                }
                if (Math.abs(pos - t0) < 1.0E-12) {
                    pos = Curves2D.choosePosition(t0, curve.t1());
                }
                point = curve.point(pos);
                set.remove(t0);
                if (box.contains(point)) {
                    pos = (Double)set.iterator().next();
                    res.add(curve.subCurve(t0, pos));
                    set.remove(pos);
                }
                iter = set.iterator();
                inside = false;
            }
        }
        double pos0 = Double.NaN;
        if (inside && !touch) {
            if (curve.isClosed()) {
                pos0 = (Double)iter.next();
            } else {
                res.add(curve.subCurve(curve.t0(), (Double)iter.next()));
            }
        }
        while (iter.hasNext()) {
            double pos1 = (Double)iter.next();
            double pos2 = iter.hasNext() ? (Double)iter.next() : (curve.isClosed() && !touch ? pos0 : curve.t1());
            res.add(curve.subCurve(pos1, pos2));
        }
        return res;
    }

    public static CurveSet2D<SmoothCurve2D> clipSmoothCurve(SmoothCurve2D curve, Box2D box) {
        CurveArray2D<SmoothCurve2D> result = new CurveArray2D<SmoothCurve2D>();
        for (ContinuousCurve2D cont : Curves2D.clipContinuousCurve(curve, box)) {
            if (!(cont instanceof SmoothCurve2D)) continue;
            result.add((SmoothCurve2D)cont);
        }
        return result;
    }

    public static CurveSet2D<SmoothCurve2D> clipSmoothCurve(SmoothCurve2D curve, StraightLine2D line) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        list.addAll(curve.intersections(line));
        TreeSet<Double> set = new TreeSet<Double>();
        Vector2D vector = line.direction();
        for (Point2D point : list) {
            double curv;
            double position = curve.project(point);
            Vector2D tangent = curve.tangent(position);
            if (Vector2D.isColinear(tangent, vector) && Math.abs(curv = curve.curvature(position)) > 1.0E-12) continue;
            set.add(new Double(position));
        }
        CurveArray2D<SmoothCurve2D> res = new CurveArray2D<SmoothCurve2D>();
        Point2D point1 = Double.isInfinite(curve.t0()) ? curve.point(-1000.0) : curve.firstPoint();
        Iterator iter = set.iterator();
        if (!iter.hasNext()) {
            double t0 = curve.t0();
            if (t0 == Double.NEGATIVE_INFINITY) {
                t0 = -100.0;
            }
            while (line.contains(point1)) {
                double t1 = curve.t1();
                if (t1 == Double.POSITIVE_INFINITY) {
                    t1 = 100.0;
                }
                t0 = (t0 + t1) / 2.0;
                point1 = curve.point(t0);
            }
            if (line.signedDistance(point1) < 0.0) {
                res.add(curve);
            }
            return res;
        }
        if (line.signedDistance(point1) < 0.0 && !line.contains(point1)) {
            double pos1 = (Double)iter.next();
            res.add(curve.subCurve(curve.t0(), pos1));
        }
        while (iter.hasNext()) {
            double pos1 = (Double)iter.next();
            double pos2 = iter.hasNext() ? ((Double)iter.next()).doubleValue() : curve.t1();
            res.add(curve.subCurve(pos1, pos2));
        }
        return res;
    }

    public static int findNextCurveIndex(double[] positions, double pos) {
        int ind = -1;
        double posMin = Double.MAX_VALUE;
        int i = 0;
        while (i < positions.length) {
            if (!Double.isNaN(positions[i]) && !(positions[i] - pos < 1.0E-12) && positions[i] < posMin) {
                ind = i;
                posMin = positions[i];
            }
            ++i;
        }
        if (ind != -1) {
            return ind;
        }
        i = 0;
        while (i < positions.length) {
            if (!Double.isNaN(positions[i]) && positions[i] - posMin < 1.0E-12) {
                ind = i;
                posMin = positions[i];
            }
            ++i;
        }
        return ind;
    }

    public static double choosePosition(double t0, double t1) {
        if (Double.isInfinite(t0)) {
            if (Double.isInfinite(t1)) {
                return 0.0;
            }
            return t1 - 10.0;
        }
        if (Double.isInfinite(t1)) {
            return t0 + 10.0;
        }
        return (t0 + t1) / 2.0;
    }

    public static boolean isLeftInfinite(Curve2D curve) {
        if (curve.isBounded()) {
            return false;
        }
        ContinuousCurve2D cont = curve.continuousCurves().iterator().next();
        SmoothCurve2D smooth = cont.smoothPieces().iterator().next();
        return Double.isInfinite(smooth.t0());
    }

    public static boolean isRightInfinite(Curve2D curve) {
        if (curve.isBounded()) {
            return false;
        }
        Curve2D lastCurve = null;
        for (ContinuousCurve2D continuousCurve2D : curve.continuousCurves()) {
            for (SmoothCurve2D smoothCurve2D : continuousCurve2D.smoothPieces()) {
                lastCurve = smoothCurve2D;
            }
        }
        return Double.isInfinite(lastCurve.t1());
    }

    public static ContinuousCurve2D getFirstContinuousCurve(Curve2D curve) {
        if (curve instanceof ContinuousCurve2D) {
            return (ContinuousCurve2D)curve;
        }
        Collection<? extends ContinuousCurve2D> curves = curve.continuousCurves();
        if (curves.size() == 0) {
            return null;
        }
        return curves.iterator().next();
    }

    public static ContinuousCurve2D getLastContinuousCurve(Curve2D curve) {
        if (curve instanceof ContinuousCurve2D) {
            return (ContinuousCurve2D)curve;
        }
        ContinuousCurve2D res = null;
        Iterator<? extends ContinuousCurve2D> iterator = curve.continuousCurves().iterator();
        while (iterator.hasNext()) {
            ContinuousCurve2D continuous;
            res = continuous = iterator.next();
        }
        return res;
    }

    public static SmoothCurve2D getFirstSmoothCurve(Curve2D curve) {
        if (curve instanceof SmoothCurve2D) {
            return (SmoothCurve2D)curve;
        }
        ContinuousCurve2D continuous = Curves2D.getFirstContinuousCurve(curve);
        if (continuous == null) {
            return null;
        }
        Collection<? extends SmoothCurve2D> curves = continuous.smoothPieces();
        if (curves.size() == 0) {
            return null;
        }
        return curves.iterator().next();
    }

    public static SmoothCurve2D getLastSmoothCurve(Curve2D curve) {
        if (curve instanceof SmoothCurve2D) {
            return (SmoothCurve2D)curve;
        }
        ContinuousCurve2D continuous = Curves2D.getLastContinuousCurve(curve);
        SmoothCurve2D res = null;
        Iterator<? extends SmoothCurve2D> iterator = continuous.smoothPieces().iterator();
        while (iterator.hasNext()) {
            SmoothCurve2D smooth;
            res = smooth = iterator.next();
        }
        return res;
    }

    public static JunctionType getJunctionType(Curve2D prev, Curve2D next) {
        double eps;
        Vector2D v2;
        SmoothCurve2D smoothPrev = Curves2D.getLastSmoothCurve(prev);
        SmoothCurve2D smoothNext = Curves2D.getFirstSmoothCurve(next);
        Vector2D v1 = Curves2D.computeTangent(smoothPrev, smoothPrev.t1());
        double diff = Angle2D.angle(v1, v2 = Curves2D.computeTangent(smoothNext, smoothNext.t0()));
        if (diff < (eps = 1.0E-12) || diff > Math.PI * 2 - eps) {
            return JunctionType.FLAT;
        }
        if (diff < Math.PI - eps) {
            return JunctionType.SALIENT;
        }
        if (diff > Math.PI + eps) {
            return JunctionType.REENTRANT;
        }
        double kappaPrev = smoothPrev.curvature(smoothPrev.t1());
        double kappaNext = smoothNext.curvature(smoothNext.t0());
        double sp = Math.signum(kappaPrev);
        double sn = Math.signum(kappaNext);
        if (sn * sp > 0.0) {
            if (sn > 0.0) {
                return JunctionType.REENTRANT;
            }
            return JunctionType.SALIENT;
        }
        if (sp == 0.0) {
            if (sn < 0.0) {
                return JunctionType.SALIENT;
            }
            if (sn > 0.0) {
                return JunctionType.REENTRANT;
            }
            throw new IllegalArgumentException("colinear lines...");
        }
        if (sn == 0.0) {
            if (sp < 0.0) {
                return JunctionType.SALIENT;
            }
            if (sp > 0.0) {
                return JunctionType.REENTRANT;
            }
        }
        if (sp == 1.0 && sn == -1.0) {
            return Math.abs(kappaPrev) < Math.abs(kappaNext) ? JunctionType.SALIENT : JunctionType.REENTRANT;
        }
        if (sp == -1.0 && sn == 1.0) {
            return Math.abs(kappaPrev) > Math.abs(kappaNext) ? JunctionType.SALIENT : JunctionType.REENTRANT;
        }
        throw new RuntimeException("Could not determine junction type");
    }

    private static Vector2D computeTangent(ContinuousCurve2D curve, double pos) {
        if (curve instanceof SmoothCurve2D) {
            return ((SmoothCurve2D)curve).tangent(pos);
        }
        if (curve instanceof CurveSet2D) {
            CurveSet2D curveSet = (CurveSet2D)((Object)curve);
            double pos2 = curveSet.localPosition(pos);
            Object subCurve = curveSet.childCurve(pos);
            return Curves2D.computeTangent((ContinuousCurve2D)subCurve, pos2);
        }
        throw new IllegalArgumentException("Unknown type of curve: should be either continuous or curveset");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JunctionType {
        SALIENT,
        REENTRANT,
        FLAT;

    }
}

