/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;

public class Stack_Interleaver
implements PlugIn {
    ImagePlus imp1;
    ImagePlus imp2;

    public void run(String arg) {
        if (!this.showDialog()) {
            return;
        }
        if (this.imp1.getType() != this.imp2.getType()) {
            this.error();
            return;
        }
        ImageStack stack1 = this.imp1.getStack();
        ImageStack stack2 = this.imp2.getStack();
        ImageStack stack3 = this.interleave(stack1, stack2);
        new ImagePlus("Combined Stacks", stack3).show();
        IJ.register(Stack_Interleaver.class);
    }

    public ImageStack interleave(ImageStack stack1, ImageStack stack2) {
        int d1 = stack1.getSize();
        int d2 = stack2.getSize();
        int d3 = d1 + d2;
        int w1 = stack1.getWidth();
        int h1 = stack1.getHeight();
        int w2 = stack2.getWidth();
        int h2 = stack2.getHeight();
        int w3 = Math.max(w1, w2);
        int h3 = Math.max(h1, h2);
        ImageStack stack3 = new ImageStack(w3, h3, stack1.getColorModel());
        ImageProcessor ip = stack1.getProcessor(1);
        Color background = Toolbar.getBackgroundColor();
        for (int i = 1; i <= d3; ++i) {
            IJ.showProgress((double)((double)i / (double)d3));
            ImageProcessor ip3 = ip.createProcessor(w3, h3);
            if (i <= d1) {
                if (h1 < h3 || w1 < w3) {
                    ip3.setColor(background);
                    ip3.fill();
                }
                ip3.insert(stack1.getProcessor(i), 0, 0);
                stack3.addSlice(null, ip3);
            }
            ip3 = ip.createProcessor(w3, h3);
            if (i > d2) continue;
            if (h2 < h3 || w2 < w3) {
                ip3.setColor(background);
                ip3.fill();
            }
            ip3.insert(stack2.getProcessor(i), 0, 0);
            stack3.addSlice(null, ip3);
        }
        return stack3;
    }

    public boolean showDialog() {
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            this.error();
            return false;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        GenericDialog gd = new GenericDialog("Interleaver");
        gd.addChoice("Stack_1:", titles, titles[0]);
        gd.addChoice("Stack_2:", titles, titles[1]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int index1 = gd.getNextChoiceIndex();
        int index2 = gd.getNextChoiceIndex();
        this.imp1 = WindowManager.getImage((int)wList[index1]);
        this.imp2 = WindowManager.getImage((int)wList[index2]);
        return true;
    }

    void error() {
        IJ.showMessage((String)"Stack_Interleaver", (String)"This plugin requires two stacks\nthat are the same data type.");
    }
}

