/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.compute_cache;

import java.util.stream.DoubleStream;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuGauss;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuNeighborhoodOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuViews;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuComputeCache;
import sc.fiji.labkit.pixel_classification.gpu.compute_cache.GpuOriginalContent;

public class GpuGaussContent
implements GpuComputeCache.Content {
    private final GpuComputeCache cache;
    private final double sigma;
    private final GpuOriginalContent source;
    private final GpuNeighborhoodOperation operation;

    public GpuGaussContent(GpuComputeCache cache, double sigma) {
        this.cache = cache;
        this.sigma = sigma;
        this.source = new GpuOriginalContent(cache);
        this.operation = GpuGauss.gauss(cache.gpuApi(), this.sigmas(cache.pixelSize()));
    }

    public int hashCode() {
        return Double.hashCode(this.sigma);
    }

    public boolean equals(Object obj) {
        return obj instanceof GpuGaussContent && this.source.equals(((GpuGaussContent)obj).source) && this.sigma == ((GpuGaussContent)obj).sigma;
    }

    @Override
    public void request(Interval interval) {
        this.cache.request(this.source, this.operation.getRequiredInputInterval(interval));
    }

    @Override
    public GpuImage load(Interval interval) {
        GpuApi gpu = this.cache.gpuApi();
        GpuView original = this.cache.get(this.source, this.operation.getRequiredInputInterval(interval));
        GpuImage output = gpu.create(Intervals.dimensionsAsLongArray((Dimensions)interval), NativeTypeEnum.Float);
        this.operation.apply(original, GpuViews.wrap(output));
        return output;
    }

    private double[] sigmas(double[] pixelSize) {
        return DoubleStream.of(pixelSize).map(p -> this.sigma / p).toArray();
    }
}

