/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.control.mcu;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import org.janelia.saalfeldlab.control.mcu.MCUButtonControl;
import org.janelia.saalfeldlab.control.mcu.MCUFaderControl;
import org.janelia.saalfeldlab.control.mcu.MCUVPotControl;

public abstract class MCUControlPanel
implements Receiver {
    private static final int STATUS_CONTROL = 176;
    private static final int STATUS_KEY = 144;
    private static final int STATUS_FADER = 232;
    private Transmitter trans = null;
    private Receiver rec = null;

    public MCUControlPanel(Transmitter trans, Receiver rec) {
        this.trans = trans;
        this.rec = rec;
        trans.setReceiver(this);
    }

    public abstract MCUVPotControl getVPotControl(int var1);

    protected abstract MCUVPotControl getVPotControlById(int var1);

    public abstract MCUFaderControl getFaderControl(int var1);

    protected abstract MCUFaderControl getFaderControlById(int var1);

    public abstract MCUButtonControl getButtonControl(int var1);

    protected abstract MCUButtonControl getButtonControlById(int var1);

    public abstract int getNumVPotControls();

    public abstract int getNumButtonControls();

    public abstract int getNumFaderControls();

    protected void send(ShortMessage msg) throws InvalidMidiDataException {
        this.rec.send(msg, System.currentTimeMillis());
    }

    protected void send(byte status, byte data1, byte data2) throws InvalidMidiDataException {
        this.send(new ShortMessage(status, data1, data2));
    }

    protected void send(int status, int data1, int data2) throws InvalidMidiDataException {
        this.send((byte)status, (byte)data1, (byte)data2);
    }

    @Override
    public void send(MidiMessage msg, long timeStamp) {
        byte[] bytes = msg.getMessage();
        if (msg instanceof ShortMessage) {
            ShortMessage sm = (ShortMessage)msg;
            int status = sm.getStatus();
            switch (status) {
                case 176: {
                    int data = sm.getData2();
                    MCUVPotControl control = this.getVPotControlById(sm.getData1());
                    control.update(data);
                    break;
                }
                case 144: {
                    int data = sm.getData2();
                    MCUButtonControl key = this.getButtonControlById(sm.getData1());
                    key.update(data);
                    break;
                }
                case 232: {
                    int data = sm.getData2();
                    MCUFaderControl fader = this.getFaderControlById(sm.getData1());
                    fader.update(data);
                }
            }
        }
    }

    @Override
    public void close() {
        this.trans.close();
        this.rec.close();
    }
}

