/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealInvertibleComponentMappingTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;

public class AxisSelectionTransform
implements RealTransform {
    private final RealTransform transform;
    private final int[] axes;
    private final boolean unProject;
    private final RealInvertibleComponentMappingTransform permutation;
    private final RealTransformSequence seq;

    public AxisSelectionTransform(RealTransform transform, int[] axes, int nd, boolean unProject) {
        this.transform = transform;
        this.axes = axes;
        this.unProject = unProject;
        this.permutation = new RealInvertibleComponentMappingTransform(axes);
        this.seq = new RealTransformSequence();
        this.seq.add((RealTransform)this.permutation);
        this.seq.add(transform);
        if (unProject) {
            this.seq.add((RealTransform)this.permutation.inverse());
        }
    }

    public AxisSelectionTransform(RealTransform transform, int[] axes, boolean unProject) {
        this(transform, axes, Arrays.stream(axes).max().getAsInt(), unProject);
    }

    public int numSourceDimensions() {
        return this.permutation.numDimensions();
    }

    public int numTargetDimensions() {
        return this.unProject ? this.numSourceDimensions() : this.transform.numTargetDimensions();
    }

    public void apply(double[] source, double[] target) {
        this.seq.apply(source, target);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.seq.apply(source, target);
    }

    public RealTransform copy() {
        return new AxisSelectionTransform(this.transform, this.axes, this.unProject);
    }
}

