/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Font;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class FontFormatter
extends DefaultFormatter {
    private boolean allowsNullValue = false;
    private boolean allowsUnknownFont = false;
    @Nullable
    private HashMap<String, Font> genericFontFamilies = new HashMap();

    public FontFormatter() {
        this(true);
    }

    public FontFormatter(boolean allowsNullValue) {
        this.allowsNullValue = allowsNullValue;
        this.setOverwriteMode(false);
        this.putGenericFontFamily("serif", new Font("Serif", 0, 12));
        this.putGenericFontFamily("sans-serif", new Font("SansSerif", 0, 12));
        this.putGenericFontFamily("cursive", new Font("SansSerif", 2, 12));
        this.putGenericFontFamily("fantasy", new Font("Serif", 0, 12));
        this.putGenericFontFamily("monospace", new Font("Monospaced", 0, 12));
    }

    public void setAllowsNullValue(boolean newValue) {
        this.allowsNullValue = newValue;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAllowsUnknownFont(boolean newValue) {
        this.allowsUnknownFont = newValue;
    }

    public boolean getAllowsUnknownFont() {
        return this.allowsUnknownFont;
    }

    public void clearGenericFontFamilies() {
        this.genericFontFamilies = null;
    }

    public void putGenericFontFamily(String familyName, Font font) {
        this.genericFontFamilies.put(familyName.toLowerCase(), font);
    }

    @Override
    public Object stringToValue(String str) throws ParseException {
        if (str == null || str.trim().length() == 0) {
            if (this.allowsNullValue) {
                return null;
            }
            throw new ParseException("Null value is not allowed.", 0);
        }
        String strLC = str.trim().toLowerCase();
        Font f = null;
        f = this.genericFontFamilies.get(strLC);
        if (f == null) {
            f = Font.decode(str);
            if (f == null) {
                throw new ParseException(str, 0);
            }
            if (!this.allowsUnknownFont) {
                String fontName = f.getFontName().toLowerCase();
                String family = f.getFamily().toLowerCase();
                if (!(fontName.equals(strLC) || family.equals(strLC) || fontName.equals(strLC + "-derived"))) {
                    throw new ParseException(str, 0);
                }
            }
        }
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String valueToString(Object value) throws ParseException {
        String str = null;
        if (value == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(value instanceof Font)) {
            throw new ParseException("Value is not a font " + value, 0);
        }
        Font f = (Font)value;
        return f.getFontName();
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory() {
        return FontFormatter.createFormatterFactory(false);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(boolean allowsNullValue) {
        return new DefaultFormatterFactory(new FontFormatter(allowsNullValue));
    }
}

