/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class SlidebookTiffReader
extends BaseTiffReader {
    public static final String SLIDEBOOK_MAGIC_STRING = "SlideBook";
    private static final int X_POS_TAG = 65000;
    private static final int Y_POS_TAG = 65001;
    private static final int Z_POS_TAG = 65002;
    private static final int CHANNEL_TAG = 65004;
    private static final int PHYSICAL_SIZE_TAG = 65007;
    private static final int MAGNIFICATION_TAG = 65005;
    private int lastFile = 0;
    private MinimalTiffReader[] readers;
    private String[] files;
    private ArrayList<String> channelNames = new ArrayList();

    public SlidebookTiffReader() {
        super("Slidebook TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.equals(SLIDEBOOK_MAGIC_STRING) && ifd.getComment().length() == 0 && (ifd.containsKey((Object)65000) || ifd.containsKey((Object)65001) || ifd.containsKey((Object)65002) || ifd.containsKey((Object)65004) || ifd.containsKey((Object)65007) || ifd.containsKey((Object)65005));
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.readers != null) {
                for (MinimalTiffReader reader : this.readers) {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            this.lastFile = 0;
            this.readers = null;
            this.files = null;
            this.channelNames.clear();
        }
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return noPixels ? null : this.files;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.readers == null || this.lastFile < 0 || this.lastFile >= this.readers.length || this.readers[this.lastFile] == null) {
            return super.get8BitLookupTable();
        }
        return this.readers[this.lastFile].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.readers == null || this.lastFile < 0 || this.lastFile >= this.readers.length || this.readers[this.lastFile] == null) {
            return super.get16BitLookupTable();
        }
        return this.readers[this.lastFile].get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int file = no / this.getSizeT();
        int plane = no % this.getSizeT();
        this.lastFile = file;
        return this.readers[file].openBytes(plane, buf, x, y, w, h);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.put("Slidebook", "yes");
        if (this.isGroupFiles()) {
            String timestamp = this.getTimestamp(this.currentId);
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            Object[] list = parent.list(true);
            Arrays.sort(list);
            ArrayList<String> matchingFiles = new ArrayList<String>();
            for (Object f : list) {
                String path = new Location(parent, (String)f).getAbsolutePath();
                if (!this.isThisType(path) || !this.getTimestamp(path).equals(timestamp)) continue;
                matchingFiles.add(path);
            }
            this.files = matchingFiles.toArray(new String[matchingFiles.size()]);
        } else {
            this.files = new String[]{this.currentId};
        }
        this.readers = new MinimalTiffReader[this.files.length];
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        m.imageCount = this.ifds.size() * this.files.length;
        m.sizeT = this.ifds.size();
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i] = new MinimalTiffReader();
            this.readers[i].setId(this.files[i]);
            String channelName = this.getFirstChannel(this.files[i]);
            if (this.channelNames.contains(channelName)) continue;
            this.channelNames.add(channelName);
        }
        m.sizeC = this.channelNames.size();
        m.sizeZ = this.getImageCount() / (this.getSizeT() * this.getSizeC());
        m.dimensionOrder = "XYTCZ";
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        Location file = new Location(this.currentId).getAbsoluteFile();
        store.setImageName(file.getParentFile().getName(), 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String mag;
            Double size;
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                String name;
                if (c >= this.channelNames.size() || (name = this.channelNames.get(c)) == null) continue;
                if (name.indexOf(58) > 0) {
                    name = name.substring(name.indexOf(58) + 1);
                }
                if (name.indexOf(59) > 0) {
                    name = name.substring(0, name.indexOf(59));
                }
                store.setChannelName(name.trim(), 0, c);
            }
            IFD ifd = (IFD)this.ifds.get(0);
            String physicalSize = ifd.getIFDTextValue(65007);
            if (physicalSize != null && (size = DataTools.parseDouble(physicalSize)) > 0.0) {
                store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX((Double)size), 0);
                store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY((Double)size), 0);
            }
            if ((mag = ifd.getIFDTextValue(65005)) != null) {
                store.setInstrumentID(MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0}), 0);
                store.setObjectiveID(MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0}), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"Other"), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion((String)"Other"), 0, 0);
                store.setObjectiveNominalMagnification(DataTools.parseDouble(mag), 0, 0);
            }
            Double xn = Double.valueOf(ifd.getIFDTextValue(65000));
            Double yn = Double.valueOf(ifd.getIFDTextValue(65001));
            Double zn = Double.valueOf(ifd.getIFDTextValue(65002));
            Length xl = new Length((Number)xn, UNITS.REFERENCEFRAME);
            Length yl = new Length((Number)yn, UNITS.REFERENCEFRAME);
            Length zl = new Length((Number)zn, UNITS.REFERENCEFRAME);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlanePositionX(xl, 0, i);
                store.setPlanePositionY(yl, 0, i);
                store.setPlanePositionZ(zl, 0, i);
            }
        }
    }

    private String getTimestamp(String path) throws FormatException, IOException {
        Object date = null;
        try (RandomAccessInputStream s = new RandomAccessInputStream(path);){
            TiffParser parser = new TiffParser(s);
            IFD ifd = parser.getFirstIFD();
            date = ifd.getIFDValue(306);
        }
        return date == null ? null : date.toString();
    }

    private String getFirstChannel(String path) throws FormatException, IOException {
        Object channel = null;
        try (RandomAccessInputStream s = new RandomAccessInputStream(path);){
            TiffParser parser = new TiffParser(s);
            IFD ifd = parser.getFirstIFD();
            channel = ifd.getIFDValue(65004);
        }
        return channel == null ? null : channel.toString();
    }
}

