/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.integral;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.converter.Converter;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public class IntegralImg<R extends NumericType<R>, T extends NumericType<T> & NativeType<T>>
implements OutputAlgorithm<Img<T>> {
    protected final RandomAccessibleInterval<R> img;
    protected final T type;
    protected Img<T> integral;
    protected final Converter<R, T> converter;
    protected final int order;

    public IntegralImg(RandomAccessibleInterval<R> img, T type, Converter<R, T> converter) {
        this(img, type, converter, 1);
    }

    public IntegralImg(RandomAccessibleInterval<R> img, T type, Converter<R, T> converter, int order) {
        this.img = img;
        this.type = type;
        this.converter = converter;
        this.order = order;
    }

    @Override
    public boolean process() {
        long size;
        int numDimensions = this.img.numDimensions();
        long[] integralSize = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            integralSize[d] = (int)this.img.dimension(d) + 1;
        }
        NativeImg integral = new ArrayImgFactory<NativeType>((NativeType)this.type).create(integralSize);
        if (integral == null) {
            return false;
        }
        this.integral = integral;
        if (numDimensions > 1) {
            long[] fakeSize = new long[numDimensions - 1];
            long[] tmpIn = new long[numDimensions];
            long[] tmpOut = new long[numDimensions];
            size = integralSize[0];
            for (int d = 1; d < numDimensions; ++d) {
                fakeSize[d - 1] = integralSize[d];
            }
            LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
            RandomAccess cursorIn = this.img.randomAccess();
            RandomAccess cursorOut = integral.randomAccess();
            NumericType tmpVar = (NumericType)this.type.createVariable();
            NumericType sum = (NumericType)this.type.createVariable();
            block2: while (cursorDim.hasNext()) {
                cursorDim.fwd();
                cursorDim.localize(fakeSize);
                tmpIn[0] = 0L;
                tmpOut[0] = 1L;
                for (int d = 1; d < numDimensions; ++d) {
                    tmpIn[d] = fakeSize[d - 1] - 1L;
                    tmpOut[d] = fakeSize[d - 1];
                    if (tmpOut[d] == 0L) continue block2;
                }
                cursorIn.setPosition(tmpIn);
                cursorOut.setPosition(tmpOut);
                this.integrateLineDim0(this.converter, cursorIn, cursorOut, sum, tmpVar, size);
            }
        } else {
            NumericType tmpVar = (NumericType)this.type.createVariable();
            NumericType sum = (NumericType)this.type.createVariable();
            long size2 = integralSize[0];
            RandomAccess cursorIn = this.img.randomAccess();
            RandomAccess cursorOut = integral.randomAccess();
            cursorIn.setPosition(0, 0);
            cursorOut.setPosition(1, 0);
            this.converter.convert(cursorIn.get(), sum);
            ((NumericType)cursorOut.get()).set(sum);
            int i = 2;
            while ((long)i < size2) {
                cursorIn.fwd(0);
                cursorOut.fwd(0);
                this.converter.convert(cursorIn.get(), tmpVar);
                sum.add(tmpVar);
                ((NumericType)cursorOut.get()).set(sum);
                ++i;
            }
            return true;
        }
        for (int d = 1; d < numDimensions; ++d) {
            long[] fakeSize = new long[numDimensions - 1];
            long[] tmp = new long[numDimensions];
            size = integralSize[d];
            int countDim = 0;
            for (int e = 0; e < numDimensions; ++e) {
                if (e == d) continue;
                fakeSize[countDim++] = integralSize[e];
            }
            LocalizingZeroMinIntervalIterator cursorDim = new LocalizingZeroMinIntervalIterator(fakeSize);
            RandomAccess cursor = integral.randomAccess();
            NumericType sum = (NumericType)this.type.createVariable();
            while (cursorDim.hasNext()) {
                cursorDim.fwd();
                cursorDim.localize(fakeSize);
                tmp[d] = 1L;
                countDim = 0;
                for (int e = 0; e < numDimensions; ++e) {
                    if (e == d) continue;
                    tmp[e] = fakeSize[countDim++];
                }
                cursor.setPosition(tmp);
                this.integrateLine(d, cursor, sum, size);
            }
        }
        return true;
    }

    protected void integrateLineDim0(Converter<R, T> converter, RandomAccess<R> cursorIn, RandomAccess<T> cursorOut, T sum, T tmpVar, long size) {
        converter.convert(cursorIn.get(), sum);
        for (int j = 0; j < this.order - 1; ++j) {
            sum.mul(sum);
        }
        ((NumericType)cursorOut.get()).set(sum);
        int i = 2;
        while ((long)i < size) {
            cursorIn.fwd(0);
            cursorOut.fwd(0);
            converter.convert(cursorIn.get(), tmpVar);
            for (int j = 0; j < this.order - 1; ++j) {
                tmpVar.mul(tmpVar);
            }
            sum.add(tmpVar);
            ((NumericType)cursorOut.get()).set(sum);
            ++i;
        }
    }

    protected void integrateLine(int d, RandomAccess<T> cursor, T sum, long size) {
        sum.set((Type)((Type)cursor.get()));
        int i = 2;
        while ((long)i < size) {
            cursor.fwd(d);
            sum.add(cursor.get());
            ((NumericType)cursor.get()).set(sum);
            ++i;
        }
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public Img<T> getResult() {
        return this.integral;
    }
}

