/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.imglib2.algorithm.kdtree.ConvexPolytope;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.algorithm.kdtree.NodeIndexIterable;
import net.imglib2.kdtree.KDTreeImpl;

class ClipConvexPolytopeKDTreeImpl {
    private final KDTreeImpl tree;
    private final int n;
    private int nPlanes;
    private double[][] normals;
    private double[] ms;
    private final double[] xmin;
    private final double[] xmax;
    private boolean[] qR;
    private boolean[] qL;
    private final ArrayList<boolean[]> activeStack;
    private final ArrayList<boolean[]> psStack;
    private final TIntArrayList inNodes;
    private final TIntArrayList inSubtrees;
    private final TIntArrayList outNodes;
    private final TIntArrayList outSubtrees;

    public ClipConvexPolytopeKDTreeImpl(KDTreeImpl tree) {
        this.tree = tree;
        this.n = tree.numDimensions();
        this.xmin = new double[this.n];
        this.xmax = new double[this.n];
        this.activeStack = new ArrayList();
        this.psStack = new ArrayList();
        this.inNodes = new TIntArrayList();
        this.inSubtrees = new TIntArrayList();
        this.outNodes = new TIntArrayList();
        this.outSubtrees = new TIntArrayList();
    }

    public int numDimensions() {
        return this.n;
    }

    public void clip(ConvexPolytope polytope) {
        Collection<? extends HyperPlane> planes = polytope.getHyperplanes();
        this.initNewSearch(planes.size());
        int i = 0;
        for (HyperPlane hyperPlane : planes) {
            double[] normal = this.normals[i];
            System.arraycopy(hyperPlane.getNormal(), 0, normal, 0, this.n);
            this.ms[i] = hyperPlane.getDistance();
            for (int d = 0; d < this.n; ++d) {
                this.qL[d * this.nPlanes + i] = normal[d] < 0.0;
                this.qR[d * this.nPlanes + i] = normal[d] >= 0.0;
            }
            ++i;
        }
        this.clip(this.tree.root(), 0);
    }

    public void clip(double[][] planes) {
        this.initNewSearch(planes.length);
        for (int i = 0; i < this.nPlanes; ++i) {
            double[] normal = this.normals[i];
            System.arraycopy(planes[i], 0, normal, 0, this.n);
            this.ms[i] = planes[i][this.n];
            for (int d = 0; d < this.n; ++d) {
                this.qL[d * this.nPlanes + i] = normal[d] < 0.0;
                this.qR[d * this.nPlanes + i] = normal[d] >= 0.0;
            }
        }
        this.clip(this.tree.root(), 0);
    }

    public NodeIndexIterable getInsideNodes() {
        return new NodeIndexIterable(this.inNodes, this.inSubtrees, this.tree);
    }

    public NodeIndexIterable getOutsideNodes() {
        return new NodeIndexIterable(this.outNodes, this.outSubtrees, this.tree);
    }

    private void initNewSearch(int nPlanes) {
        this.nPlanes = nPlanes;
        this.normals = new double[nPlanes][];
        for (int i = 0; i < nPlanes; ++i) {
            this.normals[i] = new double[this.n];
        }
        this.ms = new double[nPlanes];
        this.qR = new boolean[this.n * nPlanes];
        this.qL = new boolean[this.n * nPlanes];
        this.inNodes.clear();
        this.inSubtrees.clear();
        this.outNodes.clear();
        this.outSubtrees.clear();
        this.activeStack.clear();
        this.psStack.clear();
        Arrays.fill(this.xmin, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.xmax, Double.POSITIVE_INFINITY);
        Arrays.fill(this.getActiveArray(0), true);
    }

    private boolean[] getActiveArray(int i) {
        if (i >= this.activeStack.size()) {
            this.activeStack.add(new boolean[this.nPlanes]);
            this.psStack.add(new boolean[this.nPlanes]);
        }
        return this.activeStack.get(i);
    }

    private boolean[] getPsArray(int i) {
        return this.psStack.get(i);
    }

    private boolean allAbove(int i) {
        double[] normal = this.normals[i];
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += normal[d] * (normal[d] >= 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot >= this.ms[i];
    }

    private boolean allBelow(int i) {
        double[] normal = this.normals[i];
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += normal[d] * (normal[d] < 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot < this.ms[i];
    }

    private void clipSubtree(int currentNodeIndex, boolean[] ps, boolean[] qs, int qoff, int recursionDepth) {
        boolean[] active = this.getActiveArray(recursionDepth);
        boolean[] stillActive = this.getActiveArray(recursionDepth + 1);
        System.arraycopy(active, 0, stillActive, 0, this.nPlanes);
        boolean noneActive = true;
        for (int i = 0; i < this.nPlanes; ++i) {
            if (!active[i]) continue;
            if (ps[i] && qs[qoff + i] && this.allAbove(i)) {
                stillActive[i] = false;
                continue;
            }
            noneActive = false;
            if (ps[i] || qs[qoff + i] || !this.allBelow(i)) continue;
            this.outSubtrees.add(currentNodeIndex);
            return;
        }
        if (noneActive) {
            this.inSubtrees.add(currentNodeIndex);
        } else {
            this.clip(currentNodeIndex, recursionDepth + 1);
        }
    }

    private void clip(int currentNodeIndex, int recursionDepth) {
        int sd = recursionDepth % this.n;
        double sc = this.tree.getDoublePosition(currentNodeIndex, sd);
        int left = this.tree.left(currentNodeIndex);
        int right = this.tree.right(currentNodeIndex);
        boolean[] active = this.getActiveArray(recursionDepth);
        boolean[] ps = this.getPsArray(recursionDepth);
        boolean p = true;
        for (int i = 0; i < this.nPlanes; ++i) {
            if (!active[i]) continue;
            double[] normal = this.normals[i];
            double dot = 0.0;
            for (int d = 0; d < this.n; ++d) {
                dot += this.tree.getDoublePosition(currentNodeIndex, d) * normal[d];
            }
            ps[i] = dot >= this.ms[i];
            p &= ps[i];
        }
        if (p) {
            this.inNodes.add(currentNodeIndex);
        } else {
            this.outNodes.add(currentNodeIndex);
        }
        int qoff = sd * this.nPlanes;
        if (left >= 0) {
            double max = this.xmax[sd];
            this.xmax[sd] = sc;
            this.clipSubtree(left, ps, this.qL, qoff, recursionDepth);
            this.xmax[sd] = max;
        }
        if (right >= 0) {
            double min = this.xmin[sd];
            this.xmin[sd] = sc;
            this.clipSubtree(right, ps, this.qR, qoff, recursionDepth);
            this.xmin[sd] = min;
        }
    }
}

