/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.algorithm.math.abstractions.ABooleanFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.type.numeric.RealType;

public abstract class Comparison<O extends RealType<O>>
extends ABooleanFunction<O> {
    protected final OFunction<O> a;
    protected final OFunction<O> b;

    public Comparison(O scrap, OFunction<O> a, OFunction<O> b) {
        super(scrap);
        this.a = a;
        this.b = b;
    }

    protected abstract boolean compare(O var1, O var2);

    @Override
    public final O eval() {
        return (O)(this.compare(this.a.eval(), this.b.eval()) ? this.one : this.zero);
    }

    @Override
    public final O eval(Localizable loc) {
        return (O)(this.compare(this.a.eval(loc), this.b.eval(loc)) ? this.one : this.zero);
    }

    @Override
    public boolean evalBoolean() {
        return this.compare(this.a.eval(), this.b.eval());
    }

    @Override
    public boolean evalBoolean(Localizable loc) {
        return this.compare(this.a.eval(loc), this.b.eval(loc));
    }

    @Override
    public final List<OFunction<O>> children() {
        return Arrays.asList(this.a, this.b);
    }

    @Override
    public final double evalDouble() {
        return this.compare(this.a.eval(), this.b.eval()) ? 1.0 : 0.0;
    }

    @Override
    public final double evalDouble(Localizable loc) {
        return this.compare(this.a.eval(loc), this.b.eval(loc)) ? 1.0 : 0.0;
    }
}

