/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.util;

import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.CacheRemover;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.LoaderRemoverCache;

public class LoaderRemoverCacheAsLoaderCacheAdapter<K, V, D>
implements LoaderCache<K, V> {
    private final LoaderRemoverCache<K, V, D> cache;
    private final CacheRemover<K, V, D> remover;

    public LoaderRemoverCacheAsLoaderCacheAdapter(LoaderRemoverCache<K, V, D> cache, CacheRemover<K, V, D> remover) {
        this.cache = cache;
        this.remover = remover;
    }

    @Override
    public V getIfPresent(K key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public V get(K key, CacheLoader<? super K, ? extends V> loader) throws ExecutionException {
        return this.cache.get((K)key, loader, (CacheRemover<? super K, ? extends V, D>)this.remover);
    }

    @Override
    public void persist(K key) {
        this.cache.persist(key);
    }

    @Override
    public void persistIf(Predicate<K> condition) {
        this.cache.persistIf(condition);
    }

    @Override
    public void persistAll() {
        this.cache.persistAll();
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(key);
        this.remover.invalidate(key);
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.cache.invalidateIf(parallelismThreshold, condition);
        this.remover.invalidateIf(parallelismThreshold, condition);
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.cache.invalidateAll(parallelismThreshold);
        this.remover.invalidateAll(parallelismThreshold);
    }
}

