/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.batch.input;

import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.imagej.Dataset;
import org.scijava.ItemVisibility;
import org.scijava.batch.input.BatchInput;
import org.scijava.batch.input.BatchInputProvider;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.AbstractHandlerPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=BatchInputProvider.class)
public class DatasetBatchInputProvider
extends AbstractHandlerPlugin<BatchInput>
implements BatchInputProvider<File> {
    @Parameter
    private ConvertService convertService;
    @Parameter
    private DatasetIOService ioService;

    public boolean supports(BatchInput input) {
        return this.canProvide(input.moduleItem());
    }

    public boolean canProvide(ModuleItem<?> item) {
        if (item.getVisibility() == ItemVisibility.MESSAGE) {
            return false;
        }
        return this.convertService.supports((Object)new ConversionRequest(Dataset.class, (Type)item.getType()));
    }

    public void populateInput(Module module, ModuleItem<?> moduleItem, File inputObject) {
        try {
            Dataset dataset = this.ioService.open(inputObject.getAbsolutePath());
            Object converted = this.convertService.convert((Object)dataset, moduleItem.getType());
            moduleItem.setValue(module, converted);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public String getTargetWidgetStyle(ModuleItem<?> item) {
        ArrayList<String> targetStyles = new ArrayList<String>();
        targetStyles.add("files");
        String widgetStyle = item.getWidgetStyle();
        if (widgetStyle != null) {
            String[] styles;
            for (String s : styles = widgetStyle.trim().split("\\s*,\\s*")) {
                if (!s.startsWith("extensions")) continue;
                targetStyles.add(s);
            }
        }
        return String.join((CharSequence)",", targetStyles);
    }
}

