/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.webdav;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class NetrcParser {
    private final URL url;

    public NetrcParser() {
        this(NetrcParser.getDefaultNetrc());
    }

    public NetrcParser(URL netrcURL) {
        this.url = netrcURL;
    }

    private static URL getDefaultNetrc() {
        String path = System.getProperty("webdav.netrc");
        if (path != null) {
            File file = new File(path);
            try {
                return file.isFile() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        String home = System.getProperty("user.home");
        if (home == null) {
            return null;
        }
        File homeDirectory = new File(home);
        if (!homeDirectory.isDirectory()) {
            return null;
        }
        File file = new File(homeDirectory, ".netrc");
        try {
            return file.isFile() ? file.toURI().toURL() : null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Credentials getCredentials(String hostname) throws IOException {
        return this.getCredentials(hostname, null);
    }

    public Credentials getCredentials(String hostname, String username) throws IOException {
        Credentials credentials = new Credentials(hostname, username, null);
        return this.getCredentials(credentials) ? credentials : null;
    }

    public boolean getCredentials(Credentials credentials) throws IOException {
        if (this.url == null) {
            return false;
        }
        String keyword = null;
        boolean isOurHost = false;
        boolean needsUsername = credentials.getUsername() == null;
        Tokenizer tokenizer = new Tokenizer(this.url);
        while (true) {
            if (credentials.getPassword() != null && credentials.getUsername() != null) {
                tokenizer.close();
                return true;
            }
            String token = tokenizer.nextToken();
            if (token == null) break;
            if (keyword == null) {
                keyword = token;
                continue;
            }
            if ("machine".equals(keyword)) {
                isOurHost = token.equals(credentials.getHostname());
            } else if ("login".equals(keyword)) {
                if (isOurHost) {
                    if (needsUsername) {
                        credentials.username = token;
                    } else {
                        isOurHost = token.equals(credentials.getUsername());
                    }
                }
            } else if ("password".equals(keyword) && isOurHost) {
                credentials.password = token;
            }
            keyword = null;
        }
        return false;
    }

    public static class Credentials {
        private String hostname;
        private String username;
        private String password;

        public Credentials(String hostname, String username, String password) {
            this.hostname = hostname;
            this.username = username;
            this.password = password;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    private static class Tokenizer {
        private final BufferedReader reader;
        private String[] tokens;
        private int current;

        public Tokenizer(URL url) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(url.openStream()));
            this.nextLine();
        }

        public String nextToken() throws IOException {
            String token;
            do {
                if (this.current < 0) {
                    return null;
                }
                while (this.current >= this.tokens.length || "#".equals(this.tokens[this.current])) {
                    if (this.nextLine()) continue;
                    return null;
                }
            } while ("".equals(token = this.tokens[this.current++]));
            return token;
        }

        public boolean nextLine() throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                this.close();
                return false;
            }
            this.tokens = line.split("[ \t\n]+");
            this.current = 0;
            return true;
        }

        public void close() throws IOException {
            this.reader.close();
            this.tokens = null;
            this.current = -1;
        }
    }
}

