/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.extremafinder;

import java.util.ArrayList;
import mpicbg.imglib.algorithm.extremafinder.RegionalExtremaFinder;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;

public abstract class AbstractRegionalExtremaFinder<T extends RealType<T>>
implements RegionalExtremaFinder<T> {
    protected OutOfBoundsStrategyFactory<T> outOfBoundsFactory = new OutOfBoundsStrategyValueFactory();
    protected boolean allowEdgeMax = false;
    protected boolean doInterpolate = false;
    protected Image<T> image;
    protected final ArrayList<ArrayList<int[]>> maxima = new ArrayList();
    protected T threshold;

    @Override
    public void allowEdgeExtrema(boolean flag) {
        this.allowEdgeMax = flag;
    }

    @Override
    public ArrayList<ArrayList<int[]>> getRegionalExtrema() {
        return this.maxima;
    }

    @Override
    public ArrayList<float[]> getRegionalExtremaCenters() {
        ArrayList<float[]> centeredRegionalMaxima = new ArrayList<float[]>();
        ArrayList<ArrayList<int[]>> regionalMaxima = new ArrayList<ArrayList<int[]>>(this.maxima);
        ArrayList<int[]> curr = null;
        while (!regionalMaxima.isEmpty()) {
            curr = regionalMaxima.remove(0);
            float[] averagedCoord = this.findAveragePosition(curr);
            centeredRegionalMaxima.add(averagedCoord);
        }
        return centeredRegionalMaxima;
    }

    @Override
    public void setThreshold(T threshold) {
        this.threshold = threshold;
    }

    protected float[] findAveragePosition(ArrayList<int[]> coords) {
        int nDims = coords.get(0).length;
        float[] array = new float[3];
        for (int j = 0; j < coords.size(); ++j) {
            int[] curr = coords.get(j);
            for (int i = 0; i < nDims; ++i) {
                int n = i;
                array[n] = array[n] + (float)curr[i];
            }
        }
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] / (float)coords.size();
        }
        return array;
    }

    @Override
    public void setOutOfBoundsStrategyFactory(OutOfBoundsStrategyFactory<T> strategy) {
        this.outOfBoundsFactory = strategy;
    }
}

