/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIOFloatArray
implements ArrayDataAccess<NIOFloatArray>,
FloatAccess {
    protected FloatBuffer data;

    public NIOFloatArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public NIOFloatArray(float[] data) {
        FloatBuffer bufferIn = FloatBuffer.wrap(data);
        FloatBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public float getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, float value) {
        this.data.put(index, value);
    }

    public float[] getCurrentStorageArray() {
        float[] outData = new float[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIOFloatArray createArray(int numEntities) {
        return new NIOFloatArray(numEntities);
    }
}

