/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.constant;

import mpicbg.imglib.container.constant.ConstantContainer;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ConstantCursor<T extends Type<T>>
extends CursorImpl<T> {
    long i;
    final long sizeMinus1;
    final int numDimensions;
    final T type;

    public ConstantCursor(ConstantContainer<T> container, Image<T> image, T type) {
        super(container, image);
        this.numDimensions = image.getNumDimensions();
        long s = image.getDimension(0);
        for (int d = 1; d < this.numDimensions; ++d) {
            s *= (long)image.getDimension(d);
        }
        this.sizeMinus1 = s - 1L;
        this.type = type;
    }

    @Override
    public void reset() {
        this.i = -1L;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public int getStorageIndex() {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.i < this.sizeMinus1;
    }

    @Override
    public void fwd() {
        ++this.i;
    }
}

