/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class PlanarLocalizableByDimCursor<T extends Type<T>>
extends PlanarLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    protected final int[] step;
    protected final int[] tmp;
    protected final int[] sliceSteps;
    int numNeighborhoodCursors = 0;

    public PlanarLocalizableByDimCursor(PlanarContainer<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        int[] dims = container.getDimensions();
        this.step = Array.createAllocationSteps(dims);
        this.sliceSteps = new int[dims.length];
        if (dims.length > 2) {
            this.sliceSteps[2] = 1;
            for (int i = 3; i < dims.length; ++i) {
                int j = i - 1;
                this.sliceSteps[i] = dims[j] * this.sliceSteps[j];
            }
        }
        this.tmp = new int[this.numDimensions];
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.err.println(this.getClass().getCanonicalName() + ".createLocalNeighborhoodCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] offset, int[] size) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, offset, size);
        }
        System.err.println(this.getClass().getCanonicalName() + ".createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd(int dim) {
        int n = dim;
        this.position[n] = this.position[n] + 1;
        if (dim > 1) {
            this.sliceIndex += this.sliceSteps[dim];
            this.type.updateContainer(this);
        } else {
            this.type.incIndex(this.step[dim]);
        }
    }

    @Override
    public void move(int steps, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + steps;
        if (dim > 1) {
            this.sliceIndex += this.sliceSteps[dim] * steps;
            this.type.updateContainer(this);
        } else {
            this.type.incIndex(this.step[dim] * steps);
        }
    }

    @Override
    public void moveRel(int[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.move(vector[d], d);
        }
    }

    @Override
    public void moveTo(int[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int dist = pos[d] - this.getPosition(d);
            if (dist == 0) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void bck(int dim) {
        int n = dim;
        this.position[n] = this.position[n] - 1;
        if (dim > 1) {
            this.sliceIndex -= this.sliceSteps[dim];
            this.type.updateContainer(this);
        } else {
            this.type.decIndex(this.step[dim]);
        }
    }

    @Override
    public void setPosition(int[] position) {
        int d;
        this.type.updateIndex(this.container.getIndex(position));
        for (d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
        this.sliceIndex = 0;
        for (d = 2; d < this.numDimensions; ++d) {
            this.sliceIndex += position[d] * this.sliceSteps[d];
        }
        this.type.updateContainer(this);
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
        if (dim > 1) {
            this.sliceIndex = position * this.sliceSteps[dim];
            this.type.updateContainer(this);
        } else {
            this.type.updateIndex(this.container.getIndex(this.position));
        }
    }
}

