/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.labeling.LocalizableLabelingCursor;

public class LocalizableLabelingPerimeterCursor<T extends Comparable<T>>
extends LocalizableLabelingCursor<T> {
    LocalizableByDimCursor<LabelingType<T>> cc;
    int[] dimensions;
    int[] position;

    public LocalizableLabelingPerimeterCursor(LocalizableCursor<LabelingType<T>> c, LocalizableByDimCursor<LabelingType<T>> cc, T label) {
        super(c, label);
        this.cc = cc;
        this.dimensions = cc.getDimensions();
        this.position = c.createPositionArray();
    }

    public LocalizableLabelingPerimeterCursor(RegionOfInterestCursor<LabelingType<T>> c, int[] offset, LocalizableByDimCursor<LabelingType<T>> cc, T label) {
        super(c, offset, label);
        this.cc = cc;
        this.dimensions = cc.getDimensions();
        this.position = c.createPositionArray();
    }

    @Override
    protected boolean isLabeled() {
        if (!super.isLabeled()) {
            return false;
        }
        this.getCursorPosition(this.position);
        for (int i = 0; i < this.position.length; ++i) {
            for (int j = -1; j <= 1; j += 2) {
                if (j == -1 && this.position[i] == 0 || j == 1 && this.position[i] == this.dimensions[i] - 1) continue;
                int n = i;
                this.position[n] = this.position[n] + j;
                this.cc.setPosition(this.position);
                int n2 = i;
                this.position[n2] = this.position[n2] - j;
                boolean match = false;
                for (Comparable l : ((LabelingType)this.cc.getType()).getLabeling()) {
                    if (!l.equals(this.label)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return true;
            }
        }
        return false;
    }
}

