/*
 * Decompiled with CFR 0.152.
 */
package fiji;

import fiji.GraphicalMediaWikiClient;
import fiji.Prettify_Wiki_Screenshot;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.plugin.BrowserLauncher;
import ij.plugin.JpegWriter;
import ij.plugin.PNG_Writer;
import ij.plugin.PlugIn;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.scijava.Context;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.TextEditor;

public class Wiki_Editor
implements PlugIn,
ActionListener {
    protected String title;
    protected static String URL = "http://fiji.sc/wiki/";
    protected Mode mode;
    protected ImagePlus screenshot;
    protected Format imageFormat = Format.JPEG;
    protected static final String[] imageFormatNames;
    protected TextEditor editor;
    protected JMenuItem upload;
    protected JMenuItem preview;
    protected JMenuItem toBackToggle;
    protected JMenuItem renameImage;
    protected JMenuItem changeURL;
    protected JMenuItem insertPluginInfobox;
    protected JMenuItem whiteImage;
    protected JMenuItem importHTML;
    protected boolean putSnapshotsToBack = true;
    GraphicalMediaWikiClient client;
    protected static List<TextEditor> editors;
    protected static String originalRename;
    protected static String originalRenameArg;
    protected Frame snapshotFrame;
    protected int snapshotCounter;

    public void run(String arg) {
        String dialogTitle = "Tutorial Maker";
        String defaultTitle = "";
        String label = "Tutorial_title";
        this.mode = Mode.TUTORIAL_MAKER;
        if (arg.equals("rename")) {
            this.rename();
            return;
        }
        if (arg.equals("news")) {
            this.mode = Mode.NEWS;
            dialogTitle = "Fiji News";
            defaultTitle = new SimpleDateFormat("yyyy-MM-dd - ").format(Calendar.getInstance().getTime());
            label = "News_title";
        } else if (arg.equals("screenshot")) {
            this.screenshot = IJ.getImage();
            if (this.screenshot == null) {
                IJ.error((String)"Which screenshot do you want to upload?");
                return;
            }
            this.mode = Mode.SCREENSHOT;
            dialogTitle = "Fiji Wiki Screenshot";
            defaultTitle = this.screenshot.getTitle().replace('_', ' ');
            int dot = defaultTitle.lastIndexOf(46);
            if (dot > 0) {
                defaultTitle = defaultTitle.substring(0, dot);
            }
            label = "Project_title (e.g. TrakEM2)";
        } else {
            this.interceptRenames();
        }
        GenericDialog gd = new GenericDialog(dialogTitle);
        gd.addStringField(label, defaultTitle, 20);
        gd.addChoice("Image_format", imageFormatNames, imageFormatNames[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.title = gd.getNextString();
        this.imageFormat = Format.valueOf(gd.getNextChoice());
        if (this.title.length() == 0) {
            return;
        }
        if (this.mode != Mode.SCREENSHOT) {
            this.title = Wiki_Editor.capitalize(this.title).replace(' ', '_');
        } else {
            this.title = Wiki_Editor.capitalize(this.title);
            new Prettify_Wiki_Screenshot().run(this.screenshot.getProcessor());
            this.screenshot = IJ.getImage();
            String imageTitle = this.title + "-snapshot" + this.imageFormat.extension;
            int i = 2;
            while (this.wikiHasImage(imageTitle)) {
                imageTitle = this.title + "-snapshot-" + i + this.imageFormat.extension;
                ++i;
            }
            this.screenshot.setTitle(imageTitle.replace(' ', '_'));
        }
        this.addEditor();
    }

    protected static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    protected void addEditor() {
        Context context = (Context)IJ.runPlugIn((String)Context.class.getName(), (String)"");
        this.editor = new TextEditor(context);
        this.editor.getTextArea().setLineWrap(true);
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu menu = new JMenu("Wiki");
        menu.setMnemonic(87);
        this.upload = this.editor.addToMenu(menu, "Upload", 85, ctrl);
        this.preview = this.editor.addToMenu(menu, "Preview", 82, ctrl);
        if (this.mode == Mode.TUTORIAL_MAKER) {
            this.toBackToggle = this.editor.addToMenu(menu, "", 0, 0);
            this.renameImage = this.editor.addToMenu(menu, "Rename Image", 73, ctrl);
            this.whiteImage = this.editor.addToMenu(menu, "Make white background image", 0, 0);
            this.toBackToggleSetLabel();
            this.insertPluginInfobox = this.editor.addToMenu(menu, "Insert Plugin Infobox", 0, 0);
        }
        this.changeURL = this.editor.addToMenu(menu, "Change Wiki URL", 0, 0);
        this.importHTML = this.editor.addToMenu(menu, "Import HTML from URL...", 0, 0);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            menu.getItem(i).addActionListener(this);
        }
        this.editor.getJMenuBar().add(menu);
        editors.add(this.editor);
        this.editor.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (Wiki_Editor.this.snapshotFrame != null) {
                    Wiki_Editor.this.snapshotFrame.dispose();
                }
                editors.remove(this);
            }
        });
        String text = "";
        String category = "";
        switch (this.mode) {
            case TUTORIAL_MAKER: {
                text = "== " + this.title.replace('_', ' ') + " ==\n\n";
                category = "\n[[Category:Tutorials]]";
                break;
            }
            case NEWS: {
                category = "\n[[Category:News]]";
                break;
            }
            case SCREENSHOT: {
                try {
                    text = this.getPageSource("Fiji:Featured_Projects");
                }
                catch (IOException e) {
                    IJ.error((String)("Could not get page source for '" + this.title + "'"));
                    return;
                }
                if (!text.endsWith("\n")) {
                    text = text + "\n";
                }
                text = text + "\n* " + this.title + "|" + this.screenshot.getTitle() + "\nThe [[" + this.title + "]] plugin <describe the project here>\n";
            }
        }
        this.editor.getTextArea().setText(text + category);
        this.editor.getTextArea().setCaretPosition(text.length());
        JMenuBar menuBar = this.editor.getJMenuBar();
        for (int i = menuBar.getMenuCount() - 1; i >= 0; --i) {
            String label = menuBar.getMenu(i).getText();
            if (label.equals("File") || label.equals("Edit") || label.equals("Wiki")) continue;
            menuBar.remove(i);
        }
        if (this.mode == Mode.TUTORIAL_MAKER) {
            this.showSnapshotFrame();
        }
        this.editor.setTitle("Edit Wiki - " + this.title);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Wiki_Editor.this.editor.setVisible(true);
            }
        });
    }

    public String getText() {
        return this.editor.getTextArea().getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.upload) {
            new Thread(){

                @Override
                public void run() {
                    Wiki_Editor.this.upload();
                }
            }.start();
        } else if (source == this.preview) {
            new Thread(){

                @Override
                public void run() {
                    Wiki_Editor.this.preview();
                }
            }.start();
        } else if (source == this.renameImage) {
            this.renameImage();
        } else if (source == this.whiteImage) {
            this.makeWhiteBackgroundImage();
        } else if (source == this.toBackToggle) {
            this.putSnapshotsToBack = !this.putSnapshotsToBack;
            this.toBackToggleSetLabel();
        } else if (source == this.changeURL) {
            GenericDialog gd = new GenericDialog("Change URL");
            gd.addStringField("URL", URL, 40);
            gd.showDialog();
            if (!gd.wasCanceled()) {
                URL = gd.getNextString();
                int off = URL.indexOf("/index.php");
                if (off > 0) {
                    URL = URL.substring(0, off + 1);
                }
                this.client = null;
            }
        } else if (source == this.importHTML) {
            GenericDialog gd = new GenericDialog("Import HTML from URL");
            gd.addStringField("URL", "", 40);
            gd.showDialog();
            if (!gd.wasCanceled()) {
                String url = gd.getNextString();
                if (url.startsWith("http://") || url.startsWith("https://")) {
                    this.importHTML(url);
                } else {
                    IJ.error((String)("Invalid URL: " + url));
                }
            }
        } else if (source == this.insertPluginInfobox) {
            RSyntaxTextArea textArea = this.editor.getTextArea();
            Calendar now = Calendar.getInstance();
            String today = new SimpleDateFormat("dd/MM/yyyy").format(now.getTime());
            textArea.insert("{{Infobox Plugin\n| software               = ImageJ\n| name                   = \n| maintainer             = [mailto:author_at_example_dot_com A U Thor]\n| author                 = A U Thor\n| source                 = \n| released               = " + today + "\n| latest version         = " + today + "\n| status                 = \n| category               = [[:Category:Plugins]]\n| website                = \n}}\n", 0);
            textArea.insert("\n[[Category:Plugins]]", textArea.getDocument().getLength());
        }
    }

    protected void toBackToggleSetLabel() {
        this.toBackToggle.setText(this.putSnapshotsToBack ? "Leave snapshots in the foreground" : "Put snapshots into the background");
    }

    protected void getClient() {
        if (this.client != null) {
            return;
        }
        this.client = new GraphicalMediaWikiClient(URL + "index.php");
    }

    protected void upload() {
        IJ.showStatus((String)("Uploading " + this.title + "..."));
        IJ.showProgress((int)0, (int)1);
        List<String> images = this.getImages();
        if (!this.saveOrUploadImages(null, images)) {
            return;
        }
        this.getClient();
        if (!this.client.login("Login for " + URL)) {
            return;
        }
        if (!this.saveOrUploadImages(this.client, images)) {
            return;
        }
        String name = this.mode == Mode.SCREENSHOT ? "Fiji:Featured_Projects" : this.title;
        boolean result = this.client.uploadPage(name, this.getText(), "Add " + this.title);
        this.client.logOut();
        IJ.showStatus((String)("Uploading " + name + " finished."));
        IJ.showProgress((int)1, (int)1);
        if (!result) {
            IJ.error((String)"Could not upload!");
            return;
        }
        new BrowserLauncher().run(URL + "index.php?title= " + name);
        this.editor.dispose();
    }

    protected void preview() {
        IJ.showStatus((String)("Previewing " + this.title + "..."));
        IJ.showProgress((int)0, (int)2);
        List<String> images = this.getImages();
        if (!this.saveOrUploadImages(null, images)) {
            return;
        }
        this.getClient();
        if (!this.client.login("Wiki Login (Preview)")) {
            return;
        }
        String name = this.mode == Mode.SCREENSHOT ? "Fiji:Featured_Projects" : this.title;
        String html = this.client.uploadOrPreviewPage(name, this.getText(), "Add " + this.title, true);
        this.client.logOut();
        if (html == null) {
            IJ.error((String)"Could not parse response");
            return;
        }
        IJ.showStatus((String)("Preparing " + name + " for preview..."));
        IJ.showProgress((int)1, (int)2);
        html = html.replaceAll("<img[^>]*src=\"(?=/wiki/)", "$0" + URL.substring(0, URL.length() - 6));
        int start = html.indexOf("<div class='previewnote'>");
        start = html.indexOf("</div>", start) + 6;
        int end = html.indexOf("<div id='toolbar'>");
        if (end < 0) {
            end = html.indexOf("<div id=\"toolbar\">");
        }
        html = "<html>\n<head>\n<title>Preview of " + name + "</title>\n<meta http-equiv='Content-Type' content='text/html; charset=utf-8'/>\n</head>\n<body>\n" + html.substring(start, end) + "</body>\n</html>\n";
        Pattern imagePattern = Pattern.compile("<a href=[^>]*DestFile=", 32);
        String[] parts = imagePattern.split(html);
        html = parts[0];
        for (int i = 1; i < parts.length; ++i) {
            int quote = parts[i].indexOf(34, 1);
            int endTag = parts[i].indexOf("</a>", quote + 1);
            String image = parts[i].substring(0, quote);
            ImagePlus imp = WindowManager.getImage((String)image);
            if (imp == null && Character.isUpperCase(image.charAt(0))) {
                image = Wiki_Editor.capitalize(image);
                imp = WindowManager.getImage((String)image);
            }
            if (imp == null) {
                html = html + "&lt;img src=" + image + "&gt;";
            } else {
                FileInfo info = imp.getOriginalFileInfo();
                File file = new File(info.directory, info.fileName);
                try {
                    html = html + "<img src=\"" + file.toURI().toURL() + "\">";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            html = html + parts[i].substring(endTag + 4);
        }
        try {
            File file = File.createTempFile("preview", ".html");
            FileOutputStream out = new FileOutputStream(file);
            out.write(html.getBytes());
            out.close();
            new BrowserLauncher().run(file.toURI().toURL().toString());
            IJ.showStatus((String)("Browsing " + name));
            IJ.showProgress((int)2, (int)2);
        }
        catch (IOException e) {
            e.printStackTrace();
            Wiki_Editor.error(e.getMessage());
        }
    }

    public String getPageSource(String pageTitle) throws IOException {
        String result = this.getPage(pageTitle, "edit");
        this.client.logOut();
        int offset = result.indexOf("id=\"wpTextbox1\"");
        if (offset < 0) {
            return "";
        }
        if ((offset = result.indexOf(62, offset)) < 0) {
            return "";
        }
        int endOffset = result.indexOf("</textarea>", offset);
        if (endOffset < 0) {
            return "";
        }
        return result.substring(offset + 1, endOffset);
    }

    public String getPage(String pageTitle) throws IOException {
        return this.getPage(pageTitle, null);
    }

    public String getPage(String pageTitle, String action) throws IOException {
        String result;
        this.getClient();
        String[] getVars = new String[]{"title", pageTitle};
        if (action != null) {
            getVars = new String[]{"title", pageTitle, "action", action};
        }
        if ((result = this.client.sendRequest(getVars, null)) == null || result.indexOf("Login Required") > 0 || result.indexOf("Login required") > 0) {
            this.getClient();
            if (!this.client.login("Login to view " + pageTitle)) {
                return null;
            }
            result = this.client.sendRequest(getVars, null);
        }
        return result;
    }

    protected List<String> getImages() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.mode == Mode.SCREENSHOT) {
            result.add(this.screenshot.getTitle());
            return result;
        }
        String text = this.getText();
        int image = 0;
        while ((image = text.indexOf("[[Image:", image)) >= 0) {
            int bracket = text.indexOf("]]", image += 8);
            int pipe = text.indexOf(124, image);
            if (bracket < 0 || pipe >= 0 && pipe < bracket) {
                bracket = pipe;
            }
            if (bracket < 0) {
                return result;
            }
            result.add(text.substring(image, bracket));
            image = bracket + 1;
        }
        return result;
    }

    protected static boolean error(String message) {
        IJ.showProgress((int)1, (int)1);
        IJ.error((String)message);
        return false;
    }

    protected static String normalizeImageTitle(String page) {
        int colon;
        String pageTitle = page.replace(' ', '_');
        if (pageTitle.length() > 0) {
            pageTitle = Wiki_Editor.capitalize(pageTitle);
        }
        while ((colon = pageTitle.indexOf(58)) >= 0) {
            pageTitle = pageTitle.substring(0, colon) + pageTitle.substring(colon + 1);
        }
        return pageTitle;
    }

    protected FileInfo setTmpFileInfo(ImagePlus imp, String fileName) {
        FileInfo info = new FileInfo();
        info.width = imp.getWidth();
        info.height = imp.getHeight();
        info.directory = IJ.getDirectory((String)"temp");
        info.fileName = fileName;
        imp.changes = true;
        imp.setFileInfo(info);
        return info;
    }

    protected boolean saveOrUploadImages(GraphicalMediaWikiClient clientOrNull, List<String> images) {
        int i = 0;
        int total = images.size() * 2 + 1;
        block4: for (String image : images) {
            FileInfo info;
            ImagePlus imp = WindowManager.getImage((String)image);
            if (imp == null) {
                return Wiki_Editor.error("There is no image " + image);
            }
            String newTitle = Wiki_Editor.normalizeImageTitle(image);
            if (!image.equals(newTitle)) {
                if (!IJ.showMessageWithCancel((String)"Rename Image", (String)("Image title '" + image + "' is invalid; fix?"))) {
                    return Wiki_Editor.error("Aborted");
                }
                imp.setTitle(newTitle);
                this.rename(image, newTitle);
                images.set(i, newTitle);
            }
            if ((info = imp.getOriginalFileInfo()) == null) {
                info = this.setTmpFileInfo(imp, image);
            }
            if (info.directory == null) {
                info.directory = IJ.getDirectory((String)"temp");
                imp.changes = true;
            }
            if (info.fileName == null) {
                info.fileName = image;
                imp.changes = true;
            }
            if (imp.changes) {
                String fullFilename = info.directory + "/" + info.fileName;
                Format format = Format.byExtension(fullFilename);
                if (format == null) {
                    format = this.imageFormat;
                }
                format.write(imp, fullFilename);
            }
            if (clientOrNull != null) {
                if (this.wikiHasImage(image)) {
                    switch (this.imageExistsDialog(image)) {
                        case 1: {
                            return Wiki_Editor.error("Aborted");
                        }
                        case 2: {
                            continue block4;
                        }
                    }
                }
                if (!clientOrNull.login("Login to upload " + image)) {
                    return false;
                }
                if (!clientOrNull.uploadFile(image, "Upload " + image + " for " + this.title, new File(info.directory, info.fileName)) && !this.wikiHasImage(image)) {
                    return Wiki_Editor.error("Uploading " + image + " failed");
                }
                IJ.showStatus((String)("Uploading " + image + "..."));
                IJ.showProgress((int)(++i + total / 2), (int)total);
                continue;
            }
            IJ.showProgress((int)(++i), (int)total);
        }
        return true;
    }

    protected String getContent(Element e) {
        try {
            int start = e.getStartOffset();
            int end = e.getEndOffset();
            String content = e.getDocument().getText(start, end - start);
            if (content.endsWith("\n")) {
                content = content.substring(0, content.length() - 1);
            }
            return content;
        }
        catch (BadLocationException e2) {
            return "";
        }
    }

    protected Object getAttribute(Object element, Object key) {
        if (element instanceof AttributeSet) {
            return ((AttributeSet)element).getAttribute(key);
        }
        return null;
    }

    protected void importHTML(String urlString) {
        try {
            StringBuffer buffer = new StringBuffer();
            HTMLDocument html = new HTMLDocument();
            html.putProperty("IgnoreCharsetDirective", new Boolean(true));
            HTMLEditorKit kit = new HTMLEditorKit();
            URL url = new URL(urlString);
            kit.read(url.openStream(), (Document)html, 0);
            Stack<Element> stack = new Stack<Element>();
            stack.push(html.getDefaultRootElement());
            while (!stack.empty()) {
                Element e = (Element)stack.pop();
                String name = e.getName();
                if (name.equals("head") || name.equals("br") || name.equals("comment") || name.equals("form") || name.equals("script")) continue;
                if (name.equals("html") || name.equals("body") || name.equals("p") || name.equals("p-implied") || name.equals("div") || name.equals("center")) {
                    for (int i = e.getElementCount() - 1; i >= 0; --i) {
                        stack.push(e.getElement(i));
                    }
                    continue;
                }
                String content = this.getContent(e);
                if (name.equals("content")) {
                    Object href;
                    Object a = this.getAttribute(e, HTML.Tag.A);
                    if (a != null && (href = this.getAttribute(a, HTML.Attribute.HREF)) != null) {
                        buffer.append("[" + new URL(url, (String)href) + " " + content + "]");
                    } else {
                        buffer.append(content);
                    }
                } else if (name.equals("table")) {
                    buffer.append("{|\n");
                    for (int i = 0; i < e.getElementCount(); ++i) {
                        if (i > 0) {
                            buffer.append("|-\n");
                        }
                        Element e2 = e.getElement(i);
                        for (int j = 0; j < e2.getElementCount(); ++j) {
                            buffer.append("| " + this.getContent(e2.getElement(j))).append("\n");
                        }
                    }
                    buffer.append("|}\n");
                } else if (name.equals("ul")) {
                    for (int i = 0; i < e.getElementCount(); ++i) {
                        buffer.append("* " + this.getContent(e.getElement(i))).append("\n");
                    }
                } else if (name.equals("blockquote")) {
                    for (int i = e.getElementCount() - 1; i >= 0; --i) {
                        stack.push(e.getElement(i));
                    }
                    buffer.append(";").append(content.replaceAll("\n", "\n;"));
                } else if (name.equals("img")) {
                    String src = (String)this.getAttribute(e, HTML.Attribute.SRC);
                    if (src != null) {
                        ImagePlus image = new ImagePlus(new URL(url, src).toString());
                        image.show();
                        String baseName = src.substring(src.lastIndexOf(47) + 1);
                        this.setTmpFileInfo(image, baseName);
                        buffer.append("[[Image:" + baseName + "]]");
                    }
                } else if (name.equals("h1")) {
                    buffer.append("= " + content + " =\n");
                } else if (name.equals("h2")) {
                    buffer.append("== " + content + " ==\n");
                } else if (name.equals("h3")) {
                    buffer.append("=== " + content + " ===\n");
                } else if (name.equals("h4")) {
                    buffer.append("==== " + content + " ====\n");
                } else {
                    IJ.log((String)("Unhandled tag: " + name));
                    continue;
                }
                buffer.append("\n");
            }
            EditorPane pane = this.editor.getEditorPane();
            pane.insert(buffer.toString(), pane.getCaretPosition());
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.error((String)("Could not open " + urlString + ":\n \n" + e.getMessage()));
        }
    }

    protected boolean wikiHasImage(String image) {
        try {
            boolean hasFile;
            String html = this.getPage("Image:" + image);
            boolean bl = hasFile = html.indexOf("No file by this name exists") < 0;
            if (hasFile) {
                System.err.println("has image: " + html);
            }
            return hasFile;
        }
        catch (IOException e) {
            String message = "Could not retrieve image " + image + ": " + e.getMessage();
            if ("HTTP code: 404".equals(e.getMessage())) {
                System.err.println(message);
            } else {
                IJ.error((String)message);
            }
            return false;
        }
    }

    protected int imageExistsDialog(String image) {
        GenericDialog gd = new GenericDialog("Image exists");
        gd.addMessage("The image '" + image + "' exists already on the Wiki");
        String[] choice = new String[]{"Upload '" + image + "' anyway", "Abort", "Skip uploading '" + image + "'"};
        gd.addChoice("action", choice, choice[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        return gd.getNextChoiceIndex();
    }

    protected void interceptRenames() {
        if (originalRename != null) {
            return;
        }
        Hashtable commands = Menus.getCommands();
        if (commands != null) {
            originalRename = (String)commands.get("Rename...");
            if (originalRename.endsWith("\")")) {
                int paren = originalRename.lastIndexOf("(\"");
                originalRenameArg = originalRename.substring(paren + 2, originalRename.length() - 2);
                originalRename = originalRename.substring(0, paren);
            } else {
                originalRenameArg = "";
            }
            commands.put("Rename...", this.getClass().getName() + "(\"rename\")");
        }
    }

    protected void rename() {
        String oldTitle = WindowManager.getCurrentImage().getTitle();
        IJ.runPlugIn((String)originalRename, (String)originalRenameArg);
        String newTitle = WindowManager.getCurrentImage().getTitle();
        this.rename(oldTitle, newTitle);
    }

    protected void rename(String oldTitle, String newTitle) {
        if (oldTitle.equals(newTitle)) {
            return;
        }
        for (TextEditor textEditor : editors) {
            String transformed;
            String text;
            if (textEditor == null || textEditor.getTextArea() == null || (text = textEditor.getTextArea().getText()).equals(transformed = text.replaceAll("\\[\\[Image:" + oldTitle.replaceAll("\\.", "\\\\.") + "(?=[]|])", "[[Image:" + newTitle))) continue;
            int pos = textEditor.getTextArea().getCaretPosition();
            textEditor.getTextArea().setText(transformed);
            try {
                textEditor.getTextArea().setCaretPosition(pos);
            }
            catch (Exception exception) {}
        }
    }

    protected void renameImage() {
        List<String> images = this.getImages();
        if (images.size() == 0) {
            IJ.error((String)"The text refers to no image");
            return;
        }
        String[] list = images.toArray(new String[0]);
        GenericDialog gd = new GenericDialog("Rename Image");
        gd.addChoice("image", list, list[0]);
        gd.addStringField("new_title", list[0], 20);
        final TextField textField = (TextField)gd.getStringFields().lastElement();
        final Choice choice = (Choice)gd.getChoices().lastElement();
        choice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                textField.setText(choice.getSelectedItem());
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String oldTitle = gd.getNextChoice();
        String newTitle = gd.getNextString();
        if (newTitle.length() == 0) {
            return;
        }
        ImagePlus image = WindowManager.getImage((String)oldTitle);
        if (image == null) {
            IJ.error((String)("No such image: " + oldTitle));
            return;
        }
        image.setTitle(newTitle);
        this.rename(oldTitle, newTitle);
    }

    protected void makeWhiteBackgroundImage() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        final Frame white = new Frame("White");
        white.setUndecorated(true);
        Panel panel = new Panel();
        panel.setSize(screenSize);
        panel.setMinimumSize(screenSize);
        panel.setBackground(Color.WHITE);
        white.add(panel);
        white.pack();
        white.setExtendedState(6);
        WindowManager.addWindow((Frame)white);
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    IJ.getInstance().requestFocus();
                } else if (key == 27 || key == 87) {
                    WindowManager.removeWindow((Frame)white);
                    white.dispose();
                } else if (key == 32) {
                    white.toBack();
                }
            }
        };
        white.addKeyListener(listener);
        panel.addKeyListener(listener);
        white.setVisible(true);
        white.requestFocus();
    }

    public void showSnapshotFrame() {
        this.snapshotFrame = new Frame("Snapshot");
        this.snapshotFrame.setLayout(new FlowLayout());
        this.snapshotFrame.add(this.createButton("Snap", 0L));
        this.snapshotFrame.add(this.createButton("Snap (3sec delay)", 3000L));
        this.snapshotFrame.pack();
        this.snapshotFrame.setAlwaysOnTop(true);
        this.snapshotFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Wiki_Editor.this.snapshotFrame.dispose();
            }
        });
        this.snapshotFrame.setVisible(true);
    }

    protected Button createButton(String text, long delay) {
        Button button = new Button(text);
        if (delay > 0L) {
            AutoSnap auto = new AutoSnap(button, delay);
            button.addActionListener(auto);
            button.addMouseListener(auto);
            this.snapshotFrame.addMouseListener(auto);
        } else {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wiki_Editor.this.snapshot();
                }
            });
            button.addMouseListener(new AutoSnap(button, 1000L));
        }
        return button;
    }

    protected String getSnapshotName() {
        String result;
        while (WindowManager.getImage((String)(result = this.title + "-" + ++this.snapshotCounter + this.imageFormat.extension)) != null) {
        }
        return result;
    }

    protected boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void snapshot() {
        try {
            Robot robot = new Robot();
            Rectangle rectangle = new Rectangle(IJ.getScreenSize());
            this.snapshotFrame.setVisible(false);
            BufferedImage image = robot.createScreenCapture(rectangle);
            this.snapshotFrame.setVisible(true);
            if (image != null) {
                String name = this.getSnapshotName();
                ImagePlus imp = new ImagePlus(name, (Image)image);
                imp.show();
                if (this.putSnapshotsToBack) {
                    imp.getWindow().toBack();
                }
                int p = this.editor.getTextArea().getCaretPosition();
                String insert = "[[Image:" + name + "]]\n";
                this.editor.getTextArea().insert(insert, p);
                this.editor.getTextArea().setCaretPosition(p += insert.length());
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new Wiki_Editor().run("");
    }

    static {
        Format[] values = Format.values();
        imageFormatNames = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Wiki_Editor.imageFormatNames[i] = values[i].name();
        }
        editors = new ArrayList<TextEditor>();
    }

    class AutoSnap
    extends MouseAdapter
    implements ActionListener {
        String originalLabel;
        Button button;
        int delay = 3;
        Thread thread;

        AutoSnap(Button button, long millis) {
            this.button = button;
            this.originalLabel = button.getLabel();
            this.delay = (int)(millis / 1000L);
        }

        synchronized void startThread() {
            this.stopThread();
            this.thread = new Thread(){

                @Override
                public void run() {
                    AutoSnap.this.delayedSnap();
                    AutoSnap.this.button.setLabel(AutoSnap.this.originalLabel);
                }
            };
            this.thread.start();
        }

        protected void delayedSnap() {
            for (int i = this.delay; i >= 0; --i) {
                if (!Wiki_Editor.this.sleep(1000L)) {
                    return;
                }
                this.button.setLabel(this.delay == 1 ? "..." : "Snap in " + i + " secs");
            }
            Wiki_Editor.this.snapshot();
        }

        synchronized void stopThread() {
            if (this.thread == null) {
                return;
            }
            this.button.setLabel(this.originalLabel);
            this.thread.interrupt();
            this.thread = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.startThread();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.stopThread();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.stopThread();
            this.delayedSnap();
        }
    }

    protected static enum Format {
        JPEG(".jpg"),
        PNG(".png");

        private String extension;

        private Format(String extension) {
            this.extension = extension;
        }

        public void write(ImagePlus imp, String fullFilename) {
            switch (this) {
                case JPEG: {
                    JpegWriter.save((ImagePlus)imp, (String)fullFilename, (int)75);
                    imp.changes = false;
                    break;
                }
                case PNG: {
                    PNG_Writer pngWriter = new PNG_Writer();
                    try {
                        pngWriter.writeImage(imp, fullFilename, -1);
                        imp.changes = false;
                    }
                    catch (Exception e) {
                        IJ.error((String)("PNG_Writer.writeImage failed to write to " + fullFilename));
                    }
                    break;
                }
                default: {
                    IJ.error((String)("[BUG] Unknown image format: " + this.name()));
                }
            }
        }

        public static Format byExtension(String extension) {
            String ext = extension;
            int dot = ext.lastIndexOf(46);
            if (dot < 0) {
                return null;
            }
            ext = ext.substring(dot);
            for (Format format : Format.values()) {
                if (!ext.equals(format.extension)) continue;
                return format;
            }
            return null;
        }
    }

    protected static enum Mode {
        TUTORIAL_MAKER,
        NEWS,
        SCREENSHOT;

    }
}

