/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.search;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpListing;
import net.imagej.ops.OpListingInfo;
import net.imagej.ops.OpService;
import org.scijava.Context;
import org.scijava.cache.CacheService;
import org.scijava.module.ModuleInfo;
import org.scijava.search.SearchResult;
import org.scijava.search.module.ModuleSearcher;

public class OpSearchResult
implements SearchResult {
    private final OpListingInfo info;
    private final String shortSig;
    private final Map<String, String> props;

    public OpSearchResult(Context context, OpInfo info, String baseDir) {
        this(context, new OpListing(info));
        Object[] aliases = info.getAliases();
        if (aliases != null && aliases.length > 0) {
            this.props.put("Aliases", Arrays.toString(aliases));
        }
        this.props.put("Identifier", info.cInfo().getIdentifier());
        this.props.put("Location", ModuleSearcher.location((ModuleInfo)info.cInfo(), (String)baseDir));
    }

    public OpSearchResult(Context context, OpListing signature) {
        CacheService cacheService = (CacheService)context.getService(CacheService.class);
        this.info = new OpListingInfo((OpService)context.getService(OpService.class), signature);
        ShortSigKey shortSigKey = new ShortSigKey(this.info);
        Object shortSigValue = cacheService.get((Object)shortSigKey);
        if (shortSigValue == null) {
            this.shortSig = signature.toString();
            cacheService.put((Object)shortSigKey, (Object)this.shortSig);
        } else {
            this.shortSig = (String)shortSigValue;
        }
        this.props = new LinkedHashMap<String, String>();
        this.props.put("Signature", this.info.toString());
        String opType = this.info.getDelegateClassName();
        this.props.put("Op type", opType.startsWith("net.imagej.ops.Ops$") ? opType.substring(15).replace('$', '.') : opType);
    }

    public OpListingInfo info() {
        return this.info;
    }

    public String name() {
        return this.shortSig;
    }

    public String identifier() {
        return this.shortSig;
    }

    public String iconPath() {
        return ModuleSearcher.iconPath((ModuleInfo)this.info);
    }

    public Map<String, String> properties() {
        return this.props;
    }

    private static class ShortSigKey {
        private final OpListingInfo opInfo;

        public ShortSigKey(OpListingInfo info) {
            this.opInfo = info;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ShortSigKey)) {
                return false;
            }
            ShortSigKey that = (ShortSigKey)o;
            return this.opInfo == that.opInfo;
        }

        public int hashCode() {
            return this.opInfo.hashCode();
        }
    }
}

