/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.BSplineModel;
import bunwarpj.Mask;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;

public class MiscTools {
    public static void applyTransformationToSource(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, int intervals, double[][] cx, double[][] cy) {
        int targetHeight = targetImp.getProcessor().getHeight();
        int targetWidth = targetImp.getProcessor().getWidth();
        int sourceHeight = sourceImp.getProcessor().getHeight();
        int sourceWidth = sourceImp.getProcessor().getWidth();
        double[][] transformation_x = new double[targetHeight][targetWidth];
        double[][] transformation_y = new double[targetHeight][targetWidth];
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        boolean ORIGINAL = false;
        for (int v = 0; v < targetHeight; ++v) {
            double tv = (double)(v * intervals) / (double)(targetHeight - 1) + 1.0;
            for (int u = 0; u < targetWidth; ++u) {
                double tu = (double)(u * intervals) / (double)(targetWidth - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, ORIGINAL);
                transformation_x[v][u] = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, ORIGINAL);
                transformation_y[v][u] = swy.interpolateI();
            }
        }
        if (!(sourceImp.getProcessor() instanceof ColorProcessor)) {
            source.startPyramids();
            try {
                source.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            FloatProcessor fp = new FloatProcessor(targetWidth, targetHeight);
            for (int v = 0; v < targetHeight; ++v) {
                for (int u = 0; u < targetWidth; ++u) {
                    double x = transformation_x[v][u];
                    double y = transformation_y[v][u];
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        source.prepareForInterpolation(x, y, ORIGINAL);
                        fp.setf(u, v, (float)source.interpolateI());
                        continue;
                    }
                    fp.setf(u, v, 0.0f);
                }
            }
            fp.resetMinAndMax();
            sourceImp.setProcessor(sourceImp.getTitle(), (ImageProcessor)fp);
            sourceImp.updateImage();
        } else {
            BSplineModel sourceR = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(0, null), false, 1);
            sourceR.setPyramidDepth(0);
            sourceR.startPyramids();
            BSplineModel sourceG = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(1, null), false, 1);
            sourceG.setPyramidDepth(0);
            sourceG.startPyramids();
            BSplineModel sourceB = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(2, null), false, 1);
            sourceB.setPyramidDepth(0);
            sourceB.startPyramids();
            try {
                sourceR.getThread().join();
                sourceG.getThread().join();
                sourceB.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            ColorProcessor cp = new ColorProcessor(targetWidth, targetHeight);
            FloatProcessor fpR = new FloatProcessor(targetWidth, targetHeight);
            FloatProcessor fpG = new FloatProcessor(targetWidth, targetHeight);
            FloatProcessor fpB = new FloatProcessor(targetWidth, targetHeight);
            for (int v = 0; v < targetHeight; ++v) {
                for (int u = 0; u < targetWidth; ++u) {
                    double x = transformation_x[v][u];
                    double y = transformation_y[v][u];
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        sourceR.prepareForInterpolation(x, y, ORIGINAL);
                        fpR.setf(u, v, (float)sourceR.interpolateI());
                        sourceG.prepareForInterpolation(x, y, ORIGINAL);
                        fpG.setf(u, v, (float)sourceG.interpolateI());
                        sourceB.prepareForInterpolation(x, y, ORIGINAL);
                        fpB.setf(u, v, (float)sourceB.interpolateI());
                        continue;
                    }
                    fpR.setf(u, v, 0.0f);
                    fpG.setf(u, v, 0.0f);
                    fpB.setf(u, v, 0.0f);
                }
            }
            cp.setPixels(0, fpR);
            cp.setPixels(1, fpG);
            cp.setPixels(2, fpB);
            cp.resetMinAndMax();
            sourceImp.setProcessor(sourceImp.getTitle(), (ImageProcessor)cp);
            sourceImp.updateImage();
        }
    }

    public static void applyTransformationToSource(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel sourceR, BSplineModel sourceG, BSplineModel sourceB, int intervals, double[][] cx, double[][] cy) {
        int targetHeight = targetImp.getProcessor().getHeight();
        int targetWidth = targetImp.getProcessor().getWidth();
        int sourceHeight = sourceImp.getProcessor().getHeight();
        int sourceWidth = sourceImp.getProcessor().getWidth();
        double[][] transformation_x = new double[targetHeight][targetWidth];
        double[][] transformation_y = new double[targetHeight][targetWidth];
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        boolean ORIGINAL = false;
        for (int v = 0; v < targetHeight; ++v) {
            double tv = (double)(v * intervals) / (double)(targetHeight - 1) + 1.0;
            for (int u = 0; u < targetWidth; ++u) {
                double tu = (double)(u * intervals) / (double)(targetWidth - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, ORIGINAL);
                transformation_x[v][u] = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, ORIGINAL);
                transformation_y[v][u] = swy.interpolateI();
            }
        }
        ColorProcessor cp = new ColorProcessor(targetWidth, targetHeight);
        FloatProcessor fpR = new FloatProcessor(targetWidth, targetHeight);
        FloatProcessor fpG = new FloatProcessor(targetWidth, targetHeight);
        FloatProcessor fpB = new FloatProcessor(targetWidth, targetHeight);
        for (int v = 0; v < targetHeight; ++v) {
            for (int u = 0; u < targetWidth; ++u) {
                double x = transformation_x[v][u];
                double y = transformation_y[v][u];
                if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                    sourceR.prepareForInterpolation(x, y, ORIGINAL);
                    fpR.setf(u, v, (float)sourceR.interpolateI());
                    sourceG.prepareForInterpolation(x, y, ORIGINAL);
                    fpG.setf(u, v, (float)sourceG.interpolateI());
                    sourceB.prepareForInterpolation(x, y, ORIGINAL);
                    fpB.setf(u, v, (float)sourceB.interpolateI());
                    continue;
                }
                fpR.setf(u, v, 0.0f);
                fpG.setf(u, v, 0.0f);
                fpB.setf(u, v, 0.0f);
            }
        }
        cp.setPixels(0, fpR);
        cp.setPixels(1, fpG);
        cp.setPixels(2, fpB);
        cp.resetMinAndMax();
        sourceImp.setProcessor(sourceImp.getTitle(), (ImageProcessor)cp);
        sourceImp.updateImage();
    }

    public static void applyRawTransformationToSource(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, double[][] transformation_x, double[][] transformation_y) {
        int targetHeight = targetImp.getProcessor().getHeight();
        int targetWidth = targetImp.getProcessor().getWidth();
        int sourceHeight = sourceImp.getProcessor().getHeight();
        int sourceWidth = sourceImp.getProcessor().getWidth();
        boolean ORIGINAL = false;
        if (!(sourceImp.getProcessor() instanceof ColorProcessor)) {
            source.startPyramids();
            try {
                source.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            FloatProcessor fp = new FloatProcessor(targetWidth, targetHeight);
            for (int v = 0; v < targetHeight; ++v) {
                for (int u = 0; u < targetWidth; ++u) {
                    double x = transformation_x[v][u];
                    double y = transformation_y[v][u];
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        source.prepareForInterpolation(x, y, ORIGINAL);
                        fp.setf(u, v, (float)source.interpolateI());
                        continue;
                    }
                    fp.setf(u, v, 0.0f);
                }
            }
            fp.resetMinAndMax();
            sourceImp.setProcessor(sourceImp.getTitle(), (ImageProcessor)fp);
            sourceImp.updateImage();
        } else {
            BSplineModel sourceR = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(0, null), false, 1);
            sourceR.setPyramidDepth(0);
            sourceR.startPyramids();
            BSplineModel sourceG = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(1, null), false, 1);
            sourceG.setPyramidDepth(0);
            sourceG.startPyramids();
            BSplineModel sourceB = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(2, null), false, 1);
            sourceB.setPyramidDepth(0);
            sourceB.startPyramids();
            try {
                sourceR.getThread().join();
                sourceG.getThread().join();
                sourceB.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            ColorProcessor cp = new ColorProcessor(targetWidth, targetHeight);
            FloatProcessor fpR = new FloatProcessor(targetWidth, targetHeight);
            FloatProcessor fpG = new FloatProcessor(targetWidth, targetHeight);
            FloatProcessor fpB = new FloatProcessor(targetWidth, targetHeight);
            for (int v = 0; v < targetHeight; ++v) {
                for (int u = 0; u < targetWidth; ++u) {
                    double x = transformation_x[v][u];
                    double y = transformation_y[v][u];
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        sourceR.prepareForInterpolation(x, y, ORIGINAL);
                        fpR.setf(u, v, (float)sourceR.interpolateI());
                        sourceG.prepareForInterpolation(x, y, ORIGINAL);
                        fpG.setf(u, v, (float)sourceG.interpolateI());
                        sourceB.prepareForInterpolation(x, y, ORIGINAL);
                        fpB.setf(u, v, (float)sourceB.interpolateI());
                        continue;
                    }
                    fpR.setf(u, v, 0.0f);
                    fpG.setf(u, v, 0.0f);
                    fpB.setf(u, v, 0.0f);
                }
            }
            cp.setPixels(0, fpR);
            cp.setPixels(1, fpG);
            cp.setPixels(2, fpB);
            cp.resetMinAndMax();
            sourceImp.setProcessor(sourceImp.getTitle(), (ImageProcessor)cp);
            sourceImp.updateImage();
        }
    }

    public static double[] approximateInverseCoords(double[] movingCoords, ImagePlus fixedImp, double[][] transformation_x, double[][] transformation_y) {
        double[] coords = new double[2];
        double minDistance = Double.MAX_VALUE;
        for (int v = 0; v < fixedImp.getHeight(); ++v) {
            for (int u = 0; u < fixedImp.getWidth(); ++u) {
                double x = transformation_x[v][u];
                double xdiff = x - movingCoords[0];
                double y = transformation_y[v][u];
                double ydiff = y - movingCoords[1];
                double dist = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                coords[0] = u;
                coords[1] = v;
            }
        }
        return coords;
    }

    public static double oppositeWarpingIndex(String directTransfPath, String inverseTransfPath, ImagePlus targetImp, ImagePlus sourceImp) {
        int intervals = MiscTools.numberOfIntervalsOfTransformation(directTransfPath);
        double[][] cx_direct = new double[intervals + 3][intervals + 3];
        double[][] cy_direct = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(directTransfPath, cx_direct, cy_direct);
        intervals = MiscTools.numberOfIntervalsOfTransformation(inverseTransfPath);
        double[][] cx_inverse = new double[intervals + 3][intervals + 3];
        double[][] cy_inverse = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(inverseTransfPath, cx_inverse, cy_inverse);
        return MiscTools.warpingIndex(sourceImp, targetImp, intervals, cx_direct, cy_direct, cx_inverse, cy_inverse);
    }

    public static double warpingIndex(ImagePlus sourceImp, ImagePlus targetImp, int intervals, double[][] cx_direct, double[][] cy_direct, double[][] cx_inverse, double[][] cy_inverse) {
        double tu;
        int u;
        double tv;
        int v;
        int cYdim;
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        int sourceCurrentHeight = sourceImp.getProcessor().getHeight();
        int sourceCurrentWidth = sourceImp.getProcessor().getWidth();
        double[][] transformation_x_direct = new double[targetCurrentHeight][targetCurrentWidth];
        double[][] transformation_y_direct = new double[targetCurrentHeight][targetCurrentWidth];
        double[][] transformation_x_inverse = new double[sourceCurrentHeight][sourceCurrentWidth];
        double[][] transformation_y_inverse = new double[sourceCurrentHeight][sourceCurrentWidth];
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] c_direct = new double[twiceNk];
        int n = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c_direct[n] = cx_direct[i][j];
                c_direct[n + Nk] = cy_direct[i][j];
                ++j;
                ++n;
            }
        }
        BSplineModel swx_direct = new BSplineModel(c_direct, cYdim, cXdim, 0);
        BSplineModel swy_direct = new BSplineModel(c_direct, cYdim, cXdim, Nk);
        double[] c_inverse = new double[twiceNk];
        int n2 = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c_inverse[n2] = cx_inverse[i][j];
                c_inverse[n2 + Nk] = cy_inverse[i][j];
                ++j;
                ++n2;
            }
        }
        BSplineModel swx_inverse = new BSplineModel(c_inverse, cYdim, cXdim, 0);
        BSplineModel swy_inverse = new BSplineModel(c_inverse, cYdim, cXdim, Nk);
        for (v = 0; v < targetCurrentHeight; ++v) {
            tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (u = 0; u < targetCurrentWidth; ++u) {
                tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx_direct.prepareForInterpolation(tu, tv, false);
                transformation_x_direct[v][u] = swx_direct.interpolateI();
                swy_direct.prepareForInterpolation(tu, tv, false);
                transformation_y_direct[v][u] = swy_direct.interpolateI();
            }
        }
        for (v = 0; v < sourceCurrentHeight; ++v) {
            tv = (double)(v * intervals) / (double)(sourceCurrentHeight - 1) + 1.0;
            for (u = 0; u < sourceCurrentWidth; ++u) {
                tu = (double)(u * intervals) / (double)(sourceCurrentWidth - 1) + 1.0;
                swx_inverse.prepareForInterpolation(tu, tv, false);
                transformation_x_inverse[v][u] = swx_inverse.interpolateI();
                swy_inverse.prepareForInterpolation(tu, tv, false);
                transformation_y_inverse[v][u] = swy_inverse.interpolateI();
            }
        }
        double warpingIndex = 0.0;
        int n3 = 0;
        for (int v2 = 0; v2 < targetCurrentHeight; ++v2) {
            for (int u2 = 0; u2 < targetCurrentWidth; ++u2) {
                int x = (int)Math.round(transformation_x_direct[v2][u2]);
                int y = (int)Math.round(transformation_y_direct[v2][u2]);
                if (x < 0 || x >= sourceCurrentWidth || y < 0 || y >= sourceCurrentHeight) continue;
                double x2 = transformation_x_inverse[y][x];
                double y2 = transformation_y_inverse[y][x];
                double aux1 = (double)u2 - x2;
                double aux2 = (double)v2 - y2;
                warpingIndex += aux1 * aux1 + aux2 * aux2;
                ++n3;
            }
        }
        if (n3 != 0) {
            warpingIndex /= (double)n3;
            warpingIndex = Math.sqrt(warpingIndex);
        } else {
            warpingIndex = -1.0;
        }
        return warpingIndex;
    }

    public static void saveElasticAsRaw(String elasticTransfPath, String rawTransfPath, ImagePlus targetImp) {
        int intervals = MiscTools.numberOfIntervalsOfTransformation(elasticTransfPath);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(elasticTransfPath, cx, cy);
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.convertElasticTransformationToRaw(targetImp, intervals, cx, cy, transformation_x, transformation_y);
        MiscTools.saveRawTransformation(rawTransfPath, targetImp.getWidth(), targetImp.getHeight(), transformation_x, transformation_y);
    }

    public static void saveRawAsElastic(String rawTransfPath, String elasticTransfPath, int intervals, ImagePlus targetImp) {
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(rawTransfPath, transformation_x, transformation_y);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.convertRawTransformationToBSpline(targetImp, intervals, transformation_x, transformation_y, cx, cy);
        MiscTools.saveElasticTransformation(intervals, cx, cy, elasticTransfPath);
    }

    public static void convertElasticTransformationToRaw(ImagePlus targetImp, int intervals, double[][] cx, double[][] cy, double[][] transformation_x, double[][] transformation_y) {
        int cYdim;
        if (cx == null || cy == null || transformation_x == null || transformation_y == null) {
            IJ.error((String)"Error in transformations parameters!");
            return;
        }
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] c = new double[twiceNk];
        int n = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c[n] = cx[i][j];
                c[n + Nk] = cy[i][j];
                ++j;
                ++n;
            }
        }
        BSplineModel swx = new BSplineModel(c, cYdim, cXdim, 0);
        BSplineModel swy = new BSplineModel(c, cYdim, cXdim, Nk);
        swx.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        for (int v = 0; v < targetCurrentHeight; ++v) {
            double tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (int u = 0; u < targetCurrentWidth; ++u) {
                double tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx.prepareForInterpolation(tu, tv, false);
                transformation_x[v][u] = swx.interpolateI();
                swy.prepareForInterpolation(tu, tv, false);
                transformation_y[v][u] = swy.interpolateI();
            }
        }
    }

    public static void convertRawTransformationToBSpline(ImagePlus targetImp, int intervals, double[][] transformation_x, double[][] transformation_y, double[][] cx, double[][] cy) {
        int i;
        if (cx == null || cy == null || transformation_x == null || transformation_y == null) {
            IJ.error((String)"Error in transformations parameters!");
            return;
        }
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        for (i = 0; i < intervals + 3; ++i) {
            double v = (double)((i - 1) * (targetCurrentHeight - 1)) / (double)intervals;
            for (int j = 0; j < intervals + 3; ++j) {
                double u = (double)((j - 1) * (targetCurrentWidth - 1)) / (double)intervals;
                if (!(v >= 0.0) || !(v < (double)targetCurrentHeight) || !(u < (double)targetCurrentWidth) || !(u >= 0.0)) continue;
                int tv = (int)v;
                int tu = (int)u;
                cx[i][j] = transformation_x[tv][tu];
                cy[i][j] = transformation_y[tv][tu];
            }
        }
        for (i = 0; i < intervals + 3; ++i) {
            for (int j = 0; j < intervals + 3; ++j) {
                int iFrom = i;
                int jFrom = j;
                int iPivot = -1;
                int jPivot = -1;
                if (iFrom < 1) {
                    iFrom = 2 - i;
                    iPivot = 1;
                    jPivot = j;
                } else if (iFrom > intervals + 1) {
                    iFrom = 2 * (intervals + 1) - i;
                    iPivot = intervals + 1;
                    jPivot = j;
                }
                if (jFrom < 1) {
                    jFrom = 2 - j;
                    jPivot = 1;
                    iPivot = iPivot != -1 ? iPivot : i;
                } else if (jFrom > intervals + 1) {
                    jFrom = 2 * (intervals + 1) - j;
                    jPivot = intervals + 1;
                    int n = iPivot = iPivot != -1 ? iPivot : i;
                }
                if (iPivot == -1 || jPivot == -1) continue;
                cx[i][j] = 2.0 * cx[iPivot][jPivot] - cx[iFrom][jFrom];
                cy[i][j] = 2.0 * cy[iPivot][jPivot] - cy[iFrom][jFrom];
            }
        }
    }

    public static void invertRawTransformation(ImagePlus targetImp, double[][] transformation_x, double[][] transformation_y, double[][] inv_x, double[][] inv_y) {
        int j;
        int i;
        if (inv_x == null || inv_y == null || transformation_x == null || transformation_y == null) {
            IJ.error((String)"Error in transformations parameters!");
            return;
        }
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        for (i = 0; i < targetCurrentHeight; ++i) {
            for (j = 0; j < targetCurrentWidth; ++j) {
                int originX = (int)Math.round(transformation_x[i][j]);
                int originY = (int)Math.round(transformation_y[i][j]);
                if (originX < 0 || originX >= targetCurrentWidth || originY < 0 || originY >= targetCurrentHeight) continue;
                inv_x[originY][originX] = j;
                inv_y[originY][originX] = i;
            }
        }
        for (i = 0; i < targetCurrentHeight; ++i) {
            for (j = 0; j < targetCurrentWidth; ++j) {
                if (inv_x[i][j] != 0.0 || inv_y[i][j] != 0.0) continue;
                double val_x = 0.0;
                double val_y = 0.0;
                int n = 0;
                if (i > 0) {
                    if (inv_x[i - 1][j] != 0.0 && inv_y[i - 1][j] != 0.0) {
                        val_x += inv_x[i - 1][j];
                        val_y += inv_y[i - 1][j];
                        ++n;
                    }
                    if (j > 0 && inv_x[i - 1][j - 1] != 0.0 && inv_y[i - 1][j - 1] != 0.0) {
                        val_x += inv_x[i - 1][j - 1];
                        val_y += inv_y[i - 1][j - 1];
                        ++n;
                    }
                    if (j < targetCurrentWidth - 1 && inv_x[i - 1][j + 1] != 0.0 && inv_y[i - 1][j + 1] != 0.0) {
                        val_x += inv_x[i - 1][j + 1];
                        val_y += inv_y[i - 1][j + 1];
                        ++n;
                    }
                }
                if (i < targetCurrentHeight - 1) {
                    if (inv_x[i + 1][j] != 0.0 && inv_y[i + 1][j] != 0.0) {
                        val_x += inv_x[i + 1][j];
                        val_y += inv_y[i + 1][j];
                        ++n;
                    }
                    if (j > 0 && inv_x[i + 1][j - 1] != 0.0 && inv_y[i + 1][j - 1] != 0.0) {
                        val_x += inv_x[i + 1][j - 1];
                        val_y += inv_y[i + 1][j - 1];
                        ++n;
                    }
                    if (j < targetCurrentWidth - 1 && inv_x[i + 1][j + 1] != 0.0 && inv_y[i + 1][j + 1] != 0.0) {
                        val_x += inv_x[i + 1][j + 1];
                        val_y += inv_y[i + 1][j + 1];
                        ++n;
                    }
                }
                if (j > 0 && inv_x[i][j - 1] != 0.0 && inv_y[i][j - 1] != 0.0) {
                    val_x += inv_x[i][j - 1];
                    val_y += inv_y[i][j - 1];
                    ++n;
                }
                if (j < targetCurrentWidth - 1 && inv_x[i][j + 1] != 0.0 && inv_y[i][j + 1] != 0.0) {
                    val_x += inv_x[i][j + 1];
                    val_y += inv_y[i][j + 1];
                    ++n;
                }
                if (n == 0) continue;
                double[] dArray = inv_x[i];
                int n2 = j;
                dArray[n2] = dArray[n2] + val_x / (double)n;
                double[] dArray2 = inv_y[i];
                int n3 = j;
                dArray2[n3] = dArray2[n3] + val_y / (double)n;
            }
        }
    }

    public static void invertRawTransformation(String inputTransfPath, String outputTransfPath, ImagePlus targetImp) {
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(inputTransfPath, transformation_x, transformation_y);
        double[][] inv_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] inv_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.invertRawTransformation(targetImp, transformation_x, transformation_y, inv_x, inv_y);
        MiscTools.saveRawTransformation(outputTransfPath, targetImp.getWidth(), targetImp.getHeight(), inv_x, inv_y);
    }

    public static double rawWarpingIndex(ImagePlus sourceImp, ImagePlus targetImp, int intervals, double[][] cx_direct, double[][] cy_direct, double[][] transformation_x, double[][] transformation_y) {
        int cYdim;
        if (cx_direct == null || cy_direct == null || transformation_x == null || transformation_y == null) {
            IJ.error((String)"Error in the raw warping index parameters!");
            return -1.0;
        }
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        int sourceCurrentHeight = sourceImp.getProcessor().getHeight();
        int sourceCurrentWidth = sourceImp.getProcessor().getWidth();
        double[][] transformation_x_direct = new double[targetCurrentHeight][targetCurrentWidth];
        double[][] transformation_y_direct = new double[targetCurrentHeight][targetCurrentWidth];
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] c_direct = new double[twiceNk];
        int n = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c_direct[n] = cx_direct[i][j];
                c_direct[n + Nk] = cy_direct[i][j];
                ++j;
                ++n;
            }
        }
        BSplineModel swx_direct = new BSplineModel(c_direct, cYdim, cXdim, 0);
        BSplineModel swy_direct = new BSplineModel(c_direct, cYdim, cXdim, Nk);
        swx_direct.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy_direct.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        for (int v = 0; v < targetCurrentHeight; ++v) {
            double tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (int u = 0; u < targetCurrentWidth; ++u) {
                double tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx_direct.prepareForInterpolation(tu, tv, false);
                transformation_x_direct[v][u] = swx_direct.interpolateI();
                swy_direct.prepareForInterpolation(tu, tv, false);
                transformation_y_direct[v][u] = swy_direct.interpolateI();
            }
        }
        double warpingIndex = 0.0;
        int n2 = 0;
        for (int v = 0; v < targetCurrentHeight; ++v) {
            for (int u = 0; u < targetCurrentWidth; ++u) {
                double x_elastic = transformation_x_direct[v][u];
                double y_elastic = transformation_y_direct[v][u];
                if (!(x_elastic >= 0.0) || !(x_elastic < (double)sourceCurrentWidth) || !(y_elastic >= 0.0) || !(y_elastic < (double)sourceCurrentHeight)) continue;
                double x_random = transformation_x[v][u];
                double y_random = transformation_y[v][u];
                double aux1 = x_elastic - x_random;
                double aux2 = y_elastic - y_random;
                warpingIndex += aux1 * aux1 + aux2 * aux2;
                ++n2;
            }
        }
        if (n2 != 0) {
            warpingIndex /= (double)n2;
            warpingIndex = Math.sqrt(warpingIndex);
        } else {
            warpingIndex = -1.0;
        }
        return warpingIndex;
    }

    public static double rawWarpingIndex(ImagePlus sourceImp, ImagePlus targetImp, double[][] transformation_x_1, double[][] transformation_y_1, double[][] transformation_x_2, double[][] transformation_y_2) {
        if (transformation_x_1 == null || transformation_y_1 == null || transformation_x_2 == null || transformation_y_2 == null) {
            IJ.error((String)"Error in the raw warping index parameters!");
            return -1.0;
        }
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        int sourceCurrentHeight = sourceImp.getProcessor().getHeight();
        int sourceCurrentWidth = sourceImp.getProcessor().getWidth();
        double warpingIndex = 0.0;
        int n = 0;
        for (int v = 0; v < targetCurrentHeight; ++v) {
            for (int u = 0; u < targetCurrentWidth; ++u) {
                double x1 = transformation_x_1[v][u];
                double y1 = transformation_y_1[v][u];
                if (!(x1 >= 0.0) || !(x1 < (double)sourceCurrentWidth) || !(y1 >= 0.0) || !(y1 < (double)sourceCurrentHeight)) continue;
                double x2 = transformation_x_2[v][u];
                double y2 = transformation_y_2[v][u];
                double aux1 = x1 - x2;
                double aux2 = y1 - y2;
                warpingIndex += aux1 * aux1 + aux2 * aux2;
                ++n;
            }
        }
        if (n != 0) {
            warpingIndex /= (double)n;
            warpingIndex = Math.sqrt(warpingIndex);
        } else {
            warpingIndex = -1.0;
        }
        return warpingIndex;
    }

    public static void drawArrow(double[][] canvas, int x1, int y1, int x2, int y2, double color, int arrow_size) {
        MiscTools.drawLine(canvas, x1, y1, x2, y2, color);
        int arrow_size2 = 2 * arrow_size;
        if ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) < arrow_size * arrow_size) {
            return;
        }
        if (x2 == x1) {
            if (y2 > y1) {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size, y2 - arrow_size2, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size, y2 - arrow_size2, color);
            } else {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size, y2 + arrow_size2, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size, y2 + arrow_size2, color);
            }
        } else if (y2 == y1) {
            if (x2 > x1) {
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size2, y2 - arrow_size, color);
                MiscTools.drawLine(canvas, x2, y2, x2 - arrow_size2, y2 + arrow_size, color);
            } else {
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size2, y2 - arrow_size, color);
                MiscTools.drawLine(canvas, x2, y2, x2 + arrow_size2, y2 + arrow_size, color);
            }
        } else {
            double t1 = Math.abs(new Integer(y2 - y1).doubleValue());
            double t2 = Math.abs(new Integer(x2 - x1).doubleValue());
            double theta = Math.atan(t1 / t2);
            if (x2 < x1) {
                theta = y2 < y1 ? Math.PI + theta : -(Math.PI + theta);
            } else if (x2 > x1 && y2 < y1) {
                theta = Math.PI * 2 - theta;
            }
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            Point p2 = new Point(-arrow_size2, -arrow_size);
            Point p3 = new Point(-arrow_size2, arrow_size);
            int x = new Long(Math.round(cosTheta * (double)p2.x - sinTheta * (double)p2.y)).intValue();
            p2.y = new Long(Math.round(sinTheta * (double)p2.x + cosTheta * (double)p2.y)).intValue();
            p2.x = x;
            x = new Long(Math.round(cosTheta * (double)p3.x - sinTheta * (double)p3.y)).intValue();
            p3.y = new Long(Math.round(sinTheta * (double)p3.x + cosTheta * (double)p3.y)).intValue();
            p3.x = x;
            p2.translate(x2, y2);
            p3.translate(x2, y2);
            MiscTools.drawLine(canvas, x2, y2, p2.x, p2.y, color);
            MiscTools.drawLine(canvas, x2, y2, p3.x, p3.y, color);
        }
    }

    public static void drawLine(double[][] canvas, int x1, int y1, int x2, int y2, double color) {
        int temp;
        int dy_neg = 1;
        int dx_neg = 1;
        boolean switch_x_y = false;
        boolean neg_slope = false;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y1 > y2) {
                for (int n = y2; n <= y1; ++n) {
                    MiscTools.Point(canvas, n, x1, color);
                }
                return;
            }
            for (int n = y1; n <= y2; ++n) {
                MiscTools.Point(canvas, n, x1, color);
            }
            return;
        }
        int dy = y2 - y1;
        if (dy == 0) {
            if (x1 > x2) {
                for (int n = x2; n <= x1; ++n) {
                    MiscTools.Point(canvas, y1, n, color);
                }
                return;
            }
            for (int n = x1; n <= x2; ++n) {
                MiscTools.Point(canvas, y1, n, color);
            }
            return;
        }
        float m = (float)dy / (float)dx;
        if (m > 1.0f || m < -1.0f) {
            temp = x1;
            x1 = y1;
            y1 = temp;
            temp = x2;
            x2 = y2;
            y2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            m = (float)dy / (float)dx;
            switch_x_y = true;
        }
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            m = (float)dy / (float)dx;
        }
        if (m < 0.0f) {
            if (dy < 0) {
                dy_neg = -1;
                dx_neg = 1;
            } else {
                dy_neg = 1;
                dx_neg = -1;
            }
            neg_slope = true;
        }
        int d = 2 * (dy * dy_neg) - dx * dx_neg;
        int incrH = 2 * dy * dy_neg;
        int incrHV = 2 * (dy * dy_neg - dx * dx_neg);
        int x = x1;
        int y = y1;
        int tempx = x;
        int tempy = y;
        if (switch_x_y) {
            temp = x;
            x = y;
            y = temp;
        }
        MiscTools.Point(canvas, y, x, color);
        x = tempx;
        y = tempy;
        while (x < x2) {
            if (d <= 0) {
                d += incrH;
            } else {
                d += incrHV;
                ++x;
                if (neg_slope) {
                    --y;
                }
            }
            tempx = ++x;
            tempy = ++y;
            if (switch_x_y) {
                temp = x;
                x = y;
                y = temp;
            }
            MiscTools.Point(canvas, y, x, color);
            x = tempx;
            y = tempy;
        }
    }

    public static void extractImage(ImageProcessor ip, double[] image) {
        block7: {
            int width;
            int height;
            block9: {
                block8: {
                    int k;
                    block6: {
                        k = 0;
                        height = ip.getHeight();
                        width = ip.getWidth();
                        if (!(ip instanceof ByteProcessor)) break block6;
                        byte[] pixels = (byte[])ip.getPixels();
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                image[k] = pixels[k] & 0xFF;
                                ++x;
                                ++k;
                            }
                        }
                        break block7;
                    }
                    if (!(ip instanceof ShortProcessor)) break block8;
                    short[] pixels = (short[])ip.getPixels();
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            image[k] = pixels[k] < 0 ? (double)pixels[k] + 65536.0 : (double)pixels[k];
                            ++x;
                            ++k;
                        }
                    }
                    break block7;
                }
                if (!(ip instanceof FloatProcessor)) break block9;
                float[] pixels = (float[])ip.getPixels();
                for (int p = 0; p < height * width; ++p) {
                    image[p] = pixels[p];
                }
                break block7;
            }
            if (!(ip instanceof ColorProcessor)) break block7;
            ImageProcessor fp = ip.convertToFloat();
            float[] pixels = (float[])fp.getPixels();
            for (int p = 0; p < height * width; ++p) {
                image[p] = pixels[p];
            }
        }
    }

    public static void extractImage(ImageProcessor ip, double[][] image) {
        block7: {
            int width;
            int height;
            int k;
            block8: {
                block6: {
                    k = 0;
                    height = ip.getHeight();
                    width = ip.getWidth();
                    if (!(ip instanceof ByteProcessor)) break block6;
                    byte[] pixels = (byte[])ip.getPixels();
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            image[y][x] = pixels[k] & 0xFF;
                            ++x;
                            ++k;
                        }
                    }
                    break block7;
                }
                if (!(ip instanceof ShortProcessor)) break block8;
                short[] pixels = (short[])ip.getPixels();
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        image[y][x] = pixels[k] < 0 ? (double)pixels[k] + 65536.0 : (double)pixels[k];
                        ++x;
                        ++k;
                    }
                }
                break block7;
            }
            if (!(ip instanceof FloatProcessor)) break block7;
            float[] pixels = (float[])ip.getPixels();
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    image[y][x] = pixels[k];
                    ++x;
                    ++k;
                }
            }
        }
    }

    public static void loadPoints(String filename, Stack<Point> sourceStack, Stack<Point> targetStack) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            int k = 1;
            String line = br.readLine();
            if (!line.equals("Index\txSource\tySource\txTarget\tyTarget")) {
                fr.close();
                IJ.log((String)("Line " + k + ": 'Index\txSource\tySource\txTarget\tyTarget'"));
                return;
            }
            ++k;
            while ((line = br.readLine()) != null) {
                int separatorIndex = (line = line.trim()).indexOf(9);
                if (separatorIndex == -1) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + k + ": #Index# <tab> #xSource# <tab> #ySource# <tab> #xTarget# <tab> #yTarget#"));
                    return;
                }
                String index = line.substring(0, separatorIndex);
                index = index.trim();
                line = line.substring(separatorIndex);
                separatorIndex = (line = line.trim()).indexOf(9);
                if (separatorIndex == -1) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + k + ": #Index# <tab> #xSource# <tab> #ySource# <tab> #xTarget# <tab> #yTarget#"));
                    return;
                }
                String xSource = line.substring(0, separatorIndex);
                xSource = xSource.trim();
                line = line.substring(separatorIndex);
                separatorIndex = (line = line.trim()).indexOf(9);
                if (separatorIndex == -1) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + k + ": #Index# <tab> #xSource# <tab> #ySource# <tab> #xTarget# <tab> #yTarget#"));
                    return;
                }
                String ySource = line.substring(0, separatorIndex);
                ySource = ySource.trim();
                line = line.substring(separatorIndex);
                separatorIndex = (line = line.trim()).indexOf(9);
                if (separatorIndex == -1) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + k + ": #Index# <tab> #xSource# <tab> #ySource# <tab> #xTarget# <tab> #yTarget#"));
                    return;
                }
                String xTarget = line.substring(0, separatorIndex);
                xTarget = xTarget.trim();
                String yTarget = line.substring(separatorIndex);
                yTarget = yTarget.trim();
                Point sourcePoint = new Point(Integer.valueOf(xSource), Integer.valueOf(ySource));
                sourceStack.push(sourcePoint);
                Point targetPoint = new Point(Integer.valueOf(xTarget), Integer.valueOf(yTarget));
                targetStack.push(targetPoint);
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }

    public static void loadPointRoiAsLandmarks(ImagePlus sourceImp, ImagePlus targetImp, Stack<Point> sourceStack, Stack<Point> targetStack) {
        Roi roiSource = sourceImp.getRoi();
        Roi roiTarget = targetImp.getRoi();
        if (roiSource instanceof PointRoi && roiTarget instanceof PointRoi) {
            PointRoi prTarget;
            int[] xTarget;
            PointRoi prSource = (PointRoi)roiSource;
            int[] xSource = prSource.getXCoordinates();
            int numOfPoints = xSource.length;
            if (numOfPoints != (xTarget = (prTarget = (PointRoi)roiTarget).getXCoordinates()).length) {
                return;
            }
            int[] ySource = prSource.getYCoordinates();
            int[] yTarget = prTarget.getYCoordinates();
            Rectangle recSource = prSource.getBounds();
            int originXSource = recSource.x;
            int originYSource = recSource.y;
            Rectangle recTarget = prTarget.getBounds();
            int originXTarget = recTarget.x;
            int originYTarget = recTarget.y;
            for (int i = 0; i < numOfPoints; ++i) {
                sourceStack.push(new Point(xSource[i] + originXSource, ySource[i] + originYSource));
                targetStack.push(new Point(xTarget[i] + originXTarget, yTarget[i] + originYTarget));
            }
        }
    }

    public static void loadTransformation(String filename, double[][] cx, double[][] cy) {
        try {
            int j;
            int i;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            int lineN = 1;
            StringTokenizer st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                br.close();
                fr.close();
                IJ.log((String)("Line " + lineN + "+: Cannot read number of intervals"));
                return;
            }
            st.nextToken();
            int intervals = Integer.valueOf(st.nextToken());
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < intervals + 3; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != intervals + 3) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + lineN + ": Cannot read enough coefficients"));
                    return;
                }
                for (j = 0; j < intervals + 3; ++j) {
                    cx[i][j] = Double.valueOf(st.nextToken());
                }
            }
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < intervals + 3; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != intervals + 3) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + lineN + ": Cannot read enough coefficients"));
                    return;
                }
                for (j = 0; j < intervals + 3; ++j) {
                    cy[i][j] = Double.valueOf(st.nextToken());
                }
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }

    public static void loadRawTransformation(String filename, double[][] transformation_x, double[][] transformation_y) {
        try {
            int j;
            int i;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            int lineN = 1;
            StringTokenizer st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                fr.close();
                IJ.log((String)("Line " + lineN + "+: Cannot read transformation width"));
                return;
            }
            st.nextToken();
            int width = Integer.valueOf(st.nextToken());
            line = br.readLine();
            ++lineN;
            st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                fr.close();
                IJ.log((String)("Line " + lineN + "+: Cannot read transformation height"));
                return;
            }
            st.nextToken();
            int height = Integer.valueOf(st.nextToken());
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < height; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != width) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + lineN + ": Cannot read enough coordinates"));
                    return;
                }
                for (j = 0; j < width; ++j) {
                    transformation_x[i][j] = Double.valueOf(st.nextToken());
                }
            }
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < height; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != width) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + lineN + ": Cannot read enough coordinates"));
                    return;
                }
                for (j = 0; j < width; ++j) {
                    transformation_y[i][j] = Double.valueOf(st.nextToken());
                }
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }

    public static void loadRawTransformation(String filename, double[] transformation_x, double[] transformation_y) {
        try {
            int j;
            int i;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            int lineN = 1;
            StringTokenizer st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                fr.close();
                IJ.log((String)("Line " + lineN + "+: Cannot read transformation width"));
                return;
            }
            st.nextToken();
            int width = Integer.valueOf(st.nextToken());
            line = br.readLine();
            ++lineN;
            st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                fr.close();
                IJ.log((String)("Line " + lineN + "+: Cannot read transformation height"));
                return;
            }
            st.nextToken();
            int height = Integer.valueOf(st.nextToken());
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < height; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != width) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + lineN + ": Cannot read enough coordinates"));
                    return;
                }
                for (j = 0; j < width; ++j) {
                    transformation_x[j + i * width] = Double.valueOf(st.nextToken());
                }
            }
            line = br.readLine();
            line = br.readLine();
            lineN += 2;
            for (i = 0; i < height; ++i) {
                line = br.readLine();
                ++lineN;
                st = new StringTokenizer(line);
                if (st.countTokens() != width) {
                    br.close();
                    fr.close();
                    IJ.log((String)("Line " + lineN + ": Cannot read enough coordinates"));
                    return;
                }
                for (j = 0; j < width; ++j) {
                    transformation_y[j + i * width] = Double.valueOf(st.nextToken());
                }
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }

    public static void loadAffineMatrix(String filename, double[][] affineMatrix) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line, " ");
            if (st.countTokens() != 6) {
                fr.close();
                IJ.log((String)"Cannot read affine transformation matrix");
                return;
            }
            affineMatrix[0][0] = Double.valueOf(st.nextToken());
            affineMatrix[0][1] = Double.valueOf(st.nextToken());
            affineMatrix[1][0] = Double.valueOf(st.nextToken());
            affineMatrix[1][1] = Double.valueOf(st.nextToken());
            affineMatrix[0][2] = Double.valueOf(st.nextToken());
            affineMatrix[1][2] = Double.valueOf(st.nextToken());
            fr.close();
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return;
        }
    }

    public static void composeElasticTransformations(ImagePlus targetImp, int intervals, double[][] cx1, double[][] cy1, double[][] cx2, double[][] cy2, double[][] outputTransformation_x, double[][] outputTransformation_y) {
        int cYdim;
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] c1 = new double[twiceNk];
        int n = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c1[n] = cx1[i][j];
                c1[n + Nk] = cy1[i][j];
                ++j;
                ++n;
            }
        }
        BSplineModel swx1 = new BSplineModel(c1, cYdim, cXdim, 0);
        BSplineModel swy1 = new BSplineModel(c1, cYdim, cXdim, Nk);
        double[] c2 = new double[twiceNk];
        int n2 = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c2[n2] = cx2[i][j];
                c2[n2 + Nk] = cy2[i][j];
                ++j;
                ++n2;
            }
        }
        BSplineModel swx2 = new BSplineModel(c2, cYdim, cXdim, 0);
        BSplineModel swy2 = new BSplineModel(c2, cYdim, cXdim, Nk);
        swx1.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy1.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swx2.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy2.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        for (int v = 0; v < targetCurrentHeight; ++v) {
            double tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (int u = 0; u < targetCurrentWidth; ++u) {
                double tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx2.prepareForInterpolation(tu, tv, false);
                double x2 = swx2.interpolateI();
                swy2.prepareForInterpolation(tu, tv, false);
                double y2 = swy2.interpolateI();
                double tv2 = y2 * (double)intervals / (double)(targetCurrentHeight - 1) + 1.0;
                double tu2 = x2 * (double)intervals / (double)(targetCurrentWidth - 1) + 1.0;
                swx1.prepareForInterpolation(tu2, tv2, false);
                outputTransformation_x[v][u] = swx1.interpolateI();
                swy1.prepareForInterpolation(tu2, tv2, false);
                outputTransformation_y[v][u] = swy1.interpolateI();
            }
        }
    }

    public static void composeRawElasticTransformations(ImagePlus targetImp, int intervals, double[][] transformation_x_1, double[][] transformation_y_1, double[][] cx2, double[][] cy2, double[][] outputTransformation_x, double[][] outputTransformation_y) {
        int cYdim;
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] c2 = new double[twiceNk];
        int n = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c2[n] = cx2[i][j];
                c2[n + Nk] = cy2[i][j];
                ++j;
                ++n;
            }
        }
        BSplineModel swx2 = new BSplineModel(c2, cYdim, cXdim, 0);
        BSplineModel swy2 = new BSplineModel(c2, cYdim, cXdim, Nk);
        swx2.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy2.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        for (int v = 0; v < targetCurrentHeight; ++v) {
            double tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (int u = 0; u < targetCurrentWidth; ++u) {
                double tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx2.prepareForInterpolation(tu, tv, false);
                double x2 = swx2.interpolateI();
                swy2.prepareForInterpolation(tu, tv, false);
                double y2 = swy2.interpolateI();
                int xbase = (int)x2;
                int ybase = (int)y2;
                double xFraction = x2 - (double)xbase;
                double yFraction = y2 - (double)ybase;
                if (x2 >= 0.0 && x2 < (double)targetCurrentWidth && y2 >= 0.0 && y2 < (double)targetCurrentHeight) {
                    double lowerLeftX = transformation_x_1[ybase][xbase];
                    double lowerLeftY = transformation_y_1[ybase][xbase];
                    int xp1 = xbase < targetCurrentWidth - 1 ? xbase + 1 : xbase;
                    int yp1 = ybase < targetCurrentHeight - 1 ? ybase + 1 : ybase;
                    double lowerRightX = transformation_x_1[ybase][xp1];
                    double lowerRightY = transformation_y_1[ybase][xp1];
                    double upperRightX = transformation_x_1[yp1][xp1];
                    double upperRightY = transformation_y_1[yp1][xp1];
                    double upperLeftX = transformation_x_1[yp1][xbase];
                    double upperLeftY = transformation_y_1[yp1][xbase];
                    double upperAverageX = upperLeftX + xFraction * (upperRightX - upperLeftX);
                    double upperAverageY = upperLeftY + xFraction * (upperRightY - upperLeftY);
                    double lowerAverageX = lowerLeftX + xFraction * (lowerRightX - lowerLeftX);
                    double lowerAverageY = lowerLeftY + xFraction * (lowerRightY - lowerLeftY);
                    outputTransformation_x[v][u] = lowerAverageX + yFraction * (upperAverageX - lowerAverageX);
                    outputTransformation_y[v][u] = lowerAverageY + yFraction * (upperAverageY - lowerAverageY);
                    continue;
                }
                outputTransformation_x[v][u] = x2;
                outputTransformation_y[v][u] = y2;
            }
        }
    }

    public static void composeElasticTransformationsAtPixelLevel(ImagePlus targetImp, int intervals, double[][] cx1, double[][] cy1, double[][] cx2, double[][] cy2, double[][] outputTransformation_x, double[][] outputTransformation_y) {
        double tu;
        int u;
        double tv;
        int v;
        int cYdim;
        int targetCurrentHeight = targetImp.getProcessor().getHeight();
        int targetCurrentWidth = targetImp.getProcessor().getWidth();
        double[][] transformation_x_1 = new double[targetCurrentHeight][targetCurrentWidth];
        double[][] transformation_y_1 = new double[targetCurrentHeight][targetCurrentWidth];
        double[][] transformation_x_2 = new double[targetCurrentHeight][targetCurrentWidth];
        double[][] transformation_y_2 = new double[targetCurrentHeight][targetCurrentWidth];
        int cXdim = cYdim = intervals + 3;
        int Nk = cYdim * cXdim;
        int twiceNk = 2 * Nk;
        double[] c1 = new double[twiceNk];
        int n = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c1[n] = cx1[i][j];
                c1[n + Nk] = cy1[i][j];
                ++j;
                ++n;
            }
        }
        BSplineModel swx1 = new BSplineModel(c1, cYdim, cXdim, 0);
        BSplineModel swy1 = new BSplineModel(c1, cYdim, cXdim, Nk);
        double[] c2 = new double[twiceNk];
        int n2 = 0;
        for (int i = 0; i < cYdim; ++i) {
            int j = 0;
            while (j < cYdim) {
                c2[n2] = cx2[i][j];
                c2[n2 + Nk] = cy2[i][j];
                ++j;
                ++n2;
            }
        }
        BSplineModel swx2 = new BSplineModel(c2, cYdim, cXdim, 0);
        BSplineModel swy2 = new BSplineModel(c2, cYdim, cXdim, Nk);
        swx1.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy1.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swx2.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        swy2.precomputed_prepareForInterpolation(targetCurrentHeight, targetCurrentWidth, intervals);
        for (v = 0; v < targetCurrentHeight; ++v) {
            tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (u = 0; u < targetCurrentWidth; ++u) {
                tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx1.prepareForInterpolation(tu, tv, false);
                transformation_x_1[v][u] = swx1.interpolateI();
                swy1.prepareForInterpolation(tu, tv, false);
                transformation_y_1[v][u] = swy1.interpolateI();
            }
        }
        for (v = 0; v < targetCurrentHeight; ++v) {
            tv = (double)(v * intervals) / (double)(targetCurrentHeight - 1) + 1.0;
            for (u = 0; u < targetCurrentWidth; ++u) {
                tu = (double)(u * intervals) / (double)(targetCurrentWidth - 1) + 1.0;
                swx2.prepareForInterpolation(tu, tv, false);
                transformation_x_2[v][u] = swx2.interpolateI();
                swy2.prepareForInterpolation(tu, tv, false);
                transformation_y_2[v][u] = swy2.interpolateI();
            }
        }
        MiscTools.composeRawTransformations(targetCurrentWidth, targetCurrentHeight, transformation_x_1, transformation_y_1, transformation_x_2, transformation_y_2, outputTransformation_x, outputTransformation_y);
    }

    public static void composeRawTransforms(String transfPath1, String transfPath2, String outputTransfPath, ImagePlus targetImp) {
        double[][] transformation_x_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(transfPath1, transformation_x_1, transformation_y_1);
        double[][] transformation_x_2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y_2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(transfPath2, transformation_x_2, transformation_y_2);
        double[][] outputTransformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] outputTransformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.composeRawTransformations(targetImp.getWidth(), targetImp.getHeight(), transformation_x_1, transformation_y_1, transformation_x_2, transformation_y_2, outputTransformation_x, outputTransformation_y);
        MiscTools.saveRawTransformation(outputTransfPath, targetImp.getWidth(), targetImp.getHeight(), outputTransformation_x, outputTransformation_y);
    }

    public static void composeElasticTransforms(String elasticTransfPath1, String elasticTransfPath2, String outputRawTransfPath, ImagePlus targetImp) {
        int intervals = MiscTools.numberOfIntervalsOfTransformation(elasticTransfPath1);
        double[][] cx1 = new double[intervals + 3][intervals + 3];
        double[][] cy1 = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(elasticTransfPath1, cx1, cy1);
        intervals = MiscTools.numberOfIntervalsOfTransformation(elasticTransfPath2);
        double[][] cx2 = new double[intervals + 3][intervals + 3];
        double[][] cy2 = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(elasticTransfPath1, cx2, cy2);
        double[][] outputTransformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] outputTransformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.composeElasticTransformations(targetImp, intervals, cx1, cy1, cx2, cy2, outputTransformation_x, outputTransformation_y);
        MiscTools.saveRawTransformation(outputRawTransfPath, targetImp.getWidth(), targetImp.getHeight(), outputTransformation_x, outputTransformation_y);
    }

    public static void composeRawTransformations(int width, int height, double[][] transformation_x_1, double[][] transformation_y_1, double[][] transformation_x_2, double[][] transformation_y_2, double[][] outputTransformation_x, double[][] outputTransformation_y) {
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                double dX = transformation_x_2[i][j];
                double dY = transformation_y_2[i][j];
                int xbase = (int)dX;
                int ybase = (int)dY;
                double xFraction = dX - (double)xbase;
                double yFraction = dY - (double)ybase;
                if (dX >= 0.0 && dX < (double)width && dY >= 0.0 && dY < (double)height) {
                    double lowerLeftX = transformation_x_1[ybase][xbase];
                    double lowerLeftY = transformation_y_1[ybase][xbase];
                    int xp1 = xbase < width - 1 ? xbase + 1 : xbase;
                    int yp1 = ybase < height - 1 ? ybase + 1 : ybase;
                    double lowerRightX = transformation_x_1[ybase][xp1];
                    double lowerRightY = transformation_y_1[ybase][xp1];
                    double upperRightX = transformation_x_1[yp1][xp1];
                    double upperRightY = transformation_y_1[yp1][xp1];
                    double upperLeftX = transformation_x_1[yp1][xbase];
                    double upperLeftY = transformation_y_1[yp1][xbase];
                    double upperAverageX = upperLeftX + xFraction * (upperRightX - upperLeftX);
                    double upperAverageY = upperLeftY + xFraction * (upperRightY - upperLeftY);
                    double lowerAverageX = lowerLeftX + xFraction * (lowerRightX - lowerLeftX);
                    double lowerAverageY = lowerLeftY + xFraction * (lowerRightY - lowerLeftY);
                    outputTransformation_x[i][j] = lowerAverageX + yFraction * (upperAverageX - lowerAverageX);
                    outputTransformation_y[i][j] = lowerAverageY + yFraction * (upperAverageY - lowerAverageY);
                    continue;
                }
                outputTransformation_x[i][j] = dX;
                outputTransformation_y[i][j] = dY;
            }
        }
    }

    public static void saveElasticTransformation(int intervals, double[][] cx, double[][] cy, String filename) {
        try {
            String aux;
            int j;
            int i;
            FileWriter fw = new FileWriter(filename);
            fw.write("Intervals=" + intervals + "\n\n");
            fw.write("X Coeffs -----------------------------------\n");
            for (i = 0; i < intervals + 3; ++i) {
                for (j = 0; j < intervals + 3; ++j) {
                    aux = "" + cx[i][j];
                    while (aux.length() < 21) {
                        aux = " " + aux;
                    }
                    fw.write(aux + " ");
                }
                fw.write("\n");
            }
            fw.write("\n");
            fw.write("Y Coeffs -----------------------------------\n");
            for (i = 0; i < intervals + 3; ++i) {
                for (j = 0; j < intervals + 3; ++j) {
                    aux = "" + cy[i][j];
                    while (aux.length() < 21) {
                        aux = " " + aux;
                    }
                    fw.write(aux + " ");
                }
                fw.write("\n");
            }
            fw.close();
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
        }
        catch (SecurityException e) {
            IJ.error((String)("Security exception" + e));
        }
    }

    public static void saveRawTransformation(String filename, int width, int height, double[][] transformation_x, double[][] transformation_y) {
        if (filename == null || filename.equals("")) {
            String path = "";
            OpenDialog od = new OpenDialog("Save Transformation", "");
            path = od.getDirectory();
            filename = od.getFileName();
            if (path == null || filename == null) {
                return;
            }
            filename = path + filename;
        }
        try {
            String aux;
            int j;
            int i;
            FileWriter fw = new FileWriter(filename);
            fw.write("Width=" + width + "\n");
            fw.write("Height=" + height + "\n\n");
            fw.write("X Trans -----------------------------------\n");
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    aux = "" + transformation_x[i][j];
                    while (aux.length() < 21) {
                        aux = " " + aux;
                    }
                    fw.write(aux + " ");
                }
                fw.write("\n");
            }
            fw.write("\n");
            fw.write("Y Trans -----------------------------------\n");
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    aux = "" + transformation_y[i][j];
                    while (aux.length() < 21) {
                        aux = " " + aux;
                    }
                    fw.write(aux + " ");
                }
                fw.write("\n");
            }
            fw.close();
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
        }
        catch (SecurityException e) {
            IJ.error((String)("Security exception" + e));
        }
    }

    public static int numberOfIntervalsOfTransformation(String filename) {
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            int lineN = 1;
            StringTokenizer st = new StringTokenizer(line, "=");
            if (st.countTokens() != 2) {
                fr.close();
                IJ.log((String)("Line " + lineN + "+: Cannot read number of intervals"));
                return -1;
            }
            st.nextToken();
            int intervals = Integer.valueOf(st.nextToken());
            fr.close();
            return intervals;
        }
        catch (FileNotFoundException e) {
            IJ.error((String)("File not found exception" + e));
            return -1;
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
            return -1;
        }
        catch (NumberFormatException e) {
            IJ.error((String)("Number format exception" + e));
            return -1;
        }
    }

    public static void Point(double[][] canvas, int y, int x, double color) {
        if (y < 0 || y >= canvas.length) {
            return;
        }
        if (x < 0 || x >= canvas[0].length) {
            return;
        }
        canvas[y][x] = color;
    }

    public static void printMatrix(String title, double[][] array) {
        int Ydim = array.length;
        int Xdim = array[0].length;
        System.out.println(title);
        for (int i = 0; i < Ydim; ++i) {
            for (int j = 0; j < Xdim; ++j) {
                System.out.print(array[i][j] + " ");
            }
            System.out.println();
        }
    }

    public static void showImage(String title, double[] array, int Ydim, int Xdim) {
        FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
        int ij = 0;
        for (int i = 0; i < Ydim; ++i) {
            int j = 0;
            while (j < Xdim) {
                fp.setf(j, i, (float)array[ij]);
                ++j;
                ++ij;
            }
        }
        fp.resetMinAndMax();
        ImagePlus ip = new ImagePlus(title, (ImageProcessor)fp);
        ip.updateImage();
        ip.show();
    }

    public static void showImage(String title, double[][] array) {
        int Ydim = array.length;
        int Xdim = array[0].length;
        FloatProcessor fp = new FloatProcessor(Xdim, Ydim);
        for (int i = 0; i < Ydim; ++i) {
            for (int j = 0; j < Xdim; ++j) {
                fp.setf(j, i, (float)array[i][j]);
            }
        }
        fp.resetMinAndMax();
        ImagePlus ip = new ImagePlus(title, (ImageProcessor)fp);
        ip.updateImage();
        ip.show();
    }

    public static void adaptCoefficients(String inputTransfPath, double scaleFactor, String outputTransfPath) {
        int intervals = MiscTools.numberOfIntervalsOfTransformation(inputTransfPath);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(inputTransfPath, cx, cy);
        for (int i = 0; i < intervals + 3; ++i) {
            int j = 0;
            while (j < intervals + 3) {
                double[] dArray = cx[i];
                int n = j;
                dArray[n] = dArray[n] * scaleFactor;
                double[] dArray2 = cy[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] * scaleFactor;
            }
        }
        MiscTools.saveElasticTransformation(intervals, cx, cy, outputTransfPath);
    }

    public static void adaptCoefficients(double xScale, double yScale, int intervals, double[][] cx, double[][] cy) {
        for (int i = 0; i < intervals + 3; ++i) {
            int j = 0;
            while (j < intervals + 3) {
                double[] dArray = cx[i];
                int n = j;
                dArray[n] = dArray[n] * xScale;
                double[] dArray2 = cy[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] * yScale;
            }
        }
    }

    public static void applyTransformationToSourceMT(ImagePlus sourceImp, ImagePlus targetImp, int intervals, double[][] cx, double[][] cy) {
        BSplineModel source = new BSplineModel(sourceImp.getProcessor(), false, 1);
        ImageProcessor result_imp = MiscTools.applyTransformationMT(sourceImp, targetImp, source, intervals, cx, cy);
        sourceImp.setProcessor(sourceImp.getTitle(), result_imp);
        sourceImp.updateImage();
    }

    public static void applyTransformationToSourceMT(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, int intervals, double[][] cx, double[][] cy) {
        ImageProcessor result_imp = MiscTools.applyTransformationMT(sourceImp, targetImp, source, intervals, cx, cy);
        sourceImp.setProcessor(sourceImp.getTitle(), result_imp);
        sourceImp.updateImage();
    }

    public static ImageProcessor applyTransformationMT(ImagePlus sourceImp, ImagePlus targetImp, BSplineModel source, int intervals, double[][] cx, double[][] cy) {
        int i;
        int targetHeight = targetImp.getProcessor().getHeight();
        int targetWidth = targetImp.getProcessor().getWidth();
        BSplineModel swx = new BSplineModel(cx);
        BSplineModel swy = new BSplineModel(cy);
        if (!(sourceImp.getProcessor() instanceof ColorProcessor)) {
            int i2;
            source.startPyramids();
            try {
                source.getThread().join();
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception " + e));
            }
            FloatProcessor fp = new FloatProcessor(targetWidth, targetHeight);
            int nproc = Runtime.getRuntime().availableProcessors();
            int block_height = targetHeight / nproc;
            int nThreads = nproc;
            Thread[] threads = new Thread[nThreads];
            Rectangle[] rects = new Rectangle[nThreads];
            FloatProcessor[] fp_tile = new FloatProcessor[nThreads];
            for (i2 = 0; i2 < nThreads; ++i2) {
                int y_start = i2 * block_height;
                if (nThreads - 1 == i2) {
                    block_height = targetHeight - i2 * block_height;
                }
                rects[i2] = new Rectangle(0, y_start, targetWidth, block_height);
                fp_tile[i2] = new FloatProcessor(rects[i2].width, rects[i2].height);
                threads[i2] = new Thread(new GrayscaleApplyTransformTile(swx, swy, source, targetWidth, targetHeight, intervals, rects[i2], fp_tile[i2]));
                threads[i2].start();
            }
            for (i2 = 0; i2 < nThreads; ++i2) {
                try {
                    threads[i2].join();
                    threads[i2] = null;
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            for (i2 = 0; i2 < nThreads; ++i2) {
                fp.insert((ImageProcessor)fp_tile[i2], rects[i2].x, rects[i2].y);
                fp_tile[i2] = null;
                rects[i2] = null;
            }
            fp.resetMinAndMax();
            return fp;
        }
        BSplineModel sourceR = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(0, null), false, 1);
        sourceR.setPyramidDepth(0);
        sourceR.startPyramids();
        BSplineModel sourceG = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(1, null), false, 1);
        sourceG.setPyramidDepth(0);
        sourceG.startPyramids();
        BSplineModel sourceB = new BSplineModel((ImageProcessor)((ColorProcessor)sourceImp.getProcessor()).toFloat(2, null), false, 1);
        sourceB.setPyramidDepth(0);
        sourceB.startPyramids();
        try {
            sourceR.getThread().join();
            sourceG.getThread().join();
            sourceB.getThread().join();
        }
        catch (InterruptedException e) {
            IJ.error((String)("Unexpected interruption exception " + e));
        }
        ColorProcessor cp = new ColorProcessor(targetWidth, targetHeight);
        FloatProcessor fpR = new FloatProcessor(targetWidth, targetHeight);
        FloatProcessor fpG = new FloatProcessor(targetWidth, targetHeight);
        FloatProcessor fpB = new FloatProcessor(targetWidth, targetHeight);
        int nproc = Runtime.getRuntime().availableProcessors();
        int block_height = targetHeight / nproc;
        int nThreads = nproc;
        Thread[] threads = new Thread[nThreads];
        Rectangle[] rects = new Rectangle[nThreads];
        FloatProcessor[] fpR_tile = new FloatProcessor[nThreads];
        FloatProcessor[] fpG_tile = new FloatProcessor[nThreads];
        FloatProcessor[] fpB_tile = new FloatProcessor[nThreads];
        for (i = 0; i < nThreads; ++i) {
            int y_start = i * block_height;
            if (nThreads - 1 == i) {
                block_height = targetHeight - i * block_height;
            }
            rects[i] = new Rectangle(0, y_start, targetWidth, block_height);
            fpR_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
            fpG_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
            fpB_tile[i] = new FloatProcessor(rects[i].width, rects[i].height);
            threads[i] = new Thread(new ColorApplyTransformTile(swx, swy, sourceR, sourceG, sourceB, targetWidth, targetHeight, intervals, rects[i], fpR_tile[i], fpG_tile[i], fpB_tile[i]));
            threads[i].start();
        }
        for (i = 0; i < nThreads; ++i) {
            try {
                threads[i].join();
                threads[i] = null;
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < nThreads; ++i) {
            fpR.insert((ImageProcessor)fpR_tile[i], rects[i].x, rects[i].y);
            fpG.insert((ImageProcessor)fpG_tile[i], rects[i].x, rects[i].y);
            fpB.insert((ImageProcessor)fpB_tile[i], rects[i].x, rects[i].y);
            fpR_tile[i] = null;
            fpG_tile[i] = null;
            fpB_tile[i] = null;
            rects[i] = null;
        }
        cp.setPixels(0, fpR);
        cp.setPixels(1, fpG);
        cp.setPixels(2, fpB);
        cp.resetMinAndMax();
        return cp;
    }

    public static final void smoothForScale(ImageProcessor source, float scale, float sourceSigma, float targetSigma) {
        if (scale >= 1.0f) {
            return;
        }
        float s = targetSigma / scale;
        float sigma = (float)Math.sqrt(s * s - sourceSigma * sourceSigma);
        new GaussianBlur().blurGaussian(source, (double)sigma, (double)sigma, 0.01);
    }

    public static final ImageProcessor createDownsampled(ImageProcessor source, float scale, float sourceSigma, float targetSigma) {
        int ow = source.getWidth();
        int oh = source.getHeight();
        int w = Math.round((float)ow * scale);
        int h = Math.round((float)oh * scale);
        ImageProcessor temp = source.duplicate();
        if (scale >= 1.0f) {
            return temp;
        }
        MiscTools.smoothForScale(temp, scale, sourceSigma, targetSigma);
        return temp.resize(w, h);
    }

    public static final ImageProcessor scale(ImageProcessor source, float scale) {
        if (scale == 1.0f) {
            return source.duplicate();
        }
        if (scale < 1.0f) {
            return MiscTools.createDownsampled(source, scale, 0.5f, 0.5f);
        }
        source.setInterpolationMethod(1);
        return source.resize(Math.round(scale * (float)source.getWidth()));
    }

    public static ImagePlus applyTransformToStack(String transformationFile, ImagePlus fixedImage, ImagePlus movingStack) {
        int intervals = MiscTools.numberOfIntervalsOfTransformation(transformationFile);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(transformationFile, cx, cy);
        ImageStack outputStack = new ImageStack(movingStack.getWidth(), movingStack.getHeight());
        for (int i = 1; i <= movingStack.getImageStackSize(); ++i) {
            ImageProcessor ip = movingStack.getImageStack().getProcessor(i);
            BSplineModel source = new BSplineModel(ip, false, 1);
            ImagePlus movingImage = new ImagePlus("", ip);
            ImageProcessor result = MiscTools.applyTransformationMT(movingImage, fixedImage, source, intervals, cx, cy);
            outputStack.addSlice("", result);
        }
        return new ImagePlus(movingStack.getTitle() + "-deformed", outputStack);
    }

    public static double imageSimilarity(ImagePlus targetImp, ImagePlus sourceImp, Mask targetMsk, boolean verbose) {
        int x;
        int y;
        int p;
        int x2;
        Object[] pixels;
        int k = 0;
        ImageProcessor sourceIp = sourceImp.getProcessor();
        int sourceHeight = sourceIp.getHeight();
        int sourceWidth = sourceIp.getWidth();
        ImageProcessor targetIp = targetImp.getProcessor();
        int targetHeight = targetIp.getHeight();
        int targetWidth = targetIp.getWidth();
        if (sourceHeight != targetHeight || sourceWidth != targetWidth) {
            IJ.error((String)"Error: source and target dimensions do not match!");
            return -1.0;
        }
        double[] sourceImage = new double[sourceHeight * sourceWidth];
        if (sourceIp instanceof ByteProcessor) {
            pixels = (byte[])sourceIp.getPixels();
            for (int y2 = 0; y2 < sourceHeight; ++y2) {
                x2 = 0;
                while (x2 < sourceWidth) {
                    sourceImage[k] = pixels[k] & 0xFF;
                    ++x2;
                    ++k;
                }
            }
        } else if (sourceIp instanceof ShortProcessor) {
            pixels = (short[])sourceIp.getPixels();
            for (int y3 = 0; y3 < sourceHeight; ++y3) {
                x2 = 0;
                while (x2 < sourceWidth) {
                    sourceImage[k] = pixels[k] < 0 ? (double)pixels[k] + 65536.0 : (double)pixels[k];
                    ++x2;
                    ++k;
                }
            }
        } else if (sourceIp instanceof FloatProcessor) {
            pixels = (float[])sourceIp.getPixels();
            for (int p2 = 0; p2 < sourceHeight * sourceWidth; ++p2) {
                sourceImage[p2] = pixels[p2];
            }
        } else if (sourceIp instanceof ColorProcessor) {
            ImageProcessor fp = sourceIp.convertToFloat();
            float[] pixels2 = (float[])fp.getPixels();
            for (p = 0; p < sourceHeight * sourceWidth; ++p) {
                sourceImage[p] = pixels2[p];
            }
        }
        k = 0;
        double[] targetImage = new double[targetHeight * targetWidth];
        if (targetIp instanceof ByteProcessor) {
            byte[] pixels3 = (byte[])targetIp.getPixels();
            for (y = 0; y < targetHeight; ++y) {
                x = 0;
                while (x < targetWidth) {
                    targetImage[k] = pixels3[k] & 0xFF;
                    ++x;
                    ++k;
                }
            }
        } else if (targetIp instanceof ShortProcessor) {
            short[] pixels4 = (short[])targetIp.getPixels();
            for (y = 0; y < targetHeight; ++y) {
                x = 0;
                while (x < targetWidth) {
                    targetImage[k] = pixels4[k] < 0 ? (double)pixels4[k] + 65536.0 : (double)pixels4[k];
                    ++x;
                    ++k;
                }
            }
        } else if (targetIp instanceof FloatProcessor) {
            float[] pixels5 = (float[])targetIp.getPixels();
            for (p = 0; p < targetHeight * targetWidth; ++p) {
                targetImage[p] = pixels5[p];
            }
        } else if (targetIp instanceof ColorProcessor) {
            ImageProcessor fp = targetIp.convertToFloat();
            float[] pixels6 = (float[])fp.getPixels();
            for (int p3 = 0; p3 < targetHeight * targetWidth; ++p3) {
                targetImage[p3] = pixels6[p3];
            }
        }
        double imageSimilarity = 0.0;
        int n = 0;
        for (int v = 0; v < targetImp.getHeight(); ++v) {
            for (int u = 0; u < targetImp.getWidth(); ++u) {
                if (null != targetMsk && !targetMsk.getValue(u, v)) continue;
                double I2 = targetImage[v * targetWidth + u];
                double I1 = sourceImage[v * targetWidth + u];
                double error = I2 - I1;
                double error2 = error * error;
                imageSimilarity += error2;
                ++n;
            }
        }
        if (n != 0) {
            if (verbose) {
                IJ.log((String)(" Image similarity = " + imageSimilarity / (double)n + ", n = " + n));
            }
            return imageSimilarity / (double)n;
        }
        if (verbose) {
            IJ.log((String)" Error: not a single pixel was evaluated ");
        }
        return -1.0;
    }

    public static void saveLandmarks(String outputPath, Vector<Point> sourceList, Vector<Point> targetList) {
        if (null == outputPath) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(outputPath);
            fw.write("Index\txSource\tySource\txTarget\tyTarget\n");
            for (int k = 0; k < sourceList.size(); ++k) {
                String n = "" + k;
                while (n.length() < 5) {
                    n = " " + n;
                }
                Point sourcePoint = sourceList.elementAt(k);
                String xSource = "" + sourcePoint.x;
                while (xSource.length() < 7) {
                    xSource = " " + xSource;
                }
                String ySource = "" + sourcePoint.y;
                while (ySource.length() < 7) {
                    ySource = " " + ySource;
                }
                Point targetPoint = targetList.elementAt(k);
                String xTarget = "" + targetPoint.x;
                while (xTarget.length() < 7) {
                    xTarget = " " + xTarget;
                }
                String yTarget = "" + targetPoint.y;
                while (yTarget.length() < 7) {
                    yTarget = " " + yTarget;
                }
                fw.write(n + "\t" + xSource + "\t" + ySource + "\t" + xTarget + "\t" + yTarget + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            IJ.error((String)("IOException exception" + e));
        }
        catch (SecurityException e) {
            IJ.error((String)("Security exception" + e));
        }
    }

    public static void showPoints(Vector<Point> sourceList, Vector<Point> targetList) {
        IJ.getTextPanel().setFont(new Font("Monospaced", 0, 12));
        IJ.setColumnHeadings((String)"Index\txSource\tySource\txTarget\tyTarget");
        for (int k = 0; k < sourceList.size(); ++k) {
            String n = "" + k;
            while (n.length() < 5) {
                n = " " + n;
            }
            Point sourcePoint = sourceList.elementAt(k);
            String xTarget = "" + sourcePoint.x;
            while (xTarget.length() < 7) {
                xTarget = " " + xTarget;
            }
            String yTarget = "" + sourcePoint.y;
            while (yTarget.length() < 7) {
                yTarget = " " + yTarget;
            }
            Point targetPoint = targetList.elementAt(k);
            String xSource = "" + targetPoint.x;
            while (xSource.length() < 7) {
                xSource = " " + xSource;
            }
            String ySource = "" + targetPoint.y;
            while (ySource.length() < 7) {
                ySource = " " + ySource;
            }
            IJ.getTextPanel().append(n + "\t" + xSource + "\t" + ySource + "\t" + xTarget + "\t" + yTarget);
        }
    }

    public static String getUserSelectedFilePath(String dialogTitle, boolean saveDialog) {
        String currentFolder;
        String path = null;
        String filename = null;
        String string = currentFolder = OpenDialog.getLastDirectory() != null ? OpenDialog.getLastDirectory() : OpenDialog.getDefaultDirectory();
        if (Prefs.useFileChooser) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(dialogTitle);
            chooser.setCurrentDirectory(new File(currentFolder));
            chooser.setVisible(true);
            chooser.setDialogType(saveDialog ? 1 : 0);
            int result = chooser.showOpenDialog(null);
            if (result == 0) {
                path = chooser.getCurrentDirectory().getPath() + File.separator;
                filename = chooser.getSelectedFile().getName();
            }
        } else {
            FileDialog fd = new FileDialog((Frame)IJ.getInstance(), dialogTitle, saveDialog ? 1 : 0);
            fd.setDirectory(currentFolder);
            fd.setVisible(true);
            path = fd.getDirectory() + File.separator;
            filename = fd.getName();
        }
        if (path == null || filename == null) {
            return null;
        }
        return path + filename;
    }

    public static double elasticRawWarpingIndex(String elasticTransfPath, String rawTransfPath, ImagePlus targetImp, ImagePlus sourceImp) {
        int intervals = MiscTools.numberOfIntervalsOfTransformation(elasticTransfPath);
        double[][] cx_direct = new double[intervals + 3][intervals + 3];
        double[][] cy_direct = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(elasticTransfPath, cx_direct, cy_direct);
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(rawTransfPath, transformation_x, transformation_y);
        double warpingIndex = MiscTools.rawWarpingIndex(sourceImp, targetImp, intervals, cx_direct, cy_direct, transformation_x, transformation_y);
        return warpingIndex;
    }

    public static double rawWarpingIndex(String rawTransfPath1, String rawTransfPath2, ImagePlus targetImp, ImagePlus sourceImp) {
        double[][] transformation_x1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y1 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(rawTransfPath1, transformation_x1, transformation_y1);
        double[][] transformation_x2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y2 = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(rawTransfPath2, transformation_x2, transformation_y2);
        double warpingIndex = MiscTools.rawWarpingIndex(sourceImp, targetImp, transformation_x1, transformation_y1, transformation_x2, transformation_y2);
        return warpingIndex;
    }

    public static void composeRawElasticTransforms(String rawTransfPath, String elasticTransfPath, String outputPath, ImagePlus targetImp, ImagePlus sourceImp) {
        double[][] transformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] transformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.loadRawTransformation(rawTransfPath, transformation_x, transformation_y);
        int intervals = MiscTools.numberOfIntervalsOfTransformation(elasticTransfPath);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(elasticTransfPath, cx, cy);
        double[][] outputTransformation_x = new double[targetImp.getHeight()][targetImp.getWidth()];
        double[][] outputTransformation_y = new double[targetImp.getHeight()][targetImp.getWidth()];
        MiscTools.composeRawElasticTransformations(targetImp, intervals, transformation_x, transformation_y, cx, cy, outputTransformation_x, outputTransformation_y);
        MiscTools.saveRawTransformation(outputPath, targetImp.getWidth(), targetImp.getHeight(), outputTransformation_x, outputTransformation_y);
    }

    private static class ColorApplyTransformTile
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel sourceR;
        final BSplineModel sourceG;
        final BSplineModel sourceB;
        final int targetCurrentWidth;
        final int targetCurrentHeight;
        final int intervals;
        final Rectangle rect;
        private final FloatProcessor fpR;
        private final FloatProcessor fpG;
        private final FloatProcessor fpB;

        ColorApplyTransformTile(BSplineModel swx, BSplineModel swy, BSplineModel sourceR, BSplineModel sourceG, BSplineModel sourceB, int targetCurrentWidth, int targetCurrentHeight, int intervals, Rectangle rect, FloatProcessor fpR, FloatProcessor fpG, FloatProcessor fpB) {
            this.swx = swx;
            this.swy = swy;
            this.sourceR = sourceR;
            this.sourceG = sourceG;
            this.sourceB = sourceB;
            this.targetCurrentWidth = targetCurrentWidth;
            this.targetCurrentHeight = targetCurrentHeight;
            this.intervals = intervals;
            this.rect = rect;
            this.fpR = fpR;
            this.fpG = fpG;
            this.fpB = fpB;
        }

        @Override
        public void run() {
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            float[] fpR_array = (float[])this.fpR.getPixels();
            float[] fpG_array = (float[])this.fpG.getPixels();
            float[] fpB_array = (float[])this.fpB.getPixels();
            int sourceWidth = this.sourceR.getWidth();
            int sourceHeight = this.sourceR.getHeight();
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                double tv = (double)(v * this.intervals) / (double)(this.targetCurrentHeight - 1) + 1.0;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    double tu = (double)(u * this.intervals) / (double)(this.targetCurrentWidth - 1) + 1.0;
                    double x = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double y = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        fpR_array[u_rect + v_offset] = (float)this.sourceR.prepareForInterpolationAndInterpolateI(x, y, false, false);
                        fpG_array[u_rect + v_offset] = (float)this.sourceG.prepareForInterpolationAndInterpolateI(x, y, false, false);
                        fpB_array[u_rect + v_offset] = (float)this.sourceB.prepareForInterpolationAndInterpolateI(x, y, false, false);
                    } else {
                        fpR_array[u_rect + v_offset] = 0.0f;
                        fpG_array[u_rect + v_offset] = 0.0f;
                        fpB_array[u_rect + v_offset] = 0.0f;
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
        }
    }

    private static class GrayscaleApplyTransformTile
    implements Runnable {
        final BSplineModel swx;
        final BSplineModel swy;
        final BSplineModel source;
        final int targetCurrentWidth;
        final int targetCurrentHeight;
        final int intervals;
        final Rectangle rect;
        private final FloatProcessor fp;

        GrayscaleApplyTransformTile(BSplineModel swx, BSplineModel swy, BSplineModel source, int targetCurrentWidth, int targetCurrentHeight, int intervals, Rectangle rect, FloatProcessor fp) {
            this.swx = swx;
            this.swy = swy;
            this.source = source;
            this.targetCurrentWidth = targetCurrentWidth;
            this.targetCurrentHeight = targetCurrentHeight;
            this.intervals = intervals;
            this.rect = rect;
            this.fp = fp;
        }

        @Override
        public void run() {
            int auxTargetHeight = this.rect.y + this.rect.height;
            int auxTargetWidth = this.rect.x + this.rect.width;
            float[] fp_array = (float[])this.fp.getPixels();
            int sourceWidth = this.source.getWidth();
            int sourceHeight = this.source.getHeight();
            int v_rect = 0;
            int v = this.rect.y;
            while (v < auxTargetHeight) {
                int v_offset = v_rect * this.rect.width;
                double tv = (double)(v * this.intervals) / (double)(this.targetCurrentHeight - 1) + 1.0;
                int u_rect = 0;
                int u = this.rect.x;
                while (u < auxTargetWidth) {
                    double tu = (double)(u * this.intervals) / (double)(this.targetCurrentWidth - 1) + 1.0;
                    double transformation_x_v_u = this.swx.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double transformation_y_v_u = this.swy.prepareForInterpolationAndInterpolateI(tu, tv, false, false);
                    double x = transformation_x_v_u;
                    double y = transformation_y_v_u;
                    if (x >= 0.0 && x < (double)sourceWidth && y >= 0.0 && y < (double)sourceHeight) {
                        double sval = this.source.prepareForInterpolationAndInterpolateI(x, y, false, false);
                        fp_array[u_rect + v_offset] = (float)sval;
                    } else {
                        fp_array[u_rect + v_offset] = 0.0f;
                    }
                    ++u;
                    ++u_rect;
                }
                ++v;
                ++v_rect;
            }
        }
    }
}

