/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.plugin.HandlerService;
import org.scijava.service.SciJavaService;

public interface ConvertService
extends HandlerService<ConversionRequest, Converter<?, ?>>,
SciJavaService {
    default public Object convert(Object src, Type dest) {
        return this.convert(new ConversionRequest(src, dest));
    }

    default public <T> T convert(Object src, Class<T> dest) {
        Converter<?, ?> handler = this.getHandler(src, dest);
        return handler == null ? null : (T)handler.convert(src, dest);
    }

    default public Object convert(ConversionRequest request) {
        Converter handler = (Converter)this.getHandler(request);
        return handler == null ? null : handler.convert(request);
    }

    default public Converter<?, ?> getHandler(Object src, Type dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    default public Converter<?, ?> getHandler(Object src, Class<?> dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    default public Converter<?, ?> getHandler(Class<?> src, Type dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    default public Converter<?, ?> getHandler(Class<?> src, Class<?> dest) {
        return (Converter)this.getHandler(new ConversionRequest(src, dest));
    }

    default public boolean supports(Object src, Type dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    default public boolean supports(Object src, Class<?> dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    default public boolean supports(Class<?> src, Type dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    default public boolean supports(Class<?> src, Class<?> dest) {
        return this.supports(new ConversionRequest(src, dest));
    }

    default public Collection<Object> getCompatibleInputs(Class<?> dest) {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        for (Converter c : this.getInstances()) {
            if (!dest.isAssignableFrom(c.getOutputType())) continue;
            c.populateInputCandidates(objects);
        }
        return objects;
    }

    default public Collection<Class<?>> getCompatibleInputClasses(Class<?> dest) {
        HashSet compatibleClasses = new HashSet();
        for (Converter converter : this.getInstances()) {
            if (dest != converter.getOutputType()) continue;
            compatibleClasses.add(converter.getInputType());
        }
        return compatibleClasses;
    }

    default public Collection<Class<?>> getCompatibleOutputClasses(Class<?> source) {
        HashSet compatibleClasses = new HashSet();
        for (Converter converter : this.getInstances()) {
            try {
                if (source != converter.getInputType()) continue;
                compatibleClasses.add(converter.getOutputType());
            }
            catch (Throwable t) {
                this.log().error("Malfunctioning converter plugin: " + converter.getClass().getName(), t);
            }
        }
        return compatibleClasses;
    }

    @Override
    default public Class<Converter<?, ?>> getPluginType() {
        return Converter.class;
    }

    @Override
    default public Class<ConversionRequest> getType() {
        return ConversionRequest.class;
    }
}

