/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.scijava.Context;
import org.scijava.util.Combiner;
import org.scijava.util.FileUtils;

public class ServiceCombiner
implements Combiner {
    private static final String SERVICES_PREFIX = "META-INF/services/";

    @Override
    public void combine(File outputDirectory) throws IOException {
        HashMap<String, StringBuilder> files = new HashMap<String, StringBuilder>();
        Enumeration<URL> directories = Context.getClassLoader().getResources(SERVICES_PREFIX);
        while (directories.hasMoreElements()) {
            for (URL url : FileUtils.listContents(directories.nextElement())) {
                String line;
                String urlString = url.toString();
                if (urlString.endsWith("/")) continue;
                String fileName = urlString.substring(urlString.lastIndexOf(47) + 1);
                StringBuilder builder = (StringBuilder)files.get(fileName);
                if (builder == null) {
                    builder = new StringBuilder();
                    files.put(fileName, builder);
                }
                InputStreamReader reader = new InputStreamReader(url.openStream());
                BufferedReader buffered = new BufferedReader(reader);
                while ((line = buffered.readLine()) != null) {
                    builder.append(line).append('\n');
                }
                buffered.close();
            }
        }
        if (files.isEmpty()) {
            return;
        }
        File servicesDirectory = new File(outputDirectory, SERVICES_PREFIX);
        servicesDirectory.mkdirs();
        for (Map.Entry entry : files.entrySet()) {
            FileWriter writer = new FileWriter(new File(servicesDirectory, (String)entry.getKey()));
            writer.write(((StringBuilder)entry.getValue()).toString());
            writer.close();
        }
    }

    public static void main(String ... args) throws IOException {
        new ServiceCombiner().combine(args.length > 0 ? new File(args[0]) : null);
    }
}

