/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.IndexedGeometryStripArray;
import org.jogamp.java3d.IndexedTriangleFanArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;

public class IndexedTriangleFanArray
extends IndexedGeometryStripArray {
    IndexedTriangleFanArray() {
    }

    public IndexedTriangleFanArray(int vertexCount, int vertexFormat, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArray0"));
        }
        if (indexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArray1"));
        }
    }

    public IndexedTriangleFanArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArray0"));
        }
        if (indexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArray1"));
        }
    }

    public IndexedTriangleFanArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount, int[] stripIndexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount, stripIndexCounts);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArray0"));
        }
        if (indexCount < 3) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedTriangleFanArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedTriangleFanArrayRetained rt = (IndexedTriangleFanArrayRetained)this.retained;
        int[] stripIndexCounts = new int[rt.getNumStrips()];
        rt.getStripIndexCounts(stripIndexCounts);
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedTriangleFanArray t = new IndexedTriangleFanArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount(), stripIndexCounts);
        t.duplicateNodeComponent(this);
        return t;
    }
}

