/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.QuadArrayRetained;

public class QuadArray
extends GeometryArray {
    QuadArray() {
    }

    public QuadArray(int vertexCount, int vertexFormat) {
        super(vertexCount, vertexFormat);
        if (vertexCount < 4 || vertexCount % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap);
        if (vertexCount < 4 || vertexCount % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
        if (vertexCount < 4 || vertexCount % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new QuadArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        QuadArrayRetained rt = (QuadArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        QuadArray q = new QuadArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes);
        q.duplicateNodeComponent(this);
        return q;
    }
}

