/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomMultiMesh;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.StackConverter;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.UniverseSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import org.jogamp.vecmath.Color3f;

public class ContentCreator {
    private static final boolean SWAP_TIMELAPSE_DATA = false;

    public static Content createContent(String name, ImagePlus image, int type) {
        int resf = Content.getDefaultResamplingFactor(image, type);
        return ContentCreator.createContent(name, image, type, resf, 0);
    }

    public static Content createContent(String name, ImagePlus image, int type, int resf) {
        return ContentCreator.createContent(name, image, type, resf, 0);
    }

    public static Content createContent(String name, ImagePlus image, int type, int resf, int tp) {
        int thr = Content.getDefaultThreshold(image, type);
        return ContentCreator.createContent(name, image, type, resf, tp, null, thr, new boolean[]{true, true, true});
    }

    public static Content createContent(String name, ImagePlus image, int type, int resf, int tp, Color3f color, int thresh, boolean[] channels) {
        return ContentCreator.createContent(name, ContentCreator.getImages(image), type, resf, tp, color, thresh, channels);
    }

    public static Content createContent(String name, File file, int type, int resf, int tp, Color3f color, int thresh, boolean[] channels) {
        return ContentCreator.createContent(name, ContentCreator.getImages(file), type, resf, tp, color, thresh, channels);
    }

    public static Content createContent(String name, ImagePlus[] images, int type, int resf, int tp, Color3f color, int thresh, boolean[] channels) {
        TreeMap<Integer, ContentInstant> instants = new TreeMap<Integer, ContentInstant>();
        boolean timelapse = images.length > 1;
        boolean shouldSwap = false;
        for (ImagePlus imp : images) {
            ContentInstant content = new ContentInstant(name);
            content.image = imp;
            content.color = color;
            content.threshold = thresh;
            content.channels = channels;
            content.resamplingF = resf;
            content.timepoint = tp;
            content.showCoordinateSystem(UniverseSettings.showLocalCoordinateSystemsByDefault);
            content.displayAs(type);
            content.compile();
            if (shouldSwap) {
                content.clearOriginalData();
                content.swapDisplayedData();
            }
            instants.put(tp++, content);
        }
        return new Content(name, instants, shouldSwap);
    }

    public static Content createContent(CustomMesh mesh, String name) {
        return ContentCreator.createContent(mesh, name, 0);
    }

    public static Content createContent(CustomMesh mesh, String name, int tp) {
        Content c = new Content(name, tp);
        ContentInstant content = c.getInstant(tp);
        content.color = mesh.getColor();
        content.transparency = mesh.getTransparency();
        content.shaded = mesh.isShaded();
        content.showCoordinateSystem(UniverseSettings.showLocalCoordinateSystemsByDefault);
        content.display(new CustomMeshNode(mesh));
        return c;
    }

    public static Content createContent(CustomMultiMesh node, String name) {
        return ContentCreator.createContent(node, name, 0);
    }

    public static Content createContent(CustomMultiMesh node, String name, int tp) {
        Content c = new Content(name, tp);
        ContentInstant content = c.getInstant(tp);
        content.color = null;
        content.transparency = 0.0f;
        content.shaded = true;
        content.showCoordinateSystem(UniverseSettings.showLocalCoordinateSystemsByDefault);
        content.display(node);
        return c;
    }

    public static ImagePlus[] getImages(ImagePlus imp) {
        ImagePlus[] ret = new ImagePlus[imp.getNFrames()];
        int i = 0;
        for (ImagePlus frame : HyperStackIterator.getIterable(imp)) {
            ret[i++] = frame;
        }
        return ret;
    }

    public static ImagePlus[] getImages(File file) {
        ArrayList<ImagePlus> images = new ArrayList<ImagePlus>();
        for (ImagePlus frame : FileIterator.getIterable(file)) {
            images.add(frame);
        }
        return images.toArray(new ImagePlus[0]);
    }

    public static void convert(ImagePlus image) {
        int imaget = image.getType();
        if (imaget == 0 || imaget == 3) {
            return;
        }
        int s = image.getStackSize();
        switch (imaget) {
            case 1: 
            case 2: {
                if (s == 1) {
                    new ImageConverter(image).convertToGray8();
                    break;
                }
                new StackConverter(image).convertToGray8();
            }
        }
    }

    private static class HyperStackIterator
    implements Iterator<ImagePlus>,
    Iterable<ImagePlus> {
        private final ImagePlus image;
        private final int nChannels;
        private final int nSlices;
        private final int nFrames;
        private final int w;
        private final int h;
        private int nextFrame = 0;

        public static Iterable<ImagePlus> getIterable(ImagePlus image) {
            return new HyperStackIterator(image);
        }

        private HyperStackIterator(ImagePlus image) {
            this.image = image;
            this.nChannels = image.getNChannels();
            this.nSlices = image.getNSlices();
            this.nFrames = image.getNFrames();
            System.out.println("nFrames = " + this.nFrames);
            this.w = image.getWidth();
            this.h = image.getHeight();
        }

        @Override
        public Iterator<ImagePlus> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.nextFrame < this.nFrames;
        }

        @Override
        public ImagePlus next() {
            if (this.nextFrame == this.nFrames) {
                return null;
            }
            ImageStack oldStack = this.image.getStack();
            String oldTitle = this.image.getTitle();
            FileInfo fi = this.image.getFileInfo();
            ImageStack newStack = new ImageStack(this.w, this.h);
            newStack.setColorModel(oldStack.getColorModel());
            for (int j = 0; j < this.nSlices; ++j) {
                Object pixels;
                int index = this.image.getStackIndex(1, j + 1, this.nextFrame + 1);
                if (this.nChannels > 1) {
                    this.image.setPositionWithoutUpdate(1, j + 1, this.nextFrame + 1);
                    pixels = new ColorProcessor(this.image.getImage()).getPixels();
                } else {
                    pixels = oldStack.getPixels(index);
                }
                newStack.addSlice(oldStack.getSliceLabel(index), pixels);
            }
            ImagePlus ret = new ImagePlus(oldTitle + " (frame " + this.nextFrame + ")", newStack);
            ret.setCalibration(this.image.getCalibration().copy());
            ret.setFileInfo((FileInfo)fi.clone());
            ++this.nextFrame;
            return ret;
        }
    }

    private static class FileIterator
    implements Iterator<ImagePlus>,
    Iterable<ImagePlus> {
        private final String directory;
        private final String[] names;
        private int nextIndex = 0;

        public static Iterable<ImagePlus> getIterable(File file) {
            if (!file.isDirectory()) {
                return HyperStackIterator.getIterable(IJ.openImage((String)file.getAbsolutePath()));
            }
            return new FileIterator(file);
        }

        private FileIterator(File file) {
            if (!file.isDirectory()) {
                this.names = new String[]{file.getName()};
                this.directory = file.getParentFile().getAbsolutePath();
                return;
            }
            this.directory = file.getAbsolutePath();
            this.names = file.list();
            Arrays.sort(this.names);
        }

        @Override
        public Iterator<ImagePlus> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.names.length;
        }

        @Override
        public ImagePlus next() {
            if (this.nextIndex == this.names.length) {
                return null;
            }
            File f = new File(this.directory, this.names[this.nextIndex]);
            ++this.nextIndex;
            try {
                return IJ.openImage((String)f.getAbsolutePath());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

