/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import ij3d.Content;
import ij3d.UniverseListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Properties;
import octree.Cube;
import octree.CubeData;
import octree.ShapeGroup;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.OrderedGroup;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class VolumeOctree
implements UniverseListener,
AxisConstants {
    public static final int SIZE = 128;
    static final int DETAIL_AXIS = 6;
    private static final int[][] axisIndex = new int[3][2];
    private int[][] sortingIndices;
    private final Switch axisSwitch;
    private final String imageDir;
    private final Cube rootCube;
    private final BranchGroup rootBranchGroup;
    private final UpdaterThread updater;
    int curAxis = 2;
    int curDir = 1;
    private final int maxLevel;
    private final int xdim;
    private final int ydim;
    private final int zdim;
    final float pw;
    final float ph;
    final float pd;
    private final Point3d refPt;
    boolean stopUpdating = false;
    private final Transform3D toVWorld = new Transform3D();
    private final Transform3D volToIP = new Transform3D();
    private final BitSet bitset = new BitSet(6);
    private final Vector3d eyeVec = new Vector3d();
    private static Transform3D parentInv = new Transform3D();
    private static Point3d viewPosition = new Point3d();
    private static Transform3D t = new Transform3D();

    public VolumeOctree(String imageDir, Canvas3D canvas) throws RuntimeException {
        this.imageDir = imageDir;
        VolumeOctree.axisIndex[0][0] = 0;
        VolumeOctree.axisIndex[0][1] = 1;
        VolumeOctree.axisIndex[1][0] = 2;
        VolumeOctree.axisIndex[1][1] = 3;
        VolumeOctree.axisIndex[2][0] = 4;
        VolumeOctree.axisIndex[2][1] = 5;
        this.axisSwitch = new Switch();
        this.axisSwitch.setCapability(18);
        this.axisSwitch.setCapability(13);
        this.axisSwitch.setCapability(14);
        for (int i = 0; i < 7; ++i) {
            this.axisSwitch.addChild((Node)VolumeOctree.newOrderedGroup());
        }
        this.rootBranchGroup = new BranchGroup();
        this.rootBranchGroup.setCapability(17);
        this.rootBranchGroup.setCapability(11);
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(new File(imageDir, "props.txt")));
            this.xdim = Integer.parseInt(props.getProperty("width"));
            this.ydim = Integer.parseInt(props.getProperty("height"));
            this.zdim = Integer.parseInt(props.getProperty("depth"));
            this.maxLevel = Integer.parseInt(props.getProperty("level"));
            this.pw = Float.parseFloat(props.getProperty("pixelWidth"));
            this.ph = Float.parseFloat(props.getProperty("pixelHeight"));
            this.pd = Float.parseFloat(props.getProperty("pixelDepth"));
            this.rootCube = new Cube(this, imageDir, 0, 0, 0, this.maxLevel);
            this.rootCube.createChildren();
            this.refPt = new Point3d((double)((float)this.xdim * this.pw / 2.0f), (double)((float)this.ydim * this.ph / 2.0f), (double)((float)this.zdim * this.pd / 2.0f));
        }
        catch (Exception e) {
            throw new RuntimeException("Error in property file.", e);
        }
        this.addEmptyGroups(this.curAxis, this.curDir);
        this.createSortingIndices();
        this.updater = new UpdaterThread(canvas);
        this.updater.run();
    }

    public BranchGroup getRootBranchGroup() {
        return this.rootBranchGroup;
    }

    public Cube getRootCube() {
        return this.rootCube;
    }

    public float realWorldXDim() {
        return (float)this.xdim * this.pw;
    }

    public float realWorldYDim() {
        return (float)this.ydim * this.ph;
    }

    public float realWorldZDim() {
        return (float)this.zdim * this.pd;
    }

    public void displayInitial() {
        int[] axis = new int[]{0, 1, 2};
        for (int ai = 0; ai < 3; ++ai) {
            CubeData cdata = new CubeData(this.rootCube);
            cdata.prepareForAxis(axis[ai]);
            cdata.show();
            Arrays.sort(cdata.shapes);
            OrderedGroup fg = this.getOrderedGroup(axisIndex[axis[ai]][0]);
            OrderedGroup bg = this.getOrderedGroup(axisIndex[axis[ai]][1]);
            for (int i = 0; i < 128; ++i) {
                fg.addChild((Node)cdata.shapes[i].duplicate().group);
                bg.addChild((Node)cdata.shapes[i].duplicate().group);
            }
        }
        this.rootBranchGroup.addChild((Node)this.axisSwitch);
        this.setWhichChild(axisIndex[this.curAxis][this.curDir]);
        System.out.println("# shapes: " + this.countInitialShapes());
    }

    final void removeAllCubes() {
        OrderedGroup og = this.getOrderedGroup(6);
        for (int i = og.numChildren() - 1; i >= 0; --i) {
            BranchGroup child = (BranchGroup)og.getChild(i);
            child.detach();
            child.removeAllChildren();
        }
    }

    private final void createSortingIndices() {
        int[] axis = new int[]{0, 1, 2};
        int[] dir = new int[]{0, 1};
        this.sortingIndices = new int[6][];
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        for (int a : axis) {
            cubes.clear();
            this.rootCube.collectCubes(cubes, a);
            Object[] shapes = new ShapeGroup[cubes.size() * 128];
            int i = 0;
            for (Cube c : cubes) {
                for (ShapeGroup sg : c.cdata.shapes) {
                    shapes[i] = sg;
                    ((ShapeGroup)shapes[i]).indexInParent = i;
                    ++i;
                }
            }
            Arrays.sort(shapes);
            int aif = axisIndex[a][0];
            int aib = axisIndex[a][1];
            this.sortingIndices[aif] = new int[shapes.length];
            this.sortingIndices[aib] = new int[shapes.length];
            for (i = 0; i < shapes.length; ++i) {
                int j = shapes.length - 1 - i;
                this.sortingIndices[aif][i] = ((ShapeGroup)shapes[i]).indexInParent;
                this.sortingIndices[aib][j] = ((ShapeGroup)shapes[i]).indexInParent;
            }
        }
    }

    private final void addEmptyGroups(int axis, int dir) {
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        this.rootCube.collectCubes(cubes, axis);
        ShapeGroup[] shapes = new ShapeGroup[cubes.size() * 128];
        int i = 0;
        for (Cube c : cubes) {
            for (ShapeGroup sg : c.cdata.shapes) {
                shapes[i++] = sg;
            }
        }
        OrderedGroup og = this.getOrderedGroup(6);
        for (i = 0; i < shapes.length; ++i) {
            og.addChild((Node)shapes[i].group);
        }
    }

    final void axisChanged(Point3d eyePosInLocal) {
        System.out.println("**** AXIS CHANGED ****");
        this.rootCube.hideSelf();
        this.rootCube.hideSubtree();
        this.rootCube.prepareForAxis(this.curAxis, eyePosInLocal);
        this.getOrderedGroup(6).setChildIndexOrder(this.sortingIndices[axisIndex[this.curAxis][this.curDir]]);
        System.out.println("**** AXIS CHANGED DONE ****");
    }

    final void volumeToIP(Canvas3D canvas, Transform3D ret) {
        canvas.getImagePlateToVworld(ret);
        ret.invert();
        this.rootBranchGroup.getLocalToVworld(this.toVWorld);
        ret.mul(this.toVWorld);
    }

    final void updateCubes(Canvas3D canvas, Point3d eyePosInLocal, boolean axisChanged) {
        this.volumeToIP(canvas, this.volToIP);
        this.updater.submit(this.volToIP, eyePosInLocal, axisChanged);
    }

    final void setCombinedWhichChild(int child) {
        this.axisSwitch.setWhichChild(-3);
        this.bitset.clear();
        this.bitset.set(6, true);
        this.bitset.set(child, true);
        this.axisSwitch.setChildMask(this.bitset);
    }

    final void setWhichChild(int child) {
        this.axisSwitch.setWhichChild(child);
    }

    final OrderedGroup getOrderedGroup(int i) {
        return (OrderedGroup)this.axisSwitch.getChild(i);
    }

    static final BranchGroup newBranchGroup() {
        BranchGroup bg = new BranchGroup();
        bg.setCapability(17);
        return bg;
    }

    final int countDetailShapes() {
        return this.getOrderedGroup(6).numChildren();
    }

    private final int countInitialShapes() {
        int sum = 0;
        for (int i = 0; i < 6; ++i) {
            OrderedGroup og = this.getOrderedGroup(i);
            sum += og.numChildren();
        }
        return sum;
    }

    private static final OrderedGroup newOrderedGroup() {
        OrderedGroup og = new OrderedGroup();
        og.setCapability(14);
        og.setCapability(13);
        og.setCapability(18);
        return og;
    }

    @Override
    public void transformationUpdated(View view) {
        Point3d eyePt = VolumeOctree.getViewPosInLocal(view, (Node)this.rootBranchGroup);
        if (eyePt == null) {
            return;
        }
        this.eyeVec.sub((Tuple3d)eyePt, (Tuple3d)this.refPt);
        int axis = 0;
        double value = this.eyeVec.x;
        double max = Math.abs(this.eyeVec.x);
        if (Math.abs(this.eyeVec.y) > max) {
            axis = 1;
            value = this.eyeVec.y;
            max = Math.abs(this.eyeVec.y);
        }
        if (Math.abs(this.eyeVec.z) > max) {
            axis = 2;
            value = this.eyeVec.z;
            max = Math.abs(this.eyeVec.z);
        }
        int dir = value > 0.0 ? 0 : 1;
        Canvas3D canvas = view.getCanvas3D(0);
        if (axis != this.curAxis || dir != this.curDir) {
            this.curAxis = axis;
            this.curDir = dir;
            this.updateCubes(canvas, eyePt, true);
        } else {
            this.updateCubes(canvas, eyePt, false);
        }
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void transformationFinished(View view) {
    }

    @Override
    public void contentAdded(Content c) {
    }

    @Override
    public void contentRemoved(Content c) {
    }

    @Override
    public void contentChanged(Content c) {
    }

    @Override
    public void contentSelected(Content c) {
    }

    @Override
    public void canvasResized() {
    }

    @Override
    public void universeClosed() {
    }

    private static Point3d getViewPosInLocal(View view, Node node) {
        if (node == null) {
            return null;
        }
        if (!node.isLive()) {
            return null;
        }
        Canvas3D canvas = view.getCanvas3D(0);
        canvas.getCenterEyeInImagePlate(viewPosition);
        canvas.getImagePlateToVworld(t);
        t.transform(viewPosition);
        node.getLocalToVworld(parentInv);
        parentInv.invert();
        parentInv.transform(viewPosition);
        return viewPosition;
    }

    private class UpdaterThread {
        private final Canvas3D canvas;
        private final Transform3D nextT = new Transform3D();
        private final Point3d nextEyePosInLocal = new Point3d();
        private final Transform3D runningT = new Transform3D();
        private final Point3d runningEyePosInLocal = new Point3d();
        private Thread thread;
        private boolean available = false;
        private boolean axisChanged = false;

        public UpdaterThread(Canvas3D canvas) {
            this.canvas = canvas;
        }

        public synchronized void submit(Transform3D t, Point3d eyePosInLocal, boolean axisChanged) {
            if (axisChanged) {
                this.axisChanged = axisChanged;
                System.out.println("SUBMIT AXIS CHANGE");
            }
            this.nextT.set(t);
            this.nextEyePosInLocal.set((Tuple3d)eyePosInLocal);
            this.available = true;
            VolumeOctree.this.stopUpdating = true;
            this.notify();
        }

        private synchronized void fetchNext() {
            if (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.runningT.set(this.nextT);
            this.runningEyePosInLocal.set((Tuple3d)this.nextEyePosInLocal);
            this.available = false;
        }

        public void run() {
            this.thread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        UpdaterThread.this.fetchNext();
                        VolumeOctree.this.setWhichChild(axisIndex[VolumeOctree.this.curAxis][VolumeOctree.this.curDir]);
                        if (UpdaterThread.this.axisChanged) {
                            UpdaterThread.this.axisChanged = false;
                            VolumeOctree.this.axisChanged(UpdaterThread.this.runningEyePosInLocal);
                            VolumeOctree.this.setWhichChild(6);
                        }
                        System.out.println("updateCubes");
                        VolumeOctree.this.stopUpdating = false;
                        VolumeOctree.this.rootCube.update(UpdaterThread.this.canvas, UpdaterThread.this.runningT);
                        VolumeOctree.this.setWhichChild(6);
                        System.out.println("updateCubes finished");
                    }
                }
            };
            this.thread.setPriority(1);
            this.thread.start();
        }
    }
}

