/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.options.OptionsMisc;
import net.imagej.plugins.commands.assign.MathCommand;
import net.imglib2.ops.operation.real.unary.RealDivideConstant;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.command.Command;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Math", mnemonic=109), @Menu(label="Divide...", weight=4.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class DivideDataValuesBy<T extends RealType<T>>
extends MathCommand<T, DoubleType> {
    @Parameter
    private OptionsService optionsService;
    @Parameter(label="Value")
    private double value;

    public DivideDataValuesBy() {
        super(new DoubleType());
    }

    @Override
    public RealDivideConstant<DoubleType, DoubleType> getOperation() {
        double dbzVal;
        OptionsMisc optionsMisc = (OptionsMisc)this.optionsService.getOptions(OptionsMisc.class);
        String dbzString = optionsMisc.getDivByZeroVal();
        try {
            dbzVal = Double.parseDouble(dbzString);
        }
        catch (NumberFormatException e) {
            dbzVal = Double.POSITIVE_INFINITY;
        }
        return new RealDivideConstant(this.value, dbzVal);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}

