/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.behaviors.interpolators;

import org.scijava.java3d.utils.behaviors.interpolators.TCBKeyFrame;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Quat4f;
import org.scijava.vecmath.Vector3f;

public class CubicSplineSegment {
    static final double[] modRoot = new double[]{0.046910077, 0.230765345, 0.5, 0.769234655, 0.953089922};
    static final double[] modCoeff = new double[]{0.118463442, 0.239314335, 0.284444444, 0.239314335, 0.118463442};
    TCBKeyFrame[] keyFrame = new TCBKeyFrame[4];
    Point3f c0;
    Point3f c1;
    Point3f c2;
    Point3f c3;
    Point3f e0;
    Point3f e1;
    Point3f e2;
    Point3f e3;
    float one_minus_t_in;
    float one_minus_c_in;
    float one_minus_b_in;
    float one_plus_c_in;
    float one_plus_b_in;
    float ddb;
    float dda;
    float one_minus_t_out;
    float one_minus_c_out;
    float one_minus_b_out;
    float one_plus_c_out;
    float one_plus_b_out;
    float dsb;
    float dsa;
    float length;
    int linear;

    CubicSplineSegment() {
        this.length = 0.0f;
    }

    CubicSplineSegment(TCBKeyFrame kf0, TCBKeyFrame kf1, TCBKeyFrame kf2, TCBKeyFrame kf3) {
        this.keyFrame[0] = new TCBKeyFrame(kf0);
        this.keyFrame[1] = new TCBKeyFrame(kf1);
        this.keyFrame[2] = new TCBKeyFrame(kf2);
        this.keyFrame[3] = new TCBKeyFrame(kf3);
        if (kf2.linear == 1) {
            this.linear = 1;
        } else {
            this.linear = 0;
            this.computeCommonCoefficients(kf0, kf1, kf2, kf3);
            this.computeHermiteCoefficients(kf0, kf1, kf2, kf3);
        }
        this.length = this.computeLength(1.0f);
    }

    private void computeCommonCoefficients(TCBKeyFrame kf0, TCBKeyFrame kf1, TCBKeyFrame kf2, TCBKeyFrame kf3) {
        float one_minus_t_in = 1.0f - kf1.tension;
        float one_minus_c_in = 1.0f - kf1.continuity;
        float one_minus_b_in = 1.0f - kf1.bias;
        float one_plus_c_in = 1.0f + kf1.continuity;
        float one_plus_b_in = 1.0f + kf1.bias;
        this.ddb = one_minus_t_in * one_minus_c_in * one_minus_b_in;
        this.dda = one_minus_t_in * one_plus_c_in * one_plus_b_in;
        float one_minus_t_out = 1.0f - kf2.tension;
        float one_minus_c_out = 1.0f - kf2.continuity;
        float one_minus_b_out = 1.0f - kf2.bias;
        float one_plus_c_out = 1.0f + kf2.continuity;
        float one_plus_b_out = 1.0f + kf2.bias;
        this.dsb = one_minus_t_in * one_plus_c_in * one_minus_b_in;
        this.dsa = one_minus_t_in * one_minus_c_in * one_plus_b_in;
    }

    private void computeHermiteCoefficients(TCBKeyFrame kf0, TCBKeyFrame kf1, TCBKeyFrame kf2, TCBKeyFrame kf3) {
        Point3f deltaP = new Point3f();
        Point3f deltaS = new Point3f();
        deltaP.x = kf2.position.x - kf1.position.x;
        deltaP.y = kf2.position.y - kf1.position.y;
        deltaP.z = kf2.position.z - kf1.position.z;
        deltaS.x = kf2.scale.x - kf1.scale.x;
        deltaS.y = kf2.scale.y - kf1.scale.y;
        deltaS.z = kf2.scale.z - kf1.scale.z;
        Point3f dd_pos = new Point3f();
        Point3f dd_scale = new Point3f();
        if (kf0.knot == kf1.knot) {
            float ddab = 0.5f * (this.dda + this.ddb);
            dd_pos.x = ddab * deltaP.x;
            dd_pos.y = ddab * deltaP.y;
            dd_pos.z = ddab * deltaP.z;
            dd_scale.x = ddab * deltaS.x;
            dd_scale.y = ddab * deltaS.y;
            dd_scale.z = ddab * deltaS.z;
        } else {
            float adj0 = (kf1.knot - kf0.knot) / (kf2.knot - kf0.knot);
            dd_pos.x = adj0 * (this.ddb * deltaP.x + this.dda * (kf1.position.x - kf0.position.x));
            dd_pos.y = adj0 * (this.ddb * deltaP.y + this.dda * (kf1.position.y - kf0.position.y));
            dd_pos.z = adj0 * (this.ddb * deltaP.z + this.dda * (kf1.position.z - kf0.position.z));
            dd_scale.x = adj0 * (this.ddb * deltaS.x + this.dda * (kf1.scale.x - kf0.scale.x));
            dd_scale.y = adj0 * (this.ddb * deltaS.y + this.dda * (kf1.scale.y - kf0.scale.y));
            dd_scale.z = adj0 * (this.ddb * deltaS.z + this.dda * (kf1.scale.z - kf0.scale.z));
        }
        Point3f ds_pos = new Point3f();
        Point3f ds_scale = new Point3f();
        if (kf2.knot == kf3.knot) {
            float dsab = 0.5f * (this.dsa + this.dsb);
            ds_pos.x = dsab * deltaP.x;
            ds_pos.y = dsab * deltaP.y;
            ds_pos.z = dsab * deltaP.z;
            ds_scale.x = dsab * deltaS.x;
            ds_scale.y = dsab * deltaS.y;
            ds_scale.z = dsab * deltaS.z;
        } else {
            float adj1 = (kf2.knot - kf1.knot) / (kf3.knot - kf1.knot);
            ds_pos.x = adj1 * (this.dsb * (kf3.position.x - kf2.position.x) + this.dsa * deltaP.x);
            ds_pos.y = adj1 * (this.dsb * (kf3.position.y - kf2.position.y) + this.dsa * deltaP.y);
            ds_pos.z = adj1 * (this.dsb * (kf3.position.z - kf2.position.z) + this.dsa * deltaP.z);
            ds_scale.x = adj1 * (this.dsb * (kf3.scale.x - kf2.scale.x) + this.dsa * deltaS.x);
            ds_scale.y = adj1 * (this.dsb * (kf3.scale.y - kf2.scale.y) + this.dsa * deltaS.y);
            ds_scale.z = adj1 * (this.dsb * (kf3.scale.z - kf2.scale.z) + this.dsa * deltaS.z);
        }
        this.c0 = new Point3f();
        this.c0.x = kf1.position.x;
        this.c0.y = kf1.position.y;
        this.c0.z = kf1.position.z;
        this.c1 = new Point3f();
        this.c1.x = dd_pos.x;
        this.c1.y = dd_pos.y;
        this.c1.z = dd_pos.z;
        this.c2 = new Point3f();
        this.c2.x = 3.0f * deltaP.x - 2.0f * dd_pos.x - ds_pos.x;
        this.c2.y = 3.0f * deltaP.y - 2.0f * dd_pos.y - ds_pos.y;
        this.c2.z = 3.0f * deltaP.z - 2.0f * dd_pos.z - ds_pos.z;
        this.c3 = new Point3f();
        this.c3.x = -2.0f * deltaP.x + dd_pos.x + ds_pos.x;
        this.c3.y = -2.0f * deltaP.y + dd_pos.y + ds_pos.y;
        this.c3.z = -2.0f * deltaP.z + dd_pos.z + ds_pos.z;
        this.e0 = new Point3f();
        this.e0.x = kf1.scale.x;
        this.e0.y = kf1.scale.y;
        this.e0.z = kf1.scale.z;
        this.e1 = new Point3f();
        this.e1.x = dd_scale.x;
        this.e1.y = dd_scale.y;
        this.e1.z = dd_scale.z;
        this.e2 = new Point3f();
        this.e2.x = 3.0f * deltaS.x - 2.0f * dd_scale.x - ds_scale.x;
        this.e2.y = 3.0f * deltaS.y - 2.0f * dd_scale.y - ds_scale.y;
        this.e2.z = 3.0f * deltaS.z - 2.0f * dd_scale.z - ds_scale.z;
        this.e3 = new Point3f();
        this.e3.x = -2.0f * deltaS.x + dd_scale.x + ds_scale.x;
        this.e3.y = -2.0f * deltaS.y + dd_scale.y + ds_scale.y;
        this.e3.z = -2.0f * deltaS.z + dd_scale.z + ds_scale.z;
    }

    public float computeLength(float u) {
        float result = 0.0f;
        if (this.linear == 1) {
            result = u * this.keyFrame[2].position.distance(this.keyFrame[1].position);
        } else {
            int degree = 5;
            for (int i = 0; i < degree; ++i) {
                result += (float)modCoeff[i] * this.computeSpeed(u * (float)modRoot[i]);
            }
            result *= u;
        }
        return result;
    }

    private float computeSpeed(float u) {
        Point3f v = new Point3f();
        v.x = this.c1.x + u * (2.0f * this.c2.x + 3.0f * u * this.c3.x);
        v.y = this.c1.y + u * (2.0f * this.c2.y + 3.0f * u * this.c3.y);
        v.z = this.c1.z + u * (2.0f * this.c2.z + 3.0f * u * this.c3.z);
        return (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
    }

    public void getInterpolatedQuaternion(float u, Quat4f newQuat) {
        if (this.linear == 1) {
            double quatDot = this.keyFrame[1].quat.x * this.keyFrame[2].quat.x + this.keyFrame[1].quat.y * this.keyFrame[2].quat.y + this.keyFrame[1].quat.z * this.keyFrame[2].quat.z + this.keyFrame[1].quat.w * this.keyFrame[2].quat.w;
            if (quatDot < 0.0) {
                newQuat.x = this.keyFrame[1].quat.x + (-this.keyFrame[2].quat.x - this.keyFrame[1].quat.x) * u;
                newQuat.y = this.keyFrame[1].quat.y + (-this.keyFrame[2].quat.y - this.keyFrame[1].quat.y) * u;
                newQuat.z = this.keyFrame[1].quat.z + (-this.keyFrame[2].quat.z - this.keyFrame[1].quat.z) * u;
                newQuat.w = this.keyFrame[1].quat.w + (-this.keyFrame[2].quat.w - this.keyFrame[1].quat.w) * u;
            } else {
                newQuat.x = this.keyFrame[1].quat.x + (this.keyFrame[2].quat.x - this.keyFrame[1].quat.x) * u;
                newQuat.y = this.keyFrame[1].quat.y + (this.keyFrame[2].quat.y - this.keyFrame[1].quat.y) * u;
                newQuat.z = this.keyFrame[1].quat.z + (this.keyFrame[2].quat.z - this.keyFrame[1].quat.z) * u;
                newQuat.w = this.keyFrame[1].quat.w + (this.keyFrame[2].quat.w - this.keyFrame[1].quat.w) * u;
            }
        } else {
            newQuat.interpolate(this.keyFrame[1].quat, this.keyFrame[2].quat, u);
        }
    }

    public void getInterpolatedScale(float u, Point3f newScale) {
        if (this.linear == 1) {
            newScale.x = this.keyFrame[1].scale.x + (this.keyFrame[2].scale.x - this.keyFrame[1].scale.x) * u;
            newScale.y = this.keyFrame[1].scale.y + (this.keyFrame[2].scale.y - this.keyFrame[1].scale.y) * u;
            newScale.z = this.keyFrame[1].scale.z + (this.keyFrame[2].scale.z - this.keyFrame[1].scale.z) * u;
        } else {
            newScale.x = this.e0.x + u * (this.e1.x + u * (this.e2.x + u * this.e3.x));
            newScale.y = this.e0.y + u * (this.e1.y + u * (this.e2.y + u * this.e3.y));
            newScale.z = this.e0.z + u * (this.e1.z + u * (this.e2.z + u * this.e3.z));
        }
    }

    public void getInterpolatedPosition(float u, Point3f newPos) {
        if (this.linear == 1) {
            newPos.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * u;
            newPos.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * u;
            newPos.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * u;
        } else {
            newPos.x = this.c0.x + u * (this.c1.x + u * (this.c2.x + u * this.c3.x));
            newPos.y = this.c0.y + u * (this.c1.y + u * (this.c2.y + u * this.c3.y));
            newPos.z = this.c0.z + u * (this.c1.z + u * (this.c2.z + u * this.c3.z));
        }
    }

    public void getInterpolatedPositionVector(float u, Vector3f newPos) {
        if (this.linear == 1) {
            newPos.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * u;
            newPos.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * u;
            newPos.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * u;
        } else {
            newPos.x = this.c0.x + u * (this.c1.x + u * (this.c2.x + u * this.c3.x));
            newPos.y = this.c0.y + u * (this.c1.y + u * (this.c2.y + u * this.c3.y));
            newPos.z = this.c0.z + u * (this.c1.z + u * (this.c2.z + u * this.c3.z));
        }
    }

    public float getInterpolatedValue(float u) {
        return this.computeLength(u) / this.length;
    }
}

