/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.model;

import com.google.common.primitives.Doubles;
import java.util.Arrays;

public class Tip {
    private double[] x;
    private double[] y;
    private int[] frames;
    private double averageX = Double.NaN;
    private double averageY = Double.NaN;
    private double stdX = Double.NaN;
    private double stdY = Double.NaN;

    public Tip(double[] x, double[] y, int[] frames) {
        this.x = x;
        this.y = y;
        this.frames = frames;
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getY() {
        return this.y;
    }

    public int[] getFrames() {
        return this.frames;
    }

    public double getAverageX() {
        if (Double.isNaN(this.averageX)) {
            this.averageX = Arrays.stream(this.x).summaryStatistics().getAverage();
        }
        return this.averageX;
    }

    public double getAverageY() {
        if (Double.isNaN(this.averageY)) {
            this.averageY = Arrays.stream(this.y).summaryStatistics().getAverage();
        }
        return this.averageY;
    }

    public double getStdX() {
        if (Double.isNaN(this.stdX)) {
            double rawSum = Doubles.asList((double[])this.x).stream().mapToDouble(xx -> Math.pow(xx - this.getAverageX(), 2.0)).sum();
            this.stdX = Math.sqrt(rawSum / (double)(this.x.length - 1));
        }
        return this.stdX;
    }

    public double getStdY() {
        if (Double.isNaN(this.stdY)) {
            double rawSum = Doubles.asList((double[])this.y).stream().mapToDouble(yy -> Math.pow(yy - this.getAverageY(), 2.0)).sum();
            this.stdY = Math.sqrt(rawSum / (double)(this.y.length - 1));
        }
        return this.stdY;
    }

    public double getDispX() {
        return this.x[this.x.length - 1] - this.x[0];
    }

    public double getDispY() {
        return this.y[this.y.length - 1] - this.y[0];
    }

    public String toString() {
        String out = "";
        out = out + "Average x : " + this.getAverageX() + " | ";
        out = out + "Average y : " + this.getAverageY() + "\n";
        return out;
    }
}

