/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export.tiles;

import bdv.export.ProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.ij.export.tiles.TileImgLoader;
import bdv.ij.util.PluginHelper;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import ij.IJ;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class CellVoyagerDataExporter {
    private static final String CHANNELS_ELEMENT = "Channels";
    private Document document;
    private final File measurementSettingFile;
    private final File imageIndexFile;

    public CellVoyagerDataExporter(File measurementSettingFile, File imageIndexFile) {
        this.measurementSettingFile = measurementSettingFile;
        this.imageIndexFile = imageIndexFile;
        if (!measurementSettingFile.exists()) {
            throw new IllegalArgumentException("The target file " + measurementSettingFile + " does not exist.");
        }
        if (!measurementSettingFile.isFile()) {
            throw new IllegalArgumentException("The target file " + measurementSettingFile + " is not a file.");
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            this.document = builder.build(measurementSettingFile);
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException("The target file " + measurementSettingFile + " is malformed:\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Trouble reading " + measurementSettingFile + ":\n" + e.getMessage());
        }
        if (!this.document.getRootElement().getName().equals("MeasurementSetting")) {
            throw new IllegalArgumentException("The target file " + measurementSettingFile + " is not a CellVoyager Measurement Setting file.");
        }
    }

    public List<ChannelInfo> readInfo() {
        ArrayList<ChannelInfo> channels = new ArrayList<ChannelInfo>();
        Element root = this.document.getRootElement();
        double objectiveMagnification = Double.parseDouble(root.getChild("SelectedObjectiveLens").getChildText("Magnification"));
        double zoomLensMagnification = Double.parseDouble(root.getChild("ZoomLens").getChild("Magnification").getChildText("Value"));
        double magnification = objectiveMagnification * zoomLensMagnification;
        Element channelsEl = root.getChild(CHANNELS_ELEMENT);
        List channelElements = channelsEl.getChildren();
        for (Element channelElement : channelElements) {
            boolean isEnabled = Boolean.parseBoolean(channelElement.getChild("IsEnabled").getText());
            if (!isEnabled) continue;
            ChannelInfo ci = new ChannelInfo();
            channels.add(ci);
            ci.isEnabled = true;
            ci.channelNumber = Integer.parseInt(channelElement.getChild("Number").getText());
            Element acquisitionSettings = channelElement.getChild("AcquisitionSetting");
            Element cameraEl = acquisitionSettings.getChild("Camera");
            ci.tileWidth = Integer.parseInt(cameraEl.getChildText("EffectiveHorizontalPixels_pixel"));
            ci.tileHeight = Integer.parseInt(cameraEl.getChildText("EffectiveVerticalPixels_pixel"));
            ci.unmagnifiedPixelWidth = Double.parseDouble(cameraEl.getChildText("HorizonalCellSize_um"));
            ci.unmagnifiedPixelHeight = Double.parseDouble(cameraEl.getChildText("VerticalCellSize_um"));
            Element colorElement = channelElement.getChild("ContrastEnhanceParam").getChild("Color");
            int r = Integer.parseInt(colorElement.getChildText("R"));
            int g = Integer.parseInt(colorElement.getChildText("G"));
            int b = Integer.parseInt(colorElement.getChildText("B"));
            int a = Integer.parseInt(colorElement.getChildText("A"));
            ci.channelColor = new Color(r, g, b, a);
            ci.bitDepth = channelElement.getChild("ContrastEnhanceParam").getChildText("BitDepth");
            ci.pixelWidth = ci.unmagnifiedPixelWidth / magnification;
            ci.pixelHeight = ci.unmagnifiedPixelWidth / magnification;
        }
        for (ChannelInfo channelInfo : channels) {
            Object fieldElement2;
            List fieldElements = root.getChild("Wells").getChild("Well").getChild("Areas").getChild("Area").getChild("Fields").getChildren("Field");
            double xmin = Double.POSITIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            double xmax = Double.NEGATIVE_INFINITY;
            double ymax = Double.NEGATIVE_INFINITY;
            ArrayList<double[]> offsetsUm = new ArrayList<double[]>();
            for (Object fieldElement2 : fieldElements) {
                double yum;
                double xum = Double.parseDouble(fieldElement2.getChildText("StageX_um"));
                if (xum < xmin) {
                    xmin = xum;
                }
                if (xum > xmax) {
                    xmax = xum;
                }
                if ((yum = -Double.parseDouble(fieldElement2.getChildText("StageY_um"))) < ymin) {
                    ymin = yum;
                }
                if (yum > ymax) {
                    ymax = yum;
                }
                offsetsUm.add(new double[]{xum, yum});
            }
            ArrayList<long[]> offsets = new ArrayList<long[]>();
            fieldElement2 = offsetsUm.iterator();
            while (fieldElement2.hasNext()) {
                double[] offsetUm = (double[])fieldElement2.next();
                long x = (long)((offsetUm[0] - xmin) / (channelInfo.unmagnifiedPixelWidth / magnification));
                long y = (long)((offsetUm[1] - ymin) / (channelInfo.unmagnifiedPixelHeight / magnification));
                offsets.add(new long[]{x, y});
            }
            channelInfo.offsets = offsets;
            int width = 1 + (int)((xmax - xmin) / (channelInfo.unmagnifiedPixelWidth / magnification));
            int height = 1 + (int)((ymax - ymin) / (channelInfo.unmagnifiedPixelWidth / magnification));
            channelInfo.width = width + channelInfo.tileWidth;
            channelInfo.height = height + channelInfo.tileHeight;
        }
        int nZSlices = Integer.parseInt(root.getChild("ZRange").getChildText("NumberOfSlices"));
        double zStroke = Double.parseDouble(root.getChild("ZRange").getChildText("Stroke_um"));
        double pixelDepth = zStroke / (double)(nZSlices - 1);
        for (ChannelInfo channelInfo : channels) {
            channelInfo.nZSlices = nZSlices;
            channelInfo.pixelDepth = pixelDepth;
            channelInfo.spaceUnits = "\u00b5m";
        }
        return channels;
    }

    public TimePoints readTimePoints() {
        Element root = this.document.getRootElement();
        int nTimePoints = Integer.parseInt(root.getChild("TimelapsCondition").getChildText("Iteration"));
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(nTimePoints);
        for (int i = 0; i < nTimePoints; ++i) {
            timepoints.add(new TimePoint(Integer.valueOf(i).intValue()));
        }
        return new TimePoints(timepoints);
    }

    public double readFrameInterval() {
        Element root = this.document.getRootElement();
        double dt = Double.parseDouble(root.getChild("TimelapsCondition").getChildText("Interval"));
        return dt;
    }

    public void export(File seqFile, File hdf5File, int[][] resolutions, int[][] chunks, ProgressWriter progressWriter) {
        progressWriter.setProgress(0.0);
        List<ChannelInfo> channelInfos = this.readInfo();
        ArrayList<BasicViewSetup> setups = new ArrayList<BasicViewSetup>(channelInfos.size());
        int viewSetupIndex = 0;
        for (ChannelInfo channelInfo : channelInfos) {
            Channel channel = new Channel(channelInfo.channelNumber);
            FinalDimensions size = new FinalDimensions(new int[]{channelInfo.width, channelInfo.height, channelInfo.nZSlices});
            FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(channelInfo.spaceUnits, new double[]{channelInfo.pixelWidth, channelInfo.pixelHeight, channelInfo.pixelDepth});
            BasicViewSetup viewSetup = new BasicViewSetup(viewSetupIndex++, null, (Dimensions)size, (VoxelDimensions)voxelSize);
            viewSetup.setAttribute((Entity)channel);
            setups.add(viewSetup);
        }
        TileImgLoader imgLoader = new TileImgLoader(this.imageIndexFile, channelInfos);
        TimePoints timePoints = this.readTimePoints();
        SequenceDescriptionMinimal sequenceDescriptionHDF5 = new SequenceDescriptionMinimal(timePoints, (Map)Entity.idMap(setups), (BasicImgLoader)imgLoader, null);
        int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
        WriteSequenceToHdf5.writeHdf5File((AbstractSequenceDescription)sequenceDescriptionHDF5, (int[][])resolutions, (int[][])chunks, (boolean)true, (File)hdf5File, null, null, (int)numCellCreatorThreads, (ProgressWriter)progressWriter);
        SequenceDescriptionMinimal sequenceDescriptionXML = sequenceDescriptionHDF5;
        sequenceDescriptionXML.setImgLoader((BasicImgLoader)new Hdf5ImageLoader(hdf5File, null, (AbstractSequenceDescription)sequenceDescriptionXML, false));
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int setupIndex = 0; setupIndex < setups.size(); ++setupIndex) {
            BasicViewSetup viewSetup = (BasicViewSetup)setups.get(setupIndex);
            int setupId = viewSetup.getId();
            VoxelDimensions voxelSize = viewSetup.getVoxelSize();
            double pw = voxelSize.dimension(0);
            double ph = voxelSize.dimension(1);
            double pd = voxelSize.dimension(2);
            AffineTransform3D sourceTransform = new AffineTransform3D();
            sourceTransform.set(pw, 0.0, 0.0, 0.0, 0.0, ph, 0.0, 0.0, 0.0, 0.0, pd, 0.0);
            for (TimePoint timepoint : timePoints.getTimePointsOrdered()) {
                int timepointId = timepoint.getId();
                ViewRegistration view = new ViewRegistration(timepointId, setupId, sourceTransform);
                registrations.add(view);
            }
        }
        ViewRegistrations viewRegistrations = new ViewRegistrations(registrations);
        SpimDataMinimal spimData = new SpimDataMinimal(seqFile.getParentFile(), sequenceDescriptionXML, viewRegistrations);
        try {
            new XmlIoSpimDataMinimal().save((AbstractSpimData)spimData, seqFile.getAbsolutePath());
            IJ.showProgress((double)1.0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        progressWriter.setProgress(1.0);
    }

    public static final class ChannelInfo {
        public int height;
        public int width;
        public int nZSlices;
        public String spaceUnits;
        public double pixelHeight;
        public double pixelWidth;
        public double pixelDepth;
        public List<long[]> offsets;
        public boolean isEnabled;
        public String bitDepth;
        public Color channelColor;
        public double unmagnifiedPixelHeight;
        public double unmagnifiedPixelWidth;
        public int tileHeight;
        public int tileWidth;
        public int channelNumber;

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("Channel " + this.channelNumber + ": \n");
            str.append(" - isEnabled: " + this.isEnabled + "\n");
            str.append(" - width: " + this.width + "\n");
            str.append(" - height: " + this.height + "\n");
            str.append(" - tile width: " + this.tileWidth + "\n");
            str.append(" - tile height: " + this.tileHeight + "\n");
            str.append(" - NZSlices: " + this.nZSlices + "\n");
            str.append(" - unmagnifiedPixelWidth: " + this.unmagnifiedPixelWidth + "\n");
            str.append(" - unmagnifiedPixelHeight: " + this.unmagnifiedPixelHeight + "\n");
            str.append(" - color: " + this.channelColor + "\n");
            str.append(" - bitDepth: " + this.bitDepth + "\n");
            str.append(" - has " + this.offsets.size() + " fields:\n");
            int index = 1;
            for (long[] offset : this.offsets) {
                str.append("    " + index++ + ": x = " + offset[0] + ", y = " + offset[1] + "\n");
            }
            str.append(" - spatial calibration:\n");
            str.append("    dx = " + this.pixelWidth + " " + this.spaceUnits + "\n");
            str.append("    dy = " + this.pixelHeight + " " + this.spaceUnits + "\n");
            str.append("    dz = " + this.pixelDepth + " " + this.spaceUnits + "\n");
            return str.toString();
        }
    }
}

