/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import ij.WindowManager;
import ij.io.FileInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.imagearchive.lsm.reader.info.ImageDirectory;
import org.imagearchive.lsm.reader.info.LSMFileInfo;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.gui.ListBoxImage;
import org.imagearchive.lsm.toolbox.info.CZLSMInfoExtended;

public class SelectImageDialog
extends JDialog {
    private JPanel panel;
    private JList imageList;
    private final MasterModel masterModel = MasterModel.getMasterModel();
    private Vector<ListBoxImage> fileInfos;
    private Vector<String> images;
    private String label = "Please select:";
    private JButton okButton;
    private JButton cancelButton;
    private int returnVal = -1;
    private int[] values = null;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    private boolean channel = false;

    public SelectImageDialog(JFrame parent, String label, boolean channel, byte filter) {
        super((Frame)parent, true);
        this.label = label;
        this.channel = channel;
        this.initiliazeGUI();
        this.fillList(filter);
    }

    public SelectImageDialog(JFrame parent, String label, boolean channel) {
        super((Frame)parent, true);
        this.label = label;
        this.channel = channel;
        this.initiliazeGUI();
        this.fillList(MasterModel.NONE);
    }

    private void initiliazeGUI() {
        this.panel = new JPanel();
        this.imageList = new JList();
        this.okButton = new JButton("OK", new ImageIcon(this.getClass().getResource("images/ok.png")));
        this.cancelButton = new JButton("Cancel", new ImageIcon(this.getClass().getResource("images/cancel.png")));
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.setSize(new Dimension(200, 300));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.weightx = 0.25;
        constraints.weighty = 0.25;
        this.panel.add((Component)new JLabel(this.label), constraints);
        constraints.gridy = 1;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.panel.add((Component)this.imageList, constraints);
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.weightx = 0.25;
        constraints.weighty = 0.25;
        constraints.fill = 2;
        this.panel.add((Component)this.okButton, constraints);
        constraints.gridx = 1;
        this.panel.add((Component)this.cancelButton, constraints);
        this.getContentPane().add(this.panel);
        this.setTitle("Select...");
        if (this.channel) {
            this.imageList.setSelectionMode(2);
        } else {
            this.imageList.setSelectionMode(0);
        }
        this.setListeners();
        this.centerWindow();
    }

    private void fillList(byte filter) {
        int[] imagesIDs = WindowManager.getIDList();
        this.images = new Vector();
        this.fileInfos = new Vector();
        if (imagesIDs == null) {
            return;
        }
        for (int i = 0; i < imagesIDs.length; ++i) {
            if (WindowManager.getImage((int)imagesIDs[i]) == null) continue;
            FileInfo fi = WindowManager.getImage((int)imagesIDs[i]).getOriginalFileInfo();
            boolean add = false;
            if (fi == null || !(fi instanceof LSMFileInfo)) continue;
            LSMFileInfo lsm = (LSMFileInfo)fi;
            CZLSMInfoExtended cz = (CZLSMInfoExtended)((Object)((ImageDirectory)lsm.imageDirectories.get((int)0)).TIF_CZ_LSMINFO);
            if (filter == MasterModel.TIME && cz.DimensionTime > 1L) {
                add = true;
            }
            if (filter == MasterModel.DEPTH && cz.DimensionZ > 1L) {
                add = true;
            }
            if (filter == MasterModel.CHANNEL && cz.SpectralScan == 1 && cz.channelWavelength != null && cz.channelWavelength.Channels >= 1L) {
                add = true;
            }
            if (filter == MasterModel.NONE) {
                add = true;
            }
            if (!add) continue;
            this.images.add(lsm.fileName);
            this.fileInfos.add(new ListBoxImage(lsm.fileName, lsm, imagesIDs[i]));
        }
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(this.images);
        this.imageList.setModel(cbm);
    }

    private void setListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectImageDialog.this.imageList.getModel().getSize() == 0) {
                    return;
                }
                int[] selectedIndices = SelectImageDialog.this.imageList.getSelectedIndices();
                SelectImageDialog.access$102(SelectImageDialog.this, new int[selectedIndices.length]);
                for (int i = 0; i < selectedIndices.length; ++i) {
                    ListBoxImage im = (ListBoxImage)SelectImageDialog.this.fileInfos.get(selectedIndices[i]);
                    ((SelectImageDialog)SelectImageDialog.this).values[i] = im.imageIndex;
                }
                SelectImageDialog.this.returnVal = 0;
                SelectImageDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectImageDialog.this.returnVal = 2;
                SelectImageDialog.this.setVisible(false);
            }
        });
    }

    public int showDialog() {
        this.setVisible(true);
        this.dispose();
        return this.returnVal;
    }

    public int[] getSelected() {
        return this.values;
    }

    public void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    static /* synthetic */ int[] access$102(SelectImageDialog x0, int[] x1) {
        x0.values = x1;
        return x1;
    }
}

