/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

import ij.IJ;
import ij.ImagePlus;

public abstract class Metrics {
    protected ImagePlus originalLabels;
    protected ImagePlus proposedLabels;
    protected boolean verbose = true;

    public Metrics(ImagePlus originalLabels, ImagePlus proposedLabels) {
        this.originalLabels = originalLabels;
        this.proposedLabels = proposedLabels;
    }

    public abstract double getMetricValue(double var1);

    public void setVerboseMode(boolean verbose) {
        this.verbose = verbose;
    }

    public double getMinimumMetricValue(double minThreshold, double maxThreshold, double stepThreshold) {
        double min = 1.0;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            double error;
            if (this.verbose) {
                IJ.log((String)("  Calculating metric value for threshold " + String.format("%.3f", th) + "..."));
            }
            if (min > (error = this.getMetricValue(th))) {
                min = error;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    Error = " + error));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Minimum metric value = " + min + ", with threshold = " + bestTh + " **\n"));
        }
        return min;
    }
}

