/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.ConverterResources;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.converters.Saver;
import weka.core.converters.StreamTokenizerUtils;
import weka.core.converters.URLSourcedLoader;

public class ConverterUtils
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -2460855349276148760L;
    protected static Hashtable<String, List<String>> m_FileLoaders;
    protected static Hashtable<String, List<String>> m_URLFileLoaders;
    protected static Hashtable<String, List<String>> m_FileSavers;

    public static void initialize() {
        ConverterResources.initialize();
        m_FileLoaders = ConverterResources.getFileLoaders();
        m_URLFileLoaders = ConverterResources.getURLFileLoaders();
        m_FileSavers = ConverterResources.getFileSavers();
    }

    public static void getFirstToken(StreamTokenizer tokenizer) throws IOException {
        StreamTokenizerUtils.getFirstToken(tokenizer);
    }

    public static void getToken(StreamTokenizer tokenizer) throws IOException {
        StreamTokenizerUtils.getToken(tokenizer);
    }

    public static void errms(StreamTokenizer tokenizer, String theMsg) throws IOException {
        throw new IOException(theMsg + ", read " + tokenizer.toString());
    }

    protected static Vector<String> getConverters(Hashtable<String, List<String>> ht) {
        Vector<String> result = new Vector<String>();
        Enumeration<List<String>> enm = ht.elements();
        while (enm.hasMoreElements()) {
            List<String> convs = enm.nextElement();
            for (String converter : convs) {
                if (result.contains(converter)) continue;
                result.add(converter);
            }
        }
        Collections.sort(result);
        return result;
    }

    protected static Object getConverterForFile(String filename, Hashtable<String, List<String>> ht) {
        Object result = null;
        int index = filename.lastIndexOf(46);
        if (index > -1) {
            String extension = filename.substring(index).toLowerCase();
            result = ConverterUtils.getConverterForExtension(extension, ht);
            if (extension.equals(".gz") && result == null) {
                index = filename.lastIndexOf(46, index - 1);
                extension = filename.substring(index).toLowerCase();
                result = ConverterUtils.getConverterForExtension(extension, ht);
            }
        }
        return result;
    }

    protected static Object getConverterForExtension(String extension, Hashtable<String, List<String>> ht) {
        Object result = null;
        List<String> classnames = ht.get(extension);
        if (classnames != null && !classnames.isEmpty()) {
            try {
                result = WekaPackageClassLoaderManager.forName(classnames.get(0)).newInstance();
            }
            catch (Exception e) {
                result = null;
                e.printStackTrace();
            }
        }
        return result;
    }

    protected static List<Object> getConvertersForFile(String filename, Hashtable<String, List<String>> ht) {
        List<Object> result = new ArrayList<Object>();
        int index = filename.lastIndexOf(46);
        if (index > -1) {
            String extension = filename.substring(index).toLowerCase();
            result = ConverterUtils.getConvertersForExtension(extension, ht);
            if (extension.equals(".gz") && result == null) {
                index = filename.lastIndexOf(46, index - 1);
                extension = filename.substring(index).toLowerCase();
                result = ConverterUtils.getConvertersForExtension(extension, ht);
            }
        }
        return result;
    }

    protected static List<Object> getConvertersForExtension(String extension, Hashtable<String, List<String>> ht) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<String> classnames = ht.get(extension);
        if (classnames != null && !classnames.isEmpty()) {
            for (String classname : classnames) {
                try {
                    result.add(WekaPackageClassLoaderManager.forName(classnames.get(0)).newInstance());
                }
                catch (Exception e) {
                    result = null;
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static Vector<String> getFileLoaders() {
        return ConverterUtils.getConverters(m_FileLoaders);
    }

    public static AbstractFileLoader getLoaderForFile(String filename) {
        return (AbstractFileLoader)ConverterUtils.getConverterForFile(filename, m_FileLoaders);
    }

    public static List<AbstractFileLoader> getLoadersForFile(String filename) {
        List<Object> objects = ConverterUtils.getConvertersForFile(filename, m_FileLoaders);
        ArrayList<AbstractFileLoader> result = new ArrayList<AbstractFileLoader>();
        for (Object object : objects) {
            result.add((AbstractFileLoader)object);
        }
        return result;
    }

    public static AbstractFileLoader getLoaderForFile(File file) {
        return ConverterUtils.getLoaderForFile(file.getAbsolutePath());
    }

    public static List<AbstractFileLoader> getLoadersForFile(File file) {
        return ConverterUtils.getLoadersForFile(file.getAbsolutePath());
    }

    public static AbstractFileLoader getLoaderForExtension(String extension) {
        return (AbstractFileLoader)ConverterUtils.getConverterForExtension(extension, m_FileLoaders);
    }

    public static List<AbstractFileLoader> getLoadersForExtension(String extension) {
        List<Object> objects = ConverterUtils.getConvertersForExtension(extension, m_FileLoaders);
        ArrayList<AbstractFileLoader> result = new ArrayList<AbstractFileLoader>();
        for (Object object : objects) {
            result.add((AbstractFileLoader)object);
        }
        return result;
    }

    public static Vector<String> getURLFileLoaders() {
        return ConverterUtils.getConverters(m_URLFileLoaders);
    }

    public static AbstractFileLoader getURLLoaderForFile(String filename) {
        return (AbstractFileLoader)ConverterUtils.getConverterForFile(filename, m_URLFileLoaders);
    }

    public static List<AbstractFileLoader> getURLLoadersForFile(String filename) {
        List<Object> objects = ConverterUtils.getConvertersForFile(filename, m_URLFileLoaders);
        ArrayList<AbstractFileLoader> result = new ArrayList<AbstractFileLoader>();
        for (Object object : objects) {
            result.add((AbstractFileLoader)object);
        }
        return result;
    }

    public static AbstractFileLoader getURLLoaderForFile(File file) {
        return ConverterUtils.getURLLoaderForFile(file.getAbsolutePath());
    }

    public static List<AbstractFileLoader> getURLLoadersForFile(File file) {
        return ConverterUtils.getURLLoadersForFile(file.getAbsolutePath());
    }

    public static AbstractFileLoader getURLLoaderForExtension(String extension) {
        return (AbstractFileLoader)ConverterUtils.getConverterForExtension(extension, m_URLFileLoaders);
    }

    public static List<AbstractFileLoader> getURLLoadersForExtension(String extension) {
        List<Object> objects = ConverterUtils.getConvertersForExtension(extension, m_URLFileLoaders);
        ArrayList<AbstractFileLoader> result = new ArrayList<AbstractFileLoader>();
        for (Object object : objects) {
            result.add((AbstractFileLoader)object);
        }
        return result;
    }

    public static Vector<String> getFileSavers() {
        return ConverterUtils.getConverters(m_FileSavers);
    }

    public static AbstractFileSaver getSaverForFile(String filename) {
        return (AbstractFileSaver)ConverterUtils.getConverterForFile(filename, m_FileSavers);
    }

    public static List<AbstractFileSaver> getSaversForFile(String filename) {
        List<Object> objects = ConverterUtils.getConvertersForFile(filename, m_FileSavers);
        ArrayList<AbstractFileSaver> result = new ArrayList<AbstractFileSaver>();
        for (Object object : objects) {
            result.add((AbstractFileSaver)object);
        }
        return result;
    }

    public static AbstractFileSaver getSaverForFile(File file) {
        return ConverterUtils.getSaverForFile(file.getAbsolutePath());
    }

    public static List<AbstractFileSaver> getSaversForFile(File file) {
        return ConverterUtils.getSaversForFile(file.getAbsolutePath());
    }

    public static AbstractFileSaver getSaverForExtension(String extension) {
        return (AbstractFileSaver)ConverterUtils.getConverterForExtension(extension, m_FileSavers);
    }

    public static List<AbstractFileSaver> getSaversForExtension(String extension) {
        List<Object> objects = ConverterUtils.getConvertersForExtension(extension, m_FileSavers);
        ArrayList<AbstractFileSaver> result = new ArrayList<AbstractFileSaver>();
        for (Object object : objects) {
            result.add((AbstractFileSaver)object);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15656 $");
    }

    static {
        ConverterUtils.initialize();
    }

    public static class DataSink
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -1504966891136411204L;
        protected Saver m_Saver = null;
        protected OutputStream m_Stream = null;

        public DataSink(String filename) throws Exception {
            this.m_Stream = null;
            this.m_Saver = DataSource.isArff(filename) ? new ArffSaver() : ConverterUtils.getSaverForFile(filename);
            ((AbstractFileSaver)this.m_Saver).setFile(new File(filename));
        }

        public DataSink(Saver saver) {
            this.m_Saver = saver;
            this.m_Stream = null;
        }

        public DataSink(OutputStream stream) {
            this.m_Saver = null;
            this.m_Stream = stream;
        }

        public void write(Instances data) throws Exception {
            if (this.m_Saver != null) {
                this.m_Saver.setInstances(data);
                this.m_Saver.writeBatch();
            } else {
                this.m_Stream.write(data.toString().getBytes());
                this.m_Stream.flush();
            }
        }

        public static void write(String filename, Instances data) throws Exception {
            DataSink sink = new DataSink(filename);
            sink.write(data);
        }

        public static void write(Saver saver, Instances data) throws Exception {
            DataSink sink = new DataSink(saver);
            sink.write(data);
        }

        public static void write(OutputStream stream, Instances data) throws Exception {
            DataSink sink = new DataSink(stream);
            sink.write(data);
        }

        public static void main(String[] args) throws Exception {
            if (args.length != 2) {
                System.out.println("\nUsage: " + DataSource.class.getName() + " <input-file> <output-file>\n");
                System.exit(1);
            }
            Instances data = DataSource.read(args[0]);
            DataSink.write(args[1], data);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15656 $");
        }
    }

    public static class DataSource
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -613122395928757332L;
        protected File m_File;
        protected URL m_URL;
        protected Loader m_Loader;
        protected boolean m_Incremental;
        protected int m_BatchCounter;
        protected Instance m_IncrementalBuffer;
        protected Instances m_BatchBuffer;

        public DataSource(String location) throws Exception {
            if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("ftp://") || location.startsWith("file://")) {
                this.m_URL = new URL(location);
            } else {
                this.m_File = new File(location);
            }
            if (DataSource.isArff(location)) {
                this.m_Loader = new ArffLoader();
            } else {
                this.m_Loader = this.m_File != null ? ConverterUtils.getLoaderForFile(location) : ConverterUtils.getURLLoaderForFile(location);
                if (this.m_Loader == null) {
                    throw new IllegalArgumentException("No suitable converter found for '" + location + "'!");
                }
            }
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.reset();
        }

        public DataSource(Instances inst) {
            this.m_BatchBuffer = inst;
            this.m_Loader = null;
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = false;
        }

        public DataSource(Loader loader) {
            this.m_BatchBuffer = null;
            this.m_Loader = loader;
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.initBatchBuffer();
        }

        public DataSource(InputStream stream) {
            this.m_BatchBuffer = null;
            this.m_Loader = new ArffLoader();
            try {
                this.m_Loader.setSource(stream);
            }
            catch (Exception e) {
                this.m_Loader = null;
            }
            this.m_File = null;
            this.m_URL = null;
            this.m_Incremental = this.m_Loader instanceof IncrementalConverter;
            this.initBatchBuffer();
        }

        protected void initBatchBuffer() {
            try {
                this.m_BatchBuffer = !this.isIncremental() ? this.m_Loader.getDataSet() : null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static boolean isArff(String location) {
            return location.toLowerCase().endsWith(ArffLoader.FILE_EXTENSION.toLowerCase()) || location.toLowerCase().endsWith(ArffLoader.FILE_EXTENSION_COMPRESSED.toLowerCase());
        }

        public boolean isIncremental() {
            return this.m_Incremental;
        }

        public Loader getLoader() {
            return this.m_Loader;
        }

        public Instances getDataSet() throws Exception {
            Instances result = null;
            this.reset();
            try {
                result = this.m_BatchBuffer == null ? this.m_Loader.getDataSet() : this.m_BatchBuffer;
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
            return result;
        }

        public Instances getDataSet(int classIndex) throws Exception {
            Instances result = this.getDataSet();
            if (result != null) {
                result.setClassIndex(classIndex);
            }
            return result;
        }

        public void reset() throws Exception {
            if (this.m_File != null) {
                ((AbstractFileLoader)this.m_Loader).setFile(this.m_File);
            } else if (this.m_URL != null) {
                ((URLSourcedLoader)((Object)this.m_Loader)).setURL(this.m_URL.toString());
            } else if (this.m_Loader != null) {
                this.m_Loader.reset();
            }
            this.m_BatchCounter = 0;
            this.m_IncrementalBuffer = null;
            if (this.m_Loader != null) {
                this.m_BatchBuffer = !this.isIncremental() ? this.m_Loader.getDataSet() : null;
            }
        }

        public Instances getStructure() throws Exception {
            if (this.m_BatchBuffer == null) {
                return this.m_Loader.getStructure();
            }
            return new Instances(this.m_BatchBuffer, 0);
        }

        public Instances getStructure(int classIndex) throws Exception {
            Instances result = this.getStructure();
            if (result != null) {
                result.setClassIndex(classIndex);
            }
            return result;
        }

        public boolean hasMoreElements(Instances structure) {
            boolean result = false;
            if (this.isIncremental()) {
                if (this.m_IncrementalBuffer != null) {
                    result = true;
                } else {
                    try {
                        this.m_IncrementalBuffer = this.m_Loader.getNextInstance(structure);
                        result = this.m_IncrementalBuffer != null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        result = false;
                    }
                }
            } else {
                result = this.m_BatchCounter < this.m_BatchBuffer.numInstances();
            }
            return result;
        }

        public Instance nextElement(Instances dataset) {
            Instance result = null;
            if (this.isIncremental()) {
                if (this.m_IncrementalBuffer != null) {
                    result = this.m_IncrementalBuffer;
                    this.m_IncrementalBuffer = null;
                } else {
                    try {
                        result = this.m_Loader.getNextInstance(dataset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        result = null;
                    }
                }
            } else if (this.m_BatchCounter < this.m_BatchBuffer.numInstances()) {
                result = this.m_BatchBuffer.instance(this.m_BatchCounter);
                ++this.m_BatchCounter;
            }
            if (result != null) {
                result.setDataset(dataset);
            }
            return result;
        }

        public static Instances read(String location) throws Exception {
            DataSource source = new DataSource(location);
            Instances result = source.getDataSet();
            return result;
        }

        public static Instances read(InputStream stream) throws Exception {
            DataSource source = new DataSource(stream);
            Instances result = source.getDataSet();
            return result;
        }

        public static Instances read(Loader loader) throws Exception {
            DataSource source = new DataSource(loader);
            Instances result = source.getDataSet();
            return result;
        }

        public static void main(String[] args) throws Exception {
            if (args.length != 1) {
                System.out.println("\nUsage: " + DataSource.class.getName() + " <file>\n");
                System.exit(1);
            }
            DataSource loader = new DataSource(args[0]);
            System.out.println("Incremental? " + loader.isIncremental());
            System.out.println("Loader: " + loader.getLoader().getClass().getName());
            System.out.println("Data:\n");
            Instances structure = loader.getStructure();
            System.out.println(structure);
            while (loader.hasMoreElements(structure)) {
                System.out.println(loader.nextElement(structure));
            }
            Instances inst = loader.getDataSet();
            loader = new DataSource(inst);
            System.out.println("\n\nProxy-Data:\n");
            System.out.println(loader.getStructure());
            while (loader.hasMoreElements(structure)) {
                System.out.println(loader.nextElement(inst));
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 15656 $");
        }
    }
}

