/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagValueName
implements ResourceName {
    private static final PathTemplate TAG_VALUE = PathTemplate.createWithoutUrlEncoding((String)"tagValues/{tag_value}");
    private volatile Map<String, String> fieldValuesMap;
    private final String tagValue;

    @Deprecated
    protected TagValueName() {
        this.tagValue = null;
    }

    private TagValueName(Builder builder) {
        this.tagValue = (String)Preconditions.checkNotNull((Object)builder.getTagValue());
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TagValueName of(String tagValue) {
        return TagValueName.newBuilder().setTagValue(tagValue).build();
    }

    public static String format(String tagValue) {
        return TagValueName.newBuilder().setTagValue(tagValue).build().toString();
    }

    public static TagValueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TAG_VALUE.validatedMatch(formattedString, "TagValueName.parse: formattedString not in valid format");
        return TagValueName.of((String)matchMap.get("tag_value"));
    }

    public static List<TagValueName> parseList(List<String> formattedStrings) {
        ArrayList<TagValueName> list = new ArrayList<TagValueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagValueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagValueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagValueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TAG_VALUE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagValueName tagValueName = this;
            synchronized (tagValueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.tagValue != null) {
                        fieldMapBuilder.put((Object)"tag_value", (Object)this.tagValue);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TAG_VALUE.instantiate(new String[]{"tag_value", this.tagValue});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TagValueName that = (TagValueName)o;
            return Objects.equals(this.tagValue, that.tagValue);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.tagValue);
    }

    public static class Builder {
        private String tagValue;

        protected Builder() {
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public Builder setTagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        private Builder(TagValueName tagValueName) {
            this.tagValue = tagValueName.tagValue;
        }

        public TagValueName build() {
            return new TagValueName(this);
        }
    }
}

