/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdService;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.overlay.ThresholdFigure;
import org.jhotdraw.draw.Figure;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;

@Plugin(type=JHotDrawAdapter.class, priority=100.0)
public class ThresholdJHotDrawAdapter
extends AbstractJHotDrawAdapter<ThresholdOverlay, ThresholdFigure> {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private ThresholdService thresholdService;

    @Override
    public boolean supports(Tool tool) {
        return false;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof ThresholdOverlay)) {
            return false;
        }
        return figure == null || figure instanceof ThresholdFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        ImageDisplay display = this.imageDisplayService.getActiveImageDisplay();
        if (display == null) {
            return null;
        }
        return this.thresholdService.getThreshold(display);
    }

    @Override
    public Figure createDefaultFigure() {
        ImageDisplay display = this.imageDisplayService.getActiveImageDisplay();
        if (display == null) {
            return null;
        }
        Dataset dataset = this.imageDisplayService.getActiveDataset();
        if (dataset == null) {
            return null;
        }
        ThresholdOverlay overlay = this.thresholdService.getThreshold(display);
        return new ThresholdFigure(display, dataset, overlay);
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<ThresholdFigure>(display, this);
    }

    @Override
    public Shape toShape(ThresholdFigure figure) {
        throw new UnsupportedOperationException("to be implemented");
    }
}

