/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.mdi;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ModalInternalFrame
extends JInternalFrame {
    public ModalInternalFrame(String title, JRootPane rootPane, Component desktop, JOptionPane pane) {
        super(title);
        final JPanel glass = new JPanel();
        glass.setOpaque(false);
        MouseInputAdapter adapter = new MouseInputAdapter(){};
        glass.addMouseListener(adapter);
        glass.addMouseMotionListener(adapter);
        this.getContentPane().add((Component)pane, "Center");
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (ModalInternalFrame.this.isVisible() && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                    try {
                        ModalInternalFrame.this.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    ModalInternalFrame.this.setVisible(false);
                    glass.setVisible(false);
                }
            }
        };
        pane.addPropertyChangeListener(pcl);
        this.putClientProperty("JInternalFrame.frameType", "optionDialog");
        Dimension size = this.getPreferredSize();
        Dimension rootSize = desktop.getSize();
        this.setBounds((rootSize.width - size.width) / 2, (rootSize.height - size.height) / 2, size.width, size.height);
        desktop.validate();
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        glass.add(this);
        rootPane.setGlassPane(glass);
        glass.setVisible(true);
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.startModal();
        } else {
            this.stopModal();
        }
    }

    private synchronized void startModal() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("Unable to dispatch: " + event);
                }
            } else {
                while (this.isVisible()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void stopModal() {
        this.notifyAll();
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Modal Internal Frame");
        frame.setDefaultCloseOperation(3);
        final JDesktopPane desktop = new JDesktopPane();
        ActionListener showModal = new ActionListener(){
            Integer ZERO = new Integer(0);
            Integer ONE = new Integer(1);

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane optionPane = new JOptionPane("Print?", 3, 0);
                ModalInternalFrame modal = new ModalInternalFrame("Really Modal", frame.getRootPane(), desktop, optionPane);
                ((JComponent)modal).setVisible(true);
                Object value = optionPane.getValue();
                if (value.equals(this.ZERO)) {
                    System.out.println("Selected Yes");
                } else if (value.equals(this.ONE)) {
                    System.out.println("Selected No");
                } else {
                    System.err.println("Input Error");
                }
            }
        };
        JInternalFrame internal = new JInternalFrame("Opener");
        desktop.add(internal);
        JButton button = new JButton("Open");
        button.addActionListener(showModal);
        Container iContent = internal.getContentPane();
        iContent.add((Component)button, "Center");
        internal.setBounds(25, 25, 200, 100);
        internal.setVisible(true);
        Container content = frame.getContentPane();
        content.add((Component)desktop, "Center");
        frame.setSize(500, 300);
        frame.setVisible(true);
    }
}

