/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.scijava.object.ObjectService;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.ObjectWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingObjectWidget
extends SwingInputWidget<Object>
implements ActionListener,
ObjectWidget<JPanel> {
    private JComboBox<Object> comboBox;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    public Object getValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        String[] choices = model.getChoices();
        this.comboBox = choices != null && choices.length > 0 ? new JComboBox<String>(choices) : new JComboBox<Object>(model.getObjectPool().toArray());
        this.setToolTip(this.comboBox);
        this.getComponent().add(this.comboBox);
        this.comboBox.addActionListener(this);
        this.comboBox.setRenderer(new NamedObjectCellRenderer());
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && (model.getChoices() != null && model.getChoices().length > 0 || model.getObjectPool() != null && model.getObjectPool().size() > 0);
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        if (value == this.comboBox.getSelectedItem()) {
            return;
        }
        this.comboBox.setSelectedItem(value);
    }

    private class NamedObjectCellRenderer
    implements ListCellRenderer<Object> {
        private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private NamedObjectCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            renderer.setText(value == null ? "" : ((ObjectService)SwingObjectWidget.this.context().service(ObjectService.class)).getName(value));
            renderer.setToolTipText(value == null ? null : value.toString());
            return renderer;
        }
    }
}

