/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ini.trakem2.utils.CachingThread;

public final class P {
    public static final int[] blend(byte[] pi, byte[] pm) {
        int[] p = CachingThread.getOrCreateIntArray(pi.length);
        for (int i = 0; i < p.length; ++i) {
            int c = pi[i] & 0xFF;
            p[i] = (pm[i] & 0xFF) << 24 | c << 16 | c << 8 | c;
        }
        return p;
    }

    public static final int[] blendPre(byte[] pi, byte[] pm) {
        int[] p = CachingThread.getOrCreateIntArray(pi.length);
        for (int i = 0; i < p.length; ++i) {
            int a = pm[i] & 0xFF;
            double K = (double)a / 255.0;
            int c = (int)((double)(pi[i] & 0xFF) * K + 0.5);
            p[i] = a << 24 | c << 16 | c << 8 | c;
        }
        return p;
    }

    public static final int[] blend(byte[] r, byte[] g, byte[] b, byte[] a) {
        int[] p = CachingThread.getOrCreateIntArray(r.length);
        for (int i = 0; i < p.length; ++i) {
            p[i] = (a[i] & 0xFF) << 24 | (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
        }
        return p;
    }

    public static final int[] blendPre(byte[] r, byte[] g, byte[] b, byte[] alpha) {
        int[] p = CachingThread.getOrCreateIntArray(r.length);
        for (int i = 0; i < p.length; ++i) {
            int a = alpha[i] & 0xFF;
            double K = (double)a / 255.0;
            p[i] = a << 24 | (int)((double)(r[i] & 0xFF) * K + 0.5) << 16 | (int)((double)(g[i] & 0xFF) * K + 0.5) << 8 | (int)((double)(b[i] & 0xFF) * K + 0.5);
        }
        return p;
    }

    public static final int[] blend(byte[] r, byte[] g, byte[] b) {
        int[] p = CachingThread.getOrCreateIntArray(r.length);
        for (int i = 0; i < p.length; ++i) {
            p[i] = (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
        }
        return p;
    }

    public static final byte[] merge(byte[] alpha, byte[] outside) {
        if (null == outside) {
            return alpha;
        }
        for (int i = 0; i < alpha.length; ++i) {
            alpha[i] = -1 == outside[i] ? alpha[i] : (byte)0;
        }
        return alpha;
    }

    public static final byte[][] asRGBABytes(int[] pixels, byte[] alpha, byte[] outside) {
        P.merge(alpha, outside);
        byte[] r = CachingThread.getOrCreateByteArray(pixels.length);
        byte[] g = CachingThread.getOrCreateByteArray(pixels.length);
        byte[] b = CachingThread.getOrCreateByteArray(pixels.length);
        for (int i = 0; i < pixels.length; ++i) {
            int x = pixels[i];
            r[i] = (byte)(x >> 16 & 0xFF);
            g[i] = (byte)(x >> 8 & 0xFF);
            b[i] = (byte)(x & 0xFF);
        }
        return new byte[][]{r, g, b, alpha};
    }

    public static byte[][] asRGBBytes(int[] pix) {
        byte[] r = CachingThread.getOrCreateByteArray(pix.length);
        byte[] g = CachingThread.getOrCreateByteArray(pix.length);
        byte[] b = CachingThread.getOrCreateByteArray(pix.length);
        for (int i = 0; i < pix.length; ++i) {
            int x = pix[i];
            r[i] = (byte)(x >> 16 & 0xFF);
            g[i] = (byte)(x >> 8 & 0xFF);
            b[i] = (byte)(x & 0xFF);
        }
        return new byte[][]{r, g, b};
    }
}

