/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ij.IJ;
import ij.gui.GenericDialog;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.tree.DNDTree;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.tree.RenameThingStep;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class LayerTree
extends DNDTree
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultMutableTreeNode selected_node = null;
    private static final Color FRONT_LAYER_COLOR = new Color(1.0f, 1.0f, 0.4f, 0.5f);

    public LayerTree(Project project, LayerThing root) {
        super(project, DNDTree.makeNode(root), new Color(230, 235, 255));
        this.setEditable(false);
        this.addMouseListener(this);
        this.getSelectionModel().setSelectionMode(4);
    }

    private JPopupMenu getPopupMenu(DefaultMutableTreeNode node) {
        Object ob = node.getUserObject();
        LayerThing thing = null;
        if (!(ob instanceof LayerThing)) {
            return null;
        }
        thing = (LayerThing)ob;
        JMenuItem[] item = thing.getPopupItems(this);
        if (0 == item.length) {
            return null;
        }
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < item.length; ++i) {
            if (null == item[i] || "" == item[i].getText()) {
                popup.addSeparator();
                continue;
            }
            popup.add(item[i]);
        }
        return popup;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Object source = me.getSource();
        if (!source.equals(this) || !this.project.isInputEnabled()) {
            return;
        }
        if (!Utils.isPopupTrigger(me) && (me.isShiftDown() || !IJ.isMacOSX() && me.isControlDown())) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        TreePath[] paths = this.getSelectionPaths();
        if (null != paths && paths.length > 1) {
            if (Utils.isPopupTrigger(me)) {
                String type_first = ((LayerThing)((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject()).getType();
                for (int i = 1; i < paths.length; ++i) {
                    String type = ((LayerThing)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject()).getType();
                    if (type.equals(type_first)) continue;
                    Utils.showMessage("All selected items must be of the same type for operations on multiple items.");
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                JMenuItem item = null;
                if (type_first.equals("layer")) {
                    item = new JMenuItem("Reverse layer Z coords");
                    item.addActionListener(this);
                    popup.add(item);
                    item = new JMenuItem("Translate layers in Z...");
                    item.addActionListener(this);
                    popup.add(item);
                    item = new JMenuItem("Scale Z and thickness...");
                    item.addActionListener(this);
                    popup.add(item);
                    item = new JMenuItem("Delete...");
                    item.addActionListener(this);
                    popup.add(item);
                }
                if (popup.getSubElements().length > 0) {
                    popup.show(this, x, y);
                }
            }
            this.selected_node = null;
            return;
        }
        TreePath path = this.getPathForLocation(x, y);
        if (null == path) {
            return;
        }
        this.setSelectionPath(path);
        this.selected_node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (2 == me.getClickCount() && !Utils.isPopupTrigger(me) && 1 == me.getButton()) {
            LayerThing thing = (LayerThing)this.selected_node.getUserObject();
            DBObject ob = (DBObject)thing.getObject();
            if (thing.getType().toLowerCase().replace('_', ' ').equals("layer set") && null == ((LayerSet)ob).getParent()) {
                return;
            }
            Display.createDisplay(ob.getProject(), thing.getType().toLowerCase().equals("layer") ? (Layer)ob : ((LayerSet)ob).getParent());
            return;
        }
        if (Utils.isPopupTrigger(me)) {
            JPopupMenu popup = this.getPopupMenu(this.selected_node);
            if (null == popup) {
                return;
            }
            popup.show(this, x, y);
            return;
        }
    }

    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        int i;
        TreePath[] paths;
        block92: {
            int i2;
            LayerSet ls;
            Layer[] layer;
            block91: {
                try {
                    Layer layer2;
                    String command = ae.getActionCommand();
                    paths = this.getSelectionPaths();
                    if (null != paths && paths.length > 1) {
                        if (command.equals("Reverse layer Z coords")) {
                            layer = new Layer[paths.length];
                            ls = null;
                            break block91;
                        }
                        if (command.equals("Translate layers in Z...")) {
                            GenericDialog gd = ControlWindow.makeGenericDialog("Range");
                            gd.addMessage("Translate selected range in the Z axis:");
                            gd.addNumericField("by: ", 0.0, 4);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            double dz = gd.getNextNumber();
                            if (Double.isNaN(dz)) {
                                Utils.showMessage("Invalid number");
                                return;
                            }
                            HashSet<LayerSet> hs_parents = new HashSet<LayerSet>();
                            for (int i3 = 0; i3 < paths.length; ++i3) {
                                Layer layer3 = (Layer)((LayerThing)((DefaultMutableTreeNode)paths[i3].getLastPathComponent()).getUserObject()).getObject();
                                layer3.setZ(layer3.getZ() + dz);
                                hs_parents.add(layer3.getParent());
                            }
                            for (LayerSet layerSet : hs_parents) {
                                this.updateList(layerSet);
                            }
                            ProjectThing root_pt = this.project.getRootProjectThing();
                            Iterator<ProjectThing> iterator = root_pt.findChildrenOfType("profile_list").iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    this.project.getProjectTree().updateUILater();
                                    return;
                                }
                                ProjectThing pt = iterator.next();
                                pt.fixZOrdering();
                                this.project.getProjectTree().updateList(pt);
                            }
                        }
                        if (command.equals("Delete...")) {
                            if (!Utils.check("Really remove all selected layers?")) {
                                return;
                            }
                            i = 0;
                            break block92;
                        } else {
                            if (!command.equals("Scale Z and thickness...")) {
                                Utils.showMessage("Don't know what to do with command " + command + " for multiple selected nodes");
                                return;
                            }
                            GenericDialog gd = new GenericDialog("Scale Z");
                            gd.addNumericField("scale: ", 1.0, 2);
                            gd.showDialog();
                            double scale = gd.getNextNumber();
                            if (Double.isNaN(scale) || 0.0 == scale) {
                                Utils.showMessage("Imvalid scaling factor: " + scale);
                                return;
                            }
                            int i4 = 0;
                            while (true) {
                                if (i4 >= paths.length) {
                                    this.updateUILater();
                                    return;
                                }
                                DefaultMutableTreeNode lnode = (DefaultMutableTreeNode)paths[i4].getLastPathComponent();
                                LayerThing layerThing = (LayerThing)lnode.getUserObject();
                                Layer layer4 = (Layer)layerThing.getObject();
                                layer4.setZ(layer4.getZ() * scale);
                                layer4.setThickness(layer4.getThickness() * scale);
                                ++i4;
                            }
                        }
                    }
                    if (null == this.selected_node) {
                        return;
                    }
                    LayerThing thing = (LayerThing)this.selected_node.getUserObject();
                    LayerThing new_thing = null;
                    TemplateThing tt = null;
                    DBObject ob = null;
                    int i_position = -1;
                    if (command.startsWith("new ")) {
                        String string = command.substring(4).toLowerCase();
                        if (string.equals("layer")) {
                            LayerSet set = (LayerSet)thing.getObject();
                            Layer new_layer = Layer.create(thing.getProject(), set);
                            if (null == new_layer) {
                                return;
                            }
                            tt = thing.getChildTemplate("layer");
                            ob = new_layer;
                            Display.updateTitle(set);
                        } else {
                            if (!string.equals("layer set")) {
                                Utils.log("LayerTree.actionPerformed: don't know what to do with the command: " + command);
                                return;
                            }
                            layer2 = (Layer)thing.getObject();
                            LayerSet new_set = layer2.getParent().create(layer2);
                            if (null == new_set) {
                                return;
                            }
                            layer2.add(new_set);
                            tt = thing.getChildTemplate("layer set");
                            ob = new_set;
                            i_position = this.selected_node.getChildCount();
                            Display.update(layer2);
                        }
                    } else {
                        if (command.equals("many new layers...")) {
                            LayerSet layerSet = (LayerSet)thing.getObject();
                            List<Layer> layers = Layer.createMany(layerSet.getProject(), layerSet);
                            if (null == layers) {
                                return;
                            }
                            Iterator<Layer> new_set = layers.iterator();
                            while (true) {
                                if (!new_set.hasNext()) {
                                    Display.updateTitle(layerSet);
                                    return;
                                }
                                Layer la = new_set.next();
                                this.addLayer(layerSet, la);
                            }
                        }
                        if (command.equals("Show")) {
                            DBObject dBObject = (DBObject)thing.getObject();
                            if (thing.getType().equals("layer_set") && null == ((LayerSet)dBObject).getParent()) {
                                return;
                            }
                            Display.createDisplay(dBObject.getProject(), thing.getType().equals("layer") ? (Layer)dBObject : ((LayerSet)dBObject).getParent());
                            return;
                        }
                        if (command.equals("Show centered in Display")) {
                            LayerSet layerSet = (LayerSet)thing.getObject();
                            Display.showCentered(layerSet.getParent(), layerSet, false, false);
                        } else {
                            if (command.equals("Delete...")) {
                                this.remove(true, thing, this.selected_node);
                                return;
                            }
                            if (command.equals("Import stack...")) {
                                if (thing.getObject() instanceof LayerSet) {
                                    LayerSet layerSet = (LayerSet)thing.getObject();
                                    layer2 = null;
                                    if (0 != layerSet.getLayers().size()) return;
                                    layer2 = Layer.create(layerSet.getProject(), layerSet);
                                    if (null == layer2) {
                                        return;
                                    }
                                    tt = thing.getChildTemplate("Layer");
                                    ob = layer2;
                                    layer2.getProject().getLoader().importStack(layer2, null, true);
                                } else if (thing.getObject() instanceof Layer) {
                                    Layer layer5 = (Layer)thing.getObject();
                                    layer5.getProject().getLoader().importStack(layer5, null, true);
                                    return;
                                }
                            } else if (command.equals("Import grid...")) {
                                if (thing.getObject() instanceof Layer) {
                                    Layer layer6 = (Layer)thing.getObject();
                                    layer6.getProject().getLoader().importGrid(layer6);
                                }
                            } else if (command.equals("Import sequence as grid...")) {
                                if (thing.getObject() instanceof Layer) {
                                    Layer layer7 = (Layer)thing.getObject();
                                    layer7.getProject().getLoader().importSequenceAsGrid(layer7);
                                }
                            } else if (command.equals("Import from text file...")) {
                                if (thing.getObject() instanceof Layer) {
                                    Layer layer8 = (Layer)thing.getObject();
                                    layer8.getProject().getLoader().importImages(layer8);
                                }
                            } else if (command.equals("Resize LayerSet...")) {
                                if (thing.getObject() instanceof LayerSet) {
                                    LayerSet layerSet = (LayerSet)thing.getObject();
                                    GenericDialog gd = ControlWindow.makeGenericDialog("Resize LayerSet");
                                    gd.addNumericField("new width: ", (double)layerSet.getLayerWidth(), 3);
                                    gd.addNumericField("new height: ", (double)layerSet.getLayerHeight(), 3);
                                    gd.addChoice("Anchor: ", LayerSet.ANCHORS, LayerSet.ANCHORS[0]);
                                    gd.showDialog();
                                    if (gd.wasCanceled()) {
                                        return;
                                    }
                                    float new_width = (float)gd.getNextNumber();
                                    float new_height = (float)gd.getNextNumber();
                                    layerSet.setDimensions(new_width, new_height, gd.getNextChoiceIndex());
                                }
                            } else if (command.equals("Autoresize LayerSet")) {
                                if (thing.getObject() instanceof LayerSet) {
                                    LayerSet layerSet = (LayerSet)thing.getObject();
                                    layerSet.setMinimumDimensions();
                                }
                            } else {
                                ArrayList<Layer> al_layers;
                                if (command.equals("Adjust...")) {
                                    if (!(thing.getObject() instanceof Layer)) return;
                                    Layer layer9 = (Layer)thing.getObject();
                                    GenericDialog gd = ControlWindow.makeGenericDialog("Adjust Layer");
                                    gd.addNumericField("new z: ", layer9.getZ(), 4);
                                    gd.addNumericField("new thickness: ", layer9.getThickness(), 4);
                                    gd.showDialog();
                                    if (gd.wasCanceled()) {
                                        return;
                                    }
                                    double new_z = gd.getNextNumber();
                                    layer9.setThickness(gd.getNextNumber());
                                    if (new_z == layer9.getZ()) return;
                                    layer9.setZ(new_z);
                                    this.updateList(layer9.getParent());
                                    DefaultMutableTreeNode child = LayerTree.findNode(thing, this);
                                    TreePath treePath = new TreePath(child.getPath());
                                    this.scrollPathToVisible(treePath);
                                    this.setSelectionPath(treePath);
                                    return;
                                }
                                if (command.equals("Rename...")) {
                                    GenericDialog genericDialog = ControlWindow.makeGenericDialog("Rename");
                                    genericDialog.addStringField("new name: ", thing.getTitle());
                                    genericDialog.showDialog();
                                    if (genericDialog.wasCanceled()) {
                                        return;
                                    }
                                    this.project.getRootLayerSet().addUndoStep(new RenameThingStep(thing));
                                    thing.setTitle(genericDialog.getNextString());
                                    this.project.getRootLayerSet().addUndoStep(new RenameThingStep(thing));
                                } else if (command.equals("Translate layers in Z...")) {
                                    if (thing.getObject() instanceof LayerSet) {
                                        LayerSet layerSet = (LayerSet)thing.getObject();
                                        al_layers = layerSet.getLayers();
                                        String[] layer_names = new String[al_layers.size()];
                                        for (int i5 = 0; i5 < layer_names.length; ++i5) {
                                            layer_names[i5] = layerSet.getProject().findLayerThing(al_layers.get(i5)).toString();
                                        }
                                        GenericDialog gd = ControlWindow.makeGenericDialog("Range");
                                        gd.addMessage("Translate selected range in the Z axis:");
                                        gd.addChoice("from: ", layer_names, layer_names[0]);
                                        gd.addChoice("to: ", layer_names, layer_names[layer_names.length - 1]);
                                        gd.addNumericField("by: ", 0.0, 4);
                                        gd.showDialog();
                                        if (gd.wasCanceled()) {
                                            return;
                                        }
                                        double dz = gd.getNextNumber();
                                        if (Double.isNaN(dz)) {
                                            Utils.showMessage("Invalid number");
                                            return;
                                        }
                                        int i_start = gd.getNextChoiceIndex();
                                        int i_end = gd.getNextChoiceIndex();
                                        for (int i6 = i_start; i6 <= i_end; ++i6) {
                                            Layer layer10 = al_layers.get(i6);
                                            layer10.setZ(layer10.getZ() + dz);
                                        }
                                        this.updateList(layerSet);
                                    }
                                } else if (command.equals("Reverse layer Z coords...")) {
                                    if (thing.getObject() instanceof LayerSet) {
                                        LayerSet layerSet = (LayerSet)thing.getObject();
                                        al_layers = layerSet.getLayers();
                                        String[] layer_names = new String[al_layers.size()];
                                        for (int i7 = 0; i7 < layer_names.length; ++i7) {
                                            layer_names[i7] = layerSet.getProject().findLayerThing(al_layers.get(i7)).toString();
                                        }
                                        GenericDialog gd = ControlWindow.makeGenericDialog("Range");
                                        gd.addMessage("Reverse Z coordinates of selected range:");
                                        gd.addChoice("from: ", layer_names, layer_names[0]);
                                        gd.addChoice("to: ", layer_names, layer_names[layer_names.length - 1]);
                                        gd.showDialog();
                                        if (gd.wasCanceled()) {
                                            return;
                                        }
                                        int i_start = gd.getNextChoiceIndex();
                                        int i_end = gd.getNextChoiceIndex();
                                        int j = i_end;
                                        for (int i8 = i_start; i8 < i_end / 2; ++i8, --j) {
                                            Layer layer1 = al_layers.get(i8);
                                            double z1 = layer1.getZ();
                                            Layer layer22 = al_layers.get(j);
                                            layer1.setZ(layer22.getZ());
                                            layer22.setZ(z1);
                                        }
                                        this.updateList(layerSet);
                                    }
                                } else if (command.equals("Search...")) {
                                    Search.showWindow();
                                } else {
                                    if (!command.equals("Reset layer Z and thickness")) {
                                        Utils.log("LayerTree.actionPerformed: don't know what to do with the command: " + command);
                                        return;
                                    }
                                    LayerSet layerSet = (LayerSet)thing.getObject();
                                    ArrayList<Layer> layers = layerSet.getLayers();
                                    layerSet.addLayerEditedStep(layers);
                                    int i9 = 0;
                                    for (Layer la : layerSet.getLayers()) {
                                        la.setZ(i9++);
                                        la.setThickness(1.0);
                                    }
                                    layerSet.addLayerEditedStep(layers);
                                }
                            }
                        }
                    }
                    if (null == tt) {
                        return;
                    }
                    new_thing = new LayerThing(tt, thing.getProject(), ob);
                    if (-1 == i_position && new_thing.getType().equals("layer")) {
                        double iz;
                        DefaultMutableTreeNode child_node;
                        LayerThing child_thing;
                        int i10;
                        double d = ((Layer)ob).getZ();
                        int n = this.selected_node.getChildCount();
                        for (i10 = 0; i10 < n && (!(child_thing = (LayerThing)(child_node = (DefaultMutableTreeNode)this.selected_node.getChildAt(i10)).getUserObject()).getType().equals("layer") || (iz = ((Layer)child_thing.getObject()).getZ()) < d); ++i10) {
                        }
                        i_position = i10;
                    }
                    thing.addChild(new_thing);
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new_thing);
                    ((DefaultTreeModel)this.getModel()).insertNodeInto(defaultMutableTreeNode, this.selected_node, i_position);
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    this.scrollPathToVisible(treePath);
                    this.setSelectionPath(treePath);
                    if (!new_thing.getType().equals("layer set")) return;
                    LayerSet newls = (LayerSet)new_thing.getObject();
                    Layer la = new Layer(newls.getProject(), 0.0, 1.0, newls);
                    this.addLayer(newls, la);
                    new Display(newls.getProject(), la);
                    return;
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                return;
            }
            for (int i11 = 0; i11 < paths.length; ++i11) {
                layer[i11] = (Layer)((LayerThing)((DefaultMutableTreeNode)paths[i11].getLastPathComponent()).getUserObject()).getObject();
                if (null == ls) {
                    ls = layer[i11].getParent();
                    continue;
                }
                if (ls.equals(layer[i11].getParent())) continue;
                Utils.showMessage("To reverse, all layers must belong to the same layer set");
                return;
            }
            ArrayList<Layer> al = new ArrayList<Layer>();
            for (i2 = 0; i2 < layer.length; ++i2) {
                al.add(layer[i2]);
            }
            ls.addLayerEditedStep(al);
            i2 = 0;
            int j = layer.length - 1;
            while (true) {
                if (i2 >= layer.length / 2) {
                    this.updateList(ls);
                    ls.addLayerEditedStep(al);
                    Display.updateLayerScroller(ls);
                    return;
                }
                double d = layer[i2].getZ();
                layer[i2].setZ(layer[j].getZ());
                layer[j].setZ(d);
                ++i2;
                --j;
            }
        }
        while (true) {
            if (i >= paths.length) {
                this.updateUILater();
                return;
            }
            DefaultMutableTreeNode lnode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            LayerThing lt = (LayerThing)lnode.getUserObject();
            Layer layer = (Layer)lt.getObject();
            if (!layer.remove(false)) {
                Utils.showMessage("Could not delete layer " + layer);
                this.updateUILater();
                return;
            }
            if (lt.remove(false)) {
                ((DefaultTreeModel)this.getModel()).removeNodeFromParent(lnode);
            }
            ++i;
        }
    }

    public boolean remove(Layer layer, boolean check) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        LayerThing thing = (LayerThing)((LayerThing)root.getUserObject()).findChild(layer);
        if (null == thing) {
            Utils.log2("LayerTree.remove(Layer): thing not found");
            return false;
        }
        DefaultMutableTreeNode node = DNDTree.findNode(thing, this);
        if (null == node) {
            Utils.log2("LayerTree.remove(Layer): node not found");
            return false;
        }
        if (thing.remove(check)) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
            this.updateUILater();
        }
        return true;
    }

    public void addLayer(LayerSet layer_set, Layer layer) {
        if (null == layer_set || null == layer) {
            return;
        }
        try {
            double iz;
            DefaultMutableTreeNode child_node;
            LayerThing child_thing;
            int i;
            DefaultMutableTreeNode root_node = (DefaultMutableTreeNode)this.getModel().getRoot();
            LayerThing root_lt = (LayerThing)root_node.getUserObject();
            Thing thing = null;
            thing = root_lt.getObject().equals(layer_set) ? root_lt : root_lt.findChild(layer_set);
            DefaultMutableTreeNode parent_node = DNDTree.findNode(thing, this);
            if (null == parent_node) {
                Utils.log("LayerTree: LayerSet not found.");
                return;
            }
            LayerThing parent_thing = (LayerThing)parent_node.getUserObject();
            double z = layer.getZ();
            int n = parent_node.getChildCount();
            for (i = 0; i < n && (!(child_thing = (LayerThing)(child_node = (DefaultMutableTreeNode)parent_node.getChildAt(i)).getUserObject()).getType().equals("layer") || (iz = ((Layer)child_thing.getObject()).getZ()) < z); ++i) {
            }
            TemplateThing tt = parent_thing.getChildTemplate("layer");
            if (null == tt) {
                Utils.log("LayerTree: Null template Thing!");
                return;
            }
            LayerThing new_thing = new LayerThing(tt, layer.getProject(), layer);
            if (null != new_thing) {
                parent_thing.addChild(new_thing);
                DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new_thing);
                ((DefaultTreeModel)this.getModel()).insertNodeInto(new_node, parent_node, i);
                TreePath treePath = new TreePath(new_node.getPath());
                this.scrollPathToVisible(treePath);
                this.setSelectionPath(treePath);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.selected_node = null;
    }

    public void updateList(LayerSet layer_set) {
        LayerThing lt = layer_set.getProject().findLayerThing(layer_set);
        if (null == lt) {
            Utils.log2("LayerTree.updateList: could not find LayerSet " + layer_set);
            return;
        }
        this.updateList(lt);
        this.getSelectionModel().setSelectionMode(4);
    }

    public boolean remove(boolean check, LayerThing thing, DefaultMutableTreeNode node) {
        if (null == thing || null == thing.getParent()) {
            return false;
        }
        return thing.remove(check) && this.removeNode(null != node ? node : LayerTree.findNode(thing, this));
    }

    @Override
    protected DNDTree.NodeRenderer createNodeRenderer() {
        return new LayerThingNodeRender();
    }

    public void selectNode(Layer layer) {
        final DefaultMutableTreeNode node = DNDTree.findNode2(layer, this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerTree.this.setSelectionPath(null);
                if (null != node) {
                    TreePath path = new TreePath(node.getPath());
                    try {
                        LayerTree.this.scrollPathToVisible(path);
                        LayerTree.this.setSelectionPath(path);
                    }
                    catch (Exception e) {
                        IJError.print(e, true);
                    }
                }
            }
        });
    }

    @Override
    protected Thing getRootThing() {
        return this.project.getRootLayerThing();
    }

    protected final class LayerThingNodeRender
    extends DNDTree.NodeRenderer {
        private static final long serialVersionUID = 1L;

        protected LayerThingNodeRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            label.setText(label.getText().replace('_', ' '));
            try {
                if (value.getClass() == DefaultMutableTreeNode.class) {
                    Layer layer;
                    Object ob;
                    Object obb = ((DefaultMutableTreeNode)value).getUserObject();
                    if (!(obb instanceof LayerThing)) {
                        Utils.log2("WARNING: not a LayerThing: obb is " + obb.getClass() + " and contains " + obb + "   " + ((Thing)obb).getObject());
                    }
                    if ((ob = ((Thing)obb).getObject()) == (layer = Display.getFrontLayer())) {
                        label.setOpaque(true);
                        label.setBackground(FRONT_LAYER_COLOR);
                    } else if (ob.getClass() == LayerSet.class && null != layer && layer.contains((Displayable)ob)) {
                        label.setOpaque(true);
                        label.setBackground(ProjectTree.ACTIVE_DISPL_COLOR);
                    } else {
                        label.setOpaque(false);
                        label.setBackground(LayerTree.this.background);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return label;
        }
    }
}

