/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Loader;
import javassist.NotFoundException;
import javassist.Translator;

public class MemoryProfiler
implements Translator {
    protected static final boolean debug = false;
    protected Set<String> only;
    protected static Runtime runtime = Runtime.getRuntime();

    public MemoryProfiler() {
        this(System.getenv("MEMORY_PROFILE_ONLY"));
    }

    public MemoryProfiler(String only) {
        this(only == null ? null : Arrays.asList(only.split(" +")));
    }

    public MemoryProfiler(Collection<String> only) {
        if (only != null) {
            this.only = new HashSet<String>();
            this.only.addAll(only);
        }
    }

    public void start(ClassPool pool) throws NotFoundException, CannotCompileException {
    }

    public void onLoad(ClassPool pool, String classname) throws NotFoundException {
        block7: {
            if (classname.equals(this.getClass().getName())) {
                return;
            }
            if (this.only != null && !this.only.contains(classname)) {
                return;
            }
            CtClass cc = pool.get(classname);
            if (cc.isFrozen()) {
                return;
            }
            try {
                for (CtMethod ctMethod : cc.getMethods()) {
                    this.handle((CtBehavior)ctMethod);
                }
                for (CtMethod ctMethod : cc.getConstructors()) {
                    this.handle((CtBehavior)ctMethod);
                }
            }
            catch (RuntimeException e) {
                if (e.getMessage().endsWith(" class is frozen")) break block7;
                e.printStackTrace();
            }
        }
    }

    protected void handle(CtBehavior behavior) {
        block3: {
            try {
                if (behavior.isEmpty()) {
                    return;
                }
                behavior.addLocalVariable("memoryBefore", CtClass.longType);
                behavior.insertBefore("memoryBefore = fiji.MemoryProfiler.get();");
                behavior.insertAfter("fiji.MemoryProfiler.report(memoryBefore);");
            }
            catch (CannotCompileException e) {
                if (e.getMessage().equals("no method body")) break block3;
                e.printStackTrace();
            }
        }
    }

    public static long get() {
        MemoryProfiler.gc();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static void report(long memoryBefore) {
        MemoryProfiler.gc();
        StackTraceElement[] trace = new Exception().getStackTrace();
        StackTraceElement last = trace.length > 1 ? trace[1] : new StackTraceElement("null", "null", "null", -1);
        long current = MemoryProfiler.get();
        System.err.println("MemoryProfiler: " + (current - memoryBefore) + " " + current + " " + last.getClassName() + "." + last.getMethodName() + "(" + last.getFileName() + ":" + last.getLineNumber() + ")");
    }

    public static void gc() {
        System.gc();
        System.gc();
    }

    public static void main(String[] args) throws Throwable {
        Thread.currentThread().setContextClassLoader(MemoryProfiler.class.getClassLoader());
        if (args.length == 0) {
            System.err.println("Usage: java " + MemoryProfiler.class + " <main-class> [<argument>...]");
            System.exit(1);
        }
        String mainClass = args[0];
        String[] mainArgs = new String[args.length - 1];
        System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
        Loader loader = new Loader();
        loader.addTranslator(ClassPool.getDefault(), (Translator)new MemoryProfiler());
        MemoryProfiler.gc();
        loader.run(mainClass, mainArgs);
    }
}

