/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.SparseCostMatrix;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.util.Util;

public class LAPJV
implements OutputAlgorithm<int[]>,
Benchmark {
    private static final String BASE_ERROR_MESSAGE = "[JonkerVolgenantSparseAlgorithm] ";
    private int[] output;
    private String errorMessage;
    private long processingTime;
    private final SparseCostMatrix cm;

    public LAPJV(SparseCostMatrix cm) {
        this.cm = cm;
    }

    public boolean process() {
        int i;
        int j;
        long start = System.currentTimeMillis();
        int[] x = new int[this.cm.nRows];
        int[] y = new int[this.cm.nCols];
        double[] v = new double[this.cm.nCols];
        int[] col = new int[this.cm.nCols];
        for (j = 0; j < col.length; ++j) {
            col[j] = j;
        }
        Arrays.fill(v, Double.MAX_VALUE);
        for (int i2 = 0; i2 < this.cm.nRows; ++i2) {
            for (int k = this.cm.start[i2]; k < this.cm.start[i2] + this.cm.number[i2]; ++k) {
                int j2 = this.cm.kk[k];
                if (!(this.cm.cc[k] < v[j2])) continue;
                v[j2] = this.cm.cc[k];
                y[j2] = i2 + 1;
            }
        }
        for (j = this.cm.nCols - 1; j >= 0; --j) {
            int i3 = y[j] - 1;
            if (x[i3] == 0) {
                x[i3] = j + 1;
                continue;
            }
            if (x[i3] > 0) {
                x[i3] = -x[i3];
            }
            y[j] = 0;
        }
        int f = 0;
        int[] free = new int[this.cm.nRows];
        for (int i4 = 0; i4 < this.cm.nRows; ++i4) {
            if (x[i4] == 0) {
                free[f++] = i4;
                continue;
            }
            if (x[i4] < 0) {
                x[i4] = -x[i4];
                continue;
            }
            int j1 = x[i4] - 1;
            double min = Double.MAX_VALUE;
            for (int k = this.cm.start[i4]; k < this.cm.start[i4] + this.cm.number[i4]; ++k) {
                int j3 = this.cm.kk[k];
                if (j3 == j1 || !(this.cm.cc[k] - v[j3] < min)) continue;
                min = this.cm.cc[k] - v[j3];
            }
            int n = j1;
            v[n] = v[n] - min;
        }
        if (f == 0) {
            return true;
        }
        for (int count = 0; count < 2; ++count) {
            int k = 0;
            int f0 = f;
            f = 0;
            while (k < f0) {
                i = free[k++];
                double v0 = Double.MAX_VALUE;
                int j0 = 0;
                int j1 = -1;
                double vj = Double.MAX_VALUE;
                for (int kj = this.cm.start[i]; kj < this.cm.start[i] + this.cm.number[i]; ++kj) {
                    int j4 = this.cm.kk[kj];
                    double h = this.cm.cc[kj] - v[j4];
                    if (!(h < vj)) continue;
                    if (h > v0) {
                        vj = h;
                        j1 = j4;
                        continue;
                    }
                    vj = v0;
                    v0 = h;
                    j1 = j0;
                    j0 = j4;
                }
                int i0 = y[j0] - 1;
                if (v0 < vj) {
                    int n = j0;
                    v[n] = v[n] - (vj - v0);
                } else if (i0 >= 0) {
                    j0 = j1;
                    i0 = y[j1] - 1;
                }
                if (i0 >= 0) {
                    if (v0 < vj) {
                        free[--k] = i0;
                    } else {
                        free[f++] = i0;
                    }
                }
                x[i] = j0 + 1;
                y[j0] = i + 1;
            }
        }
        int f0 = f;
        double[] d = new double[this.cm.nCols];
        int[] pred = new int[this.cm.nCols];
        for (f = 0; f < f0; ++f) {
            int i5;
            int k;
            int last;
            int i1 = free[f];
            int low = 0;
            int up = 0;
            Arrays.fill(d, Double.MAX_VALUE);
            for (int k2 = this.cm.start[i1]; k2 < this.cm.start[i1] + this.cm.number[i1]; ++k2) {
                int j5 = this.cm.kk[k2];
                d[j5] = this.cm.cc[k2] - v[j5];
                pred[j5] = i1;
            }
            int j6 = -1;
            double min = Double.MAX_VALUE;
            block11: do {
                last = low;
                min = d[col[up++]];
                for (k = up; k < this.cm.nCols; ++k) {
                    j6 = col[k];
                    double h = d[j6];
                    if (!(h <= min)) continue;
                    if (h < min) {
                        up = low;
                        min = h;
                    }
                    col[k] = col[up];
                    col[up++] = j6;
                }
                for (int h = low; h < up; ++h) {
                    j6 = col[h];
                    if (y[j6] == 0) break block11;
                }
                do {
                    int j1;
                    int kj1;
                    if ((kj1 = Arrays.binarySearch(this.cm.kk, this.cm.start[i5 = y[j1 = col[low++]] - 1], this.cm.start[i5] + this.cm.number[i5], j1)) < 0) continue;
                    double u1 = this.cm.cc[kj1] - v[j1] - min;
                    for (int k3 = up; k3 < this.cm.nCols; ++k3) {
                        double h;
                        j6 = col[k3];
                        int kj = Arrays.binarySearch(this.cm.kk, this.cm.start[i5], this.cm.start[i5] + this.cm.number[i5], j6);
                        if (kj < 0 || !((h = this.cm.cc[kj] - v[j6] - u1) < d[j6])) continue;
                        d[j6] = h;
                        pred[j6] = i5;
                        if (h != min) continue;
                        if (y[j6] == 0) break block11;
                        col[k3] = col[up];
                        col[up++] = j6;
                    }
                } while (low != up);
            } while (low == up);
            for (k = 0; k < last; ++k) {
                int j0;
                int n = j0 = col[k];
                v[n] = v[n] + (d[j0] - min);
            }
            do {
                i5 = pred[j6];
                y[j6] = i5 + 1;
                k = j6;
                j6 = x[i5] - 1;
                x[i5] = k + 1;
            } while (i1 != i5);
        }
        this.output = new int[x.length];
        for (i = 0; i < x.length; ++i) {
            this.output[i] = x[i] - 1;
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public boolean checkInput() {
        if (this.cm.nRows > this.cm.nCols) {
            this.errorMessage = "[JonkerVolgenantSparseAlgorithm] This solver converges only if the cost matrix has more rows than column. Found " + this.cm.nRows + " rows and " + this.cm.nCols + " columns.";
            return false;
        }
        double minCost = Util.min((double[])this.cm.cc);
        if (minCost <= 0.0) {
            this.errorMessage = "[JonkerVolgenantSparseAlgorithm] This solver only accept strictly positive costs. Found " + minCost + ".";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public int[] getResult() {
        return this.output;
    }

    public String resultToString() {
        return this.resultToString(Collections.emptyList(), Collections.emptyList());
    }

    public String resultToString(List<?> rows, List<?> cols) {
        if (null == this.output) {
            return "Not solved yet. Process the algorithm prior to calling this method.";
        }
        String[] colNames = new String[this.cm.nCols];
        for (int j = 0; j < colNames.length; ++j) {
            colNames[j] = "" + j;
        }
        String[] rowNames = new String[this.cm.nRows];
        for (int i = 0; i < rowNames.length; ++i) {
            rowNames[i] = "" + i;
        }
        for (int j = 0; j < cols.size(); ++j) {
            String str;
            Object obj = cols.get(j);
            if (null == obj) continue;
            colNames[j] = str = obj.toString();
        }
        int colWidth = -1;
        for (String string : colNames) {
            if (string.length() <= colWidth) continue;
            colWidth = string.length();
        }
        ++colWidth;
        colWidth = Math.max(colWidth, 7);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(colNames));
        for (int i = 0; i < rows.size(); ++i) {
            String string;
            Object row = rows.get(i);
            if (null == row) continue;
            rowNames[i] = string = row.toString();
        }
        int rowWidth = -1;
        for (String str : rowNames) {
            if (str.length() <= rowWidth) continue;
            rowWidth = str.length();
        }
        ++rowWidth;
        rowWidth = Math.max(7, rowWidth);
        StringBuilder str = new StringBuilder();
        double d = this.cm.totalAssignmentCost(this.output);
        int digits = (int)(Math.log10(d) + 2.0);
        str.append(String.format("Optimal assignment with total cost = %" + digits + ".1f:\n", d));
        for (int i = 0; i < this.output.length; ++i) {
            int k;
            int j = this.output[i];
            double cost = this.cm.get(i, j, Double.POSITIVE_INFINITY);
            for (k = 0; k < rowWidth - rowNames[i].length(); ++k) {
                str.append(' ');
            }
            str.append(rowNames[i]);
            str.append(" \u2192 ");
            str.append(colNames[j]);
            hashSet.remove(colNames[j]);
            for (k = 0; k < colWidth - colNames[j].length(); ++k) {
                str.append(' ');
            }
            str.append(String.format(" cost = %" + digits + ".1f\n", cost));
        }
        if (this.cm.nCols > this.cm.nRows) {
            str.append("Unassigned columns:\n");
            for (String ucn : hashSet) {
                int k;
                for (k = 0; k < rowWidth / 2; ++k) {
                    str.append(' ');
                }
                str.append('\u00f8');
                for (k = 0; k < rowWidth - rowWidth / 2 - 1; ++k) {
                    str.append(' ');
                }
                str.append(" \u2192 ");
                str.append(ucn);
                for (k = 0; k < colWidth - ucn.length(); ++k) {
                    str.append(' ');
                }
                str.append('\n');
            }
        }
        return str.toString();
    }
}

